/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common.english;

import java.util.HashMap;
import java.util.HashSet;
import opennlp.common.util.FilterFcn;

public final class EnglishClosedClassTags
implements FilterFcn {
    static HashMap TagsToWords = new HashMap();

    static {
        EnglishClosedClassTags.setupHashMap();
    }

    public boolean filter(String s) {
        return false;
    }

    public boolean filter(String word, String tag) {
        if (!TagsToWords.containsKey(tag)) {
            return true;
        }
        word = word.toLowerCase();
        return ((HashSet)TagsToWords.get(tag)).contains(word);
    }

    private static void setupHashMap() {
        String[] wordsForLeftQuote = new String[]{"non-``", "`", "``"};
        TagsToWords.put("``", EnglishClosedClassTags.toSet(wordsForLeftQuote));
        String[] wordsForWP = new String[]{"whoever", "whom", "what", "who"};
        TagsToWords.put("WP", EnglishClosedClassTags.toSet(wordsForWP));
        String[] wordsForWPPoss = new String[]{"whose"};
        TagsToWords.put("WP$", EnglishClosedClassTags.toSet(wordsForWPPoss));
        String[] wordsForPOS = new String[]{"'s", "'"};
        TagsToWords.put("POS", EnglishClosedClassTags.toSet(wordsForPOS));
        String[] wordsForPRPPoss = new String[]{"its", "his", "my", "our", "their", "your", "her"};
        TagsToWords.put("PRP$", EnglishClosedClassTags.toSet(wordsForPRPPoss));
        String[] wordsForDT = new String[]{"either", "the", "those", "any", "la", "le", "another", "that", "each", "many", "del", "this", "half", "no", "a", "every", "both", "an", "neither", "some", "these", "all"};
        TagsToWords.put("DT", EnglishClosedClassTags.toSet(wordsForDT));
        String[] wordsForSYM = new String[]{"a", "b", "c", "&"};
        TagsToWords.put("SYM", EnglishClosedClassTags.toSet(wordsForSYM));
        String[] wordsForLS = new String[]{"1", "a", "2", "b", "3", "4", "5", "6", "7", "8", "9", "first", "third", "second", "fourth", "fifth"};
        TagsToWords.put("LS", EnglishClosedClassTags.toSet(wordsForLS));
        String[] wordsForRP = new String[]{"through", "up", "for", "around", "across", "back", "away", "open", "of", "in", "out", "down", "by", "about", "off", "over", "with", "on"};
        TagsToWords.put("RP", EnglishClosedClassTags.toSet(wordsForRP));
        String[] wordsForNumSign = new String[]{"#"};
        TagsToWords.put("#", EnglishClosedClassTags.toSet(wordsForNumSign));
        String[] wordsForTO = new String[]{"to"};
        TagsToWords.put("TO", EnglishClosedClassTags.toSet(wordsForTO));
        String[] wordsForBucks = new String[]{"nz$", "us$", "$", "a$", "c$"};
        TagsToWords.put("$", EnglishClosedClassTags.toSet(wordsForBucks));
        String[] wordsForCC = new String[]{"either", "or", "v.", "plus", "&", "versus", "but", "minus", "both", "neither", "nor", "yet", "and", "whether", "less", "vs.", "et", "'n'"};
        TagsToWords.put("CC", EnglishClosedClassTags.toSet(wordsForCC));
        String[] wordsForRBS = new String[]{"least", "most", "best", "worst"};
        TagsToWords.put("RBS", EnglishClosedClassTags.toSet(wordsForRBS));
        String[] wordsForPDT = new String[]{"all", "such", "half", "both"};
        TagsToWords.put("PDT", EnglishClosedClassTags.toSet(wordsForPDT));
        String[] wordsForLeftParen = new String[]{"(", "{"};
        TagsToWords.put("(", EnglishClosedClassTags.toSet(wordsForLeftParen));
        String[] wordsForRightParen = new String[]{")", "}"};
        TagsToWords.put(")", EnglishClosedClassTags.toSet(wordsForRightParen));
        String[] wordsForWRB = new String[]{"when", "whenever", "whereby", "why", "where", "how"};
        TagsToWords.put("WRB", EnglishClosedClassTags.toSet(wordsForWRB));
        String[] wordsForComma = new String[]{","};
        TagsToWords.put(",", EnglishClosedClassTags.toSet(wordsForComma));
        String[] wordsForEOS = new String[]{"!", ".", "?"};
        TagsToWords.put(".", EnglishClosedClassTags.toSet(wordsForEOS));
        String[] wordsForRightQuote = new String[]{"''", "'"};
        TagsToWords.put("''", EnglishClosedClassTags.toSet(wordsForRightQuote));
        String[] wordsForWDT = new String[]{"that", "which", "what", "whichever", "whatever"};
        TagsToWords.put("WDT", EnglishClosedClassTags.toSet(wordsForWDT));
        String[] wordsForMD = new String[]{"ca", "wo", "ought", "may", "must", "'d", "would", "should", "can", "shall", "could", "will", "might", "need", "'ll"};
        TagsToWords.put("MD", EnglishClosedClassTags.toSet(wordsForMD));
        String[] wordsForPRP = new String[]{"themselves", "she", "one", "itself", "ourselves", "himself", "us", "mine", "herself", "i", "he", "them", "theirs", "myself", "hers", "me", "yourself", "ya", "'s", "they", "we", "you", "it", "him", "thyself", "her"};
        TagsToWords.put("PRP", EnglishClosedClassTags.toSet(wordsForPRP));
        String[] wordsForColon = new String[]{"...", ":", "--", ";", "-"};
        TagsToWords.put(":", EnglishClosedClassTags.toSet(wordsForColon));
        String[] wordsForUH = new String[]{"indeed", "yes", "please", "ok", "well", "say", "no", "oh"};
        TagsToWords.put("UH", EnglishClosedClassTags.toSet(wordsForUH));
        String[] wordsForEX = new String[]{"there"};
        TagsToWords.put("EX", EnglishClosedClassTags.toSet(wordsForEX));
        String[] wordsForIN = new String[]{"upon", "up", "except", "between", "across", "until", "along", "within", "alongside", "beneath", "into", "by", "with", "beyond", "once", "for", "aboard", "behind", "toward", "which", "and", "of", "are", "out", "off", "about", "outside", "including", "on", "next", "@", "through", "so", "towards", "like", "complicated", "near", "against", "unlike", "de", "during", "around", "than", "above", "despite", "then", "whereas", "though", "that", "since", "from", "without", "worth", "whether", "ago", "lest", "past", "down", "while", "far", "below", "throughout", "unless", "amid", "onto", "via", "a", "to", "plus", "notwithstanding", "per", "but", "if", "after", "among", "en", "opposite", "before", "atop", "as", "till", "at", "vs.", "in", "because", "inside", "over", "although", "under", "besides"};
        TagsToWords.put("IN", EnglishClosedClassTags.toSet(wordsForIN));
    }

    private static HashSet toSet(String[] words) {
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < words.length) {
            hs.add(words[i]);
            ++i;
        }
        return hs;
    }
}

