/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.nivre;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.nivre.ArcStandard;
import org.maltparser.parser.algorithm.nivre.ArcStandardOracle;
import org.maltparser.parser.algorithm.nivre.NivreFactory;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.history.GuideUserHistory;

public class NivreArcStandardFactory
extends NivreFactory {
    public NivreArcStandardFactory(Algorithm algorithm) {
        super(algorithm);
    }

    public TransitionSystem makeTransitionSystem() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Transition system    : Arc-Standard\n");
        }
        ArcStandard ts = new ArcStandard();
        ts.setPropagationManager(this.manager.getPropagationManager());
        return ts;
    }

    public OracleGuide makeOracleGuide(GuideUserHistory history) throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Oracle               : Arc-Standard\n");
        }
        return new ArcStandardOracle(this.manager, history);
    }
}

