BEGIN { $| = 1; print "1..83\n"; }
END {print "not ok 1\n" unless $loaded;}
use Crypt::Twofish2;
$loaded = 1;
print "ok 1\n";

$i = 2;

$plaintext = ("p" x 30)."xi";
$key = "po".("k"  x 30);

$cbc = new Crypt::Twofish2 $key, Crypt::Twofish2::MODE_CBC;
$crypted = $cbc->encrypt($plaintext);
print unpack("H*", $crypted) eq "57a627f0aca655dc495e15e30354a6334825f10ba9d2d20441b84ffc504d2942" ? "" : "not ", "ok ".$i++."\n";
$crypted2 = $cbc->encrypt($plaintext);
print unpack("H*", $crypted2) eq "440996719ae702988b631db5820ad94e76603972835342bbbc99311654a4d6ba" ? "" : "not ", "ok ".$i++."\n";

$cbc = new Crypt::Twofish2 $key, Crypt::Twofish2::MODE_CBC;
print $cbc->decrypt($crypted)  eq $plaintext ? "" : "not ", "ok ".$i++."\n";
print $cbc->decrypt($crypted2) eq $plaintext ? "" : "not ", "ok ".$i++."\n";

# now try the test vectors provided

while (<DATA>) {
   if (/KEY=(\S+)\s+PT=(\S+)\s+CT=(\S+)\s+/) {
      my $key = pack "H*", $1;
      my $pt  = pack "H*", $2;
      my $ct  = pack "H*", $3;

      my $ecb = new Crypt::Twofish2 $key;

      my $crypted = $ecb->encrypt($pt);
      print $crypted eq $ct ? "" : "not ", "ok ".$i++."\n";
      print $ecb->decrypt($crypted) eq $pt ? "" : "not ", "ok ".$i++."\n";
   }
}

__DATA__

KEY=00000000000000000000000000000000 PT=00000000000000000000000000000000 CT=9F589F5CF6122C32B6BFEC2F2AE8C35A
KEY=0123456789ABCDEFFEDCBA98765432100011223344556677 PT=00000000000000000000000000000000 CT=CFD1D2E5A9BE9CDF501F13B892BD2248
KEY=0123456789ABCDEFFEDCBA987654321000112233445566778899AABBCCDDEEFF PT=00000000000000000000000000000000 CT=37527BE0052334B89F0CFCCAE87CFA20
KEY=00000000000000000000000000000000 PT=00000000000000000000000000000000 CT=9F589F5CF6122C32B6BFEC2F2AE8C35A
KEY=00000000000000000000000000000000 PT=9F589F5CF6122C32B6BFEC2F2AE8C35A CT=D491DB16E7B1C39E86CB086B789F5419
KEY=9F589F5CF6122C32B6BFEC2F2AE8C35A PT=D491DB16E7B1C39E86CB086B789F5419 CT=019F9809DE1711858FAAC3A3BA20FBC3
KEY=D491DB16E7B1C39E86CB086B789F5419 PT=019F9809DE1711858FAAC3A3BA20FBC3 CT=6363977DE839486297E661C6C9D668EB
KEY=019F9809DE1711858FAAC3A3BA20FBC3 PT=6363977DE839486297E661C6C9D668EB CT=816D5BD0FAE35342BF2A7412C246F752
KEY=6363977DE839486297E661C6C9D668EB PT=816D5BD0FAE35342BF2A7412C246F752 CT=5449ECA008FF5921155F598AF4CED4D0
KEY=816D5BD0FAE35342BF2A7412C246F752 PT=5449ECA008FF5921155F598AF4CED4D0 CT=6600522E97AEB3094ED5F92AFCBCDD10
KEY=5449ECA008FF5921155F598AF4CED4D0 PT=6600522E97AEB3094ED5F92AFCBCDD10 CT=34C8A5FB2D3D08A170D120AC6D26DBFA
KEY=6600522E97AEB3094ED5F92AFCBCDD10 PT=34C8A5FB2D3D08A170D120AC6D26DBFA CT=28530B358C1B42EF277DE6D4407FC591
KEY=34C8A5FB2D3D08A170D120AC6D26DBFA PT=28530B358C1B42EF277DE6D4407FC591 CT=8A8AB983310ED78C8C0ECDE030B8DCA4
KEY=137A24CA47CD12BE818DF4D2F4355960 PT=BCA724A54533C6987E14AA827952F921 CT=6B459286F3FFD28D49F15B1581B08E42
KEY=BCA724A54533C6987E14AA827952F921 PT=6B459286F3FFD28D49F15B1581B08E42 CT=5D9D4EEFFA9151575524F115815A12E0
KEY=000000000000000000000000000000000000000000000000 PT=00000000000000000000000000000000 CT=EFA71F788965BD4453F860178FC19101
KEY=000000000000000000000000000000000000000000000000 PT=EFA71F788965BD4453F860178FC19101 CT=88B2B2706B105E36B446BB6D731A1E88
KEY=EFA71F788965BD4453F860178FC191010000000000000000 PT=88B2B2706B105E36B446BB6D731A1E88 CT=39DA69D6BA4997D585B6DC073CA341B2
KEY=88B2B2706B105E36B446BB6D731A1E88EFA71F788965BD44 PT=39DA69D6BA4997D585B6DC073CA341B2 CT=182B02D81497EA45F9DAACDC29193A65
KEY=39DA69D6BA4997D585B6DC073CA341B288B2B2706B105E36 PT=182B02D81497EA45F9DAACDC29193A65 CT=7AFF7A70CA2FF28AC31DD8AE5DAAAB63
KEY=182B02D81497EA45F9DAACDC29193A6539DA69D6BA4997D5 PT=7AFF7A70CA2FF28AC31DD8AE5DAAAB63 CT=D1079B789F666649B6BD7D1629F1F77E
KEY=7AFF7A70CA2FF28AC31DD8AE5DAAAB63182B02D81497EA45 PT=D1079B789F666649B6BD7D1629F1F77E CT=3AF6F7CE5BD35EF18BEC6FA787AB506B
KEY=D1079B789F666649B6BD7D1629F1F77E7AFF7A70CA2FF28A PT=3AF6F7CE5BD35EF18BEC6FA787AB506B CT=AE8109BFDA85C1F2C5038B34ED691BFF
KEY=3AF6F7CE5BD35EF18BEC6FA787AB506BD1079B789F666649 PT=AE8109BFDA85C1F2C5038B34ED691BFF CT=893FD67B98C550073571BD631263FC78
KEY=AE8109BFDA85C1F2C5038B34ED691BFF3AF6F7CE5BD35EF1 PT=893FD67B98C550073571BD631263FC78 CT=16434FC9C8841A63D58700B5578E8F67
KEY=DEA4F3DA75EC7A8EAC3861A9912402CD5DBE44032769DF54 PT=FB66522C332FCC4C042ABE32FA9E902F CT=F0AB73301125FA21EF70BE5385FB76B6
KEY=FB66522C332FCC4C042ABE32FA9E902FDEA4F3DA75EC7A8E PT=F0AB73301125FA21EF70BE5385FB76B6 CT=E75449212BEEF9F4A390BD860A640941
KEY=0000000000000000000000000000000000000000000000000000000000000000 PT=00000000000000000000000000000000 CT=57FF739D4DC92C1BD7FC01700CC8216F
KEY=0000000000000000000000000000000000000000000000000000000000000000 PT=57FF739D4DC92C1BD7FC01700CC8216F CT=D43BB7556EA32E46F2A282B7D45B4E0D
KEY=57FF739D4DC92C1BD7FC01700CC8216F00000000000000000000000000000000 PT=D43BB7556EA32E46F2A282B7D45B4E0D CT=90AFE91BB288544F2C32DC239B2635E6
KEY=D43BB7556EA32E46F2A282B7D45B4E0D57FF739D4DC92C1BD7FC01700CC8216F PT=90AFE91BB288544F2C32DC239B2635E6 CT=6CB4561C40BF0A9705931CB6D408E7FA
KEY=90AFE91BB288544F2C32DC239B2635E6D43BB7556EA32E46F2A282B7D45B4E0D PT=6CB4561C40BF0A9705931CB6D408E7FA CT=3059D6D61753B958D92F4781C8640E58
KEY=6CB4561C40BF0A9705931CB6D408E7FA90AFE91BB288544F2C32DC239B2635E6 PT=3059D6D61753B958D92F4781C8640E58 CT=E69465770505D7F80EF68CA38AB3A3D6
KEY=3059D6D61753B958D92F4781C8640E586CB4561C40BF0A9705931CB6D408E7FA PT=E69465770505D7F80EF68CA38AB3A3D6 CT=5AB67A5F8539A4A5FD9F0373BA463466
KEY=E69465770505D7F80EF68CA38AB3A3D63059D6D61753B958D92F4781C8640E58 PT=5AB67A5F8539A4A5FD9F0373BA463466 CT=DC096BCD99FC72F79936D4C748E75AF7
KEY=5AB67A5F8539A4A5FD9F0373BA463466E69465770505D7F80EF68CA38AB3A3D6 PT=DC096BCD99FC72F79936D4C748E75AF7 CT=C5A3E7CEE0F1B7260528A68FB4EA05F2
KEY=DC096BCD99FC72F79936D4C748E75AF75AB67A5F8539A4A5FD9F0373BA463466 PT=C5A3E7CEE0F1B7260528A68FB4EA05F2 CT=43D5CEC327B24AB90AD34A79D0469151
KEY=2E2158BC3E5FC714C1EEECA0EA696D48D2DED73E59319A8138E0331F0EA149EA PT=248A7F3528B168ACFDD1386E3F51E30C CT=431058F4DBC7F734DA4F02F04CC4F459
KEY=248A7F3528B168ACFDD1386E3F51E30C2E2158BC3E5FC714C1EEECA0EA696D48 PT=431058F4DBC7F734DA4F02F04CC4F459 CT=37FE26FF1CF66175F5DDF4C33B97A205

