package WebService::Bonusly::Authentication;
$WebService::Bonusly::Authentication::VERSION = '0.153420';
use v5.14;
use Moose;
use Carp;
use JSON;
use URI::Escape;

has ws => (
    is          => 'ro',
    isa         => 'WebService::Bonusly',
    required    => 1,
    weak_ref    => 1,
    handles     => [ qw( token base_url ua ) ],
);


sub sessions {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter email is required for authentication->sessions"
        unless defined $params{email};
    
    $clean{email} = $params{email}
        if defined $params{email};
            
    croak "parameter password is required for authentication->sessions"
        unless defined $params{password};
    
    $clean{password} = $params{password}
        if defined $params{password};
    
    my $path = $self->base_url . "sessions";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
        my $content = encode_json(\%clean);
    my $res = $self->ua->post($path, [ 'Content-Type' => 'application/json' ], $content); 
    
    return decode_json($res->content);
}


__PACKAGE__->meta->make_immutable;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Bonusly::Authentication

=head1 VERSION

version 0.153420

=for Pod::Coverage *EVERYTHING*

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
