package Yukki::TextUtil;
$Yukki::TextUtil::VERSION = '0.990_001'; # TRIAL

$Yukki::TextUtil::VERSION = '0.990001';use v5.24;
use utf8;

use Encode ();
use File::Slurper ();
use IO::Prompter ();
use YAML ();

use namespace::clean;

# ABSTRACT: Utilities to help make everything happy UTF-8


use Sub::Exporter -setup => {
    exports => [ qw(
        dump_file
        load_file
        prompt
    ) ],
};


sub dump_file {
    my ($file, $data) = @_;
    File::Slurper::write_text("$file", YAML::Dump($data));
}


sub load_file {
    my ($file) = @_;
    YAML::Load(File::Slurper::read_text("$file"));
}


sub prompt {
    Encode::decode('UTF-8', IO::Prompter::prompt(@_));
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Yukki::TextUtil - Utilities to help make everything happy UTF-8

=head1 VERSION

version 0.990_001

=head1 DESCRIPTION

Yukki aims at fully supporting UTF-8 in everything it does. Please report any bugs you find. This library exports tools used internally to help make sure that input is decoded from UTF-8 on the way in and encoded into UTF-8 on the way out.

=head1 SUBROUTINES

=head2 dump_file

    dump_file($file, $data);

This is pretty much identical in purpose to L<YAML/DumpFile>, but encodes to UTF-8 on the way out.

=head2 load_file

    $data = load_file($file);

This is similar to L<YAML/LoadFile>, but decodes from UTF-8 while reading input.

=head2 prompt

    $value = prompt(...);

This is similar to L<IO::Prompter/prompt>, but decodes UTF-8 in the input.

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
