; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s "-passes=print<scalar-evolution>" -disable-output 2>&1 | FileCheck %s

define i8 @test(i8 %x, i8 %y) {
; CHECK-LABEL: 'test'
; CHECK-NEXT:  Classifying expressions for: @test
; CHECK-NEXT:    %udiv = udiv i8 %x, %y
; CHECK-NEXT:    --> (%x /u %y) U: full-set S: full-set
; CHECK-NEXT:    %res = mul i8 %udiv, %y
; CHECK-NEXT:    --> ((%x /u %y) * %y)<nuw> U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test
;
  %udiv = udiv i8 %x, %y
  %res = mul i8 %udiv, %y
  ret i8 %res
}

define i8 @test2(i8 %x) {
; CHECK-LABEL: 'test2'
; CHECK-NEXT:  Classifying expressions for: @test2
; CHECK-NEXT:    %udiv = udiv i8 %x, 2
; CHECK-NEXT:    --> (%x /u 2) U: [0,-128) S: [0,-128)
; CHECK-NEXT:    %res = mul i8 %udiv, 2
; CHECK-NEXT:    --> (2 * (%x /u 2))<nuw> U: [0,-1) S: [-128,127)
; CHECK-NEXT:  Determining loop execution counts for: @test2
;
  %udiv = udiv i8 %x, 2
  %res = mul i8 %udiv, 2
  ret i8 %res
}

define i8 @test3(i8 %x) {
; CHECK-LABEL: 'test3'
; CHECK-NEXT:  Classifying expressions for: @test3
; CHECK-NEXT:    %udiv = udiv i8 %x, -128
; CHECK-NEXT:    --> (%x /u -128) U: [0,2) S: [0,2)
; CHECK-NEXT:    %res = mul i8 %udiv, -128
; CHECK-NEXT:    --> (-128 * (%x /u -128))<nuw><nsw> U: [0,-127) S: [-128,1)
; CHECK-NEXT:  Determining loop execution counts for: @test3
;
  %udiv = udiv i8 %x, 128
  %res = mul i8 %udiv, 128
  ret i8 %res
}

define i8 @test4(i8 %x) {
; CHECK-LABEL: 'test4'
; CHECK-NEXT:  Classifying expressions for: @test4
; CHECK-NEXT:    %udiv = udiv i8 %x, -1
; CHECK-NEXT:    --> (%x /u -1) U: [0,2) S: [0,2)
; CHECK-NEXT:    %res = mul i8 %udiv, -1
; CHECK-NEXT:    --> (-1 * (%x /u -1))<nuw><nsw> U: [-1,1) S: [-1,1)
; CHECK-NEXT:  Determining loop execution counts for: @test4
;
  %udiv = udiv i8 %x, 255
  %res = mul i8 %udiv, 255
  ret i8 %res
}

define i8 @test5(i8 %x, i32 %y32) {
; CHECK-LABEL: 'test5'
; CHECK-NEXT:  Classifying expressions for: @test5
; CHECK-NEXT:    %y = trunc i32 %y32 to i8
; CHECK-NEXT:    --> (trunc i32 %y32 to i8) U: full-set S: full-set
; CHECK-NEXT:    %udiv = udiv i8 %x, %y
; CHECK-NEXT:    --> (%x /u (trunc i32 %y32 to i8)) U: full-set S: full-set
; CHECK-NEXT:    %res = mul i8 %udiv, %y
; CHECK-NEXT:    --> ((trunc i32 %y32 to i8) * (%x /u (trunc i32 %y32 to i8)))<nuw> U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @test5
;
  %y = trunc i32 %y32 to i8
  %udiv = udiv i8 %x, %y
  %res = mul i8 %udiv, %y
  ret i8 %res
}
