; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-TRUE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-FAKE16 %s

; Make sure stack use isn't introduced for these bitcasts.

define i160 @bitcast_v5i32_to_i160(<5 x i32> %vec) {
; GFX9-LABEL: bitcast_v5i32_to_i160:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v5i32_to_i160:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <5 x i32> %vec to i160
  ret i160 %bitcast
}

define i192 @bitcast_v6i32_to_i192(<6 x i32> %vec) {
; GFX9-LABEL: bitcast_v6i32_to_i192:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v6i32_to_i192:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <6 x i32> %vec to i192
  ret i192 %bitcast
}

define i224 @bitcast_v7i32_to_i224(<7 x i32> %vec) {
; GFX9-LABEL: bitcast_v7i32_to_i224:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v7i32_to_i224:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <7 x i32> %vec to i224
  ret i224 %bitcast
}

define i256 @bitcast_v8i32_to_i256(<8 x i32> %vec) {
; GFX9-LABEL: bitcast_v8i32_to_i256:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v8i32_to_i256:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <8 x i32> %vec to i256
  ret i256 %bitcast
}

define <5 x i32> @bitcast_i160_to_v5i32(i160 %int) {
; GFX9-LABEL: bitcast_i160_to_v5i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i160_to_v5i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i160 %int to <5 x i32>
  ret <5 x i32> %bitcast
}

define <6 x i32> @bitcast_i192_to_v6i32(i192 %int) {
; GFX9-LABEL: bitcast_i192_to_v6i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i192_to_v6i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i192 %int to <6 x i32>
  ret <6 x i32> %bitcast
}

define <7 x i32> @bitcast_i224_to_v7i32(i224 %int) {
; GFX9-LABEL: bitcast_i224_to_v7i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i224_to_v7i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i224 %int to <7 x i32>
  ret <7 x i32> %bitcast
}

define <8 x i32> @bitcast_i256_to_v8i32(i256 %int) {
; GFX9-LABEL: bitcast_i256_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i256_to_v8i32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i256 %int to <8 x i32>
  ret <8 x i32> %bitcast
}

define i192 @bitcast_v3i64_to_i192(<3 x i64> %vec) {
; GFX9-LABEL: bitcast_v3i64_to_i192:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v3i64_to_i192:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <3 x i64> %vec to i192
  ret i192 %bitcast
}

define <3 x i64> @bitcast_i192_to_v3i64(i192 %int) {
; GFX9-LABEL: bitcast_i192_to_v3i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i192_to_v3i64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i192 %int to <3 x i64>
  ret <3 x i64> %bitcast
}

define <10 x i16> @bitcast_i160_to_v10i16(i160 %int) {
; GFX9-LABEL: bitcast_i160_to_v10i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0xffff
; GFX9-NEXT:    v_bfi_b32 v0, s4, v0, v0
; GFX9-NEXT:    v_bfi_b32 v2, s4, v2, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: bitcast_i160_to_v10i16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v2.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v5, v0
; GFX12-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v6, v2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: bitcast_i160_to_v10i16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v0
; GFX12-FAKE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v2
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i160 %int to <10 x i16>
  ret <10 x i16> %bitcast
}

define i160 @bitcast_v10i16_to_i160(<10 x i16> %vec) {
; GFX9-LABEL: bitcast_v10i16_to_i160:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v10i16_to_i160:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <10 x i16> %vec to i160
  ret i160 %bitcast
}

define i12 @bitcast_v2i6_to_i12(<2 x i6> %vec) {
; GFX9-LABEL: bitcast_v2i6_to_i12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 6, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 63, v0
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xfff, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: bitcast_v2i6_to_i12:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 6, v1.l
; GFX12-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 63
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX12-TRUE16-NEXT:    v_and_b16 v0.l, 0xfff, v0.l
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: bitcast_v2i6_to_i12:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b16 v1, 6, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v0, 63, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v0, 0xfff, v0
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <2 x i6> %vec to i12
  ret i12 %bitcast
}

define <2 x i6> @bitcast_i12_to_v2i6(i12 %int) {
; GFX9-LABEL: bitcast_i12_to_v2i6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v2, 63, v0
; GFX9-NEXT:    v_lshrrev_b16_e32 v0, 6, v0
; GFX9-NEXT:    v_and_b32_e32 v1, 63, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: bitcast_i12_to_v2i6:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshrrev_b16 v0.h, 6, v0.l
; GFX12-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, 63
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_and_b16 v1.l, v0.h, 63
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: bitcast_i12_to_v2i6:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b16 v1, 6, v0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v0, 63, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v1, 63, v1
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i12 %int to <2 x i6>
  ret <2 x i6> %bitcast
}

define i160 @bitcast_v5f32_to_i160(<5 x float> %vec) {
; GFX9-LABEL: bitcast_v5f32_to_i160:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v5f32_to_i160:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <5 x float> %vec to i160
  ret i160 %bitcast
}

define <5 x float> @bitcast_i160_to_v5f32(i160 %int) {
; GFX9-LABEL: bitcast_i160_to_v5f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i160_to_v5f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i160 %int to <5 x float>
  ret <5 x float> %bitcast
}

define <6 x float> @bitcast_i192_to_v6f32(i192 %int) {
; GFX9-LABEL: bitcast_i192_to_v6f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_i192_to_v6f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i192 %int to <6 x float>
  ret <6 x float> %bitcast
}

define i192 @bitcast_v6f32_to_i192(<6 x float> %vec) {
; GFX9-LABEL: bitcast_v6f32_to_i192:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: bitcast_v6f32_to_i192:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <6 x float> %vec to i192
  ret i192 %bitcast
}
