; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv64 < %s | FileCheck %s --check-prefixes=CHECK,NOZBS
; RUN: llc -mtriple=riscv64 -mattr=+zbs < %s | FileCheck %s --check-prefixes=CHECK,ZBS

define i64 @add_b31(i64 %x) {
; NOZBS-LABEL: add_b31:
; NOZBS:       # %bb.0:
; NOZBS-NEXT:    lui a1, 524288
; NOZBS-NEXT:    sub a0, a0, a1
; NOZBS-NEXT:    ret
;
; ZBS-LABEL: add_b31:
; ZBS:       # %bb.0:
; ZBS-NEXT:    bseti a1, zero, 31
; ZBS-NEXT:    add a0, a0, a1
; ZBS-NEXT:    ret
  %add = add i64 %x, 2147483648
  ret i64 %add
}

define i64 @add_b32(i64 %x) {
; NOZBS-LABEL: add_b32:
; NOZBS:       # %bb.0:
; NOZBS-NEXT:    li a1, -1
; NOZBS-NEXT:    slli a1, a1, 32
; NOZBS-NEXT:    add a0, a0, a1
; NOZBS-NEXT:    ret
;
; ZBS-LABEL: add_b32:
; ZBS:       # %bb.0:
; ZBS-NEXT:    bseti a1, zero, 32
; ZBS-NEXT:    sub a0, a0, a1
; ZBS-NEXT:    ret
  %add = add i64 %x, -4294967296
  ret i64 %add
}

define i64 @sub_0xffffffffff(i64 %x) {
; CHECK-LABEL: sub_0xffffffffff:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    srli a1, a1, 24
; CHECK-NEXT:    sub a0, a0, a1
; CHECK-NEXT:    ret
  %sub = sub i64 %x, 1099511627775
  ret i64 %sub
}

define i64 @add_multiuse(i64 %x) {
; CHECK-LABEL: add_multiuse:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, -1
; CHECK-NEXT:    slli a1, a1, 40
; CHECK-NEXT:    addi a1, a1, 1
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    and a0, a0, a1
; CHECK-NEXT:    ret
  %add = add i64 %x, -1099511627775
  %and = and i64 %add, -1099511627775
  ret i64 %and
}

define i64 @add_multiuse_const(i64 %x, i64 %y) {
; CHECK-LABEL: add_multiuse_const:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, -1
; CHECK-NEXT:    srli a2, a2, 24
; CHECK-NEXT:    sub a0, a0, a2
; CHECK-NEXT:    sub a1, a1, a2
; CHECK-NEXT:    xor a0, a0, a1
; CHECK-NEXT:    ret
  %a = add i64 %x, -1099511627775
  %b = add i64 %y, -1099511627775
  %xor = xor i64 %a, %b
  ret i64 %xor
}
