; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX12-FAKE16 %s

define half @swap(half %a, half %b, i32 %i) {
; GFX11-TRUE16-LABEL: swap:
; GFX11-TRUE16:       ; %bb.0: ; %entry
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, 0
; GFX11-TRUE16-NEXT:  .LBB0_1: ; %loop
; GFX11-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, -1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX11-TRUE16-NEXT:    v_swap_b16 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB0_1
; GFX11-TRUE16-NEXT:  ; %bb.2: ; %ret
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: swap:
; GFX11-FAKE16:       ; %bb.0: ; %entry
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, 0
; GFX11-FAKE16-NEXT:  .LBB0_1: ; %loop
; GFX11-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_add_nc_u32 v2, -1, v2
; GFX11-FAKE16-NEXT:    v_swap_b32 v1, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB0_1
; GFX11-FAKE16-NEXT:  ; %bb.2: ; %ret
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: swap:
; GFX12-TRUE16:       ; %bb.0: ; %entry
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v1.l
; GFX12-TRUE16-NEXT:    s_mov_b32 s0, 0
; GFX12-TRUE16-NEXT:  .LBB0_1: ; %loop
; GFX12-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-TRUE16-NEXT:    v_add_nc_u32_e32 v2, -1, v2
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.l
; GFX12-TRUE16-NEXT:    v_swap_b16 v0.l, v0.h
; GFX12-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX12-TRUE16-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX12-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-TRUE16-NEXT:    s_cbranch_execnz .LBB0_1
; GFX12-TRUE16-NEXT:  ; %bb.2: ; %ret
; GFX12-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: swap:
; GFX12-FAKE16:       ; %bb.0: ; %entry
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    s_mov_b32 s0, 0
; GFX12-FAKE16-NEXT:  .LBB0_1: ; %loop
; GFX12-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_add_nc_u32 v2, -1, v2
; GFX12-FAKE16-NEXT:    v_swap_b32 v1, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX12-FAKE16-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX12-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-FAKE16-NEXT:    s_cbranch_execnz .LBB0_1
; GFX12-FAKE16-NEXT:  ; %bb.2: ; %ret
; GFX12-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-FAKE16-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  br label %loop

loop:
  %x = phi half [%a, %entry], [%y, %loop]
  %y = phi half [%b, %entry], [%x, %loop]
  %i2 = phi i32 [%i, %entry], [%i3, %loop]

  %i3 = sub i32 %i2, 1

  %cmp = icmp eq i32 %i3, 0
  br i1 %cmp, label %ret, label %loop

ret:
  ret half %x
}
