; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; fcmp OGT + fadd + sel => fcmp OGT + sel => fmaxnum

define float @test_fcmp_ogt_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ogt_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_ogt_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ogt_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_ogt_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_ogt_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.maxnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp ogt <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp OLT + fadd + sel => fcmp OLT + sel => fminnum

define float @test_fcmp_olt_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_olt_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp olt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_olt_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_olt_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp olt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_olt_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_olt_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp olt float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_olt_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_olt_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp olt float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_olt_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_olt_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.minnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp olt <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp OGE + fadd + sel => fcmp OGE + sel => fmaxnum

define float @test_fcmp_oge_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_oge_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp oge float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_oge_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_oge_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp oge float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_oge_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_oge_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp oge float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_oge_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_oge_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp oge float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_oge_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_oge_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.maxnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp oge <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp OLE + fadd + sel => fcmp OLE + sel => fminnum

define float @test_fcmp_ole_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ole_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ole float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ole_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_ole_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ole float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_ole_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ole_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ole float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ole_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_ole_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ole float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_ole_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_ole_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.minnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp ole <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp UGT + fadd + sel => fcmp UGT + sel => fcmp OLE + sel

define float @test_fcmp_ugt_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ugt_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ugt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ugt_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_ugt_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ugt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_ugt_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ugt_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ugt float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ugt_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_ugt_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ugt float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_ugt_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_ugt_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.maxnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp ugt <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp UGE + fadd + sel => fcmp UGE + sel => fcmp olt + sel

define float @test_fcmp_uge_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_uge_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp uge float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_uge_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_uge_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp uge float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_uge_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_uge_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp uge float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_uge_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_uge_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp uge float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_uge_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_uge_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.maxnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp uge <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp ULT + fadd + sel => fcmp ULT + sel => fcmp OGE + sel

define float @test_fcmp_ult_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ult_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ult float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ult_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_ult_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ult float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_ult_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ult_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ult float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ult_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_ult_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ult float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_ult_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_ult_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.minnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp ult <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; fcmp ULE + fadd + sel => fcmp ULE + sel => fcmp OGT + sel

define float @test_fcmp_ule_fadd_select_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ule_fadd_select_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ule float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ule_fadd_select_constant_swapped(float %in) {
; CHECK-LABEL: define float @test_fcmp_ule_fadd_select_constant_swapped(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ule float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float 1.000000e+00, float %add
  ret float %sel
}

define float @test_fcmp_ule_fadd_select_neg_constant(float %in) {
; CHECK-LABEL: define float @test_fcmp_ule_fadd_select_neg_constant(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ule float %in, -0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ule_fadd_select_fastmath_preserve(float %in) {
; CHECK-LABEL: define float @test_fcmp_ule_fadd_select_fastmath_preserve(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.minnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ule float %in, 0.000000e+00
  %add = fadd nnan float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define <2 x float> @test_fcmp_ule_fadd_select_constant_vectors(<2 x float> %in) {
; CHECK-LABEL: define <2 x float> @test_fcmp_ule_fadd_select_constant_vectors(
; CHECK-SAME: <2 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz <2 x float> @llvm.minnum.v2f32(<2 x float> [[IN]], <2 x float> zeroinitializer)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz <2 x float> [[SEL_NEW]], splat (float 1.000000e+00)
; CHECK-NEXT:    ret <2 x float> [[ADD_NEW]]
;
  %cmp1 = fcmp ule <2 x float> %in, <float 0.000000e+00, float 0.000000e+00>
  %add = fadd <2 x float> %in, <float 1.000000e+00, float 1.000000e+00>
  %sel = select nnan nsz <2 x i1> %cmp1, <2 x float> %add, <2 x float> <float 1.000000e+00, float 1.000000e+00>
  ret <2 x float> %sel
}


; Negative scenarios

; select instruction doesn't give nnan and nsz guarantees.
define float @test_select_without_nnan_nsz(float %in) {
; CHECK-LABEL: define float @test_select_without_nnan_nsz(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp ogt float [[IN]], 0.000000e+00
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP1]], float [[ADD]], float 1.000000e+00
; CHECK-NEXT:    ret float [[SEL]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

; fcmp arg doesn't match with fadd's. This won't be converted to maxnum/minnum.
define float @test_fcmp_fadd_arg_mismatch(float %in, float %in2) {
; CHECK-LABEL: define float @test_fcmp_fadd_arg_mismatch(
; CHECK-SAME: float [[IN:%.*]], float [[IN2:%.*]]) {
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp ogt float [[IN2]], 0.000000e+00
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[SEL:%.*]] = select nnan nsz i1 [[CMP1]], float [[ADD]], float 1.000000e+00
; CHECK-NEXT:    ret float [[SEL]]
;
  %cmp1 = fcmp ogt float %in2, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

; It won't be converted to maxnum/minnum because constant arg in fcmp isn't zero.
define float @test_fcmp_arg_non_zero(float %in) {
; CHECK-LABEL: define float @test_fcmp_arg_non_zero(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp ogt float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[SEL:%.*]] = select nnan nsz i1 [[CMP1]], float [[ADD]], float 1.000000e+00
; CHECK-NEXT:    ret float [[SEL]]
;
  %cmp1 = fcmp ogt float %in, 1.000000e+00
  %add = fadd float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

; fcmp has more than one use.
define float @test_fcmp_multiple_uses(float %in) {
; CHECK-LABEL: define float @test_fcmp_multiple_uses(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp ogt float [[IN]], 0.000000e+00
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[ADD_2:%.*]] = fadd float [[IN]], 1.000000e+00
; CHECK-NEXT:    [[SEL_1:%.*]] = select nnan nsz i1 [[CMP1]], float [[ADD]], float 1.000000e+00
; CHECK-NEXT:    [[SEL_2:%.*]] = select nnan nsz i1 [[CMP1]], float 2.000000e+00, float [[ADD_2]]
; CHECK-NEXT:    [[RES:%.*]] = fadd float [[SEL_1]], [[SEL_2]]
; CHECK-NEXT:    ret float [[RES]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd float %in, 1.000000e+00
  %add.2 = fadd float %in, 1.000000e+00
  %sel.1 = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  %sel.2 = select nnan nsz i1 %cmp1, float 2.000000e+00, float %add.2
  %res = fadd float %sel.1, %sel.2
  ret float %res
}

; Rewrite-based flags propagation
define float @test_fcmp_ogt_fadd_select_rewrite_flags1(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_rewrite_flags1(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call reassoc nsz arcp contract afn float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd reassoc nnan nsz arcp contract afn float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd reassoc afn arcp contract float %in, 1.000000e+00
  %sel = select nnan nsz reassoc afn arcp contract i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ogt_fadd_select_rewrite_flags2(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_rewrite_flags2(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call nsz float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd nnan nsz float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp ogt float %in, 0.000000e+00
  %add = fadd reassoc float %in, 1.000000e+00
  %sel = select nnan nsz i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}

define float @test_fcmp_ogt_fadd_select_rewrite_and_fastmath(float %in) {
; CHECK-LABEL: define float @test_fcmp_ogt_fadd_select_rewrite_and_fastmath(
; CHECK-SAME: float [[IN:%.*]]) {
; CHECK-NEXT:    [[SEL_NEW:%.*]] = call reassoc nnan nsz arcp contract afn float @llvm.maxnum.f32(float [[IN]], float 0.000000e+00)
; CHECK-NEXT:    [[ADD_NEW:%.*]] = fadd fast float [[SEL_NEW]], 1.000000e+00
; CHECK-NEXT:    ret float [[ADD_NEW]]
;
  %cmp1 = fcmp nnan ogt float %in, 0.000000e+00
  %add = fadd fast reassoc float %in, 1.000000e+00
  %sel = select fast i1 %cmp1, float %add, float 1.000000e+00
  ret float %sel
}
