#include <cmath>
#include "Cost_spikespec_event_fcn.h"
#define PI 3.14159265358979323846

void Cost_spikespec_event_fcn::cost_transform ()
{
  if (inter)
    {
      double *series_ptr = this->series->fortran_vec ();
      for (octave_idx_type i = 1; i < this->series->rows (); i++)
        {
          series_ptr[i] = series_ptr[i] + series_ptr[i-1];
        }
    }
  // Sort
  *(this->series) = this->series->sort ();

  // Initialize default parameters and establish baseline for computing cost
  this->init ();
}

Matrix Cost_spikespec_event_fcn::cost_inverse () const
{
  Matrix out (*(this->series));

  if (inter)
    {
      double *out_ptr = out.fortran_vec ();
      for (octave_idx_type i = this->series->rows () - 1; i > 0; i--)
        out_ptr[i] = out_ptr[i] - out_ptr[i-1];
    }

  return out;
}

void Cost_spikespec_event_fcn::init ()
{
  octave_idx_type rows = this->series->rows ();
  double *series_ptr = this->series->fortran_vec ();
  if (this->fmax <= 0)
    this->fmax = (double)(2 * rows) / (series_ptr[rows-1] - series_ptr[0]);
  if (this->nfreq <= 0)
    this->nfreq = this->fmax * (series_ptr[rows-1] - series_ptr[0]) / 2;

//  establish base line for computing cost
  this->sspect (this->nfreq, this->fmax / this->nfreq, this->sp0r, this->sp0i,
                this->sp0);

}

void Cost_spikespec_event_fcn::sspect (octave_idx_type nfreq, double fres,
                                       Matrix &spr, Matrix &spi, Matrix &sp)
{
  // Rescale input matrixes
  spr.resize (nfreq, 1);
  spi.resize (nfreq, 1);
  sp.resize (nfreq, 1);

  for (octave_idx_type i = 0; i < nfreq; i++)
    {
      double f     = (double)i * fres;
      double omega = 2 * PI * f;
      double sr = 0, si = 0;
      for (octave_idx_type j = 0; j < this->series->rows (); j++)
        {
          double *series_ptr = this->series->fortran_vec ();
          sr += std::cos (omega * series_ptr[j]);
          si += std::sin (omega * series_ptr[j]);
        }

      spr(i) = sr;
      spi(i) = si;
      sp(i)  = sr * sr + si * si;
    }

}
