<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Administer_Custom_Groups',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Administer_Custom_Groups',
        'label' => E::ts('Administer Custom Groups'),
        'form_values' => NULL,
        'mapping_id' => NULL,
        'search_custom_id' => NULL,
        'api_entity' => 'CustomGroup',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'is_active',
            'extends:label',
            'extends_entity_column_id:label',
            'style:label',
            'is_reserved',
            'COUNT(CustomGroup_CustomField_custom_group_id_01.id) AS COUNT_CustomGroup_CustomField_custom_group_id_01_id',
            'GROUP_CONCAT(DISTINCT CustomGroup_CustomField_custom_group_id_01.label) AS GROUP_CONCAT_CustomGroup_CustomField_custom_group_id_01_label',
          ],
          'orderBy' => [],
          'where' => [['is_reserved', '=', FALSE]],
          'groupBy' => [
            'id',
          ],
          'join' => [
            [
              'CustomField AS CustomGroup_CustomField_custom_group_id_01',
              'LEFT',
              [
                'id',
                '=',
                'CustomGroup_CustomField_custom_group_id_01.custom_group_id',
              ],
            ],
          ],
          'having' => [],
        ],
        'expires_date' => NULL,
        'description' => NULL,
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Administer_Custom_Groups_SearchDisplay_Table',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Table',
        'label' => E::ts('Table'),
        'saved_search_id.name' => 'Administer_Custom_Groups',
        'type' => 'table',
        'settings' => [
          'actions' => FALSE,
          'limit' => 50,
          'classes' => [
            'table',
            'table-striped',
          ],
          'pager' => [
            'show_count' => TRUE,
            'expose_limit' => TRUE,
            'hide_single' => TRUE,
          ],
          'sort' => [],
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'dataType' => 'String',
              'label' => E::ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'title',
              'dataType' => 'String',
              'label' => E::ts('Group Title'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'extends_entity_column_id:label',
              'dataType' => 'Integer',
              'label' => E::ts('Used for'),
              'sortable' => TRUE,
              'empty_value' => '[extends:label]',
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'dataType' => 'Boolean',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'style:label',
              'dataType' => 'String',
              'label' => E::ts('Style'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'html',
              'key' => 'GROUP_CONCAT_CustomGroup_CustomField_custom_group_id_01_label',
              'dataType' => 'String',
              'label' => E::ts('Fields'),
              'sortable' => TRUE,
              'rewrite' => "{capture assign=fields}[GROUP_CONCAT_CustomGroup_CustomField_custom_group_id_01_label]{/capture}{\$fields|replace:',':'<br>'}",
            ],
            [
              'size' => 'btn-xs',
              'links' => [
                [
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '',
                  'icon' => 'fa-list-alt',
                  'text' => E::ts('Fields (%1)', [1 => '[COUNT_CustomGroup_CustomField_custom_group_id_01_id]']),
                  'style' => 'default',
                  'path' => 'civicrm/admin/custom/group/fields#/?gid=[id]',
                  'condition' => [],
                ],
                [
                  'entity' => 'CustomGroup',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Settings'),
                  'style' => 'default',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'buttons',
              'alignment' => 'text-right',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'CustomGroup',
                  'action' => 'preview',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-eye',
                  'text' => E::ts('Preview Group'),
                  'style' => 'default',
                  'path' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'CustomGroup',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'condition' => ['is_active', '=', FALSE],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'CustomGroup',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'condition' => ['is_active', '=', TRUE],
                ],
                [
                  'entity' => 'CustomGroup',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete Group'),
                  'style' => 'danger',
                  'path' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'draggable' => 'weight',
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
          'placeholder' => 5,
          'toolbar' => [
            [
              'entity' => 'CustomGroup',
              'action' => 'add',
              'target' => 'crm-popup',
              'style' => 'primary',
              'text' => E::ts('Add Set of Custom Fields'),
              'icon' => 'fa-plus',
              'autoOpen' => TRUE,
            ],
          ],
        ],
        'acl_bypass' => FALSE,
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
];
