# CiviCRM 5.51.0

Released July 6, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **Import validate related contacts in the same way as the main contact
  ([23455](https://github.com/civicrm/civicrm-core/pull/23455))**

  Improves validation of related contacts when importing by using the same
  logic that is used for the main contact.

- **Import - make tracking fields import-specific
  ([23692](https://github.com/civicrm/civicrm-core/pull/23692))**

  Makes it so administrators can define the fields they track when importing.

- **Use UI Queue runner for import
  ([23669](https://github.com/civicrm/civicrm-core/pull/23669) and
  [23712](https://github.com/civicrm/civicrm-core/pull/23712))**

  Improves Import experience by using UI Queue runner.

- **Civi::queue() - Add support for 'template' queues
  ([23679](https://github.com/civicrm/civicrm-core/pull/23679))**

  Adds support for creating template queues.

- **CRM_Queue_Task - Track an optional `$runAs` property
  ([23743](https://github.com/civicrm/civicrm-core/pull/23743))**

  Adds tracking for the Queue task `$runAs` property.

- **CRM_Queue_Runner - Add basic/skeletal support for `runAllInteractively()`
  ([23746](https://github.com/civicrm/civicrm-core/pull/23746))**

  Adds a third Queue Runner mechanism/helper `runAllInteractively`.

- **Queue - When UserJob has no more tasks, update status & fire hook
  ([23711](https://github.com/civicrm/civicrm-core/pull/23711))**

  Updates the queue status when all tasks in the queue have been completed.

- **Define interfaces for interacting with newly cleaned up import code
  (partial work on [dev/core#3514](https://lab.civicrm.org/dev/core/-/issues/3514):
  [23888](https://github.com/civicrm/civicrm-core/pull/23888) and
  [23893](https://github.com/civicrm/civicrm-core/pull/23893))**

  Extensions can define UserJob types so that they can provide their own import
  handling.

- **Define more usable queue DX for multithreaded background work (Work Towards
  [dev/core#1304](https://lab.civicrm.org/dev/core/-/issues/1304):
  [22762](https://github.com/civicrm/civicrm-core/pull/22762) and
  [23667](https://github.com/civicrm/civicrm-core/pull/23667))**

  Defines 'status' and 'error' columns for `civicrm_queue` table and allows
  background worker to drive tasks via APIv4.

- **Enable ability to require tags in profiles
  ([23645](https://github.com/civicrm/civicrm-core/pull/23645))**

  Enables the ability to make the Tag field required in a profile.

- **Add view link to user job monitoring page
  ([23838](https://github.com/civicrm/civicrm-core/pull/23838))**

  Improves user experience by adding a view link to the user job monitoring
  page.

- **Add upgrade for label to name conversion in `civicrm_mapping_field` for
  multiple custom imports
  ([23737](https://github.com/civicrm/civicrm-core/pull/23737))**

  Improves import experience when importing custom fields that allow multiple
  values.

- **RelationshipCache - Set 'get' permissions
  ([23684](https://github.com/civicrm/civicrm-core/pull/23684))**

  Gives lesser-permissioned users access to the RelationshipCache entity, for
  Search Kit.

- **Make this error message more informative.
  ([23599](https://github.com/civicrm/civicrm-core/pull/23599))**

  Improves error message text.

- **Scan for classes based on the PHP interface (WorkflowMessageInterface,
  ExampleDataInterface)
  ([23854](https://github.com/civicrm/civicrm-core/pull/23854) and
  [23903](https://github.com/civicrm/civicrm-core/pull/23903))**

  This provides a general class scanner that can be used for finding and loading
  PHP classes based upon their tagged interfaces.  It also replaces
  single-purpose scans for `WorkflowMessageInterface` and `ExampleDataInterface`
  with implementations of the scanner.

- **Add Authx settings to navigation
  ([23631](https://github.com/civicrm/civicrm-core/pull/23631))**

  Adds Authx settings to the Navigation menu.

- **APIv4 - Filter custom fields based on supplied values
  ([23489](https://github.com/civicrm/civicrm-core/pull/23489))**

  Improves APIv4 metadata, allows targeted getfields for a particular entity or
  type of entity.

- **APIv4 - Export options along with custom field
  ([23452](https://github.com/civicrm/civicrm-core/pull/23452))**

  Exports option groups and option values along with a custom field.

- **Search kit grand totals
  ([23454](https://github.com/civicrm/civicrm-core/pull/23454))**

  Adds a row to SearchKit table displays for grand totals, averages, counts and
  other statistics. The aggregation method used can be configured per-column.

- **SearchKit - Default to simple pager when creating new table display
  ([23436](https://github.com/civicrm/civicrm-core/pull/23436))**

  Improves SearchKit user experience by defaulting to a simple pager.

- **SearchKit - add address proximity (map radius) search
  ([23597](https://github.com/civicrm/civicrm-core/pull/23597))**

  Allows searching for addresses within a given distance of a location in
  SearchKit.

- **SearchKit - Allow SearchSegments to be packaged as .mgd.php
  ([23578](https://github.com/civicrm/civicrm-core/pull/23578))**

  Allows SearchSegments to be packaged and distributed in extensions, along
  with Saved Searches and Search Displays.

- **SearchKit - Make loading placeholders configurable
  ([23702](https://github.com/civicrm/civicrm-core/pull/23702))**

  Allows administrators to control how many (if any) skeleton results are shown
  during ajax loading. It also lightens the colors to make the animation a bit
  more subtle.

- **Search-kit - allow functions in the GROUP BY clause
  ([dev/core#2485](https://lab.civicrm.org/dev/core/-/issues/2485):
  [23434](https://github.com/civicrm/civicrm-core/pull/23434))**

  Improves SearchKit so that one can have functions in the GROUP BY clause.

- **SearchKit - Default to search for individuals
  ([23385](https://github.com/civicrm/civicrm-core/pull/23385))**

  When clicking "+ New Search" in Search Kit, defaults to search for Individuals
  instead of all contacts.

- **Make SearchKit available to non-admin users
  ([dev/core#3457](https://lab.civicrm.org/dev/core/-/issues/3457):
  [23670](https://github.com/civicrm/civicrm-core/pull/23670))**

  Makes SearchKit available to non-admins by adding a new permission.

- **Dashboard - Efficiency tweak
  ([23439](https://github.com/civicrm/civicrm-core/pull/23439))**

  Improves the efficiency of the Dashboard.

- **Dashboard - Sort available dashlets alphabetically, add search box
  ([23438](https://github.com/civicrm/civicrm-core/pull/23438))**

  Improves user experience of the Dashboard by adding a search box and sorting
  available dashlets alphabetically.

- **Dashboard - Show full title when hovering an inactive dashlet
  ([23433](https://github.com/civicrm/civicrm-core/pull/23433))**

  Improves user experience on the Dashboard by showing the full title when
  hovering over an inactive dashlet.

- **Afform - support relationships
  ([23296](https://github.com/civicrm/civicrm-core/pull/23296))**

  Adds support for Relationships to Afform.

- **Afform - Add undo/redo buttons to the Admin UI
  ([23648](https://github.com/civicrm/civicrm-core/pull/23648))**

  Improves user experience of Afform by adding undo and redo buttons to the
  Admin UI.

- **Afform - Add 'administer afform' permission
  ([23687](https://github.com/civicrm/civicrm-core/pull/23687))**

  Adds a new permission to allow non-system-admins to access Form Builder

- **Afform - dispatch event when loading afforms
 ([23488](https://github.com/civicrm/civicrm-core/pull/23488))**

 Adds a hook-event which allows extensions to dynamically add Afforms.

### CiviCase

- **Make CaseType usable in Afform & SearchKit
  ([23640](https://github.com/civicrm/civicrm-core/pull/23640))**

  Adds the `CaseType` entity to Afform and Searchkit.

### CiviContribute

- **Add price set entity api4 support
  ([23694](https://github.com/civicrm/civicrm-core/pull/23694))**

  Extends APIv4 to support the `PriceSet` entity.

- **Proposal - make future recurring contribution instances modifiable & not
  fail if the only contribution is deleted. (Work Towards
  [dev/financial#6](https://lab.civicrm.org/dev/financial/-/issues/6):
  [22487](https://github.com/civicrm/civicrm-core/pull/22487))**

  Makes it so `Contribution.repeattransaction` uses the template contribution.

### CiviGrant

- **CiviGrant - Add prefix to permission label
  ([23668](https://github.com/civicrm/civicrm-core/pull/23668))**

  Makes CiviGrant permissions easier to read on the Manage Permissions page.

### CiviMail

- **Mailing List Subscription: remove the cancel button
  ([23696](https://github.com/civicrm/civicrm-core/pull/23696))**

  Improves user experience by removing the cancel button from the Mailing List
  Subscription form.

### Drupal Integration

- **Epic: Drupal 10 readiness: Allow wider range of psr-log versions to be
  installed (Work Towards
  [dev/drupal#176](https://lab.civicrm.org/dev/drupal/-/issues/176):
  [23409](https://github.com/civicrm/civicrm-core/pull/23409))**

  Work Towards Drupal 10 readiness specifically by allowing a wider range of
  psr-log versions to be installed.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Dedupe rule creation should display labels of contact types, in case they
  have been customised
  ([dev/core#492](https://lab.civicrm.org/dev/core/-/issues/492):
  [23460](https://github.com/civicrm/civicrm-core/pull/23460))**

- **Can not use Custom Fields defined on a contact_sub_type in dedupe rule
  ([dev/core#2300](https://lab.civicrm.org/dev/core/-/issues/2300):
  [23459](https://github.com/civicrm/civicrm-core/pull/23459))**

- **Activity import ignores time component of activity_date_time if the import
  file includes seconds and always ignores time for custom date fields
  ([dev/core#2325](https://lab.civicrm.org/dev/core/-/issues/2325):
  [23754](https://github.com/civicrm/civicrm-core/pull/23754) and
  [23708](https://github.com/civicrm/civicrm-core/pull/23708))**

- **Muti-select import not working for Activity
  ([dev/core#2706](https://lab.civicrm.org/dev/core/-/issues/2706)
  and [dev/core#2308](https://lab.civicrm.org/dev/core/-/issues/2308):
  [23764](https://github.com/civicrm/civicrm-core/pull/23764))**

- **Import fails on adding contacts to a group using contact ID only
  ([dev/core#3160](https://lab.civicrm.org/dev/core/-/issues/3160):
  [23756](https://github.com/civicrm/civicrm-core/pull/23756))**

- **Add 'yesno' html_type in Settings metadata
  ([dev/core#3475](https://lab.civicrm.org/dev/core/-/issues/3475):
  [23525](https://github.com/civicrm/civicrm-core/pull/23525))**

  Allows 'yesno' as a valid value of `html_type`.

- **Primary email is not visually marked as primary
  ([dev/core#3481](https://lab.civicrm.org/dev/core/-/issues/3481):
  [23686](https://github.com/civicrm/civicrm-core/pull/23686))**

  Fixes bug where Primary email was not bolded on the contact summary page when
  not using english.

- **Error when deleting a note: Undefined index: parent_id in
  CRM_Note_Form_Note->postProcess()
  ([dev/core#3483](https://lab.civicrm.org/dev/core/-/issues/3483):
  [23730](https://github.com/civicrm/civicrm-core/pull/23730))**

- **Import Custom Data - Review of refactorings (Work Towards
  [dev/core#3498](https://lab.civicrm.org/dev/core/-/issues/3498):
  [23736](https://github.com/civicrm/civicrm-core/pull/23736))**

  Fixes mishandled option values in import custom data code.

- **CiviCRM has not bootstrapped sufficiently to fire event
  "hook_civicrm_entityTypes".
  ([dev/core#3496](https://lab.civicrm.org/dev/core/-/issues/3496):
  [23718](https://github.com/civicrm/civicrm-core/pull/23718))**

  Missing extension leads to bootstrap error for "hook_civicrm_entityTypes".

- **CiviCRM has not bootstrapped sufficiently to fire event
  "hook_civicrm_entity_supported_info"
  ([dev/core#3502](https://lab.civicrm.org/dev/core/-/issues/3502):
  [23785](https://github.com/civicrm/civicrm-core/pull/23785))**

  Softer errors when CiviEventDispatcher is not-ready.

- **Import fixes for unicode url, Côte d’Ivoire
  ([dev/core#3505](https://lab.civicrm.org/dev/core/-/issues/3505),
  [dev/core#3506](https://lab.civicrm.org/dev/core/-/issues/3506),
  [dev/core#3052](https://lab.civicrm.org/dev/core/-/issues/3052), and
  [dev/core#3706](https://lab.civicrm.org/dev/core/-/issues/3706):
  [23755](https://github.com/civicrm/civicrm-core/pull/23755) and
  [23920](https://github.com/civicrm/civicrm-core/pull/23920))**

- **After completing an activity import, it takes you to the contact import
  screen ([dev/core#3513](https://lab.civicrm.org/dev/core/-/issues/3513):
  [23766](https://github.com/civicrm/civicrm-core/pull/23766))**

  Removes 'done' from the summary/import monitoring page.

- **Fix import activity & add tests
  ([23707](https://github.com/civicrm/civicrm-core/pull/23707))**

  Fixes a Fatal error in MapField.

- **Activity import error output missing the column the error is about
  ([dev/core#3651](https://lab.civicrm.org/dev/core/-/issues/3651) and
  [dev/core#1337](https://lab.civicrm.org/dev/core/-/issues/1337):
  [23771](https://github.com/civicrm/civicrm-core/pull/23771))**

  Fixes failure to show last column data in output, spaces in names.

- **Custom data type grouping mismatch
  (Work Towards [dev/core#3658](https://lab.civicrm.org/dev/core/-/issues/3658):
  [23842](https://github.com/civicrm/civicrm-core/pull/23842))**

  Regenerates civicrm_generated to ensure that grouping is added on installs.

- **When upgrading an extension to use mixins, existing managed entities
  get deleted ([dev/core#3660](https://lab.civicrm.org/dev/core/-/issues/3660):
  [23824](https://github.com/civicrm/civicrm-core/pull/23824))**

- **Permissioned Relationship no longer set up for "On Behalf of Organization"
  Membership Contribution Form submissions
  ([dev/core#3675](https://lab.civicrm.org/dev/core/-/issues/3675):
  [23865](https://github.com/civicrm/civicrm-core/pull/23865))**

- **Fix issue #116 api3 chain check_permissions
  ([23671](https://github.com/civicrm/civicrm-core/pull/23671))**

- **Handle empty date token gracefully
  ([23827](https://github.com/civicrm/civicrm-core/pull/23827))**

- **Fix Automatic renewal membership from front end contribution forms
  ([23798](https://github.com/civicrm/civicrm-core/pull/23798))**

- **Fix target contact label back to include target
  ([23763](https://github.com/civicrm/civicrm-core/pull/23763))**

- **Dedupe - Fix form buttons (again)
  ([23757](https://github.com/civicrm/civicrm-core/pull/23757))**

- **Ensure setting deceased date sets is_deceased in the BAO
  ([23521](https://github.com/civicrm/civicrm-core/pull/23521))**

- **Fix use of not-universally supported mysql field type
  ([23501](https://github.com/civicrm/civicrm-core/pull/23501))**

- **Remove extra question mark from url
  ([23480](https://github.com/civicrm/civicrm-core/pull/23480))**

- **Fix Schema System Check translation and show missing Custom Field ID
  ([23469](https://github.com/civicrm/civicrm-core/pull/23469))**

- **php8.1 - Check null first before sending to strlen
  ([23589](https://github.com/civicrm/civicrm-core/pull/23589))**

- **PHP8.1 - Fix deprecated passing null to glob
  ([23713](https://github.com/civicrm/civicrm-core/pull/23713))**

- **Typo fix for Entity Id
  ([23693](https://github.com/civicrm/civicrm-core/pull/23693))**

- **fix to get around link issues in ckeditor when opening scheduled reminder
  in popup ([23510](https://github.com/civicrm/civicrm-core/pull/23510))**

- **fix disableUSPS since import running in separate context of Queue.
  ([23777](https://github.com/civicrm/civicrm-core/pull/23777))**

- **Expand try-catch to whole function
  ([23704](https://github.com/civicrm/civicrm-core/pull/23704))**

- **Make try-catch more catchy
  ([23700](https://github.com/civicrm/civicrm-core/pull/23700))**

- **Print report permissions
  ([dev/core#2540](https://lab.civicrm.org/dev/core/-/issues/2540):
  [23616](https://github.com/civicrm/civicrm-core/pull/23616))**

  Fixes a bug where when disabling the “access Report Criteria” permission, the
  "Print report" and "Print to PDF" functions on a report appear, but do not
  function.

- **Fix createEmployerRelationship to work with the data it has when doing a
  lookup, test ([23603](https://github.com/civicrm/civicrm-core/pull/23603))**

- **Fix swapOptions writing over selected options on mapField page load.
  ([23619](https://github.com/civicrm/civicrm-core/pull/23619))**

- **Release lock when deleting cache key
  ([23624](https://github.com/civicrm/civicrm-core/pull/23624))**

- **Greeting handling - if email_greeting_custom (etc) isset &
  email_greeting_id is not, set to 'Customized'
  ([23537](https://github.com/civicrm/civicrm-core/pull/23537))**

- **Catch & convert Guzzle exception
  ([23765](https://github.com/civicrm/civicrm-core/pull/23765))**

- **CRM_Utils_Check - Catch Guzzle exception, same as core exception
  ([23466](https://github.com/civicrm/civicrm-core/pull/23466))**

- **Allow for custom base page in AJAX requests
  ([23420](https://github.com/civicrm/civicrm-core/pull/23420))**

  Fixes a bug where custom base page does not work for AJAX requests from
  "frontend".

- **Add integer validation to import
  ([23753](https://github.com/civicrm/civicrm-core/pull/23753))**

- **E-notice fix on import
  ([23541](https://github.com/civicrm/civicrm-core/pull/23541))**

- **Import - ensure userID is set on parser
  ([23636](https://github.com/civicrm/civicrm-core/pull/23636))**

- **Import locations - code cleanup, add tests, fix bugs
  ([23563](https://github.com/civicrm/civicrm-core/pull/23563))**

  Most of this is code cleanup and tests but there is also a fix for importing
  contacts with a location of Australia.

- **Import - Relax "is_required" check for custom fields
  ([23576](https://github.com/civicrm/civicrm-core/pull/23576))**

- **returns weight 0 when weight column name is empty
  ([23874](https://github.com/civicrm/civicrm-core/pull/23874))**

  If a DAO lacks a weight field, the weight should simply return 0 instead of
  causing an error.  This resolves issues with upgrades in certain
  circumstances.

- **When upgrading an extension to use mixins, existing managed entities get
  deleted ([dev/core#3660](https://lab.civicrm.org/dev/core/-/issues/3660):
  [23900](https://github.com/civicrm/civicrm-core/pull/23900))*

- **APIv4 - Respect max length for name with export action
  ([23472](https://github.com/civicrm/civicrm-core/pull/23472))**

- **APIv4 - Exclude disabled custom fields
  ([23583](https://github.com/civicrm/civicrm-core/pull/23583))**

- **APIv4 - Allow creator to read `UserJob` and `Queue` records
  ([23690](https://github.com/civicrm/civicrm-core/pull/23690))**

- **SearchKit - Fix pager & tab count after creating a new record in a popup
  ([23579](https://github.com/civicrm/civicrm-core/pull/23579))**

- **SearchKit - Only add filter values to Afform title if passed internally
  ([23807](https://github.com/civicrm/civicrm-core/pull/23807))**

- **[REGRESSION] SearchKit - Fix angular console error when totalCount is not
  given ([23759](https://github.com/civicrm/civicrm-core/pull/23759))**

- **SearchKit - Fix default aggregate function for grand total rows
  ([23573](https://github.com/civicrm/civicrm-core/pull/23573))**

- **SearchKit - Fix in-place editing custom relationship fields
  ([23496](https://github.com/civicrm/civicrm-core/pull/23496))**

- **Searchkit - can't export more than x rows
  ([dev/core#2736](https://lab.civicrm.org/dev/core/-/issues/2736):
  [23548](https://github.com/civicrm/civicrm-core/pull/23548))**

- **SearchKit - Make inline edit only available when applicable
  ([23404](https://github.com/civicrm/civicrm-core/pull/23404))**

- **SearchKit - Pick better default for aggregate functions
  ([23446](https://github.com/civicrm/civicrm-core/pull/23446))**

- **SearchKit - Don't transform case for fieldsets on admin screen (more
  translation-friendly)
  ([23437](https://github.com/civicrm/civicrm-core/pull/23437))**

- **Afform - fix dependency injection for autogenerated forms
  ([23818](https://github.com/civicrm/civicrm-core/pull/23818))**

## CiviCampaign

- **show honor roll only if it's enabled for the PCP page
  ([23567](https://github.com/civicrm/civicrm-core/pull/23567))**

### CiviCase

- **Update case via API4 fails
  ([dev/core#3671](https://lab.civicrm.org/dev/core/-/issues/3671):
  [23836](https://github.com/civicrm/civicrm-core/pull/23836) and
  [23876](https://github.com/civicrm/civicrm-core/pull/23876))**

  Fix regression where updating cases via APIv4 fails.

### CiviContribute

- **Currency incorrectly displayed for price set text/quantity fields when
  default currency is not USD
  ([dev/core#3680](https://lab.civicrm.org/dev/core/-/issues/3680):
  [23867](https://github.com/civicrm/civicrm-core/pull/23867))**

- **Fix editing and saving a template contribution via form
  ([21471](https://github.com/civicrm/civicrm-core/pull/21471))**

- **Fix breakage in message preview on workflow contributions
  ([23801](https://github.com/civicrm/civicrm-core/pull/23801))**

- **only check batch currency match when adding a financial_trxn
  ([23788](https://github.com/civicrm/civicrm-core/pull/23788))**

- **Can no longer update Amount for Recurring Contributions even if it only has
  one Lineitem
  ([dev/financial#197](https://lab.civicrm.org/dev/financial/-/issues/197):
  [23805](https://github.com/civicrm/civicrm-core/pull/23805))**

- **Additional Details section on Recurring Contribution template edit screen
  doesn't load anymore
  ([dev/financial#199](https://lab.civicrm.org/dev/financial/-/issues/199):
  [23786](https://github.com/civicrm/civicrm-core/pull/23786))**

- **Fix Contribution import with pledge handling, add test
  ([23717](https://github.com/civicrm/civicrm-core/pull/23717))**

- **Contribution import - tests & fixes on dates, amount  
  ([23688](https://github.com/civicrm/civicrm-core/pull/23688))**

- **[Import] Fix Contribution Import mapping fields to use labels
  ([23519](https://github.com/civicrm/civicrm-core/pull/23519))**

- **Import contribution fails to update payment instrument in update mode
  ([dev/core#3038](https://lab.civicrm.org/dev/core/-/issues/3038):
  [23586](https://github.com/civicrm/civicrm-core/pull/23586))**

### CiviEvent

- **Fix missing contactID when registering for paid event from waitlist
  ([23358](https://github.com/civicrm/civicrm-core/pull/23358))**

- **Capitalise event setting title
  ([23467](https://github.com/civicrm/civicrm-core/pull/23467))**

- **Participant import fix - broken uniqueName fields, mapping saving, etc.
  ([23733](https://github.com/civicrm/civicrm-core/pull/23733))**

- **Fix Participant import, add tests
  ([23703](https://github.com/civicrm/civicrm-core/pull/23703))**

  Fixes a Fatal error in MapField.

- **CiviEvent Search does not show all results
  ([dev/core#3459](https://lab.civicrm.org/dev/core/-/issues/3459):
  [23609](https://github.com/civicrm/civicrm-core/pull/23609))**

### CiviGrant

- **Installer - CiviGrant option no longer works
  ([dev/core#3485](https://lab.civicrm.org/dev/core/-/issues/3485):
  [23758](https://github.com/civicrm/civicrm-core/pull/23758))**

  Removes CiviGrant from available components.

- **Grant export Amount Granted or Amount Requested fields are blank, and
  CiviGrant Date Fields no longer respect relative dates in Advanced Search
  ([dev/core#3503](https://lab.civicrm.org/dev/core/-/issues/3503) and
  [dev/core#3492](https://lab.civicrm.org/dev/core/-/issues/3492):
  [23904](https://github.com/civicrm/civicrm-core/pull/23904))**

### CiviMail

- **Prefer frontend_title for mailing groups in {mailing.group}
  ([dev/core#3463](https://lab.civicrm.org/dev/core/-/issues/3463):
  [23570](https://github.com/civicrm/civicrm-core/pull/23570))**

- **Greeting tokens are not replaced in bulk sms
  ([dev/core#3177](https://lab.civicrm.org/dev/core/-/issues/3177):
  [23516](https://github.com/civicrm/civicrm-core/pull/23516))**

  Switches sms to use flexmailer token rendering.

### CiviMember

- **Bug Fix: Merging an Organisation contact and de-selecting the merge
  Membership checkbox causes all related Membership to not be removed and the
  Primary Membership is linked to the deleted Organisation
  ([22682](https://github.com/civicrm/civicrm-core/pull/22682))**

- **Added back 'Renewal Message' field on Membership renewal form
  ([23726](https://github.com/civicrm/civicrm-core/pull/23726))**

- **Membership should be listed chronologically by join date, the most recent
  member since first
  ([dev/core#3141](https://lab.civicrm.org/dev/core/-/issues/3141):
  [23056](https://github.com/civicrm/civicrm-core/pull/23056))**

### Backdrop Integration

- **CiviCRM cron via HTTP on Backdrop isn't documented and doesn't work
  ([dev/backdrop#8](https://lab.civicrm.org/dev/backdrop/-/issues/8):
  [23620](https://github.com/civicrm/civicrm-core/pull/23620))**

### Drupal Integration

- **Use correct user variable in hook_user_insert
  ([74](https://github.com/civicrm/civicrm-drupal-8/pull/74))**

- **KCFinder on D9: You don't have permissions to browse server.
  ([dev/drupal#179](https://lab.civicrm.org/dev/drupal/-/issues/179):
  [342](https://github.com/civicrm/civicrm-packages/pull/342))**

- **Drupal8/9 Sync email own user from Civi
  ([dev/core#3467](https://lab.civicrm.org/dev/core/-/issues/3467):
  [23546](https://github.com/civicrm/civicrm-core/pull/23546))**

  Drupal 8 - Skips requirement for password when changing your own civi contact's
  email

### Joomla Integration

- **[Joomla 4.0] Warnings when CiviCRM is uninstalled (Work towards
  [dev/joomla#16](https://lab.civicrm.org/dev/joomla/-/issues/16):
  [65](https://github.com/civicrm/civicrm-joomla/pull/65))**

  Fixes CiviCRM logo not showing in Quick Icon plugin.

- **[Joomla 4.0] Fatal error on submitting Profile with CMS username/password
  ([23549](https://github.com/civicrm/civicrm-core/pull/23549))**

- **Error when upgrading to 5.16.0
  ([dev/drupal#79](https://lab.civicrm.org/dev/drupal/issues/79):
  [51](https://github.com/civicrm/civicrm-joomla/pull/51))**

  Updates PHP version checks to throw a more digestable error when the PHP
  version is not compatible.

### WordPress Integration

- **Rc import with Wordpress goes to the right url but doesn't 'refresh'
  ([dev/core#3707](https://lab.civicrm.org/dev/core/-/issues/3707):
  [23927](https://github.com/civicrm/civicrm-core/pull/23927))**

## <a name="misc"></a>Miscellany

- **Afform - Trigger 'crmFormSuccess' event after submission
  ([23735](https://github.com/civicrm/civicrm-core/pull/23735))**

- **Afform - allow ids to be passed directly into the directive
  ([23656](https://github.com/civicrm/civicrm-core/pull/23656))**

- **SearchKit - Remove confusing extra joins between Contact & Related Contacts
  ([23655](https://github.com/civicrm/civicrm-core/pull/23655))**

- **Authx - Mark extension as beta
  ([23601](https://github.com/civicrm/civicrm-core/pull/23601))**

- **Duplicate function - divide & conquer
  ([23542](https://github.com/civicrm/civicrm-core/pull/23542))**

- **Deprecate crazy BAO handling of preferred_communication_method
  ([23623](https://github.com/civicrm/civicrm-core/pull/23623))**

- **Simplify return from createContact
  ([23635](https://github.com/civicrm/civicrm-core/pull/23635))**

- **Simplify greeting handling, add test
  ([23629](https://github.com/civicrm/civicrm-core/pull/23629))**

- **Deprecate stuff getting super deep into the BAO unformatted
  ([23520](https://github.com/civicrm/civicrm-core/pull/23520))**

- **Add not-yet-used function to allow the import to run in static (queue)
  context ([23691](https://github.com/civicrm/civicrm-core/pull/23691))**

- **FiveFiftyOne - Enable snapshots for data modified data
  ([23783](https://github.com/civicrm/civicrm-core/pull/23783))**

- **Translation: remove support for CiviCRM pre-4.5 l10n file locations
  ([23435](https://github.com/civicrm/civicrm-core/pull/23435))**

- **APIv3 - Fix regression in handling chained calls with `sequential`
  ([23672](https://github.com/civicrm/civicrm-core/pull/23672))**

- **Update contributor-key.yml
  ([23633](https://github.com/civicrm/civicrm-core/pull/23633))**

- **Whitespace cleanup - remove `if(1)`
  ([23621](https://github.com/civicrm/civicrm-core/pull/23621))**

- **Reformat whitespace
  ([23676](https://github.com/civicrm/civicrm-core/pull/23676))**

- **Another always-true-if
  ([23559](https://github.com/civicrm/civicrm-core/pull/23559))**

- **Painstaking unravelling of function
  ([23483](https://github.com/civicrm/civicrm-core/pull/23483))**

- **Consolidate datasource form - event import
  ([23457](https://github.com/civicrm/civicrm-core/pull/23457))**

- **Trivial extraction - addFormButtons shared code
  ([23709](https://github.com/civicrm/civicrm-core/pull/23709))**

- **Move validate field function to the parent class [Straight move]
  ([23564](https://github.com/civicrm/civicrm-core/pull/23564))**

- **Add noisy deprecation to unused, deprecated, functions
  ([23571](https://github.com/civicrm/civicrm-core/pull/23571))**

- **Minor simplification - use `$self->getContactType(),`
  ([23710](https://github.com/civicrm/civicrm-core/pull/23710))**

- **Clean up function signature
  ([23550](https://github.com/civicrm/civicrm-core/pull/23550))**

- **Minor cleanup on import return codes
  ([23626](https://github.com/civicrm/civicrm-core/pull/23626))**

- **Cleanup sql query
  ([23512](https://github.com/civicrm/civicrm-core/pull/23512))**

- **Cleanup gender handling in contact import + add test
  ([23484](https://github.com/civicrm/civicrm-core/pull/23484))**

- **ProximityQuery - Remove unused code
  ([23581](https://github.com/civicrm/civicrm-core/pull/23581))**

- **Remove unused class
  ([23580](https://github.com/civicrm/civicrm-core/pull/23580))**

- **Remove unused properties
  ([23701](https://github.com/civicrm/civicrm-core/pull/23701))**

- **Remove deprecated preferred_mail_format from more places...
  ([23565](https://github.com/civicrm/civicrm-core/pull/23565))**

- **Remove some never used fields - copy & paste begone
  ([23605](https://github.com/civicrm/civicrm-core/pull/23605))**

- **Remove obsolete code - this parameter is not possible
  ([23625](https://github.com/civicrm/civicrm-core/pull/23625))**

- **Remove unused variables
  ([23613](https://github.com/civicrm/civicrm-core/pull/23613))**

- **Remove no-longer-used function 29 points
  ([23653](https://github.com/civicrm/civicrm-core/pull/23653))**

- **Remove legacy calls to `civicrm_error`, unpack return
  ([23634](https://github.com/civicrm/civicrm-core/pull/23634))**

- **Remove some unused variables
  ([23614](https://github.com/civicrm/civicrm-core/pull/23614))**

- **Remove do-nothing deprecated line
  ([23556](https://github.com/civicrm/civicrm-core/pull/23556))**

- **Remove unreachable code
  ([23551](https://github.com/civicrm/civicrm-core/pull/23551))**

- **Remove a couple of non-test tests  - syntax conformance
  ([23715](https://github.com/civicrm/civicrm-core/pull/23715))**

- **Remove some more unused code
  ([23747](https://github.com/civicrm/civicrm-core/pull/23747))**

- **Remove always-true if-check
  ([23530](https://github.com/civicrm/civicrm-core/pull/23530))**

- **Remove extraneous deprecated check
  ([23532](https://github.com/civicrm/civicrm-core/pull/23532))**

- **Remove obsolete/unused code, fix notices - activity import
  ([23745](https://github.com/civicrm/civicrm-core/pull/23745))**

- **Remove more obsolete import code
  ([23742](https://github.com/civicrm/civicrm-core/pull/23742))**

- **Remove unused functions
  ([23740](https://github.com/civicrm/civicrm-core/pull/23740))**

- **Remove always true if conditions (whitespace in next commit)
  ([23533](https://github.com/civicrm/civicrm-core/pull/23533))**

- **Remove never-true fields, and impossible property handling from previously
  shared function ([23545](https://github.com/civicrm/civicrm-core/pull/23545))**

- **Remove sets for no-longer gotten vars
  ([23453](https://github.com/civicrm/civicrm-core/pull/23453))**

- **(NFC) karma - Enable all Civi components (not just CiviCase)
  ([23450](https://github.com/civicrm/civicrm-core/pull/23450))**

- **[NFC] Improve comment blocks for mapper
  ([23517](https://github.com/civicrm/civicrm-core/pull/23517))**

- **[NFC] Remove weird file
  ([23539](https://github.com/civicrm/civicrm-core/pull/23539))**

- **[NFC] Remove weird test data file
  ([23727](https://github.com/civicrm/civicrm-core/pull/23727))**

- **[NFC] Fix Since version in Price Set Entity APIv4
  ([23698](https://github.com/civicrm/civicrm-core/pull/23698))**

- **[NFC] Mixin - update version tags and add comment for new version of mgd-php
  ([23685](https://github.com/civicrm/civicrm-core/pull/23685))**

- **[NFC] Failing test for api chain using sequential
  ([23675](https://github.com/civicrm/civicrm-core/pull/23675))**

- **(NFC) Scheduled Reminders - Reinstate and analyze test-case for "Also
  Include" ([23628](https://github.com/civicrm/civicrm-core/pull/23628))**

- **[NFC] Bring back deleted activity email tests
  ([23577](https://github.com/civicrm/civicrm-core/pull/23577))**

- **(NFC) CRM_Utils_Hook - Typo
  ([23448](https://github.com/civicrm/civicrm-core/pull/23448))**

- **Ref Extract import validation
  ([23498](https://github.com/civicrm/civicrm-core/pull/23498))**

- **[Ref] [Import] Cleanup function return
  ([23511](https://github.com/civicrm/civicrm-core/pull/23511))**

- **[REF] [Import] Remove unused parameter
  ([23495](https://github.com/civicrm/civicrm-core/pull/23495))**

- **[REF] [Import] Remove now-unused code
  ([23461](https://github.com/civicrm/civicrm-core/pull/23461))**

- **[REF] [Import] Stop calling Parser in MapField mode (contact import)
  ([23470](https://github.com/civicrm/civicrm-core/pull/23470))**

- **[REF] [Import] Minor simplification
  ([23464](https://github.com/civicrm/civicrm-core/pull/23464))**

- **[REF] [Import] Remove unused variable
  ([23463](https://github.com/civicrm/civicrm-core/pull/23463))**

- **[REF] [Import] Remove unused field get action (death to copy & paste)
  ([23428](https://github.com/civicrm/civicrm-core/pull/23428))**

- **[REF] [Import] Simplify if - exit loop early
  ([23427](https://github.com/civicrm/civicrm-core/pull/23427))**

- **[REF] [Import] Activity - clean up copy & paste
  ([23289](https://github.com/civicrm/civicrm-core/pull/23289))**

- **[Import] [Ref] Trivial - fold function contents back into parent
  ([23610](https://github.com/civicrm/civicrm-core/pull/23610))**

- **Extend import option handling to prefix, suffix, language,
  communication_style
  ([23535](https://github.com/civicrm/civicrm-core/pull/23535))**

- **[Import] Consolidate DataSource.tpl - template for first file on activity
  import ([23456](https://github.com/civicrm/civicrm-core/pull/23456))**

- **[Import] Check subtype validity in validate rather than wait for 'imort'
  ([23526](https://github.com/civicrm/civicrm-core/pull/23526))**

- **[Import] Use table rather than csvs for no-match & unparsed
  ([23418](https://github.com/civicrm/civicrm-core/pull/23418))**

- **[Import] Unpack the weird wild error return
  ([23474](https://github.com/civicrm/civicrm-core/pull/23474))**

- **[Import] Remove handling for unavailable field current_employer
  ([23509](https://github.com/civicrm/civicrm-core/pull/23509))**

- **Contribution import - simplify error handling
  ([23714](https://github.com/civicrm/civicrm-core/pull/23714))**

- **[Import] [Contribution] Cleanup templates & form variables, following
  contact pattern
  ([23683](https://github.com/civicrm/civicrm-core/pull/23683))**

- **Contact import - extract common code, make tags & groups queue-friendly
  ([23680](https://github.com/civicrm/civicrm-core/pull/23680))**

- **Contact Import cleanup - includes fixes to contact machine
  ([23666](https://github.com/civicrm/civicrm-core/pull/23666))**

- **[Import] Add some not-yet-used `getParser` functions that are prone to
  conflict ([23590](https://github.com/civicrm/civicrm-core/pull/23590))**

- **[Import] Remove empty if
  ([23531](https://github.com/civicrm/civicrm-core/pull/23531))**

- **[Import] Fix & test check on contact subtype change
  ([23508](https://github.com/civicrm/civicrm-core/pull/23508))**

- **[Import] [Ref] Remove unused variable
  ([23462](https://github.com/civicrm/civicrm-core/pull/23462))**

- **[Import] Remove silly param
  ([23493](https://github.com/civicrm/civicrm-core/pull/23493))**

- **[Import] Remove svn whimsy - DUPLICATE_REPLACE
  ([23504](https://github.com/civicrm/civicrm-core/pull/23504))**

- **[Import] Remove `if (1) {` (whitespace intensive)
  ([23494](https://github.com/civicrm/civicrm-core/pull/23494))**

- **[Import] Cleanup Contribution flow - esp with regards to soft credits
  ([23588](https://github.com/civicrm/civicrm-core/pull/23588))**

- **[Import] [Ref] [Contribution] Additional functions, typo fix
  ([23637](https://github.com/civicrm/civicrm-core/pull/23637))**

- **[Import] Test + fix for failure to reject invalid ex identifier
  ([23560](https://github.com/civicrm/civicrm-core/pull/23560))**

- **[Import] [ref] Move function to parent for use by siblings
  ([23592](https://github.com/civicrm/civicrm-core/pull/23592))**

- **[Import] Add tests for contact type & contact subtype handling
  ([23475](https://github.com/civicrm/civicrm-core/pull/23475))**

- **[Import] Simplify checking contact type is valid
  ([23476](https://github.com/civicrm/civicrm-core/pull/23476))**

- **[Import] Stop passing unused parameter
  ([23421](https://github.com/civicrm/civicrm-core/pull/23421))**

- **[Ref] [Import][Member] Remove unused params
  ([23425](https://github.com/civicrm/civicrm-core/pull/23425))**

- **[REF] [Import] Create user-job records for Memership imports
  ([23416](https://github.com/civicrm/civicrm-core/pull/23416))**

- **(REF) Importer - Remove unused parameters. Simplify signature.
  ([23401](https://github.com/civicrm/civicrm-core/pull/23401))**

- **[REF] Import - make condition clearer
  ([23382](https://github.com/civicrm/civicrm-core/pull/23382))**

- **[REF] [Import] Contribution import - clarify return codes
  ([23290](https://github.com/civicrm/civicrm-core/pull/23290))**

- **[REF] [Import] Summary tpl - remove always-true ifs
  ([23406](https://github.com/civicrm/civicrm-core/pull/23406))**

- **[REF][Import] Remove some, now unused, parameters
  ([23405](https://github.com/civicrm/civicrm-core/pull/23405))**

- **[REF] [Import] Parser cleanup
  ([23442](https://github.com/civicrm/civicrm-core/pull/23442))**

- **[REF] [Import] Minor code cleanup
  ([23444](https://github.com/civicrm/civicrm-core/pull/23444))**

- **[Import] Reduce unused copy & paste
  ([23400](https://github.com/civicrm/civicrm-core/pull/23400))**

- **[REF] [Import] Stop passing unused parameters
  ([23386](https://github.com/civicrm/civicrm-core/pull/23386))**

- **[Import] [Ref] Iterate through the mapping of fields
  ([23384](https://github.com/civicrm/civicrm-core/pull/23384))**

- **[Ref][Import] Remove now-unused code
  ([23395](https://github.com/civicrm/civicrm-core/pull/23395))**

- **[TEST ONLY] APIv4 - Remove unused extras from ConformanceTest
  ([23410](https://github.com/civicrm/civicrm-core/pull/23410))**

- **[TEST ONLY] APIv4 - ensure test records are cleaned up in non-transaction
  tests ([23441](https://github.com/civicrm/civicrm-core/pull/23441))**

- **Test cleanup - use names keys in mapper array where possible for clarity
  ([23627](https://github.com/civicrm/civicrm-core/pull/23627))**

- **Additional test
  ([23562](https://github.com/civicrm/civicrm-core/pull/23562))**

- **Add location import testing
  ([23540](https://github.com/civicrm/civicrm-core/pull/23540))**

- **Test fix
  ([23561](https://github.com/civicrm/civicrm-core/pull/23561))**

- **Add unit tests to cover date field imports
  ([23502](https://github.com/civicrm/civicrm-core/pull/23502))**

- **Payment forms test fixes
  ([23524](https://github.com/civicrm/civicrm-core/pull/23524))**

- **Re-use code in test
  ([23523](https://github.com/civicrm/civicrm-core/pull/23523))**

- **Fix test to validate forms & remove some unused code
  ([23734](https://github.com/civicrm/civicrm-core/pull/23734))**

- **Reduce test output spam
  ([23750](https://github.com/civicrm/civicrm-core/pull/23750))**

- **Fix for failing test in master
  ([23751](https://github.com/civicrm/civicrm-core/pull/23751))**

- **[REF] [TEST ONLY] APIv4 - Reorganize test classes, don't use transactions
  for custom field tests
  ([23402](https://github.com/civicrm/civicrm-core/pull/23402))**

- **[REF] Fix second output in customFormat function and extend unit test
  ([23815](https://github.com/civicrm/civicrm-core/pull/23815))**

- **(REF) CRM_Dedupe_BAO_DedupeRule - Support third party fields and tables in
  rules ([23332](https://github.com/civicrm/civicrm-core/pull/23332))**

- **Update guzzle to 6.5.7
  ([23748](https://github.com/civicrm/civicrm-core/pull/23748))**

- **[REF] Update Guzzle to be 6.5.8
  ([23858](https://github.com/civicrm/civicrm-core/pull/23858))**

- **[REF] Fix PHP8.1 issue with passing NULL to trim()
  ([23317](https://github.com/civicrm/civicrm-core/pull/23317))**

- **[REF] Remove handling for non-existent 'savedMapping' field
  ([23283](https://github.com/civicrm/civicrm-core/pull/23283))**

- **[REF] Improve Get Coordinates by supporting other geocoding providers…
  ([23646](https://github.com/civicrm/civicrm-core/pull/23646))**

- **[REF] Minor simplification on input
  ([23536](https://github.com/civicrm/civicrm-core/pull/23536))**

- **(REF) CRM_Upgrade_Form - Remove silly method `runQuery`
  ([23492](https://github.com/civicrm/civicrm-core/pull/23492))**

- **[REF] APIv4 - Simplify entity creation in test suite
  ([23432](https://github.com/civicrm/civicrm-core/pull/23432))**

- **[REF] Move list of fields that have been upgraded
  ([23518](https://github.com/civicrm/civicrm-core/pull/23518))**

- **[REF] Remove unreachable code
  ([23507](https://github.com/civicrm/civicrm-core/pull/23507))**

- **[REF] Simplify contact.create
  ([23515](https://github.com/civicrm/civicrm-core/pull/23515))**

- **[REF] Fix handling of NULL values in count_characters smarty modifier by
  creating a CiviCRM specific one that handles them
  ([23318](https://github.com/civicrm/civicrm-core/pull/23318))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
Benjamin W; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM -
Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu
Lutfy; Dave D; Davis Media Access - Darrick Servis; Deepak Srivastava;
ES-Progress - Sandor Semsey; Freeform Solutions - Herb van den Dool;
Fuzion - Luke Stewart; iXiam - César Ramos; JMA Consulting - Monish Deb, Seamus
Lee; Klangsoft - David Reedy Jr; Lighthouse Consulting and Design - Brian
Shaughnessy; Megaphone Technology Consulting - Brienne Kordis, Jon Goldberg;
MJW Consulting - Matthew Wire; Nicol Wistreich; Progressive Technology
Project - Jamie McClelland; Robert J. Lang; Squiffle Consulting - Aidan
Saunders; Third Sector Design - Kurund Jalmi; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; ALL IN APPLI; Andy Clark; Artful Robot - Rich Lott;
Australian Greens - Andrew Cormick-Dockery; Betty Dolfing; Blackfly
Solutions - Alan Dixon; CiviCoop - Jaap Jansma; Coop SymbioTIC - Samuel Vanhove;
DevApp - Adam Kwiatkowski; Francesc Bassas i Bullich; Fuzion - Peter Davis;
Greenleaf Advancement - Guy Iaccarino; Humanists UK - Andrew West; jaomalley;
Jens Schuppe; Semper IT - Karin Gerritsen; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
