# CiviCRM 5.56.0

Released December 7, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add server side validation for afform
  ([dev/core#3760](https://lab.civicrm.org/dev/core/-/issues/3760):
  [24110](https://github.com/civicrm/civicrm-core/pull/24110))**

  Adds a new 'civi.afform.validate' event and implements a listener to validate
  required fields.

- **Add previous before and previous 2 fiscal year options
  ([24752](https://github.com/civicrm/civicrm-core/pull/24752))**

  Adds a few more Fiscal Year related date range options.

- **CiviCRM sample data - use a price set for at least one contribution page &
  event ([dev/core#3685](https://lab.civicrm.org/dev/core/-/issues/3685):
  [24926](https://github.com/civicrm/civicrm-core/pull/24926))**

  Improves the sample data by having a sample contribution page and sample event
  registration page use a price set instead of quick config.

- **Contact Phone Edit: make it possible for extensions to hide the phone_ext
  field ([24782](https://github.com/civicrm/civicrm-core/pull/24782))**

  Makes it so extension developers can hide the phone extension field.

- **Extensions - Limit depth of search for "info.xml"
  ([24491](https://github.com/civicrm/civicrm-core/pull/24491))**

  Improves performance of system-flushes.

- **Can Extension boot cache use the `fastArray` decorator
  ([dev/core#3814](https://lab.civicrm.org/dev/core/-/issues/3814):
  [24692](https://github.com/civicrm/civicrm-core/pull/24692))**

  Makes the Extension boot cache use php array cache after the first hit per
  process.

- **Use API4 to get message templates over DAO function
  ([24789](https://github.com/civicrm/civicrm-core/pull/24789))**

  Makes it so message template results can be altered using hooks.

- **Add DATEDIFF to calculate days between two dates
  ([24875](https://github.com/civicrm/civicrm-core/pull/24875))**

  Makes the mysql DATEDIFF function available in APIv4.

- **Add Job Entity to Api4
  ([24747](https://github.com/civicrm/civicrm-core/pull/24747))**

  Adds the Jobs entity to APIv4.

- **ClaimItems API - Optionally return the "run as" (contact ID/domain ID)
  ([24761](https://github.com/civicrm/civicrm-core/pull/24761) and
  [24805](https://github.com/civicrm/civicrm-core/pull/24805))**

  Makes it easier to read "runAs" and adds runAs to import job Queue Task.

- **Add help text for event scheduled reminders relative and absolute dates
  ([24876](https://github.com/civicrm/civicrm-core/pull/24876))**

  Improves user experience when setting up event scheduled reminders by adding
  more help text.

- **CRM_Admin_Form - Support standalone forms
  ([24770](https://github.com/civicrm/civicrm-core/pull/24770))**

  Allows Admin forms to be placed at their own url without any refactoring.

- **AdminUI - Add SearchKit-based screen for Admini forms
  ([24722](https://github.com/civicrm/civicrm-core/pull/24722),
  [24715](https://github.com/civicrm/civicrm-core/pull/24715),
  [24709](https://github.com/civicrm/civicrm-core/pull/24709),
  [24725](https://github.com/civicrm/civicrm-core/pull/24725),
  [24730](https://github.com/civicrm/civicrm-core/pull/24730) and
  [24759](https://github.com/civicrm/civicrm-core/pull/24759))**

  Converts the 'Administer Location Types', 'Administer Financial Accounts',
  'Profiles', 'Profile Fields', 'Administer Payment Processors', 'Financial
  Types', 'Relationship Types' and 'Assigned Financial Accounts' screens to use
  SearchKit for those using the AdminUI extension.

- **SearchKit - Add modulo operator to math function
  ([24830](https://github.com/civicrm/civicrm-core/pull/24830))**

  Adds support for the modulo operator to SearchKit math equations.

- **SearchKit - Improve icon handling
  ([24873](https://github.com/civicrm/civicrm-core/pull/24873))**

  Gives the ability to have "fallback" icons, e.g. choosing the icon for
  contact_sub_type with a fallback to contact_type.

- **SearchKit - Expose SearchSegment fields as filters
  ([dev/core#3929](https://lab.civicrm.org/dev/core/-/issues/3929):
  [24810](https://github.com/civicrm/civicrm-core/pull/24810))**

  Makes it so users can filter in SearchKit by data segment.

- **Add paths in xml for FinancialType, Participant & Pledge
  ([24720](https://github.com/civicrm/civicrm-core/pull/24720))**

  Adds paths in XML/DAO for FinancialType, Participant & Pledge enabling
  SearchKit to add Add, View, Update, Delete link paths automatically.

- **Searchkit: Change Rewrite field to textarea
  ([dev/core#3893](https://lab.civicrm.org/dev/core/-/issues/3893):
  [24822](https://github.com/civicrm/civicrm-core/pull/24822))**

  Improves user experience of the Rewrite field in SearchKit by making it a
  textarea field input instead of a text field.

- **SearchKit - Add generic controller for ApiBatch action
  ([24758](https://github.com/civicrm/civicrm-core/pull/24758))**

  Allows extensions to define simple batch actions without the need for any
  javascript code.

- **SearchKit: Show count on both top and bottom of display
  ([dev/core#3944](https://lab.civicrm.org/dev/core/-/issues/3944):
  [24831](https://github.com/civicrm/civicrm-core/pull/24831) and
  [24846](https://github.com/civicrm/civicrm-core/pull/24846))**

  Adds a new setting just to control the header count on SearchKit displays.

- **Afform - Add support for ReCaptcha v2
  ([24860](https://github.com/civicrm/civicrm-core/pull/24860))**

  Adds ReCaptcha v2 support for Afforms.

- **Afform - Support editing new element types added by extensions
  ([24862](https://github.com/civicrm/civicrm-core/pull/24862))**

  Adds support for editing new element types added by extensions to Afform.

- **Afform - Add "AfformBehavior" entity & implement dedupe rules
  ([24552](https://github.com/civicrm/civicrm-core/pull/24552))**

  Adds the "AfformBehavior" entity & uses it to implements contact
  deduplication in Afform.

### CiviCampaign

- **Petition Signature: add an Edit link for admins
  ([24825](https://github.com/civicrm/civicrm-core/pull/24825))**

  Improves user experience for Petition forms by adding an edit link for
  administrators.

- **APIv4 - Add titles to PCP and PCPBlock entities
  ([24724](https://github.com/civicrm/civicrm-core/pull/24724))**

  Improves APIv4 metadata for PCP and PCPBlock entities by adding some titles
  and descriptions.

### CiviEvent

- **Event participant registered by contact ID
  ([dev/core#3778](https://lab.civicrm.org/dev/core/-/issues/3778):
  [24749](https://github.com/civicrm/civicrm-core/pull/24749))**

  Adds 'Registered by Contact ID' (created_id) to civireport .

### CiviMail

- **allow bounce threshold to be 0 for bounces that you want to ignore like
  vacation auto reply
  ([23910](https://github.com/civicrm/civicrm-core/pull/23910))**

  Makes it so the bounce threshold can be set to 0.

- **Make mailing name and campaign editable in place on Find Mailings
  ([24698](https://github.com/civicrm/civicrm-core/pull/24698))**

  Improves the "Find Mailings" user interface by making the "Mailing Name" and
  "Campaign" fields editable in place.

- **Mailings menu: simplify Draft/Sent
  ([24824](https://github.com/civicrm/civicrm-core/pull/24824))**

  Improves user experience of the Mailings Menu by simplifying the options.

### Backdrop Integration

- **Add Backdrop to list of supported CMS's.
  ([24818](https://github.com/civicrm/civicrm-core/pull/24818))**

  Updates the list of supported CMS's to include Backdrop.

- **Add a Views Contextual Filter Plugin for "CiviCRM ID from logged in person"
  ([dev/backdrop#11](https://lab.civicrm.org/dev/backdrop/-/issues/11):
  [163](https://github.com/civicrm/civicrm-backdrop/pull/163))**

  Adds a contextual filter "CiviCRM ID from logged in person" to views.

- **Use lab.civicrm.org for tracking issues instead of github
  ([dev/backdrop#71](https://lab.civicrm.org/dev/backdrop/-/issues/71):
  [165](https://github.com/civicrm/civicrm-backdrop/pull/165))**

  Updates the backdrop integration to use lab.civicrm.org instead of
  github.com/civicrm to track issues.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Subscription history is not set when GroupContact is deleted via API4
  ([dev/core#3933](https://lab.civicrm.org/dev/core/-/issues/3933):
  [24804](https://github.com/civicrm/civicrm-core/pull/24804))**

- **Permission to view Subscription History in SearchKit
  ([dev/core#3908](https://lab.civicrm.org/dev/core/-/issues/3908):
  [24719](https://github.com/civicrm/civicrm-core/pull/24719))**

  Fixes permissions for SubscriptionHistory in SearchKit.

- **Calculation of relative date fiscal year previous_N is wrong
  ([dev/core#3922](https://lab.civicrm.org/dev/core/-/issues/3922):
  [24769](https://github.com/civicrm/civicrm-core/pull/24769) and
  [24766](https://github.com/civicrm/civicrm-core/pull/24766))**

  Fixes fiscal year end when fiscal year starts on Jan 1.

- **Need to increase data size for 'data' column on 'civicrm_job_log' table
  ([dev/core#3905](https://lab.civicrm.org/dev/core/-/issues/3905):
  [24718](https://github.com/civicrm/civicrm-core/pull/24718))**

- **Need to increase data size for 'url' column on 'civicrm_website' table
  ([dev/core#3926](https://lab.civicrm.org/dev/core/-/issues/3926):
  [24776](https://github.com/civicrm/civicrm-core/pull/24776))**

- **SearchKit: Tagging a saved search adds strange "Include tags used for Saved
  Searches" search option to Advanced Search
  ([dev/core#3956](https://lab.civicrm.org/dev/core/-/issues/3956):
  [24855](https://github.com/civicrm/civicrm-core/pull/24855))**

- **civi/core/Locale->uf doesn't get set usually
  ([dev/core#3979](https://lab.civicrm.org/dev/core/-/issues/3979):
  [24996](https://github.com/civicrm/civicrm-core/pull/24996))**

- **AdminUi - Update FinancialType paths to fix edit/delete links
  ([24837](https://github.com/civicrm/civicrm-core/pull/24837))**

- **AdminUI - Fix pager settings to be consistent
  ([24845](https://github.com/civicrm/civicrm-core/pull/24845))**

- **AdminUi - Fix relationship screen to show names instead of labels
  ([24795](https://github.com/civicrm/civicrm-core/pull/24795))**

- **AdminUI - Fix links in Financial Accounts page
  ([24794](https://github.com/civicrm/civicrm-core/pull/24794))**

- **SearchKit - arithmetic not working
  ([dev/core#3938](https://lab.civicrm.org/dev/core/-/issues/3938):
  [24829](https://github.com/civicrm/civicrm-core/pull/24829))**

- **SearchKit - Process tokens in the "Add new" button
  ([24708](https://github.com/civicrm/civicrm-core/pull/24708))**

- **SearchKit, Afform - Fix titles on "id" fields
  ([24762](https://github.com/civicrm/civicrm-core/pull/24762))**

- **SearchKit - Set button size default to `btn-xs` to match existing UI
  ([24755](https://github.com/civicrm/civicrm-core/pull/24755))**

- **[PHP 8.1 compat] Afform - Fix display of search filter fields
  ([24965](https://github.com/civicrm/civicrm-core/pull/24965))**

- **Afform - fix empty search filters
  ([25061](https://github.com/civicrm/civicrm-core/pull/25061))**

- **Afform - Fix picking default value for date field
  ([24696](https://github.com/civicrm/civicrm-core/pull/24696))**

- **Afform - Fix console error when adding date field to form
  ([24694](https://github.com/civicrm/civicrm-core/pull/24694))**

- **Afform - Add eof newline to make files git-friendly
  ([24756](https://github.com/civicrm/civicrm-core/pull/24756))**

- **DOMDocument::loadHTML(): Tag af-field invalid in Entity when loading
  dashboard ([dev/core#3702](https://lab.civicrm.org/dev/core/-/issues/3702):
  [24771](https://github.com/civicrm/civicrm-core/pull/24771) and
  [23918](https://github.com/civicrm/civicrm-core/pull/23918))**

- **Afform - Ensure afField ids contain only allowed characters
  ([24675](https://github.com/civicrm/civicrm-core/pull/24675))**

- **Afform - Fix ability to add items to an empty fieldset
  ([24797](https://github.com/civicrm/civicrm-core/pull/24797))**

- **Update psr0 paths to match current convention
  ([24961](https://github.com/civicrm/civicrm-core/pull/24961))**

- **Add GroupTokens to replace WelcomeTokens
  ([24265](https://github.com/civicrm/civicrm-core/pull/24265))**

- **Add psr0 classloader to info.xml for core extensions
  ([24745](https://github.com/civicrm/civicrm-core/pull/24745))**

- **🩹 Fix incorrect civicrm_preferences_date description for activityDate and
  searchDate ([24717](https://github.com/civicrm/civicrm-core/pull/24717))**

- **Fix upgrade for mariadb
  ([24786](https://github.com/civicrm/civicrm-core/pull/24786))**

- **When running unit tests don't accidentally overwrite your db
  ([24652](https://github.com/civicrm/civicrm-core/pull/24652))**

- **PHP 8.2 - Fix some random warnings
  ([24849](https://github.com/civicrm/civicrm-core/pull/24849))**

- **TypeError: call_user_func(): Argument #1 ($callback) must be a valid
  callback, non-static method CRM_Case_Page_AJAX::addClient() cannot be called
  statically ([24843](https://github.com/civicrm/civicrm-core/pull/24843))**

- **Use INSERT IGNORE when inserting new states on upgrade
  ([24728](https://github.com/civicrm/civicrm-core/pull/24728))**

- **avoid fatal error in PHP 8 in BAO/Navigation.php
  ([24904](https://github.com/civicrm/civicrm-core/pull/24904))**

- **Simplify custom data view markup for avoiding display issues with
  table-layout ([24020](https://github.com/civicrm/civicrm-core/pull/24020))**

- **🪥 Fix spelling mistake showHideSeletorSearch should be
  showHideSelectorSearch
  ([24710](https://github.com/civicrm/civicrm-core/pull/24710))**

- **Fix upgrader to safely run multiple times
  ([25055](https://github.com/civicrm/civicrm-core/pull/25055))**

- **DB_DataObject - Fix pervasive warnings on PHP 8.2
  ([353](https://github.com/civicrm/civicrm-packages/pull/353))**

- **Smarty notice fix
  ([24859](https://github.com/civicrm/civicrm-core/pull/24859))**

- **php8 compatibility, replace array_key_exists() on non-array.
  ([24868](https://github.com/civicrm/civicrm-core/pull/24868))**

### CiviCampaign

- **CiviCampaign Dashboard: fix default active tab
  ([24865](https://github.com/civicrm/civicrm-core/pull/24865))**

### CiviCase

- **APIv3 - Fix Case entityRef to exclude deleted cases & contacts
  ([24793](https://github.com/civicrm/civicrm-core/pull/24793))**

### CiviContribute

- **LYBUNT/SYBUNT hardcoded to year 2011
  ([24853](https://github.com/civicrm/civicrm-core/pull/24853))**
  
- **Unable to delete price field
  ([dev/core#3999](https://lab.civicrm.org/dev/core/-/issues/3999):
  [25016](https://github.com/civicrm/civicrm-core/pull/25016))**

- **Assigning to accounting batch and closing batch fails with javascript error
  ([dev/core#3960](https://lab.civicrm.org/dev/core/-/issues/3960):
  [24895](https://github.com/civicrm/civicrm-core/pull/24895))**

- **Disabled Financial Types are listed when creating a Price Field
  ([dev/financial#209](https://lab.civicrm.org/dev/financial/-/issues/209):
  [24867](https://github.com/civicrm/civicrm-core/pull/24867))**

- **Contribution for event registration with multiple participants lists them
  multiple times in "associated participants"
  ([dev/core#3892](https://lab.civicrm.org/dev/core/-/issues/3892):
  [24690](https://github.com/civicrm/civicrm-core/pull/24690))**

  Ensure each Associated Participant only once shows once when viewing a
  contribution.

- **Incorrect currency displayed for contribution
  ([dev/core#3917](https://lab.civicrm.org/dev/core/-/issues/3917):
  [24757](https://github.com/civicrm/civicrm-core/pull/24757))**

### CiviEvent

- **Fix event template cache not updating. Replace some deprecated functions
  with API4 ([24863](https://github.com/civicrm/civicrm-core/pull/24863))**

- **Event/registration PHP 8 compatibility improvements
  ([24779](https://github.com/civicrm/civicrm-core/pull/24779))**

- **Allow second participant registration with same email, when enabled
  ([24684](https://github.com/civicrm/civicrm-core/pull/24684))**

- **Additional Participants are incorrectly added to group set in profile for
  primary participant
  ([dev/core#3849](https://lab.civicrm.org/dev/core/-/issues/3849):
  [24633](https://github.com/civicrm/civicrm-core/pull/24633))**

### CiviMember

- **Don't prevent contact with Cancelled membership from signing up online  
  ([dev/core#3782](https://lab.civicrm.org/dev/core/-/issues/3782):
  [24159](https://github.com/civicrm/civicrm-core/pull/24159))**

  Remove rule that stops signing up for a membership if matched contact already
  has a canceled on of that type.

### Backdrop Integration

- **Issue 160: Eliminate permissions PHP warnings.
  ([161](https://github.com/civicrm/civicrm-backdrop/pull/161))**

- **The control buttons in crm pop ups are all X's
  ([dev/backdrop#76](https://lab.civicrm.org/dev/backdrop/-/issues/76):
  [24930](https://github.com/civicrm/civicrm-core/pull/24930))**

### Joomla Integration

- **Cron issue with Joomla 4
  ([dev/joomla#41](https://lab.civicrm.org/dev/joomla/-/issues/41):
  [24796](https://github.com/civicrm/civicrm-core/pull/24796))**

### WordPress Integration

- **Missing getRoleNames() method in WordPress System Utility
  ([dev/core#3914](https://lab.civicrm.org/dev/core/-/issues/3914):
  [24751](https://github.com/civicrm/civicrm-core/pull/24751))**

- **Fix WP Clean Pages check when components are disabled
  ([24950](https://github.com/civicrm/civicrm-core/pull/24950))**

## <a name="misc"></a>Miscellany

- **deprecate FinancialType create/add in favor of writeRecord
  ([24788](https://github.com/civicrm/civicrm-core/pull/24788))**

- **composer.json - Update cacerts fallback
  ([24909](https://github.com/civicrm/civicrm-core/pull/24909))**

- **Update incremental sql readme per #24786
  ([24791](https://github.com/civicrm/civicrm-core/pull/24791))**

- **Standardise names as camelcase for "SearchKit" and "FormBuilder"
  ([24726](https://github.com/civicrm/civicrm-core/pull/24726))**

- **Regenerate dao files
  ([24847](https://github.com/civicrm/civicrm-core/pull/24847))**

- **Remove notice-causing do-nothing script
  ([24836](https://github.com/civicrm/civicrm-core/pull/24836))**

- **Remove more front-end-only handling from back-office contribution form
  ([24413](https://github.com/civicrm/civicrm-core/pull/24413))**

- **Remove never-changing variable
  ([24816](https://github.com/civicrm/civicrm-core/pull/24816))**

- **Remove always true ifs (label code)
  ([24817](https://github.com/civicrm/civicrm-core/pull/24817))**

- **Clean up autoloader and views plugins
  ([157](https://github.com/civicrm/civicrm-backdrop/pull/157))**

- **Minor code cleanup - use function to replace a few lines
  ([24811](https://github.com/civicrm/civicrm-core/pull/24811))**

- **Minor cleanup in label test, use `PrematureExitException`
  ([24813](https://github.com/civicrm/civicrm-core/pull/24813))**

- **Minor code cleanup in `Sql::claimItem`
  ([24806](https://github.com/civicrm/civicrm-core/pull/24806))**

- **Add organization to @bastienho
  ([24823](https://github.com/civicrm/civicrm-core/pull/24823))**

- **[REF] Update Indian States as per ISO-3166-2
  ([24706](https://github.com/civicrm/civicrm-core/pull/24706))**

- **[REF][PHP8.2] Remove refence to num_rows as this has been removed from
  pear/db (Work Towards
  [dev/core#3958](https://lab.civicrm.org/dev/core/-/issues/3958):
  [354](https://github.com/civicrm/civicrm-packages/pull/354))**

- **[REF][PHP8.1] PHP 8.1
  ([dev/core#3181](https://lab.civicrm.org/dev/core/-/issues/3181):
  [284](https://github.com/civicrm/civicrm-wordpress/pull/284))**

- **[REF][PHP8.2] Fix some instances of properties not being declared on classes
  ([24879](https://github.com/civicrm/civicrm-core/pull/24879))**

- **[REF][PHP8.2] Add patches to pear upstream packages to fix issues with
  PHP8.2 ([24857](https://github.com/civicrm/civicrm-core/pull/24857))**

- **[REF][PHP8.2] Remove usage of utf8_decode in favour of mb_strlen
  ([24852](https://github.com/civicrm/civicrm-core/pull/24852))**

- **[REF] Update github action deprecations
  ([24864](https://github.com/civicrm/civicrm-core/pull/24864))**

- **[REF] Update HTMLPurifier to a version that supports php8.2
  ([24856](https://github.com/civicrm/civicrm-core/pull/24856))**

- **[REF] Cleanup on CRM_Admin_Form_Options
  ([24828](https://github.com/civicrm/civicrm-core/pull/24828))**

- **[REF] CiviGrant - Remove redundant icon from Afform entity file
  ([24826](https://github.com/civicrm/civicrm-core/pull/24826))**

- **[REF] SearchKit - Cleanup option group mgd files and translate labels
  ([24808](https://github.com/civicrm/civicrm-core/pull/24808))**

- **(REF) authx - Move listener to service class
  ([24783](https://github.com/civicrm/civicrm-core/pull/24783))**

- **[REF] Afform - Use autoservice for event subscribers
  ([24962](https://github.com/civicrm/civicrm-core/pull/24962))**

- **(REF) FileTest - Prevent test-interactions from testIsDirWithOpenBasedir
  ([24476](https://github.com/civicrm/civicrm-core/pull/24476))**

- **[NFC] Add missing space in membership search
  ([24820](https://github.com/civicrm/civicrm-core/pull/24820))**

- **[NFC] Afform - improve AbstractBehavior docblock
  ([24854](https://github.com/civicrm/civicrm-core/pull/24854))**

- **NFC - minor Cleanup in test class
  ([24827](https://github.com/civicrm/civicrm-core/pull/24827))**

- **[NFC] Add code comment about null locale
  ([24738](https://github.com/civicrm/civicrm-core/pull/24738))**

- **NFC: Fix a couple of typos in comments
  ([24748](https://github.com/civicrm/civicrm-core/pull/24748))**

- **Add APIv4 unit test for basic contact ACLs
  ([24723](https://github.com/civicrm/civicrm-core/pull/24723))**

- **Test - Fix backwards params to assertEquals
  ([24877](https://github.com/civicrm/civicrm-core/pull/24877))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman; \
Business & Code - Alain Benbassat; CEDC - Laryn Kragt Bakker; Circle
Interactive - Dave Jenkins, Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy, Shane Bill; Dave D;
Fuzion - Toby Messerli; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee;
John Kingsnorth; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; N.O.U.S. Open Usefull and Simple - Bastien Ho;
Supertemplates UG - Nicolás di Rago; Robert J. Lang; sebalis; Squiffle
Consulting - Aidan Saunders; Third Sector Design - Kurund Jalmi, William
Mortada; Wikimedia Foundation - Damilare Adedoyin, Eileen McNaughton;
Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Australian Greens - John Twyman; Christian Wach;
Freeform Solutions - Herb van den Dool; Humanists UK - Andrew West;
Joinery - Allen Shaw; Lighthouse Consulting and Design - Brian Shaughnessy;
Mikey O'Toole; Nicol Wistreich; rainersalal; Responsive Development
Technologies - Thomas Nilefalk; Richard van Oosterhout; Tadpole Collective -
Kevin Cristiano; Wikimedia Foundation - Jack Gleeson

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
