<?php

return CRM_Core_CodeGen_OptionGroup::create('activity_type', 'a/0002')
  ->addMetadata([
    'title' => ts('Activity Type'),
    'description' => ts('Activities track interactions with contacts. Some activity types are reserved for use by automated processes, others can be freely configured.'),
    'data_type' => 'Integer',
    'option_value_fields' => 'name,label,description,icon',
  ])
  ->addValues([
    [
      'label' => ts('Meeting'),
      'value' => 1,
      'name' => 'Meeting',
      'is_reserved' => 1,
      'icon' => 'fa-slideshare',
    ],
    [
      'label' => ts('Phone Call'),
      'value' => 2,
      'name' => 'Phone Call',
      'is_reserved' => 1,
      'icon' => 'fa-phone',
    ],
    [
      'label' => ts('Email'),
      'value' => 3,
      'name' => 'Email',
      'filter' => 1,
      'description' => ts('Email sent.'),
      'is_reserved' => 1,
      'icon' => 'fa-envelope-o',
    ],
    [
      'label' => ts('Outbound SMS'),
      'value' => 4,
      'name' => 'SMS',
      'filter' => 1,
      'description' => ts('Text message (SMS) sent.'),
      'is_reserved' => 1,
      'icon' => 'fa-mobile',
    ],
    [
      'label' => ts('Event Registration'),
      'value' => 5,
      'name' => 'Event Registration',
      'filter' => 1,
      'description' => ts('Online or offline event registration.'),
      'is_reserved' => 1,
      'component_id' => 1,
    ],
    [
      'label' => ts('Contribution'),
      'value' => 6,
      'name' => 'Contribution',
      'filter' => 1,
      'description' => ts('Online or offline contribution.'),
      'is_reserved' => 1,
      'component_id' => 2,
    ],
    [
      'label' => ts('Membership Signup'),
      'value' => 7,
      'name' => 'Membership Signup',
      'filter' => 1,
      'description' => ts('Online or offline membership signup.'),
      'is_reserved' => 1,
      'component_id' => 3,
    ],
    [
      'label' => ts('Membership Renewal'),
      'value' => 8,
      'name' => 'Membership Renewal',
      'filter' => 1,
      'description' => ts('Online or offline membership renewal.'),
      'is_reserved' => 1,
      'component_id' => 3,
    ],
    [
      'label' => ts('Tell a Friend'),
      'value' => 9,
      'name' => 'Tell a Friend',
      'filter' => 1,
      'description' => ts('Send information about a contribution campaign or event to a friend.'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Pledge Acknowledgment'),
      'value' => 10,
      'name' => 'Pledge Acknowledgment',
      'filter' => 1,
      'description' => ts('Send Pledge Acknowledgment.'),
      'is_reserved' => 1,
      'component_id' => 6,
    ],
    [
      'label' => ts('Pledge Reminder'),
      'value' => 11,
      'name' => 'Pledge Reminder',
      'filter' => 1,
      'description' => ts('Send Pledge Reminder.'),
      'is_reserved' => 1,
      'component_id' => 6,
    ],
    [
      'label' => ts('Inbound Email'),
      'value' => 12,
      'name' => 'Inbound Email',
      'filter' => 1,
      'description' => ts('Inbound Email.'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Open Case'),
      'value' => 13,
      'name' => 'Open Case',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-folder-open-o',
      'description' => '',
    ],
    [
      'label' => ts('Follow up'),
      'value' => 14,
      'name' => 'Follow up',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-share-square-o',
      'description' => '',
    ],
    [
      'label' => ts('Change Case Type'),
      'value' => 15,
      'name' => 'Change Case Type',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-random',
      'description' => '',
    ],
    [
      'label' => ts('Change Case Status'),
      'value' => 16,
      'name' => 'Change Case Status',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-pencil-square-o',
      'description' => '',
    ],
    [
      'label' => ts('Change Case Subject'),
      'value' => 53,
      'name' => 'Change Case Subject',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-pencil-square-o',
      'description' => '',
    ],
    [
      'label' => ts('Change Custom Data'),
      'value' => 33,
      'name' => 'Change Custom Data',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-table',
      'description' => '',
    ],
    [
      'label' => ts('Membership Renewal Reminder'),
      'value' => 17,
      'name' => 'Membership Renewal Reminder',
      'filter' => 1,
      'description' => ts('offline membership renewal reminder.'),
      'is_reserved' => 1,
      'component_id' => 3,
    ],
    [
      'label' => ts('Change Case Start Date'),
      'value' => 18,
      'name' => 'Change Case Start Date',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-calendar',
      'description' => '',
    ],
    [
      'label' => ts('Bulk Email'),
      'value' => 19,
      'name' => 'Bulk Email',
      'filter' => 1,
      'description' => ts('Bulk Email Sent.'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Assign Case Role'),
      'value' => 20,
      'name' => 'Assign Case Role',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-user-plus',
      'description' => '',
    ],
    [
      'label' => ts('Remove Case Role'),
      'value' => 21,
      'name' => 'Remove Case Role',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-user-times',
      'description' => '',
    ],
    [
      'label' => ts('Print/Merge Document'),
      'value' => 22,
      'name' => 'Print PDF Letter',
      'description' => ts('Export letters and other printable documents.'),
      'is_reserved' => 1,
      'icon' => 'fa-file-pdf-o',
    ],
    [
      'label' => ts('Merge Case'),
      'value' => 23,
      'name' => 'Merge Case',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-compress',
      'description' => '',
    ],
    [
      'label' => ts('Reassigned Case'),
      'value' => 24,
      'name' => 'Reassigned Case',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-user-circle-o',
      'description' => '',
    ],
    [
      'label' => ts('Link Cases'),
      'value' => 25,
      'name' => 'Link Cases',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-link',
      'description' => '',
    ],
    [
      'label' => ts('Change Case Tags'),
      'value' => 26,
      'name' => 'Change Case Tags',
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-tags',
      'description' => '',
    ],
    [
      'label' => ts('Add Client To Case'),
      'value' => 27,
      'name' => 'Add Client To Case',
      // FIXME: Weird weight
      'weight' => 27 - 1,
      'is_reserved' => 1,
      'component_id' => 7,
      'icon' => 'fa-users',
      'description' => '',
    ],
    [
      'label' => ts('Survey'),
      'value' => 28,
      'name' => 'Survey',
      // FIXME: Weird weight
      'weight' => 28 - 1,
      'is_reserved' => 1,
      'component_id' => 9,
      'description' => '',
    ],
    [
      'label' => ts('Canvass'),
      'value' => 29,
      'name' => 'Canvass',
      // FIXME: Weird weight
      'weight' => 29 - 1,
      'is_reserved' => 1,
      'component_id' => 9,
      'description' => '',
    ],
    [
      'label' => ts('PhoneBank'),
      'value' => 30,
      'name' => 'PhoneBank',
      // FIXME: Weird weight
      'weight' => 30 - 1,
      'is_reserved' => 1,
      'component_id' => 9,
      'description' => '',
    ],
    [
      'label' => ts('WalkList'),
      'value' => 31,
      'name' => 'WalkList',
      // FIXME: Weird weight
      'weight' => 31 - 1,
      'is_reserved' => 1,
      'component_id' => 9,
      'description' => '',
    ],
    [
      'label' => ts('Petition Signature'),
      'value' => 32,
      'name' => 'Petition',
      // FIXME: Weird weight
      'weight' => 32 - 1,
      'is_reserved' => 1,
      'component_id' => 9,
      'description' => '',
    ],
    [
      'label' => ts('Mass SMS'),
      'value' => 34,
      'name' => 'Mass SMS',
      'filter' => 1,
      'weight' => 34,
      'description' => ts('Mass SMS'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Change Membership Status'),
      'value' => 35,
      'name' => 'Change Membership Status',
      'filter' => 1,
      'weight' => 35,
      'description' => ts('Change Membership Status.'),
      'is_reserved' => 1,
      'component_id' => 3,
    ],
    [
      'label' => ts('Change Membership Type'),
      'value' => 36,
      'name' => 'Change Membership Type',
      'filter' => 1,
      'description' => ts('Change Membership Type.'),
      'is_reserved' => 1,
      'component_id' => 3,
    ],
    [
      'label' => ts('Cancel Recurring Contribution'),
      'value' => 37,
      'name' => 'Cancel Recurring Contribution',
      'filter' => 1,
      'is_reserved' => 1,
      'component_id' => 2,
      'description' => '',
    ],
    [
      'label' => ts('Update Recurring Contribution Billing Details'),
      'value' => 38,
      'name' => 'Update Recurring Contribution Billing Details',
      'filter' => 1,
      'is_reserved' => 1,
      'component_id' => 2,
      'description' => '',
    ],
    [
      'label' => ts('Update Recurring Contribution'),
      'value' => 39,
      'name' => 'Update Recurring Contribution',
      'filter' => 1,
      'is_reserved' => 1,
      'component_id' => 2,
      'description' => '',
    ],
    [
      'label' => ts('Reminder Sent'),
      'value' => 40,
      'name' => 'Reminder Sent',
      'filter' => 1,
      'is_reserved' => 1,
      'description' => '',
    ],
    [
      'label' => ts('Export Accounting Batch'),
      'value' => 41,
      'name' => 'Export Accounting Batch',
      'filter' => 1,
      'description' => ts('Export Accounting Batch'),
      'is_reserved' => 1,
      'component_id' => 2,
    ],
    [
      'label' => ts('SMS delivery'),
      'value' => 44,
      'name' => 'SMS delivery',
      'filter' => 1,
      'description' => ts('SMS delivery'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Inbound SMS'),
      'value' => 45,
      'name' => 'Inbound SMS',
      'filter' => 1,
      'description' => ts('Inbound SMS'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Payment'),
      'value' => 46,
      'name' => 'Payment',
      'filter' => 1,
      'description' => ts('Additional payment recorded for event or membership fee.'),
      'is_reserved' => 1,
      'component_id' => 2,
    ],
    [
      'label' => ts('Refund'),
      'value' => 47,
      'name' => 'Refund',
      'filter' => 1,
      'description' => ts('Refund recorded for event or membership fee.'),
      'is_reserved' => 1,
      'component_id' => 2,
    ],
    [
      'label' => ts('Change Registration'),
      'value' => 48,
      'name' => 'Change Registration',
      'filter' => 1,
      'description' => ts('Changes to an existing event registration.'),
      'is_reserved' => 1,
      'component_id' => 1,
    ],
    [
      'label' => ts('Downloaded Invoice'),
      'value' => 49,
      'name' => 'Downloaded Invoice',
      'filter' => 1,
      'description' => ts('Downloaded Invoice.'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Emailed Invoice'),
      'value' => 50,
      'name' => 'Emailed Invoice',
      'filter' => 1,
      'description' => ts('Emailed Invoice.'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Contact Merged'),
      'value' => 51,
      'name' => 'Contact Merged',
      'filter' => 1,
      'description' => ts('Contact Merged'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Contact Deleted by Merge'),
      'value' => 52,
      'name' => 'Contact Deleted by Merge',
      'filter' => 1,
      'description' => ts('Contact was merged into another contact'),
      'is_reserved' => 1,
    ],
    [
      'label' => ts('Failed Payment'),
      'value' => 54,
      'name' => 'Failed Payment',
      'filter' => 1,
      'description' => ts('Failed Payment'),
      'is_reserved' => 1,
      'component_id' => 2,
    ],
    [
      'label' => ts('Case Client was removed from Case'),
      'value' => 55,
      'name' => 'Case Client Removed',
      'description' => ts('Case client was removed from a case'),
      'component_id' => 7,
      'icon' => 'fa-trash',
    ],
  ])
  ->syncColumns('fill', ['value' => 'weight']);
