
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLCDNumber.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLCDNumber>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLCDNumber

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QLCDNumber::staticMetaObject);
}


// bool QLCDNumber::checkOverflow(double num)


static void _init_f_checkOverflow_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("num");
  decl->add_arg<double > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_checkOverflow_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<bool > ((bool)((QLCDNumber *)cls)->checkOverflow (arg1));
}


// bool QLCDNumber::checkOverflow(int num)


static void _init_f_checkOverflow_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("num");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_checkOverflow_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QLCDNumber *)cls)->checkOverflow (arg1));
}


// int QLCDNumber::digitCount()


static void _init_f_digitCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_digitCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLCDNumber *)cls)->digitCount ());
}


// void QLCDNumber::display(const QString &str)


static void _init_f_display_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_display_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->display (arg1);
}


// void QLCDNumber::display(int num)


static void _init_f_display_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("num");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_display_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->display (arg1);
}


// void QLCDNumber::display(double num)


static void _init_f_display_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("num");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_display_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->display (arg1);
}


// int QLCDNumber::intValue()


static void _init_f_intValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLCDNumber *)cls)->intValue ());
}


// QLCDNumber::Mode QLCDNumber::mode()


static void _init_f_mode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLCDNumber::Mode>::target_type > ();
}

static void _call_f_mode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLCDNumber::Mode>::target_type > ((qt_gsi::Converter<QLCDNumber::Mode>::target_type)qt_gsi::CppToQtAdaptor<QLCDNumber::Mode>(((QLCDNumber *)cls)->mode ()));
}


// int QLCDNumber::numDigits()


static void _init_f_numDigits_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numDigits_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLCDNumber *)cls)->numDigits ());
}


// QLCDNumber::SegmentStyle QLCDNumber::segmentStyle()


static void _init_f_segmentStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type > ();
}

static void _call_f_segmentStyle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type > ((qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type)qt_gsi::CppToQtAdaptor<QLCDNumber::SegmentStyle>(((QLCDNumber *)cls)->segmentStyle ()));
}


// void QLCDNumber::setBinMode()


static void _init_f_setBinMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setBinMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setBinMode ();
}


// void QLCDNumber::setDecMode()


static void _init_f_setDecMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setDecMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setDecMode ();
}


// void QLCDNumber::setDigitCount(int nDigits)


static void _init_f_setDigitCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nDigits");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDigitCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setDigitCount (arg1);
}


// void QLCDNumber::setHexMode()


static void _init_f_setHexMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setHexMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setHexMode ();
}


// void QLCDNumber::setMode(QLCDNumber::Mode)


static void _init_f_setMode_1850 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QLCDNumber::Mode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMode_1850 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLCDNumber::Mode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLCDNumber::Mode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setMode (qt_gsi::QtToCppAdaptor<QLCDNumber::Mode>(arg1).cref());
}


// void QLCDNumber::setNumDigits(int nDigits)


static void _init_f_setNumDigits_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nDigits");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumDigits_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setNumDigits (arg1);
}


// void QLCDNumber::setOctMode()


static void _init_f_setOctMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setOctMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setOctMode ();
}


// void QLCDNumber::setSegmentStyle(QLCDNumber::SegmentStyle)


static void _init_f_setSegmentStyle_2713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSegmentStyle_2713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QLCDNumber::SegmentStyle>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setSegmentStyle (qt_gsi::QtToCppAdaptor<QLCDNumber::SegmentStyle>(arg1).cref());
}


// void QLCDNumber::setSmallDecimalPoint(bool)


static void _init_f_setSmallDecimalPoint_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSmallDecimalPoint_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber *)cls)->setSmallDecimalPoint (arg1);
}


// QSize QLCDNumber::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QLCDNumber *)cls)->sizeHint ());
}


// bool QLCDNumber::smallDecimalPoint()


static void _init_f_smallDecimalPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_smallDecimalPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLCDNumber *)cls)->smallDecimalPoint ());
}


// double QLCDNumber::value()


static void _init_f_value_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_value_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QLCDNumber *)cls)->value ());
}


// static QString QLCDNumber::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QLCDNumber::tr (arg1, arg2));
}


// static QString QLCDNumber::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QLCDNumber::tr (arg1, arg2, arg3));
}


// static QString QLCDNumber::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QLCDNumber::trUtf8 (arg1, arg2));
}


// static QString QLCDNumber::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QLCDNumber::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QLCDNumber () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("checkOverflow", "@brief Method bool QLCDNumber::checkOverflow(double num)\n", true, &_init_f_checkOverflow_c1071, &_call_f_checkOverflow_c1071);
  methods += new qt_gsi::GenericMethod ("checkOverflow", "@brief Method bool QLCDNumber::checkOverflow(int num)\n", true, &_init_f_checkOverflow_c767, &_call_f_checkOverflow_c767);
  methods += new qt_gsi::GenericMethod (":digitCount", "@brief Method int QLCDNumber::digitCount()\n", true, &_init_f_digitCount_c0, &_call_f_digitCount_c0);
  methods += new qt_gsi::GenericMethod ("display", "@brief Method void QLCDNumber::display(const QString &str)\n", false, &_init_f_display_2025, &_call_f_display_2025);
  methods += new qt_gsi::GenericMethod ("display", "@brief Method void QLCDNumber::display(int num)\n", false, &_init_f_display_767, &_call_f_display_767);
  methods += new qt_gsi::GenericMethod ("display", "@brief Method void QLCDNumber::display(double num)\n", false, &_init_f_display_1071, &_call_f_display_1071);
  methods += new qt_gsi::GenericMethod (":intValue", "@brief Method int QLCDNumber::intValue()\n", true, &_init_f_intValue_c0, &_call_f_intValue_c0);
  methods += new qt_gsi::GenericMethod (":mode", "@brief Method QLCDNumber::Mode QLCDNumber::mode()\n", true, &_init_f_mode_c0, &_call_f_mode_c0);
  methods += new qt_gsi::GenericMethod (":numDigits", "@brief Method int QLCDNumber::numDigits()\n", true, &_init_f_numDigits_c0, &_call_f_numDigits_c0);
  methods += new qt_gsi::GenericMethod (":segmentStyle", "@brief Method QLCDNumber::SegmentStyle QLCDNumber::segmentStyle()\n", true, &_init_f_segmentStyle_c0, &_call_f_segmentStyle_c0);
  methods += new qt_gsi::GenericMethod ("setBinMode", "@brief Method void QLCDNumber::setBinMode()\n", false, &_init_f_setBinMode_0, &_call_f_setBinMode_0);
  methods += new qt_gsi::GenericMethod ("setDecMode", "@brief Method void QLCDNumber::setDecMode()\n", false, &_init_f_setDecMode_0, &_call_f_setDecMode_0);
  methods += new qt_gsi::GenericMethod ("setDigitCount|digitCount=", "@brief Method void QLCDNumber::setDigitCount(int nDigits)\n", false, &_init_f_setDigitCount_767, &_call_f_setDigitCount_767);
  methods += new qt_gsi::GenericMethod ("setHexMode", "@brief Method void QLCDNumber::setHexMode()\n", false, &_init_f_setHexMode_0, &_call_f_setHexMode_0);
  methods += new qt_gsi::GenericMethod ("setMode|mode=", "@brief Method void QLCDNumber::setMode(QLCDNumber::Mode)\n", false, &_init_f_setMode_1850, &_call_f_setMode_1850);
  methods += new qt_gsi::GenericMethod ("setNumDigits|numDigits=", "@brief Method void QLCDNumber::setNumDigits(int nDigits)\n", false, &_init_f_setNumDigits_767, &_call_f_setNumDigits_767);
  methods += new qt_gsi::GenericMethod ("setOctMode", "@brief Method void QLCDNumber::setOctMode()\n", false, &_init_f_setOctMode_0, &_call_f_setOctMode_0);
  methods += new qt_gsi::GenericMethod ("setSegmentStyle|segmentStyle=", "@brief Method void QLCDNumber::setSegmentStyle(QLCDNumber::SegmentStyle)\n", false, &_init_f_setSegmentStyle_2713, &_call_f_setSegmentStyle_2713);
  methods += new qt_gsi::GenericMethod ("setSmallDecimalPoint|smallDecimalPoint=", "@brief Method void QLCDNumber::setSmallDecimalPoint(bool)\n", false, &_init_f_setSmallDecimalPoint_864, &_call_f_setSmallDecimalPoint_864);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QLCDNumber::sizeHint()\nThis is a reimplementation of QFrame::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":smallDecimalPoint", "@brief Method bool QLCDNumber::smallDecimalPoint()\n", true, &_init_f_smallDecimalPoint_c0, &_call_f_smallDecimalPoint_c0);
  methods += new qt_gsi::GenericMethod (":value", "@brief Method double QLCDNumber::value()\n", true, &_init_f_value_c0, &_call_f_value_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QLCDNumber::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QLCDNumber::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("overflow()", "overflow", "@brief Signal declaration for QLCDNumber::overflow()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLCDNumber::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLCDNumber::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLCDNumber::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLCDNumber::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QFrame> &qtdecl_QFrame ();

qt_gsi::QtNativeClass<QLCDNumber> decl_QLCDNumber (qtdecl_QFrame (), "QtGui", "QLCDNumber_Native",
  methods_QLCDNumber (),
  "@hide\n@alias QLCDNumber");

GSI_QTGUI_PUBLIC gsi::Class<QLCDNumber> &qtdecl_QLCDNumber () { return decl_QLCDNumber; }

}


class QLCDNumber_Adaptor : public QLCDNumber, public qt_gsi::QtObjectBase
{
public:

  virtual ~QLCDNumber_Adaptor();

  //  [adaptor ctor] QLCDNumber::QLCDNumber(QWidget *parent)
  QLCDNumber_Adaptor() : QLCDNumber()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLCDNumber::QLCDNumber(QWidget *parent)
  QLCDNumber_Adaptor(QWidget *parent) : QLCDNumber(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLCDNumber::QLCDNumber(unsigned int numDigits, QWidget *parent)
  QLCDNumber_Adaptor(unsigned int numDigits) : QLCDNumber(numDigits)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLCDNumber::QLCDNumber(unsigned int numDigits, QWidget *parent)
  QLCDNumber_Adaptor(unsigned int numDigits, QWidget *parent) : QLCDNumber(numDigits, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QLCDNumber::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QLCDNumber_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QLCDNumber::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QLCDNumber::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QLCDNumber_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QLCDNumber::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QLCDNumber::drawFrame(QPainter *)
  void fp_QLCDNumber_drawFrame_1426 (QPainter *arg1) {
    QLCDNumber::drawFrame(arg1);
  }

  //  [expose] bool QLCDNumber::focusNextChild()
  bool fp_QLCDNumber_focusNextChild_0 () {
    return QLCDNumber::focusNextChild();
  }

  //  [expose] bool QLCDNumber::focusPreviousChild()
  bool fp_QLCDNumber_focusPreviousChild_0 () {
    return QLCDNumber::focusPreviousChild();
  }

  //  [expose] int QLCDNumber::receivers(const char *signal)
  int fp_QLCDNumber_receivers_c1731 (const char *signal) const {
    return QLCDNumber::receivers(signal);
  }

  //  [expose] void QLCDNumber::resetInputContext()
  void fp_QLCDNumber_resetInputContext_0 () {
    QLCDNumber::resetInputContext();
  }

  //  [expose] QObject *QLCDNumber::sender()
  QObject * fp_QLCDNumber_sender_c0 () const {
    return QLCDNumber::sender();
  }

  //  [expose] void QLCDNumber::updateMicroFocus()
  void fp_QLCDNumber_updateMicroFocus_0 () {
    QLCDNumber::updateMicroFocus();
  }

  //  [adaptor impl] bool QLCDNumber::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QLCDNumber::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QLCDNumber_Adaptor, bool, QObject *, QEvent *>(&QLCDNumber_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QLCDNumber::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QLCDNumber::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QLCDNumber::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QLCDNumber_Adaptor, int, int>(&QLCDNumber_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QLCDNumber::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QLCDNumber::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QLCDNumber::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QLCDNumber_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QLCDNumber_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QLCDNumber::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QLCDNumber::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QLCDNumber::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QLCDNumber_Adaptor, QSize>(&QLCDNumber_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QLCDNumber::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QLCDNumber::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QLCDNumber::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QLCDNumber_Adaptor, QPaintEngine *>(&QLCDNumber_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QLCDNumber::paintEngine();
    }
  }

  //  [adaptor impl] void QLCDNumber::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QLCDNumber::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QLCDNumber_Adaptor, bool>(&QLCDNumber_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QLCDNumber::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QLCDNumber::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QLCDNumber::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QLCDNumber_Adaptor, QSize>(&QLCDNumber_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QLCDNumber::sizeHint();
    }
  }

  //  [adaptor impl] void QLCDNumber::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QLCDNumber::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QLCDNumber_Adaptor, QActionEvent *>(&QLCDNumber_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QLCDNumber::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QLCDNumber::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QLCDNumber_Adaptor, QEvent *>(&QLCDNumber_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QLCDNumber::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QLCDNumber::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QLCDNumber_Adaptor, QChildEvent *>(&QLCDNumber_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QLCDNumber::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QLCDNumber::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QLCDNumber_Adaptor, QCloseEvent *>(&QLCDNumber_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QLCDNumber::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QLCDNumber::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QLCDNumber_Adaptor, QContextMenuEvent *>(&QLCDNumber_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QLCDNumber::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QLCDNumber::customContextMenuRequested(const QPoint &pos)
  void emitter_QLCDNumber_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QLCDNumber::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QLCDNumber::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QLCDNumber::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QLCDNumber_Adaptor, QEvent *>(&QLCDNumber_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QLCDNumber::customEvent(arg1);
    }
  }

  //  [emitter impl] void QLCDNumber::destroyed(QObject *)
  void emitter_QLCDNumber_destroyed_1302(QObject *arg1)
  {
    emit QLCDNumber::destroyed(arg1);
  }

  //  [adaptor impl] void QLCDNumber::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QLCDNumber::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QLCDNumber_Adaptor, const char *>(&QLCDNumber_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QLCDNumber::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QLCDNumber::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QLCDNumber::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QLCDNumber_Adaptor, QDragEnterEvent *>(&QLCDNumber_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QLCDNumber::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QLCDNumber::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QLCDNumber_Adaptor, QDragLeaveEvent *>(&QLCDNumber_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QLCDNumber::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QLCDNumber::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QLCDNumber_Adaptor, QDragMoveEvent *>(&QLCDNumber_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QLCDNumber::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QLCDNumber::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QLCDNumber_Adaptor, QDropEvent *>(&QLCDNumber_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QLCDNumber::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QLCDNumber::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QLCDNumber_Adaptor, bool>(&QLCDNumber_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QLCDNumber::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QLCDNumber::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QLCDNumber_Adaptor, QEvent *>(&QLCDNumber_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QLCDNumber::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QLCDNumber::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QLCDNumber::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QLCDNumber_Adaptor, bool, QEvent *>(&QLCDNumber_Adaptor::cbs_event_1217_0, e);
    } else {
      return QLCDNumber::event(e);
    }
  }

  //  [adaptor impl] void QLCDNumber::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QLCDNumber::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QLCDNumber_Adaptor, QFocusEvent *>(&QLCDNumber_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QLCDNumber::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QLCDNumber::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QLCDNumber::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QLCDNumber_Adaptor, bool, bool>(&QLCDNumber_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QLCDNumber::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QLCDNumber::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QLCDNumber::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QLCDNumber_Adaptor, QFocusEvent *>(&QLCDNumber_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QLCDNumber::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QLCDNumber::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QLCDNumber_Adaptor, const QFont &>(&QLCDNumber_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QLCDNumber::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QLCDNumber::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QLCDNumber_Adaptor, QHideEvent *>(&QLCDNumber_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QLCDNumber::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QLCDNumber::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QLCDNumber_Adaptor, QInputMethodEvent *>(&QLCDNumber_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QLCDNumber::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QLCDNumber::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QLCDNumber_Adaptor, QKeyEvent *>(&QLCDNumber_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QLCDNumber::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QLCDNumber::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QLCDNumber_Adaptor, QKeyEvent *>(&QLCDNumber_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QLCDNumber::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::languageChange()
  void cbs_languageChange_0_0()
  {
    QLCDNumber::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QLCDNumber_Adaptor>(&QLCDNumber_Adaptor::cbs_languageChange_0_0);
    } else {
      QLCDNumber::languageChange();
    }
  }

  //  [adaptor impl] void QLCDNumber::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QLCDNumber::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QLCDNumber_Adaptor, QEvent *>(&QLCDNumber_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QLCDNumber::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QLCDNumber::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QLCDNumber::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QLCDNumber_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QLCDNumber_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QLCDNumber::metric(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QLCDNumber::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QLCDNumber_Adaptor, QMouseEvent *>(&QLCDNumber_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QLCDNumber::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QLCDNumber::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QLCDNumber_Adaptor, QMouseEvent *>(&QLCDNumber_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QLCDNumber::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QLCDNumber::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QLCDNumber_Adaptor, QMouseEvent *>(&QLCDNumber_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QLCDNumber::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QLCDNumber::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QLCDNumber_Adaptor, QMouseEvent *>(&QLCDNumber_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QLCDNumber::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QLCDNumber::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QLCDNumber_Adaptor, QMoveEvent *>(&QLCDNumber_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QLCDNumber::moveEvent(arg1);
    }
  }

  //  [emitter impl] void QLCDNumber::overflow()
  void emitter_QLCDNumber_overflow_0()
  {
    emit QLCDNumber::overflow();
  }

  //  [adaptor impl] void QLCDNumber::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QLCDNumber::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QLCDNumber_Adaptor, QPaintEvent *>(&QLCDNumber_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QLCDNumber::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QLCDNumber::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QLCDNumber_Adaptor, const QPalette &>(&QLCDNumber_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QLCDNumber::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QLCDNumber::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QLCDNumber_Adaptor, QResizeEvent *>(&QLCDNumber_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QLCDNumber::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QLCDNumber::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QLCDNumber_Adaptor, QShowEvent *>(&QLCDNumber_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QLCDNumber::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QLCDNumber::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QLCDNumber_Adaptor, QStyle &>(&QLCDNumber_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QLCDNumber::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QLCDNumber::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QLCDNumber_Adaptor, QTabletEvent *>(&QLCDNumber_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QLCDNumber::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QLCDNumber::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QLCDNumber_Adaptor, QTimerEvent *>(&QLCDNumber_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QLCDNumber::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QLCDNumber::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QLCDNumber_Adaptor, QWheelEvent *>(&QLCDNumber_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QLCDNumber::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QLCDNumber::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QLCDNumber::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QLCDNumber_Adaptor, bool>(&QLCDNumber_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QLCDNumber::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QLCDNumber_Adaptor::~QLCDNumber_Adaptor() { }

//  Constructor QLCDNumber::QLCDNumber(QWidget *parent) (adaptor class)

static void _init_ctor_QLCDNumber_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QLCDNumber_Adaptor> ();
}

static void _call_ctor_QLCDNumber_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QLCDNumber_Adaptor *> (new QLCDNumber_Adaptor (arg1));
}


//  Constructor QLCDNumber::QLCDNumber(unsigned int numDigits, QWidget *parent) (adaptor class)

static void _init_ctor_QLCDNumber_Adaptor_2979 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("numDigits");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QLCDNumber_Adaptor> ();
}

static void _call_ctor_QLCDNumber_Adaptor_2979 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QLCDNumber_Adaptor *> (new QLCDNumber_Adaptor (arg1, arg2));
}


// void QLCDNumber::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QLCDNumber::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QLCDNumber::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QLCDNumber::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QLCDNumber::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QLCDNumber::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_create_2208 (arg1, arg2, arg3);
}


// emitter void QLCDNumber::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QLCDNumber_Adaptor *)cls)->emitter_QLCDNumber_customContextMenuRequested_1916 (arg1);
}


// void QLCDNumber::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QLCDNumber::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_destroy_1620 (arg1, arg2);
}


// emitter void QLCDNumber::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QLCDNumber_Adaptor *)cls)->emitter_QLCDNumber_destroyed_1302 (arg1);
}


// void QLCDNumber::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QLCDNumber::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QLCDNumber::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QLCDNumber::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QLCDNumber::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_drawFrame_1426 (arg1);
}


// void QLCDNumber::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QLCDNumber::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QLCDNumber::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QLCDNumber::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QLCDNumber_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QLCDNumber::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QLCDNumber_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QLCDNumber::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QLCDNumber::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_focusNextChild_0 ());
}


// bool QLCDNumber::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QLCDNumber_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QLCDNumber::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QLCDNumber::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_focusPreviousChild_0 ());
}


// void QLCDNumber::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QLCDNumber::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QLCDNumber_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QLCDNumber::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QLCDNumber::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QLCDNumber::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QLCDNumber_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QLCDNumber::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QLCDNumber::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QLCDNumber::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QLCDNumber::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QLCDNumber::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QLCDNumber_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QLCDNumber::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QLCDNumber_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QLCDNumber::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QLCDNumber::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QLCDNumber::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QLCDNumber::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QLCDNumber::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// emitter void QLCDNumber::overflow()

static void _init_emitter_overflow_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_overflow_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QLCDNumber_Adaptor *)cls)->emitter_QLCDNumber_overflow_0 ();
}


// QPaintEngine *QLCDNumber::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QLCDNumber_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QLCDNumber::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QLCDNumber::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QLCDNumber::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_receivers_c1731 (arg1));
}


// exposed void QLCDNumber::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_resetInputContext_0 ();
}


// void QLCDNumber::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QLCDNumber::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_sender_c0 ());
}


// void QLCDNumber::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QLCDNumber::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QLCDNumber::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QLCDNumber_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QLCDNumber::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QLCDNumber::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QLCDNumber::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QLCDNumber::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->fp_QLCDNumber_updateMicroFocus_0 ();
}


// void QLCDNumber::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QLCDNumber::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLCDNumber_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QLCDNumber_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QLCDNumber> &qtdecl_QLCDNumber ();

static gsi::Methods methods_QLCDNumber_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLCDNumber::QLCDNumber(QWidget *parent)\nThis method creates an object of class QLCDNumber.", &_init_ctor_QLCDNumber_Adaptor_1315, &_call_ctor_QLCDNumber_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLCDNumber::QLCDNumber(unsigned int numDigits, QWidget *parent)\nThis method creates an object of class QLCDNumber.", &_init_ctor_QLCDNumber_Adaptor_2979, &_call_ctor_QLCDNumber_Adaptor_2979);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QLCDNumber::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QLCDNumber::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QLCDNumber::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QLCDNumber::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QLCDNumber::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QLCDNumber::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QLCDNumber::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QLCDNumber::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QLCDNumber::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QLCDNumber::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QLCDNumber::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QLCDNumber::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QLCDNumber::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QLCDNumber::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QLCDNumber::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QLCDNumber::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QLCDNumber::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QLCDNumber::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QLCDNumber::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QLCDNumber::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QLCDNumber::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QLCDNumber::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QLCDNumber::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QLCDNumber::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QLCDNumber::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QLCDNumber::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QLCDNumber::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QLCDNumber::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QLCDNumber::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QLCDNumber::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QLCDNumber::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QLCDNumber::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QLCDNumber::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QLCDNumber::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QLCDNumber::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QLCDNumber::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QLCDNumber::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QLCDNumber::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QLCDNumber::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QLCDNumber::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QLCDNumber::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("emit_overflow", "@brief Emitter for signal void QLCDNumber::overflow()\nCall this method to emit this signal.", false, &_init_emitter_overflow_0, &_call_emitter_overflow_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QLCDNumber::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QLCDNumber::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QLCDNumber::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QLCDNumber::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QLCDNumber::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QLCDNumber::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QLCDNumber::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QLCDNumber::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QLCDNumber::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QLCDNumber::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QLCDNumber::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QLCDNumber::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QLCDNumber::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QLCDNumber::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QLCDNumber::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QLCDNumber::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QLCDNumber_Adaptor> decl_QLCDNumber_Adaptor (qtdecl_QLCDNumber (), "QtGui", "QLCDNumber",
  methods_QLCDNumber_Adaptor (),
  "@qt\n@brief Binding of QLCDNumber");

}


//  Implementation of the enum wrapper class for QLCDNumber::Mode
namespace qt_gsi
{

static gsi::Enum<QLCDNumber::Mode> decl_QLCDNumber_Mode_Enum ("QtGui", "QLCDNumber_Mode",
    gsi::enum_const ("Hex", QLCDNumber::Hex, "@brief Enum constant QLCDNumber::Hex") +
    gsi::enum_const ("Dec", QLCDNumber::Dec, "@brief Enum constant QLCDNumber::Dec") +
    gsi::enum_const ("Oct", QLCDNumber::Oct, "@brief Enum constant QLCDNumber::Oct") +
    gsi::enum_const ("Bin", QLCDNumber::Bin, "@brief Enum constant QLCDNumber::Bin"),
  "@qt\n@brief This class represents the QLCDNumber::Mode enum");

static gsi::QFlagsClass<QLCDNumber::Mode > decl_QLCDNumber_Mode_Enums ("QtGui", "QLCDNumber_QFlags_Mode",
  "@qt\n@brief This class represents the QFlags<QLCDNumber::Mode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLCDNumber> inject_QLCDNumber_Mode_Enum_in_parent (decl_QLCDNumber_Mode_Enum.defs ());
static gsi::ClassExt<QLCDNumber> decl_QLCDNumber_Mode_Enum_as_child (decl_QLCDNumber_Mode_Enum, "Mode");
static gsi::ClassExt<QLCDNumber> decl_QLCDNumber_Mode_Enums_as_child (decl_QLCDNumber_Mode_Enums, "QFlags_Mode");

}


//  Implementation of the enum wrapper class for QLCDNumber::SegmentStyle
namespace qt_gsi
{

static gsi::Enum<QLCDNumber::SegmentStyle> decl_QLCDNumber_SegmentStyle_Enum ("QtGui", "QLCDNumber_SegmentStyle",
    gsi::enum_const ("Outline", QLCDNumber::Outline, "@brief Enum constant QLCDNumber::Outline") +
    gsi::enum_const ("Filled", QLCDNumber::Filled, "@brief Enum constant QLCDNumber::Filled") +
    gsi::enum_const ("Flat", QLCDNumber::Flat, "@brief Enum constant QLCDNumber::Flat"),
  "@qt\n@brief This class represents the QLCDNumber::SegmentStyle enum");

static gsi::QFlagsClass<QLCDNumber::SegmentStyle > decl_QLCDNumber_SegmentStyle_Enums ("QtGui", "QLCDNumber_QFlags_SegmentStyle",
  "@qt\n@brief This class represents the QFlags<QLCDNumber::SegmentStyle> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QLCDNumber> inject_QLCDNumber_SegmentStyle_Enum_in_parent (decl_QLCDNumber_SegmentStyle_Enum.defs ());
static gsi::ClassExt<QLCDNumber> decl_QLCDNumber_SegmentStyle_Enum_as_child (decl_QLCDNumber_SegmentStyle_Enum, "SegmentStyle");
static gsi::ClassExt<QLCDNumber> decl_QLCDNumber_SegmentStyle_Enums_as_child (decl_QLCDNumber_SegmentStyle_Enums, "QFlags_SegmentStyle");

}

