; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --extra_scrub
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

; FCEIL

define <vscale x 8 x half> @frintp_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frintp_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.ceil.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frintp_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frintp_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.ceil.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frintp_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frintp_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintp z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.ceil.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frintp_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frintp_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintp z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frintp_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frintp_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintp z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.ceil.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frintp_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frintp_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintp z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; FFLOOR

define <vscale x 8 x half> @frintm_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frintm_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.floor.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frintm_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frintm_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.floor.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frintm_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frintm_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintm z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.floor.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frintm_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frintm_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintm z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frintm_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frintm_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintm z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.floor.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frintm_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frintm_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintm z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; FNEARBYINT

define <vscale x 8 x half> @frinti_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frinti_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.nearbyint.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frinti_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frinti_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.nearbyint.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frinti_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frinti_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinti z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.nearbyint.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frinti_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frinti_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frinti z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frinti_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frinti_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinti z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.nearbyint.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frinti_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frinti_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinti z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; FRINT

define <vscale x 8 x half> @frintx_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frintx_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.rint.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frintx_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frintx_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.rint.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frintx_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frintx_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintx z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.rint.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frintx_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frintx_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frintx_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frintx_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintx z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.rint.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frintx_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frintx_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintx z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; ROUND

define <vscale x 8 x half> @frinta_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frinta_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.round.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frinta_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frinta_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.round.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frinta_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frinta_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinta z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.round.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frinta_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frinta_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frinta z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frinta_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frinta_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinta z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.round.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frinta_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frinta_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frinta z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; ROUNDEVEN

define <vscale x 8 x half> @frintn_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frintn_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.roundeven.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frintn_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frintn_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.roundeven.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frintn_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frintn_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintn z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.roundeven.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frintn_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frintn_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintn z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.roundeven.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frintn_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frintn_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintn z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.roundeven.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frintn_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frintn_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintn z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.roundeven.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

; FTRUNC

define <vscale x 8 x half> @frintz_nxv8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: frintz_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x half> @llvm.trunc.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %res
}

define <vscale x 4 x half> @frintz_nxv4f16(<vscale x 4 x half> %a) {
; CHECK-LABEL: frintz_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x half> @llvm.trunc.nxv4f16(<vscale x 4 x half> %a)
  ret <vscale x 4 x half> %res
}

define <vscale x 2 x half> @frintz_nxv2f16(<vscale x 2 x half> %a) {
; CHECK-LABEL: frintz_nxv2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintz z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x half> @llvm.trunc.nxv2f16(<vscale x 2 x half> %a)
  ret <vscale x 2 x half> %res
}

define <vscale x 4 x float> @frintz_nxv4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: frintz_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    frintz z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x float> @frintz_nxv2f32(<vscale x 2 x float> %a) {
; CHECK-LABEL: frintz_nxv2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintz z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x float> @llvm.trunc.nxv2f32(<vscale x 2 x float> %a)
  ret <vscale x 2 x float> %res
}

define <vscale x 2 x double> @frintz_nxv2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: frintz_nxv2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    frintz z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %res
}

declare <vscale x 8 x half> @llvm.ceil.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.ceil.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.ceil.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.ceil.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.floor.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.floor.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.floor.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.floor.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.nearbyint.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.nearbyint.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.nearbyint.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.nearbyint.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.rint.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.rint.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.rint.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.rint.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.round.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.round.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.round.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.round.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.roundeven.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.roundeven.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.roundeven.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.roundeven.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.roundeven.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.roundeven.nxv2f64(<vscale x 2 x double>)

declare <vscale x 8 x half> @llvm.trunc.nxv8f16( <vscale x 8 x half>)
declare <vscale x 4 x half> @llvm.trunc.nxv4f16( <vscale x 4 x half>)
declare <vscale x 2 x half> @llvm.trunc.nxv2f16( <vscale x 2 x half>)
declare <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x float> @llvm.trunc.nxv2f32(<vscale x 2 x float>)
declare <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double>)
