; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -mattr=+aix-small-local-exec-tls < %s \
; RUN:      | FileCheck %s --check-prefix=SMALL-LOCAL-EXEC-SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      -mattr=+aix-small-local-exec-tls < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL-LOCAL-EXEC-LARGECM64

; Test disassembly of object.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=+aix-small-local-exec-tls \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -xcoff-traceback-table=false \
; RUN:      --code-model=large -filetype=obj -o %t.o < %s
; RUN: llvm-objdump -D -r --symbol-description %t.o | FileCheck -D#NFA=2 --check-prefix=DIS %s

@mySmallLocalExecTLS6 = external thread_local(localexec) global [60 x i64], align 8
@mySmallLocalExecTLS2 = thread_local(localexec) global [3000 x i64] zeroinitializer, align 8
@MyTLSGDVar = thread_local global [800 x i64] zeroinitializer, align 8
@mySmallLocalExecTLS3 = thread_local(localexec) global [3000 x i64] zeroinitializer, align 8
@mySmallLocalExecTLS4 = thread_local(localexec) global [3000 x i64] zeroinitializer, align 8
@mySmallLocalExecTLS5 = thread_local(localexec) global [3000 x i64] zeroinitializer, align 8
@mySmallLocalExecTLS = thread_local(localexec) local_unnamed_addr global [7800 x i64] zeroinitializer, align 8
declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1

; All accesses use a "faster" local-exec sequence directly off the thread pointer.
define i64 @StoreLargeAccess1() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: StoreLargeAccess1:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    mflr r0
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 212
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 203
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, mySmallLocalExecTLS6[UL]@le+424(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r4, mySmallLocalExecTLS2[TL]@le+1200(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tlsgdm) @MyTLSGDVar
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, L..C1(r2) # target-flags(ppc-tlsgd) @MyTLSGDVar
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    bla .__tls_get_addr[PR]
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 44
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r4, 440(r3)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 6
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 100
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, mySmallLocalExecTLS3[TL]@le+2000(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 882
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r4, (mySmallLocalExecTLS4[TL]@le+6800)-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    std r3, (mySmallLocalExecTLS5[TL]@le+8400)-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 1191
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    mtlr r0
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: StoreLargeAccess1:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    mflr r0
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 212
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r4, L..C0@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r4, L..C0@l(r4)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, mySmallLocalExecTLS6[UL]@le+424(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 203
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, mySmallLocalExecTLS2[TL]@le+1200(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r3, L..C1@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, L..C1@l(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    bla .__tls_get_addr[PR]
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 44
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r4, 440(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 6
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 100
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, mySmallLocalExecTLS3[TL]@le+2000(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 882
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r4, (mySmallLocalExecTLS4[TL]@le+6800)-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    std r3, (mySmallLocalExecTLS5[TL]@le+8400)-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 1191
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    mtlr r0
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @mySmallLocalExecTLS6)
  %arrayidx = getelementptr inbounds [60 x i64], ptr %0, i64 0, i64 53
  store i64 212, ptr %arrayidx, align 8
  %1 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @mySmallLocalExecTLS2)
  %arrayidx1 = getelementptr inbounds [3000 x i64], ptr %1, i64 0, i64 150
  store i64 203, ptr %arrayidx1, align 8
  %2 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @MyTLSGDVar)
  %arrayidx2 = getelementptr inbounds [800 x i64], ptr %2, i64 0, i64 55
  store i64 44, ptr %arrayidx2, align 8
  %3 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @mySmallLocalExecTLS3)
  %arrayidx3 = getelementptr inbounds [3000 x i64], ptr %3, i64 0, i64 250
  store i64 6, ptr %arrayidx3, align 8
  %4 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @mySmallLocalExecTLS4)
  %arrayidx4 = getelementptr inbounds [3000 x i64], ptr %4, i64 0, i64 850
  store i64 100, ptr %arrayidx4, align 8
  %5 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @mySmallLocalExecTLS5)
  %arrayidx5 = getelementptr inbounds [3000 x i64], ptr %5, i64 0, i64 1050
  store i64 882, ptr %arrayidx5, align 8
  %6 = load i64, ptr %arrayidx1, align 8
  %7 = load i64, ptr %arrayidx3, align 8
  %8 = load i64, ptr %arrayidx4, align 8
  %add = add i64 %6, 882
  %add9 = add i64 %add, %7
  %add11 = add i64 %add9, %8
  ret i64 %add11
}

; DIS:      0000000000000000 (idx: [[#NFA+7]]) .StoreLargeAccess1:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mflr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stdu 1, -48(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 212
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 0, 64(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 4, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+13]]) MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 4, 0(4)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+13]]) MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 3, 424(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+1]]) mySmallLocalExecTLS6[UL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 203
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 3, 1200(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+17]]) mySmallLocalExecTLS2[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+15]]) .MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 8(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+15]]) .MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                bla 0
; DIS-NEXT: {{0*}}[[#ADDR]]: R_RBA  (idx: [[#NFA+3]])      .__tls_get_addr[PR]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 44
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 440(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 6
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 100
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 3, 32400(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE       (idx: [[#NFA+21]]) mySmallLocalExecTLS3[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 882
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, -4336(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE       (idx: [[#NFA+23]]) mySmallLocalExecTLS4[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 3, 21264(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE       (idx: [[#NFA+25]]) mySmallLocalExecTLS5[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 1191
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 1, 1, 48
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 0, 16(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mtlr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      Disassembly of section .data:
; DIS:      0000000000000068 (idx: [[#NFA+9]]) StoreLargeAccess1[DS]:
; DIS-NEXT:       68: 00 00 00 00
; DIS-NEXT: 0000000000000068:  R_POS    (idx: [[#NFA+7]]) .StoreLargeAccess1
; DIS-NEXT:       6c: 00 00 00 00
; DIS-NEXT:       70: 00 00 00 00
; DIS-NEXT: 0000000000000070:  R_POS        (idx: [[#NFA+11]]) TOC[TC0]
; DIS-NEXT:       74: 00 00 00 80

; DIS:      Disassembly of section .tdata:
; DIS:      0000000000000000 (idx: [[#NFA+17]]) mySmallLocalExecTLS2[TL]:
; DIS:      0000000000005dc0 (idx: [[#NFA+19]]) MyTLSGDVar[TL]:
; DIS:      00000000000076c0 (idx: [[#NFA+21]]) mySmallLocalExecTLS3[TL]:
; DIS:      000000000000d480 (idx: [[#NFA+23]]) mySmallLocalExecTLS4[TL]:
; DIS:      0000000000013240 (idx: [[#NFA+25]]) mySmallLocalExecTLS5[TL]:
; DIS:      0000000000019000 (idx: [[#NFA+27]]) mySmallLocalExecTLS[TL]:
