; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=+altivec -vec-extabi \
; RUN:     -stop-after=machine-cp -mtriple powerpc-ibm-aix-xcoff < %s | \
; RUN:   FileCheck %s --check-prefix=MIR32

; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=+altivec -vec-extabi \
; RUN:     -stop-after=machine-cp -mtriple powerpc64-ibm-aix-xcoff < %s | \
; RUN:   FileCheck %s --check-prefix=MIR64

%struct.Test = type { double, double, double, double }

@__const.caller.t = private unnamed_addr constant %struct.Test { double 0.000000e+00, double 1.000000e+00, double 2.000000e+00, double 3.000000e+00 }, align 8

define double @caller() {

  ; MIR32-LABEL: name: caller
  ; MIR32: bb.0.entry:
  ; MIR32-NEXT:   renamable $r3 = LI 0
  ; MIR32-NEXT:   renamable $r4 = LIS 16392
  ; MIR32-NEXT:   STW killed renamable $r4, 180, $r1 :: (store (s32) into unknown-address + 24)
  ; MIR32-NEXT:   renamable $r4 = LIS 16384
  ; MIR32-NEXT:   STW renamable $r3, 184, $r1 :: (store (s32) into unknown-address + 28)
  ; MIR32-NEXT:   STW renamable $r3, 176, $r1 :: (store (s32) into unknown-address + 20)
  ; MIR32-NEXT:   STW killed renamable $r4, 172, $r1 :: (store (s32) into unknown-address + 16)
  ; MIR32-NEXT:   STW renamable $r3, 168, $r1 :: (store (s32) into unknown-address + 12)
  ; MIR32-NEXT:   renamable $r4 = LIS 16368
  ; MIR32-NEXT:   STW killed renamable $r4, 164, $r1 :: (store (s32) into unknown-address + 8)
  ; MIR32-NEXT:   STW renamable $r3, 160, $r1 :: (store (s32) into unknown-address + 4)
  ; MIR32-NEXT:   STW killed renamable $r3, 156, $r1 :: (store (s32))
  ; MIR32-NEXT:   ADJCALLSTACKDOWN 188, 0, implicit-def dead $r1, implicit $r1
  ; MIR32-NEXT:   renamable $vsl0 = XXLXORz
  ; MIR32-NEXT:   renamable $r3 = LI 136
  ; MIR32-NEXT:   renamable $r4 = LI 120
  ; MIR32-NEXT:   STXVW4X renamable $vsl0, $r1, killed renamable $r3 :: (store (s128), align 8)
  ; MIR32-NEXT:   renamable $r3 = LI 104
  ; MIR32-NEXT:   STXVW4X renamable $vsl0, $r1, killed renamable $r4 :: (store (s128), align 8)
  ; MIR32-NEXT:   renamable $r4 = LI 88
  ; MIR32-NEXT:   STXVW4X renamable $vsl0, $r1, killed renamable $r3 :: (store (s128), align 8)
  ; MIR32-NEXT:   STXVW4X renamable $vsl0, $r1, killed renamable $r4 :: (store (s128), align 8)
  ; MIR32-NEXT:   renamable $r3 = LI 72
  ; MIR32-NEXT:   renamable $r4 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; MIR32-NEXT:   STXVW4X killed renamable $vsl0, $r1, killed renamable $r3 :: (store (s128), align 8)
  ; MIR32-NEXT:   renamable $r3 = LI 48
  ; MIR32-NEXT:   renamable $vsl0 = LXVD2X $zero, killed renamable $r4 :: (load (s128) from constant-pool)
  ; MIR32-NEXT:   renamable $r4 = LI 512
  ; MIR32-NEXT:   STXVD2X killed renamable $vsl0, $r1, killed renamable $r3 :: (store (s128))
  ; MIR32-NEXT:   STW killed renamable $r4, 152, $r1 :: (store (s32))
  ; MIR32-NEXT:   $f1 = XXLXORdpz
  ; MIR32-NEXT:   $f2 = XXLXORdpz
  ; MIR32-NEXT:   $v2 = XXLXORz
  ; MIR32-NEXT:   $v3 = XXLXORz
  ; MIR32-NEXT:   $v4 = XXLXORz
  ; MIR32-NEXT:   $v5 = XXLXORz
  ; MIR32-NEXT:   $v6 = XXLXORz
  ; MIR32-NEXT:   $v7 = XXLXORz
  ; MIR32-NEXT:   $v8 = XXLXORz
  ; MIR32-NEXT:   $r3 = LI 128
  ; MIR32-NEXT:   $r4 = LI 256
  ; MIR32-NEXT:   $v9 = XXLXORz
  ; MIR32-NEXT:   $v10 = XXLXORz
  ; MIR32-NEXT:   $v11 = XXLXORz
  ; MIR32-NEXT:   $v12 = XXLXORz
  ; MIR32-NEXT:   $v13 = XXLXORz
  ; MIR32-NEXT:   $f3 = XXLXORdpz
  ; MIR32-NEXT:   $f4 = XXLXORdpz
  ; MIR32-NEXT:   $f5 = XXLXORdpz
  ; MIR32-NEXT:   $f6 = XXLXORdpz
  ; MIR32-NEXT:   $f7 = XXLXORdpz
  ; MIR32-NEXT:   $f8 = XXLXORdpz
  ; MIR32-NEXT:   $f9 = XXLXORdpz
  ; MIR32-NEXT:   $f10 = XXLXORdpz
  ; MIR32-NEXT:   $f11 = XXLXORdpz
  ; MIR32-NEXT:   $f12 = XXLXORdpz
  ; MIR32-NEXT:   $f13 = XXLXORdpz
  ; MIR32-NEXT:   BL_NOP <mcsymbol .callee[PR]>, csr_aix32_altivec, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $f1, implicit killed $f2, implicit killed $v2, implicit killed $v3, implicit killed $v4, implicit killed $v5, implicit killed $v6, implicit killed $v7, implicit killed $v8, implicit killed $v9, implicit killed $v10, implicit killed $v11, implicit killed $v12, implicit killed $v13, implicit killed $f3, implicit killed $f4, implicit killed $f5, implicit killed $f6, implicit killed $f7, implicit killed $f8, implicit killed $f9, implicit killed $f10, implicit killed $f11, implicit killed $f12, implicit killed $f13, implicit $r2, implicit-def $r1, implicit-def $f1
  ; MIR32-NEXT:   ADJCALLSTACKUP 188, 0, implicit-def dead $r1, implicit $r1
  ; MIR32-NEXT:   BLR implicit $lr, implicit $rm, implicit $f1
  ;
  ; MIR64-LABEL: name: caller
  ; MIR64: bb.0.entry:
  ; MIR64-NEXT:   renamable $x3 = LI8 2049
  ; MIR64-NEXT:   renamable $x4 = LI8 1
  ; MIR64-NEXT:   renamable $x3 = RLDIC killed renamable $x3, 51, 1
  ; MIR64-NEXT:   STD killed renamable $x3, 216, $x1 :: (store (s64) into unknown-address + 24, align 4)
  ; MIR64-NEXT:   renamable $x3 = LI8 1023
  ; MIR64-NEXT:   renamable $x4 = RLDIC killed renamable $x4, 62, 1
  ; MIR64-NEXT:   STD killed renamable $x4, 208, $x1 :: (store (s64) into unknown-address + 16, align 4)
  ; MIR64-NEXT:   renamable $x4 = LI8 0
  ; MIR64-NEXT:   STD renamable $x4, 192, $x1 :: (store (s64), align 4)
  ; MIR64-NEXT:   renamable $x3 = RLDIC killed renamable $x3, 52, 2
  ; MIR64-NEXT:   STD killed renamable $x3, 200, $x1 :: (store (s64) into unknown-address + 8, align 4)
  ; MIR64-NEXT:   ADJCALLSTACKDOWN 224, 0, implicit-def dead $r1, implicit $r1
  ; MIR64-NEXT:   renamable $vsl0 = XXLXORz
  ; MIR64-NEXT:   renamable $x3 = LI8 160
  ; MIR64-NEXT:   STXVW4X renamable $vsl0, $x1, killed renamable $x3 :: (store (s128), align 8)
  ; MIR64-NEXT:   renamable $x3 = LI8 144
  ; MIR64-NEXT:   STXVW4X renamable $vsl0, $x1, killed renamable $x3 :: (store (s128), align 8)
  ; MIR64-NEXT:   renamable $x3 = LI8 128
  ; MIR64-NEXT:   STXVW4X killed renamable $vsl0, $x1, killed renamable $x3 :: (store (s128), align 8)
  ; MIR64-NEXT:   renamable $x3 = LDtocCPT %const.0, $x2 :: (load (s64) from got)
  ; MIR64-NEXT:   renamable $vsl0 = LXVD2X $zero8, killed renamable $x3 :: (load (s128) from constant-pool)
  ; MIR64-NEXT:   renamable $x3 = LI8 80
  ; MIR64-NEXT:   STXVD2X killed renamable $vsl0, $x1, killed renamable $x3 :: (store (s128))
  ; MIR64-NEXT:   renamable $x3 = LI8 512
  ; MIR64-NEXT:   STD killed renamable $x3, 184, $x1 :: (store (s64))
  ; MIR64-NEXT:   STD killed renamable $x4, 176, $x1 :: (store (s64))
  ; MIR64-NEXT:   $f1 = XXLXORdpz
  ; MIR64-NEXT:   $f2 = XXLXORdpz
  ; MIR64-NEXT:   $v2 = XXLXORz
  ; MIR64-NEXT:   $v3 = XXLXORz
  ; MIR64-NEXT:   $v4 = XXLXORz
  ; MIR64-NEXT:   $v5 = XXLXORz
  ; MIR64-NEXT:   $v6 = XXLXORz
  ; MIR64-NEXT:   $x3 = LI8 128
  ; MIR64-NEXT:   $x4 = LI8 256
  ; MIR64-NEXT:   $v7 = XXLXORz
  ; MIR64-NEXT:   $v8 = XXLXORz
  ; MIR64-NEXT:   $v9 = XXLXORz
  ; MIR64-NEXT:   $v10 = XXLXORz
  ; MIR64-NEXT:   $v11 = XXLXORz
  ; MIR64-NEXT:   $v12 = XXLXORz
  ; MIR64-NEXT:   $v13 = XXLXORz
  ; MIR64-NEXT:   $f3 = XXLXORdpz
  ; MIR64-NEXT:   $f4 = XXLXORdpz
  ; MIR64-NEXT:   $f5 = XXLXORdpz
  ; MIR64-NEXT:   $f6 = XXLXORdpz
  ; MIR64-NEXT:   $f7 = XXLXORdpz
  ; MIR64-NEXT:   $f8 = XXLXORdpz
  ; MIR64-NEXT:   $f9 = XXLXORdpz
  ; MIR64-NEXT:   $f10 = XXLXORdpz
  ; MIR64-NEXT:   $f11 = XXLXORdpz
  ; MIR64-NEXT:   $f12 = XXLXORdpz
  ; MIR64-NEXT:   $f13 = XXLXORdpz
  ; MIR64-NEXT:   BL8_NOP <mcsymbol .callee[PR]>, csr_ppc64_altivec, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $f1, implicit killed $f2, implicit killed $v2, implicit killed $v3, implicit killed $v4, implicit killed $v5, implicit killed $v6, implicit killed $v7, implicit killed $v8, implicit killed $v9, implicit killed $v10, implicit killed $v11, implicit killed $v12, implicit killed $v13, implicit killed $f3, implicit killed $f4, implicit killed $f5, implicit killed $f6, implicit killed $f7, implicit killed $f8, implicit killed $f9, implicit killed $f10, implicit killed $f11, implicit killed $f12, implicit killed $f13, implicit $x2, implicit-def $r1, implicit-def $f1
  ; MIR64-NEXT:   ADJCALLSTACKUP 224, 0, implicit-def dead $r1, implicit $r1
  ; MIR64-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
  entry:
    %call = tail call double @callee(i32 signext 128, i32 signext 256, double 0.000000e+00, double 0.000000e+00, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 0.000000e+00, double 0.000000e+00>, <2 x double> <double 2.400000e+01, double 2.500000e+01>, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00, i32 signext 512, ptr nonnull byval(%struct.Test) align 4 @__const.caller.t)
      ret double %call
}

declare double @callee(i32 signext, i32 signext, double, double, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, <2 x double>, double, double, double, double, double, double, double, double, double, double, double, i32 signext, ptr byval(%struct.Test) align 8)
