; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=i686--   -mcpu=x86-64    | FileCheck %s --check-prefixes=X86-SSE2
; RUN: llc < %s -mtriple=x86_64-- -mcpu=x86-64    | FileCheck %s --check-prefixes=X64-SSE2
; RUN: llc < %s -mtriple=i686--   -mcpu=x86-64-v2 | FileCheck %s --check-prefixes=X86-SSE42
; RUN: llc < %s -mtriple=x86_64-- -mcpu=x86-64-v2 | FileCheck %s --check-prefixes=X64-SSE42
; RUN: llc < %s -mtriple=i686--   -mcpu=x86-64-v3 | FileCheck %s --check-prefixes=X86-AVX2
; RUN: llc < %s -mtriple=x86_64-- -mcpu=x86-64-v3 | FileCheck %s --check-prefixes=X64-AVX2
; RUN: llc < %s -mtriple=i686--   -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=X86-AVX512
; RUN: llc < %s -mtriple=x86_64-- -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=X64-AVX512

; PR78897 - Don't vectorize a mul of extracted values if we'd still need the extract.
; TODO: We should vectorize on 32-bit targets.
define <16 x i8> @produceShuffleVectorForByte(i8 zeroext %0) nounwind {
; X86-SSE2-LABEL: produceShuffleVectorForByte:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    pushl %ebx
; X86-SSE2-NEXT:    pushl %edi
; X86-SSE2-NEXT:    pushl %esi
; X86-SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    movd %xmm2, %esi
; X86-SSE2-NEXT:    movd %xmm1, %ecx
; X86-SSE2-NEXT:    movl $286331152, %edi # imm = 0x11111110
; X86-SSE2-NEXT:    movl %ecx, %eax
; X86-SSE2-NEXT:    mull %edi
; X86-SSE2-NEXT:    imull $286331153, %ecx, %ebx # imm = 0x11111111
; X86-SSE2-NEXT:    addl %edx, %ebx
; X86-SSE2-NEXT:    imull $286331152, %esi, %edx # imm = 0x11111110
; X86-SSE2-NEXT:    addl %ebx, %edx
; X86-SSE2-NEXT:    movd %edx, %xmm2
; X86-SSE2-NEXT:    movd %eax, %xmm1
; X86-SSE2-NEXT:    xorl $286331153, %ecx # imm = 0x11111111
; X86-SSE2-NEXT:    movl %ecx, %eax
; X86-SSE2-NEXT:    mull %edi
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X86-SSE2-NEXT:    xorl $17895697, %esi # imm = 0x1111111
; X86-SSE2-NEXT:    imull $286331153, %ecx, %ecx # imm = 0x11111111
; X86-SSE2-NEXT:    addl %edx, %ecx
; X86-SSE2-NEXT:    imull $286331152, %esi, %edx # imm = 0x11111110
; X86-SSE2-NEXT:    addl %ecx, %edx
; X86-SSE2-NEXT:    movd %edx, %xmm2
; X86-SSE2-NEXT:    movd %eax, %xmm3
; X86-SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pandn %xmm3, %xmm0
; X86-SSE2-NEXT:    por %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrlw $4, %xmm1
; X86-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X86-SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0
; X86-SSE2-NEXT:    popl %esi
; X86-SSE2-NEXT:    popl %edi
; X86-SSE2-NEXT:    popl %ebx
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: produceShuffleVectorForByte:
; X64-SSE2:       # %bb.0: # %entry
; X64-SSE2-NEXT:    movd %edi, %xmm0
; X64-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,0,0,0,4,5,6,7]
; X64-SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE2-NEXT:    pxor %xmm0, %xmm0
; X64-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X64-SSE2-NEXT:    pand %xmm0, %xmm1
; X64-SSE2-NEXT:    movq %xmm1, %rax
; X64-SSE2-NEXT:    movabsq $1229782938247303440, %rcx # imm = 0x1111111111111110
; X64-SSE2-NEXT:    movabsq $76861433640456465, %rdx # imm = 0x111111111111111
; X64-SSE2-NEXT:    xorq %rax, %rdx
; X64-SSE2-NEXT:    imulq %rcx, %rax
; X64-SSE2-NEXT:    movq %rax, %xmm1
; X64-SSE2-NEXT:    imulq %rcx, %rdx
; X64-SSE2-NEXT:    movq %rdx, %xmm2
; X64-SSE2-NEXT:    pand %xmm0, %xmm1
; X64-SSE2-NEXT:    pandn %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrlw $4, %xmm1
; X64-SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X64-SSE2-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; X64-SSE2-NEXT:    retq
;
; X86-SSE42-LABEL: produceShuffleVectorForByte:
; X86-SSE42:       # %bb.0: # %entry
; X86-SSE42-NEXT:    pushl %ebx
; X86-SSE42-NEXT:    pushl %edi
; X86-SSE42-NEXT:    pushl %esi
; X86-SSE42-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-SSE42-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X86-SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,0,0,0,4,5,6,7]
; X86-SSE42-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm0
; X86-SSE42-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE42-NEXT:    movdqa {{.*#+}} xmm1 = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X86-SSE42-NEXT:    pand %xmm0, %xmm1
; X86-SSE42-NEXT:    movd %xmm1, %ecx
; X86-SSE42-NEXT:    movl $286331152, %edi # imm = 0x11111110
; X86-SSE42-NEXT:    movl %ecx, %eax
; X86-SSE42-NEXT:    mull %edi
; X86-SSE42-NEXT:    pextrd $1, %xmm1, %esi
; X86-SSE42-NEXT:    imull $286331153, %ecx, %ebx # imm = 0x11111111
; X86-SSE42-NEXT:    addl %edx, %ebx
; X86-SSE42-NEXT:    imull $286331152, %esi, %edx # imm = 0x11111110
; X86-SSE42-NEXT:    addl %ebx, %edx
; X86-SSE42-NEXT:    movd %eax, %xmm2
; X86-SSE42-NEXT:    pinsrd $1, %edx, %xmm2
; X86-SSE42-NEXT:    xorl $286331153, %ecx # imm = 0x11111111
; X86-SSE42-NEXT:    movl %ecx, %eax
; X86-SSE42-NEXT:    mull %edi
; X86-SSE42-NEXT:    xorl $17895697, %esi # imm = 0x1111111
; X86-SSE42-NEXT:    imull $286331153, %ecx, %ecx # imm = 0x11111111
; X86-SSE42-NEXT:    addl %edx, %ecx
; X86-SSE42-NEXT:    imull $286331152, %esi, %edx # imm = 0x11111110
; X86-SSE42-NEXT:    addl %ecx, %edx
; X86-SSE42-NEXT:    movd %eax, %xmm1
; X86-SSE42-NEXT:    pinsrd $1, %edx, %xmm1
; X86-SSE42-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $4, %xmm0
; X86-SSE42-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-SSE42-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    popl %esi
; X86-SSE42-NEXT:    popl %edi
; X86-SSE42-NEXT:    popl %ebx
; X86-SSE42-NEXT:    retl
;
; X64-SSE42-LABEL: produceShuffleVectorForByte:
; X64-SSE42:       # %bb.0: # %entry
; X64-SSE42-NEXT:    movd %edi, %xmm0
; X64-SSE42-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X64-SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,0,0,0,4,5,6,7]
; X64-SSE42-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm0
; X64-SSE42-NEXT:    pcmpeqb %xmm1, %xmm0
; X64-SSE42-NEXT:    movdqa {{.*#+}} xmm1 = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X64-SSE42-NEXT:    pand %xmm0, %xmm1
; X64-SSE42-NEXT:    movq %xmm1, %rax
; X64-SSE42-NEXT:    movabsq $1229782938247303440, %rcx # imm = 0x1111111111111110
; X64-SSE42-NEXT:    movabsq $76861433640456465, %rdx # imm = 0x111111111111111
; X64-SSE42-NEXT:    xorq %rax, %rdx
; X64-SSE42-NEXT:    imulq %rcx, %rax
; X64-SSE42-NEXT:    movq %rax, %xmm2
; X64-SSE42-NEXT:    imulq %rcx, %rdx
; X64-SSE42-NEXT:    movq %rdx, %xmm1
; X64-SSE42-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $4, %xmm0
; X64-SSE42-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-SSE42-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    retq
;
; X86-AVX2-LABEL: produceShuffleVectorForByte:
; X86-AVX2:       # %bb.0: # %entry
; X86-AVX2-NEXT:    pushl %ebx
; X86-AVX2-NEXT:    pushl %edi
; X86-AVX2-NEXT:    pushl %esi
; X86-AVX2-NEXT:    vpbroadcastb {{[0-9]+}}(%esp), %xmm0
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm1
; X86-AVX2-NEXT:    vmovd %xmm1, %edx
; X86-AVX2-NEXT:    movl $286331152, %ecx # imm = 0x11111110
; X86-AVX2-NEXT:    mulxl %ecx, %edi, %esi
; X86-AVX2-NEXT:    vpextrd $1, %xmm1, %eax
; X86-AVX2-NEXT:    imull $286331153, %edx, %ebx # imm = 0x11111111
; X86-AVX2-NEXT:    addl %esi, %ebx
; X86-AVX2-NEXT:    imull $286331152, %eax, %esi # imm = 0x11111110
; X86-AVX2-NEXT:    addl %ebx, %esi
; X86-AVX2-NEXT:    vmovd %edi, %xmm1
; X86-AVX2-NEXT:    xorl $286331153, %edx # imm = 0x11111111
; X86-AVX2-NEXT:    mulxl %ecx, %edi, %ecx
; X86-AVX2-NEXT:    vpinsrd $1, %esi, %xmm1, %xmm1
; X86-AVX2-NEXT:    xorl $17895697, %eax # imm = 0x1111111
; X86-AVX2-NEXT:    imull $286331153, %edx, %edx # imm = 0x11111111
; X86-AVX2-NEXT:    addl %ecx, %edx
; X86-AVX2-NEXT:    imull $286331152, %eax, %eax # imm = 0x11111110
; X86-AVX2-NEXT:    addl %edx, %eax
; X86-AVX2-NEXT:    vmovd %edi, %xmm2
; X86-AVX2-NEXT:    vpinsrd $1, %eax, %xmm2, %xmm2
; X86-AVX2-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; X86-AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm1
; X86-AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X86-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX2-NEXT:    popl %esi
; X86-AVX2-NEXT:    popl %edi
; X86-AVX2-NEXT:    popl %ebx
; X86-AVX2-NEXT:    retl
;
; X64-AVX2-LABEL: produceShuffleVectorForByte:
; X64-AVX2:       # %bb.0: # %entry
; X64-AVX2-NEXT:    vmovd %edi, %xmm0
; X64-AVX2-NEXT:    vpbroadcastb %xmm0, %xmm0
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; X64-AVX2-NEXT:    vmovq %xmm1, %rax
; X64-AVX2-NEXT:    movabsq $1229782938247303440, %rcx # imm = 0x1111111111111110
; X64-AVX2-NEXT:    movabsq $76861433640456465, %rdx # imm = 0x111111111111111
; X64-AVX2-NEXT:    xorq %rax, %rdx
; X64-AVX2-NEXT:    imulq %rcx, %rax
; X64-AVX2-NEXT:    vmovq %rax, %xmm1
; X64-AVX2-NEXT:    imulq %rcx, %rdx
; X64-AVX2-NEXT:    vmovq %rdx, %xmm2
; X64-AVX2-NEXT:    vpblendvb %xmm0, %xmm1, %xmm2, %xmm0
; X64-AVX2-NEXT:    vpsrlw $4, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; X64-AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX2-NEXT:    retq
;
; X86-AVX512-LABEL: produceShuffleVectorForByte:
; X86-AVX512:       # %bb.0: # %entry
; X86-AVX512-NEXT:    pushl %ebx
; X86-AVX512-NEXT:    pushl %edi
; X86-AVX512-NEXT:    pushl %esi
; X86-AVX512-NEXT:    vpbroadcastb {{[0-9]+}}(%esp), %xmm0
; X86-AVX512-NEXT:    vptestnmb {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %k1
; X86-AVX512-NEXT:    vmovdqu8 {{.*#+}} xmm0 {%k1} {z} = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X86-AVX512-NEXT:    vpextrd $1, %xmm0, %eax
; X86-AVX512-NEXT:    vmovd %xmm0, %edx
; X86-AVX512-NEXT:    movl $286331152, %ecx # imm = 0x11111110
; X86-AVX512-NEXT:    mulxl %ecx, %edi, %esi
; X86-AVX512-NEXT:    imull $286331153, %edx, %ebx # imm = 0x11111111
; X86-AVX512-NEXT:    addl %esi, %ebx
; X86-AVX512-NEXT:    imull $286331152, %eax, %esi # imm = 0x11111110
; X86-AVX512-NEXT:    addl %ebx, %esi
; X86-AVX512-NEXT:    vmovd %edi, %xmm0
; X86-AVX512-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; X86-AVX512-NEXT:    xorl $17895697, %eax # imm = 0x1111111
; X86-AVX512-NEXT:    xorl $286331153, %edx # imm = 0x11111111
; X86-AVX512-NEXT:    mulxl %ecx, %esi, %ecx
; X86-AVX512-NEXT:    imull $286331153, %edx, %edx # imm = 0x11111111
; X86-AVX512-NEXT:    addl %ecx, %edx
; X86-AVX512-NEXT:    imull $286331152, %eax, %eax # imm = 0x11111110
; X86-AVX512-NEXT:    addl %edx, %eax
; X86-AVX512-NEXT:    vmovd %esi, %xmm1
; X86-AVX512-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; X86-AVX512-NEXT:    vmovdqu8 %xmm0, %xmm1 {%k1}
; X86-AVX512-NEXT:    vpsrlw $4, %xmm1, %xmm0
; X86-AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X86-AVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512-NEXT:    popl %esi
; X86-AVX512-NEXT:    popl %edi
; X86-AVX512-NEXT:    popl %ebx
; X86-AVX512-NEXT:    retl
;
; X64-AVX512-LABEL: produceShuffleVectorForByte:
; X64-AVX512:       # %bb.0: # %entry
; X64-AVX512-NEXT:    vpbroadcastb %edi, %xmm0
; X64-AVX512-NEXT:    vptestnmb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %k1
; X64-AVX512-NEXT:    vmovdqu8 {{.*#+}} xmm0 {%k1} {z} = [17,17,17,17,17,17,17,17,u,u,u,u,u,u,u,u]
; X64-AVX512-NEXT:    vmovq %xmm0, %rax
; X64-AVX512-NEXT:    movabsq $1229782938247303440, %rcx # imm = 0x1111111111111110
; X64-AVX512-NEXT:    movabsq $76861433640456465, %rdx # imm = 0x111111111111111
; X64-AVX512-NEXT:    xorq %rax, %rdx
; X64-AVX512-NEXT:    imulq %rcx, %rax
; X64-AVX512-NEXT:    vmovq %rax, %xmm0
; X64-AVX512-NEXT:    imulq %rcx, %rdx
; X64-AVX512-NEXT:    vmovq %rdx, %xmm1
; X64-AVX512-NEXT:    vmovdqu8 %xmm0, %xmm1 {%k1}
; X64-AVX512-NEXT:    vpsrlw $4, %xmm1, %xmm0
; X64-AVX512-NEXT:    vpunpcklbw {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-AVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512-NEXT:    retq
entry:
  %const = bitcast i64 1229782938247303440 to i64
  %1 = insertelement <1 x i8> poison, i8 %0, i64 0
  %2 = shufflevector <1 x i8> %1, <1 x i8> poison, <8 x i32> zeroinitializer
  %3 = and <8 x i8> %2, <i8 1, i8 2, i8 4, i8 8, i8 16, i8 32, i8 64, i8 -128>
  %.not.not = icmp eq <8 x i8> %3, zeroinitializer
  %4 = select <8 x i1> %.not.not, <8 x i8> <i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17, i8 17>, <8 x i8> zeroinitializer
  %5 = bitcast <8 x i8> %4 to i64
  %6 = mul i64 %5, %const
  %7 = bitcast i64 %6 to <8 x i8>
  %8 = xor i64 %5, 76861433640456465
  %9 = mul i64 %8, %const
  %10 = bitcast i64 %9 to <8 x i8>
  %11 = select <8 x i1> %.not.not, <8 x i8> %7, <8 x i8> %10
  %12 = and <8 x i8> %11, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %13 = lshr <8 x i8> %11, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  %14 = shufflevector <8 x i8> %12, <8 x i8> %13, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  ret <16 x i8> %14
}
