; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=xtensa -verify-machineinstrs < %s \
; RUN: | FileCheck -check-prefix=XTENSA %s

define i32 @jump(i1 %a) {
; XTENSA-LABEL: jump:
; XTENSA:         movi a8, 1
; XTENSA-NEXT:    and a8, a2, a8
; XTENSA-NEXT:    beqz a8, .LBB0_2
; XTENSA-NEXT:  # %bb.1: # %iftrue
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    .space 1024
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    movi a2, 1
; XTENSA-NEXT:    ret
; XTENSA-NEXT:  .LBB0_2: # %jmp
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    movi a2, 1
; XTENSA-NEXT:    ret
  br i1 %a, label %iftrue, label %jmp

jmp:
  call void asm sideeffect "", ""()
  br label %tail

iftrue:
  call void asm sideeffect "", ""()
  br label %space

space:
  call void asm sideeffect ".space 1024", ""()
  br label %tail

tail:
  ret i32 1
}

define i32 @jx(i1 %a) {
; XTENSA-LABEL: jx:
; XTENSA:         addi a8, a1, -16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    .cfi_def_cfa_offset 16
; XTENSA-NEXT:    movi a8, 1
; XTENSA-NEXT:    and a8, a2, a8
; XTENSA-NEXT:    bnez a8, .LBB1_1
; XTENSA-NEXT:  # %bb.4:
; XTENSA-NEXT:    l32r a8, .LCPI1_0
; XTENSA-NEXT:    jx a8
; XTENSA-NEXT:  .LBB1_1: # %iftrue
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    .space 1048576
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    j .LBB1_3
; XTENSA-NEXT:  .LBB1_2: # %jmp
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:  .LBB1_3: # %tail
; XTENSA-NEXT:    movi a2, 1
; XTENSA-NEXT:    addi a8, a1, 16
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  br i1 %a, label %iftrue, label %jmp

jmp:
  call void asm sideeffect "", ""()
  br label %tail

iftrue:
  call void asm sideeffect "", ""()
  br label %space

space:
  call void asm sideeffect ".space 1048576", ""()
  br label %tail

tail:
  ret i32 1
}

define void @relax_spill() {
; XTENSA-LABEL: relax_spill:
; XTENSA:         addi a8, a1, -32
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    s32i a12, a1, 16 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a13, a1, 12 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a14, a1, 8 # 4-byte Folded Spill
; XTENSA-NEXT:    s32i a15, a1, 4 # 4-byte Folded Spill
; XTENSA-NEXT:    .cfi_offset a12, -4
; XTENSA-NEXT:    .cfi_offset a13, -8
; XTENSA-NEXT:    .cfi_offset a14, -12
; XTENSA-NEXT:    .cfi_offset a15, -16
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a2, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a3, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a4, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a5, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a6, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a7, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a8, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a9, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a10, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a11, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a12, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a13, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a14, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    addi a15, a3, 1
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    beq a5, a6, .LBB2_1
; XTENSA-NEXT:  # %bb.3:
; XTENSA-NEXT:    s32i a12, a1, 0
; XTENSA-NEXT:    l32r a12, .LCPI2_0
; XTENSA-NEXT:    jx a12
; XTENSA-NEXT:  .LBB2_1: # %iftrue
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    .space 536870912
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    j .LBB2_2
; XTENSA-NEXT:  .LBB2_4: # %iffalse
; XTENSA-NEXT:    l32i a12, a1, 0
; XTENSA-NEXT:  .LBB2_2: # %iffalse
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a2
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a3
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a4
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a5
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a6
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a7
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a8
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a9
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a10
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a11
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a12
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a13
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a14
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    #APP
; XTENSA-NEXT:    # reg use a15
; XTENSA-NEXT:    #NO_APP
; XTENSA-NEXT:    l32i a15, a1, 4 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a14, a1, 8 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a13, a1, 12 # 4-byte Folded Reload
; XTENSA-NEXT:    l32i a12, a1, 16 # 4-byte Folded Reload
; XTENSA-NEXT:    addi a8, a1, 32
; XTENSA-NEXT:    or a1, a8, a8
; XTENSA-NEXT:    ret
  call void asm sideeffect "", ""()
  %a2 = call i32 asm sideeffect "addi a2, a3, 1", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, a3, 1", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, a3, 1", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, a3, 1", "={a5}"()
  %a6 = call i32 asm sideeffect "addi a6, a3, 1", "={a6}"()
  %a7 = call i32 asm sideeffect "addi a7, a3, 1", "={a7}"()
  %a8 = call i32 asm sideeffect "addi a8, a3, 1", "={a8}"()
  %a9 = call i32 asm sideeffect "addi a9, a3, 1", "={a9}"()
  %a10 = call i32 asm sideeffect "addi a10, a3, 1", "={a10}"()
  %a11 = call i32 asm sideeffect "addi a11, a3, 1", "={a11}"()
  %a12 = call i32 asm sideeffect "addi a12, a3, 1", "={a12}"()
  %a13 = call i32 asm sideeffect "addi a13, a3, 1", "={a13}"()
  %a14 = call i32 asm sideeffect "addi a14, a3, 1", "={a14}"()
  %a15 = call i32 asm sideeffect "addi a15, a3, 1", "={a15}"()

  %cmp = icmp eq i32 %a5, %a6
  br i1 %cmp, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 536870912", ""()
  br label %iffalse

iffalse:
  call void asm sideeffect "", ""()
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i32 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i32 %a7)
  call void asm sideeffect "# reg use $0", "{a8}"(i32 %a8)
  call void asm sideeffect "# reg use $0", "{a9}"(i32 %a9)
  call void asm sideeffect "# reg use $0", "{a10}"(i32 %a10)
  call void asm sideeffect "# reg use $0", "{a11}"(i32 %a11)
  call void asm sideeffect "# reg use $0", "{a12}"(i32 %a12)
  call void asm sideeffect "# reg use $0", "{a13}"(i32 %a13)
  call void asm sideeffect "# reg use $0", "{a14}"(i32 %a14)
  call void asm sideeffect "# reg use $0", "{a15}"(i32 %a15)
  ret void
}
