# -*-ruby-*-
#
# Copyright (c) 2009 Kazuhiro NISHIYAMA
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#

=begin

== Abstract

send IDENTIFY to NickServ.

== Configuration

  BotConfig << {
    :name => :IdentifyNickServ,
    #:nickserv => "NickServ",
    :nick => "nadoka",
    :pass => "hoge",
  }

=end

class IdentifyNickServ < Nadoka::NDK_Bot
  def bot_initialize
    @nickserv = @bot_config.fetch(:nickserv, "NickServ")
    @nick = @bot_config.fetch(:nick, false)
    @pass  = @bot_config.fetch(:pass, false)
  end

  def on_server_connected(*args)
    if @pass
      if @nick
        send_privmsg @nickserv, "IDENTIFY #{@nick} #{@pass}"
      else
        send_privmsg @nickserv, "IDENTIFY #{@pass}"
      end
    end
  end
end
