#!/bin/sh
# Generated from niminst
# Template is in tools/niminst/buildsh.nimf
# To regenerate run ``niminst csource`` or ``koch csource``

set -e

while :
do
  case "$1" in
    --os)
      optos=$2
      shift 2
      ;;
    --cpu)
      optcpu=$2
      shift 2
      ;;
    --osname)
      optosname=$2
      shift 2
      ;;
    --parallel)
      parallel=$2
      shift 2
      ;;
    --extraBuildArgs)
      extraBuildArgs=" $2"
      shift 2
      ;;
    -h | --help)
      echo "Options:"
      echo "  --os <OS>"
      echo "  --cpu <CPU architecture>"
      echo "  --osname <name>           Additional OS specification (used for Android)"
      echo "  --extraBuildArgs <args>   Additional arguments passed to the compiler"
      echo "  --parallel <number>       Multiprocess build. Requires GNU parallel"
      exit 0
      ;;
    --) # End of all options
      shift
      break;
      ;;
    -*)
      echo 2>&1 "Error: Unknown option: $1" >&2
      exit 1
      ;;
    *)  # No more options
      break
      ;;
  esac
done

parallel="${parallel:-0}"
CC="${CC:-gcc}"
if [ "$parallel" -gt 1 ]; then
  if ! command -v sem > /dev/null; then
    echo "Error: GNU parallel is required to use --parallel"
    exit 1
  fi
  CC="sem -j $parallel --id $$ ${CC}"
fi
COMP_FLAGS="${CPPFLAGS:-} ${CFLAGS:-} -w -fmax-errors=3 -O3 -fno-strict-aliasing -fno-ident -fno-math-errno $extraBuildArgs"
LINK_FLAGS="${LDFLAGS:-} "
PS4=""
# platform detection
ucpu=`uname -m`
uos=`uname`
uosname=
# bin dir detection
binDir=bin

if [ -s ../koch.nim ]; then
  binDir="../bin"
fi

if [ ! -d $binDir ]; then
  mkdir $binDir
fi

# override OS, CPU and OS Name with command-line arguments
if [ -n "$optos" ]; then
  uos="$optos"
fi
if [ -n "$optcpu" ]; then
  ucpu="$optcpu"
fi
if [ -n "$optcpu" ]; then
  uosname="$optosname"
fi

# convert to lower case:
ucpu=`echo $ucpu | tr "[:upper:]" "[:lower:]"`
uos=`echo $uos | tr "[:upper:]" "[:lower:]"`
uosname=`echo $uosname | tr "[:upper:]" "[:lower:]"`

case $uos in
  *linux* )
    myos="linux"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    ;;
  *dragonfly* )
    myos="dragonfly"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *freebsd* )
    myos="freebsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *crossos* )
    myos="crossos"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *openbsd* )
    myos="openbsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *netbsd* )
    myos="netbsd"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ucpu=`uname -p`
    ;;
  *darwin* )
    myos="macosx"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    if [ "$HOSTTYPE" = "x86_64" ] ; then
      ucpu="amd64"
    fi
    ;;
  *aix* )
    myos="aix"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    ;;
  *solaris* | *sun* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    ;;
  *SunOS* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    isOpenIndiana="yes"
    ;;
  *haiku* )
    myos="haiku"
    LINK_FLAGS="$LINK_FLAGS -lroot -lnetwork"
    ;;
  *mingw* | *msys* )
    myos="windows"
    ;;
  *android* )
    myos="android"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    ;;
  *)
    echo 2>&1 "Error: unknown operating system: $uos"
    exit 1
    ;;
esac

case $ucpu in
  *i386* | *i486* | *i586* | *i686* | *bepc* | *i86pc* )
    if [ "$isOpenIndiana" = "yes" ] || [ `uname -o` == "illumos" ] ; then
      mycpu="amd64"
    else
      mycpu="i386"
    fi
    ;;
  *amd*64* | *x86-64* | *x86_64* )
    mycpu="amd64" ;;
  *sparc*|*sun* )
    mycpu="sparc"
    if [ "$myos" = "linux" ] ; then
      if [ "$(getconf LONG_BIT)" = "64" ]; then
        mycpu="sparc64"
      elif [ "$(isainfo -b)" = "64" ]; then
        mycpu="sparc64"
      fi
    fi
    ;;
  *ppc64le* )
    mycpu="powerpc64el" ;;
  *ppc64* )
    if [ "$myos" = "linux" ] ; then
      COMP_FLAGS="$COMP_FLAGS -m64"
      LINK_FLAGS="$LINK_FLAGS -m64"
    fi
    mycpu="powerpc64" ;;
  *power*|*ppc* )
    if [ "$myos" = "freebsd" ] ; then
      if [ "$ucpu" != "powerpc" ] ; then
        COMP_FLAGS="$COMP_FLAGS -m64"
        LINK_FLAGS="$LINK_FLAGS -m64"
      fi
      mycpu=`uname -p`
      case $mycpu in
        powerpc64le)
        mycpu="powerpc64el"
      esac
    else
      mycpu="powerpc"
    fi
    ;;
  *hppa*)
    mycpu="hppa" ;;
  *ia64*)
    mycpu="ia64" ;;
  *m68k*)
    mycpu="m68k" ;;
  *mips* )
    mycpu="$("$CC" -dumpmachine | sed 's/-.*//')"
    case $mycpu in
      mips|mipsel|mips64|mips64el)
        ;;
      *)
        echo 2>&1 "Error: unknown MIPS target: $mycpu"
        exit 1
    esac
    ;;
  *alpha* )
    mycpu="alpha" ;;
  *aarch64*|*arm64* )
    mycpu="arm64" ;;
  *arm*|*armv6l*|*armv7l*|*armv8l* )
    mycpu="arm" ;;
  *riscv64|riscv* )
    mycpu="riscv64" ;;
  *e2k* )
    mycpu="e2k" ;;
  *loongarch64* )
    mycpu="loongarch64" ;;
  *)
    echo 2>&1 "Error: unknown processor: $ucpu"
    exit 1
    ;;
esac

case $uosname in
  *android* )
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    myosname="android"
    myos="android"
    ;;
esac

# call the compiler:
echo \# OS:  $myos
echo \# CPU: $mycpu

case $myos in
windows)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@sexceptions.nim.c -o c_code/1_1/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/1_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem.nim.c -o c_code/1_1/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sparseutils.nim.c -o c_code/1_1/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@smath.nim.c -o c_code/1_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@salgorithm.nim.c -o c_code/1_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sunicode.nim.c -o c_code/1_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sstrutils.nim.c -o c_code/1_1/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sntpath.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sntpath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@spathnorm.nim.c -o c_code/1_1/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sdynlib.nim.c -o c_code/1_1/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@swidestrs.nim.c -o c_code/1_1/@m..@slib@sstd@swidestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sexitprocs.nim.c -o c_code/1_1/@m..@slib@sstd@sexitprocs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@ssyncio.nim.c -o c_code/1_1/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@swindows@swinlean.nim.c -o c_code/1_1/@m..@slib@swindows@swinlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@soserrors.nim.c -o c_code/1_1/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@stimes.nim.c -o c_code/1_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@swin_setenv.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@swin_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senvvars.nim.c -o c_code/1_1/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@scmdline.nim.c -o c_code/1_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sos.nim.c -o c_code/1_1/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sparseopt.nim.c -o c_code/1_1/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@shashes.nim.c -o c_code/1_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sstrtabs.nim.c -o c_code/1_1/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@stables.nim.c -o c_code/1_1/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sstrformat.nim.c -o c_code/1_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sterminal.nim.c -o c_code/1_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpathutils.nim.c -o c_code/1_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mropes.nim.c -o c_code/1_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlineinfos.nim.c -o c_code/1_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplatform.nim.c -o c_code/1_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimpaths.nim.c -o c_code/1_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptions.nim.c -o c_code/1_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmsgs.nim.c -o c_code/1_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@midents.nim.c -o c_code/1_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mint128.nim.c -o c_code/1_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mast.nim.c -o c_code/1_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mllstream.nim.c -o c_code/1_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlexer.nim.c -o c_code/1_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderer.nim.c -o c_code/1_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulepaths.nim.c -o c_code/1_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sstreams.nim.c -o c_code/1_1/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/1_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sosproc.nim.c -o c_code/1_1/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sparsejson.nim.c -o c_code/1_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sjson.nim.c -o c_code/1_1/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/1_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mextccomp.nim.c -o c_code/1_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimblecmd.nim.c -o c_code/1_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcommands.nim.c -o c_code/1_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparser.nim.c -o c_code/1_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilters.nim.c -o c_code/1_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilter_tmpl.nim.c -o c_code/1_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msyntaxes.nim.c -o c_code/1_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrodutils.nim.c -o c_code/1_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/1_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastyaml.nim.c -o c_code/1_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastalgo.nim.c -o c_code/1_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbtrees.nim.c -o c_code/1_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpackages.nim.c -o c_code/1_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msuggestsymdb.nim.c -o c_code/1_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@srodfiles.nim.c -o c_code/1_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sic.nim.c -o c_code/1_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulegraphs.nim.c -o c_code/1_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmagicsys.nim.c -o c_code/1_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypes.nim.c -o c_code/1_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimsets.nim.c -o c_code/1_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mndi.nim.c -o c_code/1_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgendata.nim.c -o c_code/1_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmangleutils.nim.c -o c_code/1_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msaturate.nim.c -o c_code/1_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mguards.nim.c -o c_code/1_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemfold.nim.c -o c_code/1_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdef.nim.c -o c_code/1_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemdata.nim.c -o c_code/1_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvarpartitions.nim.c -o c_code/1_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnilcheck.nim.c -o c_code/1_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/1_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/1_1/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlookups.nim.c -o c_code/1_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlinter.nim.c -o c_code/1_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemtypinst.nim.c -o c_code/1_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparampatterns.nim.c -o c_code/1_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlowerings.nim.c -o c_code/1_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mconcepts.nim.c -o c_code/1_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msigmatch.nim.c -o c_code/1_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpragmas.nim.c -o c_code/1_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msighashes.nim.c -o c_code/1_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftdestructors.nim.c -o c_code/1_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msempass2.nim.c -o c_code/1_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgmeth.nim.c -o c_code/1_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftlocals.nim.c -o c_code/1_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlambdalifting.nim.c -o c_code/1_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mclosureiters.nim.c -o c_code/1_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtransf.nim.c -o c_code/1_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptimizer.nim.c -o c_code/1_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdfa.nim.c -o c_code/1_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@minjectdestructors.nim.c -o c_code/1_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpipelineutils.nim.c -o c_code/1_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mspawn.nim.c -o c_code/1_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemparallel.nim.c -o c_code/1_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgen.nim.c -o c_code/1_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodules.nim.c -o c_code/1_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemmacrosanity.nim.c -o c_code/1_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmgen.nim.c -o c_code/1_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdeps.nim.c -o c_code/1_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mgorgeimpl.nim.c -o c_code/1_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmprofiler.nim.c -o c_code/1_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mevaltempl.nim.c -o c_code/1_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmmarshal.nim.c -o c_code/1_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvm.nim.c -o c_code/1_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mimporter.nim.c -o c_code/1_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprocfind.nim.c -o c_code/1_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpatterns.nim.c -o c_code/1_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sitersgen.nim.c -o c_code/1_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvtables.nim.c -o c_code/1_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msem.nim.c -o c_code/1_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mreorder.nim.c -o c_code/1_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdepends.nim.c -o c_code/1_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msourcemap.nim.c -o c_code/1_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mjsgen.nim.c -o c_code/1_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/1_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypesrenderer.nim.c -o c_code/1_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderverbatim.nim.c -o c_code/1_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@suri.nim.c -o c_code/1_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen.nim.c -o c_code/1_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen2.nim.c -o c_code/1_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sreplayer.nim.c -o c_code/1_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpipelines.nim.c -o c_code/1_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mscriptconfig.nim.c -o c_code/1_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimconf.nim.c -o c_code/1_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sdce.nim.c -o c_code/1_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@scbackend.nim.c -o c_code/1_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sintegrity.nim.c -o c_code/1_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@snavigator.nim.c -o c_code/1_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmain.nim.c -o c_code/1_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcmdlinehelper.nim.c -o c_code/1_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sbrowsers.nim.c -o c_code/1_1/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnim.nim.c -o c_code/1_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/1_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/1_1/@m..@slib@ssystem.nim.o \
c_code/1_1/@m..@slib@spure@sparseutils.nim.o \
c_code/1_1/@m..@slib@spure@smath.nim.o \
c_code/1_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/1_1/@m..@slib@spure@sunicode.nim.o \
c_code/1_1/@m..@slib@spure@sstrutils.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sntpath.nim.o \
c_code/1_1/@m..@slib@spure@spathnorm.nim.o \
c_code/1_1/@m..@slib@spure@sdynlib.nim.o \
c_code/1_1/@m..@slib@sstd@swidestrs.nim.o \
c_code/1_1/@m..@slib@sstd@sexitprocs.nim.o \
c_code/1_1/@m..@slib@sstd@ssyncio.nim.o \
c_code/1_1/@m..@slib@swindows@swinlean.nim.o \
c_code/1_1/@m..@slib@sstd@soserrors.nim.o \
c_code/1_1/@m..@slib@spure@stimes.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@swin_setenv.nim.o \
c_code/1_1/@m..@slib@sstd@senvvars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/1_1/@m..@slib@sstd@scmdline.nim.o \
c_code/1_1/@m..@slib@spure@sos.nim.o \
c_code/1_1/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/1_1/@m..@slib@spure@shashes.nim.o \
c_code/1_1/@m..@slib@spure@sstrtabs.nim.o \
c_code/1_1/@m..@slib@spure@scollections@stables.nim.o \
c_code/1_1/@m..@slib@spure@sstrformat.nim.o \
c_code/1_1/@m..@slib@spure@sterminal.nim.o \
c_code/1_1/@mpathutils.nim.o \
c_code/1_1/@mropes.nim.o \
c_code/1_1/@mlineinfos.nim.o \
c_code/1_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/1_1/@mnimpaths.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/1_1/@moptions.nim.o \
c_code/1_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/1_1/@midents.nim.o \
c_code/1_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/1_1/@mast.nim.o \
c_code/1_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/1_1/@mlexer.nim.o \
c_code/1_1/@mrenderer.nim.o \
c_code/1_1/@mmodulepaths.nim.o \
c_code/1_1/@m..@slib@spure@sstreams.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.o \
c_code/1_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/1_1/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/1_1/@m..@slib@spure@sparsejson.nim.o \
c_code/1_1/@m..@slib@spure@sjson.nim.o \
c_code/1_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/1_1/@mextccomp.nim.o \
c_code/1_1/@mnimblecmd.nim.o \
c_code/1_1/@mcommands.nim.o \
c_code/1_1/@mparser.nim.o \
c_code/1_1/@mfilters.nim.o \
c_code/1_1/@mfilter_tmpl.nim.o \
c_code/1_1/@msyntaxes.nim.o \
c_code/1_1/@mrodutils.nim.o \
c_code/1_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/1_1/@mastyaml.nim.o \
c_code/1_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/1_1/@mbtrees.nim.o \
c_code/1_1/@mpackages.nim.o \
c_code/1_1/@msuggestsymdb.nim.o \
c_code/1_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/1_1/@mic@sic.nim.o \
c_code/1_1/@mmodulegraphs.nim.o \
c_code/1_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/1_1/@mtypes.nim.o \
c_code/1_1/@mnimsets.nim.o \
c_code/1_1/@mndi.nim.o \
c_code/1_1/@mcgendata.nim.o \
c_code/1_1/@mmangleutils.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/1_1/@msaturate.nim.o \
c_code/1_1/@mguards.nim.o \
c_code/1_1/@msemfold.nim.o \
c_code/1_1/@mvmdef.nim.o \
c_code/1_1/@msemdata.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/1_1/@mvarpartitions.nim.o \
c_code/1_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/1_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/1_1/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/1_1/@mlookups.nim.o \
c_code/1_1/@mlinter.nim.o \
c_code/1_1/@msemtypinst.nim.o \
c_code/1_1/@mparampatterns.nim.o \
c_code/1_1/@mlowerings.nim.o \
c_code/1_1/@mconcepts.nim.o \
c_code/1_1/@msigmatch.nim.o \
c_code/1_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/1_1/@msighashes.nim.o \
c_code/1_1/@mliftdestructors.nim.o \
c_code/1_1/@msempass2.nim.o \
c_code/1_1/@mcgmeth.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/1_1/@mliftlocals.nim.o \
c_code/1_1/@mlambdalifting.nim.o \
c_code/1_1/@mclosureiters.nim.o \
c_code/1_1/@mtransf.nim.o \
c_code/1_1/@moptimizer.nim.o \
c_code/1_1/@mdfa.nim.o \
c_code/1_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/1_1/@mpipelineutils.nim.o \
c_code/1_1/@mspawn.nim.o \
c_code/1_1/@msemparallel.nim.o \
c_code/1_1/@mcgen.nim.o \
c_code/1_1/@mmodules.nim.o \
c_code/1_1/@msemmacrosanity.nim.o \
c_code/1_1/@mvmgen.nim.o \
c_code/1_1/@mvmdeps.nim.o \
c_code/1_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/1_1/@mvmprofiler.nim.o \
c_code/1_1/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/1_1/@mvmmarshal.nim.o \
c_code/1_1/@mvm.nim.o \
c_code/1_1/@mimporter.nim.o \
c_code/1_1/@mprocfind.nim.o \
c_code/1_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/1_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/1_1/@mvtables.nim.o \
c_code/1_1/@msem.nim.o \
c_code/1_1/@mreorder.nim.o \
c_code/1_1/@mdepends.nim.o \
c_code/1_1/@msourcemap.nim.o \
c_code/1_1/@mjsgen.nim.o \
c_code/1_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/1_1/@mtypesrenderer.nim.o \
c_code/1_1/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/1_1/@m..@slib@spure@suri.nim.o \
c_code/1_1/@mdocgen.nim.o \
c_code/1_1/@mdocgen2.nim.o \
c_code/1_1/@mic@sreplayer.nim.o \
c_code/1_1/@mpipelines.nim.o \
c_code/1_1/@mscriptconfig.nim.o \
c_code/1_1/@mnimconf.nim.o \
c_code/1_1/@mic@sdce.nim.o \
c_code/1_1/@mic@scbackend.nim.o \
c_code/1_1/@mic@sintegrity.nim.o \
c_code/1_1/@mic@snavigator.nim.o \
c_code/1_1/@mmain.nim.o \
c_code/1_1/@mcmdlinehelper.nim.o \
c_code/1_1/@m..@slib@spure@sbrowsers.nim.o \
c_code/1_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@sexceptions.nim.c -o c_code/1_2/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/1_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem.nim.c -o c_code/1_2/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sparseutils.nim.c -o c_code/1_2/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@smath.nim.c -o c_code/1_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@salgorithm.nim.c -o c_code/1_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sunicode.nim.c -o c_code/1_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sstrutils.nim.c -o c_code/1_2/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sntpath.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sntpath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@spathnorm.nim.c -o c_code/1_2/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sdynlib.nim.c -o c_code/1_2/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@swidestrs.nim.c -o c_code/1_2/@m..@slib@sstd@swidestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sexitprocs.nim.c -o c_code/1_2/@m..@slib@sstd@sexitprocs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@ssyncio.nim.c -o c_code/1_2/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@swindows@swinlean.nim.c -o c_code/1_2/@m..@slib@swindows@swinlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@soserrors.nim.c -o c_code/1_2/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@stimes.nim.c -o c_code/1_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@swin_setenv.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@swin_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senvvars.nim.c -o c_code/1_2/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@scmdline.nim.c -o c_code/1_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sos.nim.c -o c_code/1_2/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sparseopt.nim.c -o c_code/1_2/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@shashes.nim.c -o c_code/1_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sstrtabs.nim.c -o c_code/1_2/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/1_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sstrformat.nim.c -o c_code/1_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sterminal.nim.c -o c_code/1_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpathutils.nim.c -o c_code/1_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mropes.nim.c -o c_code/1_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlineinfos.nim.c -o c_code/1_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplatform.nim.c -o c_code/1_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimpaths.nim.c -o c_code/1_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptions.nim.c -o c_code/1_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmsgs.nim.c -o c_code/1_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@midents.nim.c -o c_code/1_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mint128.nim.c -o c_code/1_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mast.nim.c -o c_code/1_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mllstream.nim.c -o c_code/1_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlexer.nim.c -o c_code/1_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderer.nim.c -o c_code/1_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulepaths.nim.c -o c_code/1_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sstreams.nim.c -o c_code/1_2/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/1_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sosproc.nim.c -o c_code/1_2/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sparsejson.nim.c -o c_code/1_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sjson.nim.c -o c_code/1_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/1_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mextccomp.nim.c -o c_code/1_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimblecmd.nim.c -o c_code/1_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcommands.nim.c -o c_code/1_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparser.nim.c -o c_code/1_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilters.nim.c -o c_code/1_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilter_tmpl.nim.c -o c_code/1_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msyntaxes.nim.c -o c_code/1_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrodutils.nim.c -o c_code/1_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/1_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastyaml.nim.c -o c_code/1_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastalgo.nim.c -o c_code/1_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbtrees.nim.c -o c_code/1_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpackages.nim.c -o c_code/1_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msuggestsymdb.nim.c -o c_code/1_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@srodfiles.nim.c -o c_code/1_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sic.nim.c -o c_code/1_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulegraphs.nim.c -o c_code/1_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmagicsys.nim.c -o c_code/1_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypes.nim.c -o c_code/1_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimsets.nim.c -o c_code/1_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mndi.nim.c -o c_code/1_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgendata.nim.c -o c_code/1_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmangleutils.nim.c -o c_code/1_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msaturate.nim.c -o c_code/1_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mguards.nim.c -o c_code/1_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemfold.nim.c -o c_code/1_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdef.nim.c -o c_code/1_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemdata.nim.c -o c_code/1_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvarpartitions.nim.c -o c_code/1_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnilcheck.nim.c -o c_code/1_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/1_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/1_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlookups.nim.c -o c_code/1_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlinter.nim.c -o c_code/1_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemtypinst.nim.c -o c_code/1_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparampatterns.nim.c -o c_code/1_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlowerings.nim.c -o c_code/1_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mconcepts.nim.c -o c_code/1_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msigmatch.nim.c -o c_code/1_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpragmas.nim.c -o c_code/1_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msighashes.nim.c -o c_code/1_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftdestructors.nim.c -o c_code/1_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msempass2.nim.c -o c_code/1_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgmeth.nim.c -o c_code/1_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftlocals.nim.c -o c_code/1_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlambdalifting.nim.c -o c_code/1_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mclosureiters.nim.c -o c_code/1_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtransf.nim.c -o c_code/1_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptimizer.nim.c -o c_code/1_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdfa.nim.c -o c_code/1_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@minjectdestructors.nim.c -o c_code/1_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpipelineutils.nim.c -o c_code/1_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mspawn.nim.c -o c_code/1_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemparallel.nim.c -o c_code/1_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgen.nim.c -o c_code/1_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodules.nim.c -o c_code/1_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemmacrosanity.nim.c -o c_code/1_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmgen.nim.c -o c_code/1_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdeps.nim.c -o c_code/1_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mgorgeimpl.nim.c -o c_code/1_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmprofiler.nim.c -o c_code/1_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mevaltempl.nim.c -o c_code/1_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmmarshal.nim.c -o c_code/1_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvm.nim.c -o c_code/1_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mimporter.nim.c -o c_code/1_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprocfind.nim.c -o c_code/1_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpatterns.nim.c -o c_code/1_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sitersgen.nim.c -o c_code/1_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvtables.nim.c -o c_code/1_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msem.nim.c -o c_code/1_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mreorder.nim.c -o c_code/1_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdepends.nim.c -o c_code/1_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msourcemap.nim.c -o c_code/1_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mjsgen.nim.c -o c_code/1_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/1_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypesrenderer.nim.c -o c_code/1_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderverbatim.nim.c -o c_code/1_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@suri.nim.c -o c_code/1_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen.nim.c -o c_code/1_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen2.nim.c -o c_code/1_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sreplayer.nim.c -o c_code/1_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpipelines.nim.c -o c_code/1_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mscriptconfig.nim.c -o c_code/1_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimconf.nim.c -o c_code/1_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sdce.nim.c -o c_code/1_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@scbackend.nim.c -o c_code/1_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sintegrity.nim.c -o c_code/1_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@snavigator.nim.c -o c_code/1_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmain.nim.c -o c_code/1_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcmdlinehelper.nim.c -o c_code/1_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/1_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnim.nim.c -o c_code/1_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/1_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/1_2/@m..@slib@ssystem.nim.o \
c_code/1_2/@m..@slib@spure@sparseutils.nim.o \
c_code/1_2/@m..@slib@spure@smath.nim.o \
c_code/1_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/1_2/@m..@slib@spure@sunicode.nim.o \
c_code/1_2/@m..@slib@spure@sstrutils.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sntpath.nim.o \
c_code/1_2/@m..@slib@spure@spathnorm.nim.o \
c_code/1_2/@m..@slib@spure@sdynlib.nim.o \
c_code/1_2/@m..@slib@sstd@swidestrs.nim.o \
c_code/1_2/@m..@slib@sstd@sexitprocs.nim.o \
c_code/1_2/@m..@slib@sstd@ssyncio.nim.o \
c_code/1_2/@m..@slib@swindows@swinlean.nim.o \
c_code/1_2/@m..@slib@sstd@soserrors.nim.o \
c_code/1_2/@m..@slib@spure@stimes.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@swin_setenv.nim.o \
c_code/1_2/@m..@slib@sstd@senvvars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/1_2/@m..@slib@sstd@scmdline.nim.o \
c_code/1_2/@m..@slib@spure@sos.nim.o \
c_code/1_2/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/1_2/@m..@slib@spure@shashes.nim.o \
c_code/1_2/@m..@slib@spure@sstrtabs.nim.o \
c_code/1_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/1_2/@m..@slib@spure@sstrformat.nim.o \
c_code/1_2/@m..@slib@spure@sterminal.nim.o \
c_code/1_2/@mpathutils.nim.o \
c_code/1_2/@mropes.nim.o \
c_code/1_2/@mlineinfos.nim.o \
c_code/1_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/1_2/@mnimpaths.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/1_2/@moptions.nim.o \
c_code/1_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/1_2/@midents.nim.o \
c_code/1_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/1_2/@mast.nim.o \
c_code/1_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/1_2/@mlexer.nim.o \
c_code/1_2/@mrenderer.nim.o \
c_code/1_2/@mmodulepaths.nim.o \
c_code/1_2/@m..@slib@spure@sstreams.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@swin_getsysteminfo.nim.o \
c_code/1_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/1_2/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/1_2/@m..@slib@spure@sparsejson.nim.o \
c_code/1_2/@m..@slib@spure@sjson.nim.o \
c_code/1_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/1_2/@mextccomp.nim.o \
c_code/1_2/@mnimblecmd.nim.o \
c_code/1_2/@mcommands.nim.o \
c_code/1_2/@mparser.nim.o \
c_code/1_2/@mfilters.nim.o \
c_code/1_2/@mfilter_tmpl.nim.o \
c_code/1_2/@msyntaxes.nim.o \
c_code/1_2/@mrodutils.nim.o \
c_code/1_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/1_2/@mastyaml.nim.o \
c_code/1_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/1_2/@mbtrees.nim.o \
c_code/1_2/@mpackages.nim.o \
c_code/1_2/@msuggestsymdb.nim.o \
c_code/1_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/1_2/@mic@sic.nim.o \
c_code/1_2/@mmodulegraphs.nim.o \
c_code/1_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/1_2/@mtypes.nim.o \
c_code/1_2/@mnimsets.nim.o \
c_code/1_2/@mndi.nim.o \
c_code/1_2/@mcgendata.nim.o \
c_code/1_2/@mmangleutils.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/1_2/@msaturate.nim.o \
c_code/1_2/@mguards.nim.o \
c_code/1_2/@msemfold.nim.o \
c_code/1_2/@mvmdef.nim.o \
c_code/1_2/@msemdata.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/1_2/@mvarpartitions.nim.o \
c_code/1_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/1_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/1_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/1_2/@mlookups.nim.o \
c_code/1_2/@mlinter.nim.o \
c_code/1_2/@msemtypinst.nim.o \
c_code/1_2/@mparampatterns.nim.o \
c_code/1_2/@mlowerings.nim.o \
c_code/1_2/@mconcepts.nim.o \
c_code/1_2/@msigmatch.nim.o \
c_code/1_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/1_2/@msighashes.nim.o \
c_code/1_2/@mliftdestructors.nim.o \
c_code/1_2/@msempass2.nim.o \
c_code/1_2/@mcgmeth.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/1_2/@mliftlocals.nim.o \
c_code/1_2/@mlambdalifting.nim.o \
c_code/1_2/@mclosureiters.nim.o \
c_code/1_2/@mtransf.nim.o \
c_code/1_2/@moptimizer.nim.o \
c_code/1_2/@mdfa.nim.o \
c_code/1_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/1_2/@mpipelineutils.nim.o \
c_code/1_2/@mspawn.nim.o \
c_code/1_2/@msemparallel.nim.o \
c_code/1_2/@mcgen.nim.o \
c_code/1_2/@mmodules.nim.o \
c_code/1_2/@msemmacrosanity.nim.o \
c_code/1_2/@mvmgen.nim.o \
c_code/1_2/@mvmdeps.nim.o \
c_code/1_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/1_2/@mvmprofiler.nim.o \
c_code/1_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/1_2/@mvmmarshal.nim.o \
c_code/1_2/@mvm.nim.o \
c_code/1_2/@mimporter.nim.o \
c_code/1_2/@mprocfind.nim.o \
c_code/1_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/1_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/1_2/@mvtables.nim.o \
c_code/1_2/@msem.nim.o \
c_code/1_2/@mreorder.nim.o \
c_code/1_2/@mdepends.nim.o \
c_code/1_2/@msourcemap.nim.o \
c_code/1_2/@mjsgen.nim.o \
c_code/1_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/1_2/@mtypesrenderer.nim.o \
c_code/1_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/1_2/@m..@slib@spure@suri.nim.o \
c_code/1_2/@mdocgen.nim.o \
c_code/1_2/@mdocgen2.nim.o \
c_code/1_2/@mic@sreplayer.nim.o \
c_code/1_2/@mpipelines.nim.o \
c_code/1_2/@mscriptconfig.nim.o \
c_code/1_2/@mnimconf.nim.o \
c_code/1_2/@mic@sdce.nim.o \
c_code/1_2/@mic@scbackend.nim.o \
c_code/1_2/@mic@sintegrity.nim.o \
c_code/1_2/@mic@snavigator.nim.o \
c_code/1_2/@mmain.nim.o \
c_code/1_2/@mcmdlinehelper.nim.o \
c_code/1_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/1_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
linux)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_1/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem.nim.c -o c_code/2_1/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparseutils.nim.c -o c_code/2_1/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrutils.nim.c -o c_code/2_1/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@spathnorm.nim.c -o c_code/2_1/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@soserrors.nim.c -o c_code/2_1/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_1/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@senvvars.nim.c -o c_code/2_1/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sos.nim.c -o c_code/2_1/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparseopt.nim.c -o c_code/2_1/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_1/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_1/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplatform.nim.c -o c_code/2_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptions.nim.c -o c_code/2_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmsgs.nim.c -o c_code/2_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mllstream.nim.c -o c_code/2_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlexer.nim.c -o c_code/2_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstreams.nim.c -o c_code/2_1/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sosproc.nim.c -o c_code/2_1/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sjson.nim.c -o c_code/2_1/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mextccomp.nim.c -o c_code/2_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimblecmd.nim.c -o c_code/2_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcommands.nim.c -o c_code/2_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mbtrees.nim.c -o c_code/2_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msigmatch.nim.c -o c_code/2_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpragmas.nim.c -o c_code/2_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sdynlib.nim.c -o c_code/2_1/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgen.nim.c -o c_code/2_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mgorgeimpl.nim.c -o c_code/2_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvm.nim.c -o c_code/2_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msem.nim.c -o c_code/2_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen.nim.c -o c_code/2_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen2.nim.c -o c_code/2_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mscriptconfig.nim.c -o c_code/2_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_1/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_1/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_1/@m..@slib@ssystem.nim.o \
c_code/2_1/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_1/@m..@slib@spure@sstrutils.nim.o \
c_code/2_1/@m..@slib@spure@spathnorm.nim.o \
c_code/2_1/@m..@slib@sstd@soserrors.nim.o \
c_code/2_1/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_1/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_1/@m..@slib@spure@sos.nim.o \
c_code/2_1/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_1/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_1/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_1/@moptions.nim.o \
c_code/2_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_1/@mast.nim.o \
c_code/2_1/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_1/@mlexer.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_1/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_1/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_1/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_1/@mextccomp.nim.o \
c_code/2_1/@mnimblecmd.nim.o \
c_code/2_1/@mcommands.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_1/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msigmatch.nim.o \
c_code/2_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/@m..@slib@spure@sdynlib.nim.o \
c_code/2_1/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_1/@mvm.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_1/@msem.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_1/@mdocgen.nim.o \
c_code/2_1/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_1/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_2/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem.nim.c -o c_code/2_2/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparseutils.nim.c -o c_code/2_2/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@salgorithm.nim.c -o c_code/2_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrutils.nim.c -o c_code/2_2/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@spathnorm.nim.c -o c_code/2_2/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@soserrors.nim.c -o c_code/2_2/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_2/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sposix@sposix.nim.c -o c_code/2_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@stimes.nim.c -o c_code/2_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@senvvars.nim.c -o c_code/2_2/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sos.nim.c -o c_code/2_2/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparseopt.nim.c -o c_code/2_2/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_2/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mropes.nim.c -o c_code/2_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplatform.nim.c -o c_code/2_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptions.nim.c -o c_code/2_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmsgs.nim.c -o c_code/2_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mllstream.nim.c -o c_code/2_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlexer.nim.c -o c_code/2_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderer.nim.c -o c_code/2_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstreams.nim.c -o c_code/2_2/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_2/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sosproc.nim.c -o c_code/2_2/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mextccomp.nim.c -o c_code/2_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimblecmd.nim.c -o c_code/2_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcommands.nim.c -o c_code/2_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msyntaxes.nim.c -o c_code/2_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@srodfiles.nim.c -o c_code/2_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sic.nim.c -o c_code/2_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mndi.nim.c -o c_code/2_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msigmatch.nim.c -o c_code/2_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpragmas.nim.c -o c_code/2_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sdynlib.nim.c -o c_code/2_2/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgen.nim.c -o c_code/2_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdeps.nim.c -o c_code/2_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mgorgeimpl.nim.c -o c_code/2_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvm.nim.c -o c_code/2_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msem.nim.c -o c_code/2_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mjsgen.nim.c -o c_code/2_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen.nim.c -o c_code/2_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mscriptconfig.nim.c -o c_code/2_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmain.nim.c -o c_code/2_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnim.nim.c -o c_code/2_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_2/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_2/@m..@slib@ssystem.nim.o \
c_code/2_2/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_2/@m..@slib@spure@sstrutils.nim.o \
c_code/2_2/@m..@slib@spure@spathnorm.nim.o \
c_code/2_2/@m..@slib@sstd@soserrors.nim.o \
c_code/2_2/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_2/@m..@slib@sposix@sposix.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_2/@m..@slib@spure@stimes.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_2/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_2/@m..@slib@spure@sos.nim.o \
c_code/2_2/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_2/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_2/@moptions.nim.o \
c_code/2_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_2/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_2/@mlexer.nim.o \
c_code/2_2/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_2/@m..@slib@spure@sstreams.nim.o \
c_code/2_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_2/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_2/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_2/@mextccomp.nim.o \
c_code/2_2/@mnimblecmd.nim.o \
c_code/2_2/@mcommands.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/2_2/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msigmatch.nim.o \
c_code/2_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/@m..@slib@spure@sdynlib.nim.o \
c_code/2_2/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_2/@mvmdeps.nim.o \
c_code/2_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_2/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_2/@msem.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/2_2/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_2/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplatform.nim.c -o c_code/2_3/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_3/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  ia64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplatform.nim.c -o c_code/2_4/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_4/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  alpha)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_5/@mplatform.nim.c -o c_code/2_5/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_5/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mplatform.nim.c -o c_code/2_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_7/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sassertions.nim.c -o c_code/2_7/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@ssystem@siterators.nim.c -o c_code/2_7/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_7/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sformatfloat.nim.c -o c_code/2_7/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@ssystem.nim.c -o c_code/2_7/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sparseutils.nim.c -o c_code/2_7/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@smath.nim.c -o c_code/2_7/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@salgorithm.nim.c -o c_code/2_7/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@senumutils.nim.c -o c_code/2_7/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sunicode.nim.c -o c_code/2_7/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sstrutils.nim.c -o c_code/2_7/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@spathnorm.nim.c -o c_code/2_7/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@soserrors.nim.c -o c_code/2_7/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_7/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@stimes.nim.c -o c_code/2_7/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@senvvars.nim.c -o c_code/2_7/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@scmdline.nim.c -o c_code/2_7/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sos.nim.c -o c_code/2_7/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sparseopt.nim.c -o c_code/2_7/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@shashes.nim.c -o c_code/2_7/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_7/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_7/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sstrformat.nim.c -o c_code/2_7/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sterminal.nim.c -o c_code/2_7/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpathutils.nim.c -o c_code/2_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mropes.nim.c -o c_code/2_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlineinfos.nim.c -o c_code/2_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplatform.nim.c -o c_code/2_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprefixmatches.nim.c -o c_code/2_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimpaths.nim.c -o c_code/2_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_7/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptions.nim.c -o c_code/2_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmsgs.nim.c -o c_code/2_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcondsyms.nim.c -o c_code/2_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mwordrecg.nim.c -o c_code/2_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@midents.nim.c -o c_code/2_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mint128.nim.c -o c_code/2_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnodekinds.nim.c -o c_code/2_7/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mast.nim.c -o c_code/2_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mllstream.nim.c -o c_code/2_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimlexbase.nim.c -o c_code/2_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlexer.nim.c -o c_code/2_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderer.nim.c -o c_code/2_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulepaths.nim.c -o c_code/2_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sstreams.nim.c -o c_code/2_7/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_7/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_7/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sosproc.nim.c -o c_code/2_7/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@slexbase.nim.c -o c_code/2_7/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sparsejson.nim.c -o c_code/2_7/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sjson.nim.c -o c_code/2_7/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_7/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mextccomp.nim.c -o c_code/2_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimblecmd.nim.c -o c_code/2_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcommands.nim.c -o c_code/2_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparser.nim.c -o c_code/2_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilters.nim.c -o c_code/2_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilter_tmpl.nim.c -o c_code/2_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msyntaxes.nim.c -o c_code/2_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrodutils.nim.c -o c_code/2_7/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_7/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastyaml.nim.c -o c_code/2_7/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastalgo.nim.c -o c_code/2_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtrees.nim.c -o c_code/2_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbtrees.nim.c -o c_code/2_7/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpackages.nim.c -o c_code/2_7/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msuggestsymdb.nim.c -o c_code/2_7/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@srodfiles.nim.c -o c_code/2_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sbitabs.nim.c -o c_code/2_7/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@siclineinfos.nim.c -o c_code/2_7/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@spacked_ast.nim.c -o c_code/2_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sic.nim.c -o c_code/2_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulegraphs.nim.c -o c_code/2_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmagicsys.nim.c -o c_code/2_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastmsgs.nim.c -o c_code/2_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypes.nim.c -o c_code/2_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimsets.nim.c -o c_code/2_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mndi.nim.c -o c_code/2_7/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgendata.nim.c -o c_code/2_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmangleutils.nim.c -o c_code/2_7/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mccgutils.nim.c -o c_code/2_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtreetab.nim.c -o c_code/2_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msaturate.nim.c -o c_code/2_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mguards.nim.c -o c_code/2_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemfold.nim.c -o c_code/2_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdef.nim.c -o c_code/2_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemdata.nim.c -o c_code/2_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypeallowed.nim.c -o c_code/2_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@misolation_check.nim.c -o c_code/2_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvarpartitions.nim.c -o c_code/2_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnilcheck.nim.c -o c_code/2_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@merrorhandling.nim.c -o c_code/2_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliasanalysis.nim.c -o c_code/2_7/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemstrictfuncs.nim.c -o c_code/2_7/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_7/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_7/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlookups.nim.c -o c_code/2_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlinter.nim.c -o c_code/2_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemtypinst.nim.c -o c_code/2_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparampatterns.nim.c -o c_code/2_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlowerings.nim.c -o c_code/2_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mconcepts.nim.c -o c_code/2_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msigmatch.nim.c -o c_code/2_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpragmas.nim.c -o c_code/2_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpushpoppragmas.nim.c -o c_code/2_7/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msighashes.nim.c -o c_code/2_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftdestructors.nim.c -o c_code/2_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msempass2.nim.c -o c_code/2_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgmeth.nim.c -o c_code/2_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliases.nim.c -o c_code/2_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftlocals.nim.c -o c_code/2_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlambdalifting.nim.c -o c_code/2_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mclosureiters.nim.c -o c_code/2_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtransf.nim.c -o c_code/2_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptimizer.nim.c -o c_code/2_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdfa.nim.c -o c_code/2_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@minjectdestructors.nim.c -o c_code/2_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mexpanddefaults.nim.c -o c_code/2_7/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpipelineutils.nim.c -o c_code/2_7/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mspawn.nim.c -o c_code/2_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemparallel.nim.c -o c_code/2_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sdynlib.nim.c -o c_code/2_7/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgen.nim.c -o c_code/2_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodules.nim.c -o c_code/2_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemmacrosanity.nim.c -o c_code/2_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmgen.nim.c -o c_code/2_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdeps.nim.c -o c_code/2_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mgorgeimpl.nim.c -o c_code/2_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmacrocacheimpl.nim.c -o c_code/2_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmprofiler.nim.c -o c_code/2_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mevaltempl.nim.c -o c_code/2_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmconv.nim.c -o c_code/2_7/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmmarshal.nim.c -o c_code/2_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvm.nim.c -o c_code/2_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mimporter.nim.c -o c_code/2_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprocfind.nim.c -o c_code/2_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpatterns.nim.c -o c_code/2_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpluginsupport.nim.c -o c_code/2_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@slocals.nim.c -o c_code/2_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sitersgen.nim.c -o c_code/2_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sactive.nim.c -o c_code/2_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@menumtostr.nim.c -o c_code/2_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvtables.nim.c -o c_code/2_7/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msem.nim.c -o c_code/2_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mreorder.nim.c -o c_code/2_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdepends.nim.c -o c_code/2_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msourcemap.nim.c -o c_code/2_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mjsgen.nim.c -o c_code/2_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_7/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_7/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypesrenderer.nim.c -o c_code/2_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderverbatim.nim.c -o c_code/2_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sxmltree.nim.c -o c_code/2_7/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@suri.nim.c -o c_code/2_7/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen.nim.c -o c_code/2_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen2.nim.c -o c_code/2_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sreplayer.nim.c -o c_code/2_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpipelines.nim.c -o c_code/2_7/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mscriptconfig.nim.c -o c_code/2_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimconf.nim.c -o c_code/2_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sdce.nim.c -o c_code/2_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@scbackend.nim.c -o c_code/2_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sintegrity.nim.c -o c_code/2_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@snavigator.nim.c -o c_code/2_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmain.nim.c -o c_code/2_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcmdlinehelper.nim.c -o c_code/2_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_7/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnim.nim.c -o c_code/2_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_7/@m..@slib@ssystem@sexceptions.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/2_7/@m..@slib@sstd@sassertions.nim.o \
c_code/2_7/@m..@slib@ssystem@siterators.nim.o \
c_code/2_7/@m..@slib@ssystem@sdollars.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/2_7/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_7/@m..@slib@ssystem.nim.o \
c_code/2_7/@m..@slib@spure@sparseutils.nim.o \
c_code/2_7/@m..@slib@spure@smath.nim.o \
c_code/2_7/@m..@slib@spure@salgorithm.nim.o \
c_code/2_7/@m..@slib@sstd@senumutils.nim.o \
c_code/2_7/@m..@slib@spure@sunicode.nim.o \
c_code/2_7/@m..@slib@spure@sstrutils.nim.o \
c_code/2_7/@m..@slib@spure@spathnorm.nim.o \
c_code/2_7/@m..@slib@sstd@soserrors.nim.o \
c_code/2_7/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_7/@m..@slib@spure@stimes.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_7/@m..@slib@sstd@senvvars.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_7/@m..@slib@sstd@scmdline.nim.o \
c_code/2_7/@m..@slib@spure@sos.nim.o \
c_code/2_7/@m..@slib@spure@sparseopt.nim.o \
c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_7/@m..@slib@spure@shashes.nim.o \
c_code/2_7/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_7/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_7/@m..@slib@spure@sstrformat.nim.o \
c_code/2_7/@m..@slib@spure@sterminal.nim.o \
c_code/2_7/@mpathutils.nim.o \
c_code/2_7/@mropes.nim.o \
c_code/2_7/@mlineinfos.nim.o \
c_code/2_7/@mplatform.nim.o \
c_code/2_7/@mprefixmatches.nim.o \
c_code/2_7/@mnimpaths.nim.o \
c_code/2_7/@m..@slib@spure@scollections@ssets.nim.o \
c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_7/@moptions.nim.o \
c_code/2_7/@mmsgs.nim.o \
c_code/2_7/@mcondsyms.nim.o \
c_code/2_7/@mwordrecg.nim.o \
c_code/2_7/@midents.nim.o \
c_code/2_7/@mint128.nim.o \
c_code/2_7/@mnodekinds.nim.o \
c_code/2_7/@mast.nim.o \
c_code/2_7/@mllstream.nim.o \
c_code/2_7/@mnimlexbase.nim.o \
c_code/2_7/@mlexer.nim.o \
c_code/2_7/@mrenderer.nim.o \
c_code/2_7/@mmodulepaths.nim.o \
c_code/2_7/@m..@slib@spure@sstreams.nim.o \
c_code/2_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_7/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_7/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_7/@m..@slib@spure@sosproc.nim.o \
c_code/2_7/@m..@slib@spure@slexbase.nim.o \
c_code/2_7/@m..@slib@spure@sparsejson.nim.o \
c_code/2_7/@m..@slib@spure@sjson.nim.o \
c_code/2_7/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_7/@mextccomp.nim.o \
c_code/2_7/@mnimblecmd.nim.o \
c_code/2_7/@mcommands.nim.o \
c_code/2_7/@mparser.nim.o \
c_code/2_7/@mfilters.nim.o \
c_code/2_7/@mfilter_tmpl.nim.o \
c_code/2_7/@msyntaxes.nim.o \
c_code/2_7/@mrodutils.nim.o \
c_code/2_7/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_7/@mastyaml.nim.o \
c_code/2_7/@mastalgo.nim.o \
c_code/2_7/@mtrees.nim.o \
c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_7/@mbtrees.nim.o \
c_code/2_7/@mpackages.nim.o \
c_code/2_7/@msuggestsymdb.nim.o \
c_code/2_7/@mic@srodfiles.nim.o \
c_code/2_7/@mic@sbitabs.nim.o \
c_code/2_7/@mic@siclineinfos.nim.o \
c_code/2_7/@mic@spacked_ast.nim.o \
c_code/2_7/@mic@sic.nim.o \
c_code/2_7/@mmodulegraphs.nim.o \
c_code/2_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/2_7/@mastmsgs.nim.o \
c_code/2_7/@mtypes.nim.o \
c_code/2_7/@mnimsets.nim.o \
c_code/2_7/@mndi.nim.o \
c_code/2_7/@mcgendata.nim.o \
c_code/2_7/@mmangleutils.nim.o \
c_code/2_7/@mccgutils.nim.o \
c_code/2_7/@mtreetab.nim.o \
c_code/2_7/@msaturate.nim.o \
c_code/2_7/@mguards.nim.o \
c_code/2_7/@msemfold.nim.o \
c_code/2_7/@mvmdef.nim.o \
c_code/2_7/@msemdata.nim.o \
c_code/2_7/@mtypeallowed.nim.o \
c_code/2_7/@misolation_check.nim.o \
c_code/2_7/@mvarpartitions.nim.o \
c_code/2_7/@mnilcheck.nim.o \
c_code/2_7/@merrorhandling.nim.o \
c_code/2_7/@maliasanalysis.nim.o \
c_code/2_7/@msemstrictfuncs.nim.o \
c_code/2_7/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_7/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_7/@mlookups.nim.o \
c_code/2_7/@mlinter.nim.o \
c_code/2_7/@msemtypinst.nim.o \
c_code/2_7/@mparampatterns.nim.o \
c_code/2_7/@mlowerings.nim.o \
c_code/2_7/@mconcepts.nim.o \
c_code/2_7/@msigmatch.nim.o \
c_code/2_7/@mpragmas.nim.o \
c_code/2_7/@mpushpoppragmas.nim.o \
c_code/2_7/@msighashes.nim.o \
c_code/2_7/@mliftdestructors.nim.o \
c_code/2_7/@msempass2.nim.o \
c_code/2_7/@mcgmeth.nim.o \
c_code/2_7/@maliases.nim.o \
c_code/2_7/@mliftlocals.nim.o \
c_code/2_7/@mlambdalifting.nim.o \
c_code/2_7/@mclosureiters.nim.o \
c_code/2_7/@mtransf.nim.o \
c_code/2_7/@moptimizer.nim.o \
c_code/2_7/@mdfa.nim.o \
c_code/2_7/@minjectdestructors.nim.o \
c_code/2_7/@mexpanddefaults.nim.o \
c_code/2_7/@mpipelineutils.nim.o \
c_code/2_7/@mspawn.nim.o \
c_code/2_7/@msemparallel.nim.o \
c_code/2_7/@m..@slib@spure@sdynlib.nim.o \
c_code/2_7/@mcgen.nim.o \
c_code/2_7/@mmodules.nim.o \
c_code/2_7/@msemmacrosanity.nim.o \
c_code/2_7/@mvmgen.nim.o \
c_code/2_7/@mvmdeps.nim.o \
c_code/2_7/@mgorgeimpl.nim.o \
c_code/2_7/@mmacrocacheimpl.nim.o \
c_code/2_7/@mvmprofiler.nim.o \
c_code/2_7/@mevaltempl.nim.o \
c_code/2_7/@mvmconv.nim.o \
c_code/2_7/@mvmmarshal.nim.o \
c_code/2_7/@mvm.nim.o \
c_code/2_7/@mimporter.nim.o \
c_code/2_7/@mprocfind.nim.o \
c_code/2_7/@mpatterns.nim.o \
c_code/2_7/@mpluginsupport.nim.o \
c_code/2_7/@mplugins@slocals.nim.o \
c_code/2_7/@mplugins@sitersgen.nim.o \
c_code/2_7/@mplugins@sactive.nim.o \
c_code/2_7/@menumtostr.nim.o \
c_code/2_7/@mvtables.nim.o \
c_code/2_7/@msem.nim.o \
c_code/2_7/@mreorder.nim.o \
c_code/2_7/@mdepends.nim.o \
c_code/2_7/@msourcemap.nim.o \
c_code/2_7/@mjsgen.nim.o \
c_code/2_7/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_7/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_7/@mtypesrenderer.nim.o \
c_code/2_7/@mrenderverbatim.nim.o \
c_code/2_7/@m..@slib@spure@sxmltree.nim.o \
c_code/2_7/@m..@slib@spure@suri.nim.o \
c_code/2_7/@mdocgen.nim.o \
c_code/2_7/@mdocgen2.nim.o \
c_code/2_7/@mic@sreplayer.nim.o \
c_code/2_7/@mpipelines.nim.o \
c_code/2_7/@mscriptconfig.nim.o \
c_code/2_7/@mnimconf.nim.o \
c_code/2_7/@mic@sdce.nim.o \
c_code/2_7/@mic@scbackend.nim.o \
c_code/2_7/@mic@sintegrity.nim.o \
c_code/2_7/@mic@snavigator.nim.o \
c_code/2_7/@mmain.nim.o \
c_code/2_7/@mcmdlinehelper.nim.o \
c_code/2_7/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mplatform.nim.c -o c_code/2_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_8/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mplatform.nim.c -o c_code/2_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_9/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mplatform.nim.c -o c_code/2_10/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_10/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_11/@mplatform.nim.c -o c_code/2_11/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_11/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_12/@mplatform.nim.c -o c_code/2_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_12/@mic@srodfiles.nim.c -o c_code/2_12/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_12/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_12/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_13/@mplatform.nim.c -o c_code/2_13/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_13/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_14/@mplatform.nim.c -o c_code/2_14/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_14/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_15/@mplatform.nim.c -o c_code/2_15/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_15/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_16/@mplatform.nim.c -o c_code/2_16/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_16/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_17/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sassertions.nim.c -o c_code/2_17/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem@siterators.nim.c -o c_code/2_17/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_17/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sformatfloat.nim.c -o c_code/2_17/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem.nim.c -o c_code/2_17/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sparseutils.nim.c -o c_code/2_17/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@smath.nim.c -o c_code/2_17/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@salgorithm.nim.c -o c_code/2_17/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@senumutils.nim.c -o c_code/2_17/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sunicode.nim.c -o c_code/2_17/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstrutils.nim.c -o c_code/2_17/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@spathnorm.nim.c -o c_code/2_17/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@soserrors.nim.c -o c_code/2_17/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_17/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@stimes.nim.c -o c_code/2_17/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@senvvars.nim.c -o c_code/2_17/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@scmdline.nim.c -o c_code/2_17/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sos.nim.c -o c_code/2_17/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sparseopt.nim.c -o c_code/2_17/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@shashes.nim.c -o c_code/2_17/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_17/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_17/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstrformat.nim.c -o c_code/2_17/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sterminal.nim.c -o c_code/2_17/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mropes.nim.c -o c_code/2_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplatform.nim.c -o c_code/2_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimpaths.nim.c -o c_code/2_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_17/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptions.nim.c -o c_code/2_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmsgs.nim.c -o c_code/2_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnodekinds.nim.c -o c_code/2_17/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mllstream.nim.c -o c_code/2_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlexer.nim.c -o c_code/2_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderer.nim.c -o c_code/2_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulepaths.nim.c -o c_code/2_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstreams.nim.c -o c_code/2_17/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_17/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_17/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sosproc.nim.c -o c_code/2_17/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@slexbase.nim.c -o c_code/2_17/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sparsejson.nim.c -o c_code/2_17/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sjson.nim.c -o c_code/2_17/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_17/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mextccomp.nim.c -o c_code/2_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimblecmd.nim.c -o c_code/2_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcommands.nim.c -o c_code/2_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msyntaxes.nim.c -o c_code/2_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrodutils.nim.c -o c_code/2_17/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_17/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastyaml.nim.c -o c_code/2_17/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbtrees.nim.c -o c_code/2_17/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpackages.nim.c -o c_code/2_17/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msuggestsymdb.nim.c -o c_code/2_17/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@srodfiles.nim.c -o c_code/2_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sbitabs.nim.c -o c_code/2_17/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@siclineinfos.nim.c -o c_code/2_17/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sic.nim.c -o c_code/2_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypes.nim.c -o c_code/2_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimsets.nim.c -o c_code/2_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mndi.nim.c -o c_code/2_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmangleutils.nim.c -o c_code/2_17/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemfold.nim.c -o c_code/2_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdef.nim.c -o c_code/2_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliasanalysis.nim.c -o c_code/2_17/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemstrictfuncs.nim.c -o c_code/2_17/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_17/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlinter.nim.c -o c_code/2_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msigmatch.nim.c -o c_code/2_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpragmas.nim.c -o c_code/2_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpushpoppragmas.nim.c -o c_code/2_17/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mexpanddefaults.nim.c -o c_code/2_17/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpipelineutils.nim.c -o c_code/2_17/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sdynlib.nim.c -o c_code/2_17/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgen.nim.c -o c_code/2_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodules.nim.c -o c_code/2_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmdeps.nim.c -o c_code/2_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mgorgeimpl.nim.c -o c_code/2_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmprofiler.nim.c -o c_code/2_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmconv.nim.c -o c_code/2_17/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvm.nim.c -o c_code/2_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvtables.nim.c -o c_code/2_17/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msem.nim.c -o c_code/2_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mjsgen.nim.c -o c_code/2_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_17/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sxmltree.nim.c -o c_code/2_17/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@suri.nim.c -o c_code/2_17/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdocgen.nim.c -o c_code/2_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdocgen2.nim.c -o c_code/2_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sreplayer.nim.c -o c_code/2_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpipelines.nim.c -o c_code/2_17/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mscriptconfig.nim.c -o c_code/2_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimconf.nim.c -o c_code/2_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmain.nim.c -o c_code/2_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_17/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnim.nim.c -o c_code/2_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/@m..@slib@ssystem@sexceptions.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/2_17/@m..@slib@sstd@sassertions.nim.o \
c_code/2_17/@m..@slib@ssystem@siterators.nim.o \
c_code/2_17/@m..@slib@ssystem@sdollars.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/2_17/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_17/@m..@slib@ssystem.nim.o \
c_code/2_17/@m..@slib@spure@sparseutils.nim.o \
c_code/2_17/@m..@slib@spure@smath.nim.o \
c_code/2_17/@m..@slib@spure@salgorithm.nim.o \
c_code/2_17/@m..@slib@sstd@senumutils.nim.o \
c_code/2_17/@m..@slib@spure@sunicode.nim.o \
c_code/2_17/@m..@slib@spure@sstrutils.nim.o \
c_code/2_17/@m..@slib@spure@spathnorm.nim.o \
c_code/2_17/@m..@slib@sstd@soserrors.nim.o \
c_code/2_17/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_17/@m..@slib@spure@stimes.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_17/@m..@slib@sstd@senvvars.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_17/@m..@slib@sstd@scmdline.nim.o \
c_code/2_17/@m..@slib@spure@sos.nim.o \
c_code/2_17/@m..@slib@spure@sparseopt.nim.o \
c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_17/@m..@slib@spure@shashes.nim.o \
c_code/2_17/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_17/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_17/@m..@slib@spure@sstrformat.nim.o \
c_code/2_17/@m..@slib@spure@sterminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/2_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/2_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/2_17/@mnimpaths.nim.o \
c_code/2_17/@m..@slib@spure@scollections@ssets.nim.o \
c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_17/@moptions.nim.o \
c_code/2_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mnodekinds.nim.o \
c_code/2_17/@mast.nim.o \
c_code/2_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/2_17/@mlexer.nim.o \
c_code/2_17/@mrenderer.nim.o \
c_code/2_17/@mmodulepaths.nim.o \
c_code/2_17/@m..@slib@spure@sstreams.nim.o \
c_code/2_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_17/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_17/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_17/@m..@slib@spure@sosproc.nim.o \
c_code/2_17/@m..@slib@spure@slexbase.nim.o \
c_code/2_17/@m..@slib@spure@sparsejson.nim.o \
c_code/2_17/@m..@slib@spure@sjson.nim.o \
c_code/2_17/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_17/@mextccomp.nim.o \
c_code/2_17/@mnimblecmd.nim.o \
c_code/2_17/@mcommands.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/2_17/@msyntaxes.nim.o \
c_code/2_17/@mrodutils.nim.o \
c_code/2_17/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_17/@mastyaml.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_17/@mbtrees.nim.o \
c_code/2_17/@mpackages.nim.o \
c_code/2_17/@msuggestsymdb.nim.o \
c_code/2_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@sbitabs.nim.o \
c_code/2_17/@mic@siclineinfos.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/2_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/2_17/@mtypes.nim.o \
c_code/2_17/@mnimsets.nim.o \
c_code/2_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mmangleutils.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@msemfold.nim.o \
c_code/2_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@maliasanalysis.nim.o \
c_code/2_17/@msemstrictfuncs.nim.o \
c_code/2_17/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mlinter.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/2_17/@msigmatch.nim.o \
c_code/2_17/@mpragmas.nim.o \
c_code/2_17/@mpushpoppragmas.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@mexpanddefaults.nim.o \
c_code/2_17/@mpipelineutils.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/@m..@slib@spure@sdynlib.nim.o \
c_code/2_17/@mcgen.nim.o \
c_code/2_17/@mmodules.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/2_17/@mvmdeps.nim.o \
c_code/2_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/2_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/2_17/@mvmconv.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/2_17/@mvm.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mvtables.nim.o \
c_code/2_17/@msem.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/2_17/@mjsgen.nim.o \
c_code/2_17/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/@m..@slib@spure@sxmltree.nim.o \
c_code/2_17/@m..@slib@spure@suri.nim.o \
c_code/2_17/@mdocgen.nim.o \
c_code/2_17/@mdocgen2.nim.o \
c_code/2_17/@mic@sreplayer.nim.o \
c_code/2_17/@mpipelines.nim.o \
c_code/2_17/@mscriptconfig.nim.o \
c_code/2_17/@mnimconf.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/2_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/2_17/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@ssystem.nim.c -o c_code/2_3/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseutils.nim.c -o c_code/2_3/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@smath.nim.c -o c_code/2_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@salgorithm.nim.c -o c_code/2_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrutils.nim.c -o c_code/2_3/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@spathnorm.nim.c -o c_code/2_3/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@soserrors.nim.c -o c_code/2_3/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_3/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@stimes.nim.c -o c_code/2_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@sstd@senvvars.nim.c -o c_code/2_3/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sos.nim.c -o c_code/2_3/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sparseopt.nim.c -o c_code/2_3/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@shashes.nim.c -o c_code/2_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_3/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_3/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sterminal.nim.c -o c_code/2_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplatform.nim.c -o c_code/2_18/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sstreams.nim.c -o c_code/2_3/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sosproc.nim.c -o c_code/2_3/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sjson.nim.c -o c_code/2_3/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_12/@mic@srodfiles.nim.c -o c_code/2_12/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mndi.nim.c -o c_code/2_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sdynlib.nim.c -o c_code/2_3/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_3/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/2_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_3/@m..@slib@ssystem.nim.o \
c_code/2_3/@m..@slib@spure@sparseutils.nim.o \
c_code/2_1/@m..@slib@spure@smath.nim.o \
c_code/2_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/2_3/@m..@slib@spure@sstrutils.nim.o \
c_code/2_3/@m..@slib@spure@spathnorm.nim.o \
c_code/2_3/@m..@slib@sstd@soserrors.nim.o \
c_code/2_3/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@m..@slib@spure@stimes.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_3/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_3/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/2_3/@m..@slib@spure@sos.nim.o \
c_code/2_3/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_1/@m..@slib@spure@shashes.nim.o \
c_code/2_3/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_3/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/2_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_18/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@m..@slib@spure@sstreams.nim.o \
c_code/2_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_3/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/2_3/@m..@slib@spure@sjson.nim.o \
c_code/2_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_12/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mndi.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_3/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@m..@slib@spure@sdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_3/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_19/@mplatform.nim.c -o c_code/2_19/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_19/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/2_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem.nim.c -o c_code/2_4/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@smath.nim.c -o c_code/2_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@salgorithm.nim.c -o c_code/2_4/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrutils.nim.c -o c_code/2_4/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@ssyncio.nim.c -o c_code/2_4/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@stimes.nim.c -o c_code/2_4/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@senvvars.nim.c -o c_code/2_4/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sos.nim.c -o c_code/2_4/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseopt.nim.c -o c_code/2_4/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@shashes.nim.c -o c_code/2_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@scollections@stables.nim.c -o c_code/2_4/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sterminal.nim.c -o c_code/2_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_20/@mplatform.nim.c -o c_code/2_20/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstreams.nim.c -o c_code/2_4/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@smonotimes.nim.c -o c_code/2_4/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sosproc.nim.c -o c_code/2_4/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sjson.nim.c -o c_code/2_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mndi.nim.c -o c_code/2_4/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sbrowsers.nim.c -o c_code/2_4/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/2_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/2_4/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/2_2/@m..@slib@spure@smath.nim.o \
c_code/2_4/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/2_4/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/2_4/@m..@slib@sstd@ssyncio.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@m..@slib@spure@stimes.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/2_4/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/2_4/@m..@slib@spure@sos.nim.o \
c_code/2_4/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/2_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/2_4/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/2_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_20/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@m..@slib@spure@sstreams.nim.o \
c_code/2_4/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/2_4/@m..@slib@sstd@smonotimes.nim.o \
c_code/2_4/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/2_2/@m..@slib@spure@sjson.nim.o \
c_code/2_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_4/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/2_4/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@m..@slib@spure@sbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
macosx)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_1/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sassertions.nim.c -o c_code/1_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/3_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@ssystem.nim.c -o c_code/3_1/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparseutils.nim.c -o c_code/2_1/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@smath.nim.c -o c_code/3_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@salgorithm.nim.c -o c_code/3_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sunicode.nim.c -o c_code/2_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sstrutils.nim.c -o c_code/3_1/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@spathnorm.nim.c -o c_code/2_1/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@soserrors.nim.c -o c_code/2_1/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sstd@ssyncio.nim.c -o c_code/3_1/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sposix@sposix.nim.c -o c_code/3_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/3_1/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@stimes.nim.c -o c_code/3_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/3_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sstd@senvvars.nim.c -o c_code/3_1/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@scmdline.nim.c -o c_code/2_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sos.nim.c -o c_code/3_1/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sparseopt.nim.c -o c_code/3_1/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@shashes.nim.c -o c_code/3_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_1/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@scollections@stables.nim.c -o c_code/3_1/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sstrformat.nim.c -o c_code/2_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sterminal.nim.c -o c_code/3_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mropes.nim.c -o c_code/3_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mplatform.nim.c -o c_code/3_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@moptions.nim.c -o c_code/3_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmsgs.nim.c -o c_code/3_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mllstream.nim.c -o c_code/3_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mlexer.nim.c -o c_code/3_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mrenderer.nim.c -o c_code/3_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sstreams.nim.c -o c_code/3_1/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/3_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/3_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sosproc.nim.c -o c_code/3_1/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@slexbase.nim.c -o c_code/1_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sparsejson.nim.c -o c_code/2_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sjson.nim.c -o c_code/3_1/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/3_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mextccomp.nim.c -o c_code/3_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimblecmd.nim.c -o c_code/3_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcommands.nim.c -o c_code/3_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msyntaxes.nim.c -o c_code/3_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mbtrees.nim.c -o c_code/3_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@srodfiles.nim.c -o c_code/3_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimsets.nim.c -o c_code/3_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mndi.nim.c -o c_code/3_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdef.nim.c -o c_code/3_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msigmatch.nim.c -o c_code/3_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpragmas.nim.c -o c_code/2_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@sdynlib.nim.c -o c_code/2_1/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcgen.nim.c -o c_code/3_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdeps.nim.c -o c_code/3_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mgorgeimpl.nim.c -o c_code/3_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmprofiler.nim.c -o c_code/3_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmconv.nim.c -o c_code/3_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvm.nim.c -o c_code/3_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msem.nim.c -o c_code/3_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mjsgen.nim.c -o c_code/3_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/3_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/3_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/3_1/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/3_1/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@sxmltree.nim.c -o c_code/1_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@spure@suri.nim.c -o c_code/2_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen.nim.c -o c_code/3_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen2.nim.c -o c_code/2_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@sreplayer.nim.c -o c_code/3_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mpipelines.nim.c -o c_code/3_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mscriptconfig.nim.c -o c_code/3_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimconf.nim.c -o c_code/3_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmain.nim.c -o c_code/3_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@spure@sbrowsers.nim.c -o c_code/3_1/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnim.nim.c -o c_code/3_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_1/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/3_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/3_1/@m..@slib@ssystem.nim.o \
c_code/2_1/@m..@slib@spure@sparseutils.nim.o \
c_code/3_1/@m..@slib@spure@smath.nim.o \
c_code/3_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/2_1/@m..@slib@spure@sunicode.nim.o \
c_code/3_1/@m..@slib@spure@sstrutils.nim.o \
c_code/2_1/@m..@slib@spure@spathnorm.nim.o \
c_code/2_1/@m..@slib@sstd@soserrors.nim.o \
c_code/3_1/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_1/@m..@slib@sposix@sposix.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/3_1/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/3_1/@m..@slib@spure@stimes.nim.o \
c_code/3_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/3_1/@m..@slib@sstd@senvvars.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@m..@slib@sstd@scmdline.nim.o \
c_code/3_1/@m..@slib@spure@sos.nim.o \
c_code/3_1/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/3_1/@m..@slib@spure@shashes.nim.o \
c_code/2_1/@m..@slib@spure@sstrtabs.nim.o \
c_code/3_1/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_1/@m..@slib@spure@sstrformat.nim.o \
c_code/3_1/@m..@slib@spure@sterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/3_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/3_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/3_1/@moptions.nim.o \
c_code/3_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_1/@mast.nim.o \
c_code/3_1/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/3_1/@mlexer.nim.o \
c_code/3_1/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/3_1/@m..@slib@spure@sstreams.nim.o \
c_code/3_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/3_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/3_1/@m..@slib@spure@sosproc.nim.o \
c_code/1_1/@m..@slib@spure@slexbase.nim.o \
c_code/2_1/@m..@slib@spure@sparsejson.nim.o \
c_code/3_1/@m..@slib@spure@sjson.nim.o \
c_code/3_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_1/@mextccomp.nim.o \
c_code/3_1/@mnimblecmd.nim.o \
c_code/3_1/@mcommands.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/3_1/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_1/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/3_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/3_1/@mnimsets.nim.o \
c_code/3_1/@mndi.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/3_1/@mvmdef.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_1/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/3_1/@msigmatch.nim.o \
c_code/2_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/@m..@slib@spure@sdynlib.nim.o \
c_code/3_1/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/3_1/@mvmdeps.nim.o \
c_code/3_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/3_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/3_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/3_1/@mvm.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/3_1/@msem.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/3_1/@mjsgen.nim.o \
c_code/2_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/3_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/3_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/3_1/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/3_1/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/@m..@slib@spure@sxmltree.nim.o \
c_code/2_1/@m..@slib@spure@suri.nim.o \
c_code/3_1/@mdocgen.nim.o \
c_code/2_1/@mdocgen2.nim.o \
c_code/3_1/@mic@sreplayer.nim.o \
c_code/3_1/@mpipelines.nim.o \
c_code/3_1/@mscriptconfig.nim.o \
c_code/3_1/@mnimconf.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/3_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/3_1/@m..@slib@spure@sbrowsers.nim.o \
c_code/3_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_2/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/3_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@ssystem.nim.c -o c_code/3_2/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparseutils.nim.c -o c_code/2_2/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@smath.nim.c -o c_code/3_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@salgorithm.nim.c -o c_code/3_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sstrutils.nim.c -o c_code/3_2/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@spathnorm.nim.c -o c_code/2_2/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@soserrors.nim.c -o c_code/2_2/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@ssyncio.nim.c -o c_code/3_2/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sposix@sposix.nim.c -o c_code/3_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/3_2/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@stimes.nim.c -o c_code/3_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/3_2/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@senvvars.nim.c -o c_code/3_2/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sos.nim.c -o c_code/3_2/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sparseopt.nim.c -o c_code/3_2/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@shashes.nim.c -o c_code/3_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_2/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/3_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sterminal.nim.c -o c_code/3_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mplatform.nim.c -o c_code/3_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@moptions.nim.c -o c_code/3_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmsgs.nim.c -o c_code/3_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mllstream.nim.c -o c_code/3_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mlexer.nim.c -o c_code/3_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mrenderer.nim.c -o c_code/3_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sstreams.nim.c -o c_code/3_2/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sosproc.nim.c -o c_code/3_2/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sjson.nim.c -o c_code/3_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/3_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mextccomp.nim.c -o c_code/3_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimblecmd.nim.c -o c_code/3_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcommands.nim.c -o c_code/3_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msyntaxes.nim.c -o c_code/3_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mbtrees.nim.c -o c_code/3_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@srodfiles.nim.c -o c_code/3_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sic.nim.c -o c_code/2_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimsets.nim.c -o c_code/3_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdef.nim.c -o c_code/3_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msigmatch.nim.c -o c_code/3_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpragmas.nim.c -o c_code/3_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sdynlib.nim.c -o c_code/2_2/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcgen.nim.c -o c_code/3_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mgorgeimpl.nim.c -o c_code/3_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmprofiler.nim.c -o c_code/3_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvm.nim.c -o c_code/3_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msem.nim.c -o c_code/3_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mjsgen.nim.c -o c_code/3_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen.nim.c -o c_code/3_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sreplayer.nim.c -o c_code/3_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpipelines.nim.c -o c_code/3_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mscriptconfig.nim.c -o c_code/3_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimconf.nim.c -o c_code/3_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmain.nim.c -o c_code/3_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/3_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnim.nim.c -o c_code/3_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_2/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/3_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/3_2/@m..@slib@ssystem.nim.o \
c_code/2_2/@m..@slib@spure@sparseutils.nim.o \
c_code/3_2/@m..@slib@spure@smath.nim.o \
c_code/3_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/3_2/@m..@slib@spure@sstrutils.nim.o \
c_code/2_2/@m..@slib@spure@spathnorm.nim.o \
c_code/2_2/@m..@slib@sstd@soserrors.nim.o \
c_code/3_2/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_2/@m..@slib@sposix@sposix.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/3_2/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/3_2/@m..@slib@spure@stimes.nim.o \
c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/3_2/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/3_2/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/3_2/@m..@slib@spure@sos.nim.o \
c_code/3_2/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/3_2/@m..@slib@spure@shashes.nim.o \
c_code/2_2/@m..@slib@spure@sstrtabs.nim.o \
c_code/3_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/3_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/3_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/3_2/@moptions.nim.o \
c_code/3_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/3_2/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/3_2/@mlexer.nim.o \
c_code/3_2/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/3_2/@m..@slib@spure@sstreams.nim.o \
c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/3_2/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/3_2/@m..@slib@spure@sjson.nim.o \
c_code/3_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_2/@mextccomp.nim.o \
c_code/3_2/@mnimblecmd.nim.o \
c_code/3_2/@mcommands.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/3_2/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/3_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/3_2/@mnimsets.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/3_2/@mvmdef.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/3_2/@msigmatch.nim.o \
c_code/3_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/@m..@slib@spure@sdynlib.nim.o \
c_code/3_2/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/3_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/3_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_2/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/3_2/@msem.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/3_2/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/3_2/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/3_2/@mic@sreplayer.nim.o \
c_code/3_2/@mpipelines.nim.o \
c_code/3_2/@mscriptconfig.nim.o \
c_code/3_2/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/3_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/3_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/3_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sassertions.nim.c -o c_code/1_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/3_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@ssystem.nim.c -o c_code/3_6/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sparseutils.nim.c -o c_code/2_4/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@smath.nim.c -o c_code/3_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@salgorithm.nim.c -o c_code/3_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sunicode.nim.c -o c_code/2_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@sstrutils.nim.c -o c_code/3_6/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@spathnorm.nim.c -o c_code/2_4/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@soserrors.nim.c -o c_code/2_4/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@sstd@ssyncio.nim.c -o c_code/3_6/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sposix@sposix.nim.c -o c_code/3_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/3_6/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@stimes.nim.c -o c_code/3_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@sstd@senvvars.nim.c -o c_code/3_6/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@scmdline.nim.c -o c_code/2_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@sos.nim.c -o c_code/3_6/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@sparseopt.nim.c -o c_code/3_6/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@shashes.nim.c -o c_code/3_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_4/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@scollections@stables.nim.c -o c_code/3_6/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sstrformat.nim.c -o c_code/2_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sterminal.nim.c -o c_code/3_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mplatform.nim.c -o c_code/3_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@moptions.nim.c -o c_code/3_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmsgs.nim.c -o c_code/3_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mllstream.nim.c -o c_code/3_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mlexer.nim.c -o c_code/3_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mrenderer.nim.c -o c_code/3_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@sstreams.nim.c -o c_code/3_6/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spure@sosproc.nim.c -o c_code/3_6/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@slexbase.nim.c -o c_code/1_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@sparsejson.nim.c -o c_code/2_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sjson.nim.c -o c_code/3_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/3_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mextccomp.nim.c -o c_code/3_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimblecmd.nim.c -o c_code/3_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcommands.nim.c -o c_code/3_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msyntaxes.nim.c -o c_code/3_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mbtrees.nim.c -o c_code/3_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mic@srodfiles.nim.c -o c_code/3_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimsets.nim.c -o c_code/3_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mndi.nim.c -o c_code/3_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvmdef.nim.c -o c_code/3_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msigmatch.nim.c -o c_code/3_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@slib@spure@sdynlib.nim.c -o c_code/2_4/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcgen.nim.c -o c_code/3_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mgorgeimpl.nim.c -o c_code/3_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmprofiler.nim.c -o c_code/3_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvm.nim.c -o c_code/3_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msem.nim.c -o c_code/3_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mjsgen.nim.c -o c_code/3_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/3_6/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/3_6/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@sxmltree.nim.c -o c_code/1_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@spure@suri.nim.c -o c_code/2_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen.nim.c -o c_code/3_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sreplayer.nim.c -o c_code/3_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpipelines.nim.c -o c_code/3_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mscriptconfig.nim.c -o c_code/3_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmain.nim.c -o c_code/3_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/3_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnim.nim.c -o c_code/3_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@m..@slib@ssystem@sexceptions.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/3_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/1_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/3_6/@m..@slib@ssystem.nim.o \
c_code/2_4/@m..@slib@spure@sparseutils.nim.o \
c_code/3_2/@m..@slib@spure@smath.nim.o \
c_code/3_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/2_2/@m..@slib@spure@sunicode.nim.o \
c_code/3_6/@m..@slib@spure@sstrutils.nim.o \
c_code/2_4/@m..@slib@spure@spathnorm.nim.o \
c_code/2_4/@m..@slib@sstd@soserrors.nim.o \
c_code/3_6/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_2/@m..@slib@sposix@sposix.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/3_6/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/3_2/@m..@slib@spure@stimes.nim.o \
c_code/3_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_4/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/3_6/@m..@slib@sstd@senvvars.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@m..@slib@sstd@scmdline.nim.o \
c_code/3_6/@m..@slib@spure@sos.nim.o \
c_code/3_6/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/3_2/@m..@slib@spure@shashes.nim.o \
c_code/2_4/@m..@slib@spure@sstrtabs.nim.o \
c_code/3_6/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_2/@m..@slib@spure@sstrformat.nim.o \
c_code/3_2/@m..@slib@spure@sterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/3_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/3_6/@moptions.nim.o \
c_code/3_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/3_6/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/3_6/@mlexer.nim.o \
c_code/3_6/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/3_6/@m..@slib@spure@sstreams.nim.o \
c_code/3_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/3_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/3_6/@m..@slib@spure@sosproc.nim.o \
c_code/1_2/@m..@slib@spure@slexbase.nim.o \
c_code/2_2/@m..@slib@spure@sparsejson.nim.o \
c_code/3_2/@m..@slib@spure@sjson.nim.o \
c_code/3_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_6/@mextccomp.nim.o \
c_code/3_6/@mnimblecmd.nim.o \
c_code/3_6/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/3_6/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/3_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/3_2/@mnimsets.nim.o \
c_code/3_2/@mndi.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/3_6/@mvmdef.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/3_6/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@m..@slib@spure@sdynlib.nim.o \
c_code/3_6/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/3_6/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/3_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_6/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/3_6/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/3_6/@mjsgen.nim.o \
c_code/2_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/3_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/1_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/3_6/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/3_6/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@m..@slib@spure@sxmltree.nim.o \
c_code/2_2/@m..@slib@spure@suri.nim.o \
c_code/3_6/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/3_2/@mic@sreplayer.nim.o \
c_code/3_2/@mpipelines.nim.o \
c_code/3_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/3_6/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/3_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/3_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem@sexceptions.nim.c -o c_code/2_17/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sassertions.nim.c -o c_code/2_17/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@ssystem@siterators.nim.c -o c_code/2_17/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@ssystem@sdollars.nim.c -o c_code/3_17/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sformatfloat.nim.c -o c_code/2_17/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@ssystem.nim.c -o c_code/3_17/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sparseutils.nim.c -o c_code/2_17/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@smath.nim.c -o c_code/3_17/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@salgorithm.nim.c -o c_code/3_17/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@senumutils.nim.c -o c_code/2_17/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sunicode.nim.c -o c_code/2_17/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sstrutils.nim.c -o c_code/3_17/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@spathnorm.nim.c -o c_code/2_17/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@soserrors.nim.c -o c_code/2_17/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sstd@ssyncio.nim.c -o c_code/3_17/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sposix@sposix.nim.c -o c_code/3_17/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/3_17/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@stimes.nim.c -o c_code/3_17/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/3_17/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sstd@senvvars.nim.c -o c_code/3_17/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@scmdline.nim.c -o c_code/2_17/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sos.nim.c -o c_code/3_17/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sparseopt.nim.c -o c_code/3_17/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@shashes.nim.c -o c_code/3_17/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstrtabs.nim.c -o c_code/2_17/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@scollections@stables.nim.c -o c_code/3_17/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sstrformat.nim.c -o c_code/2_17/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sterminal.nim.c -o c_code/3_17/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpathutils.nim.c -o c_code/2_17/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mropes.nim.c -o c_code/3_17/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlineinfos.nim.c -o c_code/2_17/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mplatform.nim.c -o c_code/3_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprefixmatches.nim.c -o c_code/2_17/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimpaths.nim.c -o c_code/2_17/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@ssets.nim.c -o c_code/2_17/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@moptions.nim.c -o c_code/3_17/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmsgs.nim.c -o c_code/3_17/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcondsyms.nim.c -o c_code/2_17/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mwordrecg.nim.c -o c_code/2_17/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@midents.nim.c -o c_code/2_17/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mint128.nim.c -o c_code/2_17/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnodekinds.nim.c -o c_code/2_17/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mast.nim.c -o c_code/2_17/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mllstream.nim.c -o c_code/3_17/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnimlexbase.nim.c -o c_code/2_17/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mlexer.nim.c -o c_code/3_17/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mrenderer.nim.c -o c_code/3_17/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulepaths.nim.c -o c_code/2_17/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sstreams.nim.c -o c_code/3_17/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/3_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/3_17/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sosproc.nim.c -o c_code/3_17/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@slexbase.nim.c -o c_code/2_17/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sparsejson.nim.c -o c_code/2_17/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sjson.nim.c -o c_code/3_17/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@sstd@sjsonutils.nim.c -o c_code/3_17/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mextccomp.nim.c -o c_code/3_17/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimblecmd.nim.c -o c_code/3_17/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mcommands.nim.c -o c_code/3_17/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparser.nim.c -o c_code/2_17/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilters.nim.c -o c_code/2_17/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mfilter_tmpl.nim.c -o c_code/2_17/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msyntaxes.nim.c -o c_code/3_17/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrodutils.nim.c -o c_code/2_17/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@spackedsets.nim.c -o c_code/2_17/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastyaml.nim.c -o c_code/2_17/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastalgo.nim.c -o c_code/2_17/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtrees.nim.c -o c_code/2_17/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mbtrees.nim.c -o c_code/3_17/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpackages.nim.c -o c_code/2_17/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msuggestsymdb.nim.c -o c_code/2_17/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mic@srodfiles.nim.c -o c_code/3_17/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sbitabs.nim.c -o c_code/2_17/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@siclineinfos.nim.c -o c_code/2_17/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@spacked_ast.nim.c -o c_code/2_17/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sic.nim.c -o c_code/2_17/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodulegraphs.nim.c -o c_code/2_17/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmagicsys.nim.c -o c_code/2_17/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mbitsets.nim.c -o c_code/2_17/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mastmsgs.nim.c -o c_code/2_17/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypes.nim.c -o c_code/2_17/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimsets.nim.c -o c_code/3_17/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mndi.nim.c -o c_code/3_17/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgendata.nim.c -o c_code/2_17/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmangleutils.nim.c -o c_code/2_17/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mccgutils.nim.c -o c_code/2_17/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtreetab.nim.c -o c_code/2_17/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msaturate.nim.c -o c_code/2_17/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mguards.nim.c -o c_code/2_17/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemfold.nim.c -o c_code/2_17/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmdef.nim.c -o c_code/3_17/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemdata.nim.c -o c_code/2_17/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypeallowed.nim.c -o c_code/2_17/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@misolation_check.nim.c -o c_code/2_17/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvarpartitions.nim.c -o c_code/2_17/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mnilcheck.nim.c -o c_code/2_17/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@merrorhandling.nim.c -o c_code/2_17/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliasanalysis.nim.c -o c_code/2_17/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemstrictfuncs.nim.c -o c_code/2_17/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@sstd@seditdistance.nim.c -o c_code/2_17/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlookups.nim.c -o c_code/2_17/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlinter.nim.c -o c_code/2_17/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemtypinst.nim.c -o c_code/2_17/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mparampatterns.nim.c -o c_code/2_17/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlowerings.nim.c -o c_code/2_17/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mconcepts.nim.c -o c_code/2_17/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msigmatch.nim.c -o c_code/3_17/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpragmas.nim.c -o c_code/2_17/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpushpoppragmas.nim.c -o c_code/2_17/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msighashes.nim.c -o c_code/2_17/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftdestructors.nim.c -o c_code/2_17/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msempass2.nim.c -o c_code/2_17/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcgmeth.nim.c -o c_code/2_17/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@maliases.nim.c -o c_code/2_17/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mliftlocals.nim.c -o c_code/2_17/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mlambdalifting.nim.c -o c_code/2_17/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mclosureiters.nim.c -o c_code/2_17/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtransf.nim.c -o c_code/2_17/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@moptimizer.nim.c -o c_code/2_17/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdfa.nim.c -o c_code/2_17/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@minjectdestructors.nim.c -o c_code/2_17/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mexpanddefaults.nim.c -o c_code/2_17/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpipelineutils.nim.c -o c_code/2_17/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mspawn.nim.c -o c_code/2_17/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemparallel.nim.c -o c_code/2_17/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sdynlib.nim.c -o c_code/2_17/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mcgen.nim.c -o c_code/3_17/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmodules.nim.c -o c_code/2_17/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msemmacrosanity.nim.c -o c_code/2_17/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmgen.nim.c -o c_code/2_17/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmdeps.nim.c -o c_code/3_17/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mgorgeimpl.nim.c -o c_code/3_17/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mmacrocacheimpl.nim.c -o c_code/2_17/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmprofiler.nim.c -o c_code/3_17/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mevaltempl.nim.c -o c_code/2_17/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvmconv.nim.c -o c_code/3_17/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvmmarshal.nim.c -o c_code/2_17/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mvm.nim.c -o c_code/3_17/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mimporter.nim.c -o c_code/2_17/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mprocfind.nim.c -o c_code/2_17/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpatterns.nim.c -o c_code/2_17/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mpluginsupport.nim.c -o c_code/2_17/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@slocals.nim.c -o c_code/2_17/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sitersgen.nim.c -o c_code/2_17/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplugins@sactive.nim.c -o c_code/2_17/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@menumtostr.nim.c -o c_code/2_17/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mvtables.nim.c -o c_code/2_17/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@msem.nim.c -o c_code/3_17/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mreorder.nim.c -o c_code/2_17/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdepends.nim.c -o c_code/2_17/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@msourcemap.nim.c -o c_code/2_17/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mjsgen.nim.c -o c_code/3_17/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@scollections@slists.nim.c -o c_code/2_17/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/3_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/3_17/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/3_17/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/3_17/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mtypesrenderer.nim.c -o c_code/2_17/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mrenderverbatim.nim.c -o c_code/2_17/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@sxmltree.nim.c -o c_code/2_17/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@m..@slib@spure@suri.nim.c -o c_code/2_17/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mdocgen.nim.c -o c_code/3_17/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mdocgen2.nim.c -o c_code/2_17/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mic@sreplayer.nim.c -o c_code/3_17/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mpipelines.nim.c -o c_code/3_17/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mscriptconfig.nim.c -o c_code/3_17/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnimconf.nim.c -o c_code/3_17/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sdce.nim.c -o c_code/2_17/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@scbackend.nim.c -o c_code/2_17/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@sintegrity.nim.c -o c_code/2_17/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mic@snavigator.nim.c -o c_code/2_17/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mmain.nim.c -o c_code/3_17/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mcmdlinehelper.nim.c -o c_code/2_17/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@m..@slib@spure@sbrowsers.nim.c -o c_code/3_17/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_17/@mnim.nim.c -o c_code/3_17/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_17/@m..@slib@ssystem@sexceptions.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/2_17/@m..@slib@sstd@sassertions.nim.o \
c_code/2_17/@m..@slib@ssystem@siterators.nim.o \
c_code/3_17/@m..@slib@ssystem@sdollars.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/2_17/@m..@slib@sstd@sformatfloat.nim.o \
c_code/3_17/@m..@slib@ssystem.nim.o \
c_code/2_17/@m..@slib@spure@sparseutils.nim.o \
c_code/3_17/@m..@slib@spure@smath.nim.o \
c_code/3_17/@m..@slib@spure@salgorithm.nim.o \
c_code/2_17/@m..@slib@sstd@senumutils.nim.o \
c_code/2_17/@m..@slib@spure@sunicode.nim.o \
c_code/3_17/@m..@slib@spure@sstrutils.nim.o \
c_code/2_17/@m..@slib@spure@spathnorm.nim.o \
c_code/2_17/@m..@slib@sstd@soserrors.nim.o \
c_code/3_17/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_17/@m..@slib@sposix@sposix.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/3_17/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/3_17/@m..@slib@spure@stimes.nim.o \
c_code/3_17/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/3_17/@m..@slib@sstd@senvvars.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/2_17/@m..@slib@sstd@scmdline.nim.o \
c_code/3_17/@m..@slib@spure@sos.nim.o \
c_code/3_17/@m..@slib@spure@sparseopt.nim.o \
c_code/2_17/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/3_17/@m..@slib@spure@shashes.nim.o \
c_code/2_17/@m..@slib@spure@sstrtabs.nim.o \
c_code/3_17/@m..@slib@spure@scollections@stables.nim.o \
c_code/2_17/@m..@slib@spure@sstrformat.nim.o \
c_code/3_17/@m..@slib@spure@sterminal.nim.o \
c_code/2_17/@mpathutils.nim.o \
c_code/3_17/@mropes.nim.o \
c_code/2_17/@mlineinfos.nim.o \
c_code/3_17/@mplatform.nim.o \
c_code/2_17/@mprefixmatches.nim.o \
c_code/2_17/@mnimpaths.nim.o \
c_code/2_17/@m..@slib@spure@scollections@ssets.nim.o \
c_code/2_17/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_17/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/3_17/@moptions.nim.o \
c_code/3_17/@mmsgs.nim.o \
c_code/2_17/@mcondsyms.nim.o \
c_code/2_17/@mwordrecg.nim.o \
c_code/2_17/@midents.nim.o \
c_code/2_17/@mint128.nim.o \
c_code/2_17/@mnodekinds.nim.o \
c_code/2_17/@mast.nim.o \
c_code/3_17/@mllstream.nim.o \
c_code/2_17/@mnimlexbase.nim.o \
c_code/3_17/@mlexer.nim.o \
c_code/3_17/@mrenderer.nim.o \
c_code/2_17/@mmodulepaths.nim.o \
c_code/3_17/@m..@slib@spure@sstreams.nim.o \
c_code/3_17/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/3_17/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/3_17/@m..@slib@spure@sosproc.nim.o \
c_code/2_17/@m..@slib@spure@slexbase.nim.o \
c_code/2_17/@m..@slib@spure@sparsejson.nim.o \
c_code/3_17/@m..@slib@spure@sjson.nim.o \
c_code/3_17/@m..@slib@sstd@sjsonutils.nim.o \
c_code/3_17/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_17/@mextccomp.nim.o \
c_code/3_17/@mnimblecmd.nim.o \
c_code/3_17/@mcommands.nim.o \
c_code/2_17/@mparser.nim.o \
c_code/2_17/@mfilters.nim.o \
c_code/2_17/@mfilter_tmpl.nim.o \
c_code/3_17/@msyntaxes.nim.o \
c_code/2_17/@mrodutils.nim.o \
c_code/2_17/@m..@slib@sstd@spackedsets.nim.o \
c_code/2_17/@mastyaml.nim.o \
c_code/2_17/@mastalgo.nim.o \
c_code/2_17/@mtrees.nim.o \
c_code/2_17/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_17/@mbtrees.nim.o \
c_code/2_17/@mpackages.nim.o \
c_code/2_17/@msuggestsymdb.nim.o \
c_code/3_17/@mic@srodfiles.nim.o \
c_code/2_17/@mic@sbitabs.nim.o \
c_code/2_17/@mic@siclineinfos.nim.o \
c_code/2_17/@mic@spacked_ast.nim.o \
c_code/2_17/@mic@sic.nim.o \
c_code/2_17/@mmodulegraphs.nim.o \
c_code/2_17/@mmagicsys.nim.o \
c_code/2_17/@mbitsets.nim.o \
c_code/2_17/@mastmsgs.nim.o \
c_code/2_17/@mtypes.nim.o \
c_code/3_17/@mnimsets.nim.o \
c_code/3_17/@mndi.nim.o \
c_code/2_17/@mcgendata.nim.o \
c_code/2_17/@mmangleutils.nim.o \
c_code/2_17/@mccgutils.nim.o \
c_code/2_17/@mtreetab.nim.o \
c_code/2_17/@msaturate.nim.o \
c_code/2_17/@mguards.nim.o \
c_code/2_17/@msemfold.nim.o \
c_code/3_17/@mvmdef.nim.o \
c_code/2_17/@msemdata.nim.o \
c_code/2_17/@mtypeallowed.nim.o \
c_code/2_17/@misolation_check.nim.o \
c_code/2_17/@mvarpartitions.nim.o \
c_code/2_17/@mnilcheck.nim.o \
c_code/2_17/@merrorhandling.nim.o \
c_code/2_17/@maliasanalysis.nim.o \
c_code/2_17/@msemstrictfuncs.nim.o \
c_code/2_17/@m..@slib@sstd@seditdistance.nim.o \
c_code/2_17/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/2_17/@mlookups.nim.o \
c_code/2_17/@mlinter.nim.o \
c_code/2_17/@msemtypinst.nim.o \
c_code/2_17/@mparampatterns.nim.o \
c_code/2_17/@mlowerings.nim.o \
c_code/2_17/@mconcepts.nim.o \
c_code/3_17/@msigmatch.nim.o \
c_code/2_17/@mpragmas.nim.o \
c_code/2_17/@mpushpoppragmas.nim.o \
c_code/2_17/@msighashes.nim.o \
c_code/2_17/@mliftdestructors.nim.o \
c_code/2_17/@msempass2.nim.o \
c_code/2_17/@mcgmeth.nim.o \
c_code/2_17/@maliases.nim.o \
c_code/2_17/@mliftlocals.nim.o \
c_code/2_17/@mlambdalifting.nim.o \
c_code/2_17/@mclosureiters.nim.o \
c_code/2_17/@mtransf.nim.o \
c_code/2_17/@moptimizer.nim.o \
c_code/2_17/@mdfa.nim.o \
c_code/2_17/@minjectdestructors.nim.o \
c_code/2_17/@mexpanddefaults.nim.o \
c_code/2_17/@mpipelineutils.nim.o \
c_code/2_17/@mspawn.nim.o \
c_code/2_17/@msemparallel.nim.o \
c_code/2_17/@m..@slib@spure@sdynlib.nim.o \
c_code/3_17/@mcgen.nim.o \
c_code/2_17/@mmodules.nim.o \
c_code/2_17/@msemmacrosanity.nim.o \
c_code/2_17/@mvmgen.nim.o \
c_code/3_17/@mvmdeps.nim.o \
c_code/3_17/@mgorgeimpl.nim.o \
c_code/2_17/@mmacrocacheimpl.nim.o \
c_code/3_17/@mvmprofiler.nim.o \
c_code/2_17/@mevaltempl.nim.o \
c_code/3_17/@mvmconv.nim.o \
c_code/2_17/@mvmmarshal.nim.o \
c_code/3_17/@mvm.nim.o \
c_code/2_17/@mimporter.nim.o \
c_code/2_17/@mprocfind.nim.o \
c_code/2_17/@mpatterns.nim.o \
c_code/2_17/@mpluginsupport.nim.o \
c_code/2_17/@mplugins@slocals.nim.o \
c_code/2_17/@mplugins@sitersgen.nim.o \
c_code/2_17/@mplugins@sactive.nim.o \
c_code/2_17/@menumtostr.nim.o \
c_code/2_17/@mvtables.nim.o \
c_code/3_17/@msem.nim.o \
c_code/2_17/@mreorder.nim.o \
c_code/2_17/@mdepends.nim.o \
c_code/2_17/@msourcemap.nim.o \
c_code/3_17/@mjsgen.nim.o \
c_code/2_17/@m..@slib@spure@scollections@slists.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/3_17/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/3_17/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/2_17/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/3_17/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/3_17/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/2_17/@mtypesrenderer.nim.o \
c_code/2_17/@mrenderverbatim.nim.o \
c_code/2_17/@m..@slib@spure@sxmltree.nim.o \
c_code/2_17/@m..@slib@spure@suri.nim.o \
c_code/3_17/@mdocgen.nim.o \
c_code/2_17/@mdocgen2.nim.o \
c_code/3_17/@mic@sreplayer.nim.o \
c_code/3_17/@mpipelines.nim.o \
c_code/3_17/@mscriptconfig.nim.o \
c_code/3_17/@mnimconf.nim.o \
c_code/2_17/@mic@sdce.nim.o \
c_code/2_17/@mic@scbackend.nim.o \
c_code/2_17/@mic@sintegrity.nim.o \
c_code/2_17/@mic@snavigator.nim.o \
c_code/3_17/@mmain.nim.o \
c_code/2_17/@mcmdlinehelper.nim.o \
c_code/3_17/@m..@slib@spure@sbrowsers.nim.o \
c_code/3_17/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
solaris)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@ssystem@sexceptions.nim.c -o c_code/4_1/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sassertions.nim.c -o c_code/4_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/4_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/4_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@ssystem.nim.c -o c_code/4_1/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sparseutils.nim.c -o c_code/4_1/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@smath.nim.c -o c_code/4_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@salgorithm.nim.c -o c_code/4_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sunicode.nim.c -o c_code/4_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sstrutils.nim.c -o c_code/4_1/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@spathnorm.nim.c -o c_code/4_1/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@soserrors.nim.c -o c_code/4_1/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@ssyncio.nim.c -o c_code/4_1/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sposix@sposix.nim.c -o c_code/4_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@stimes.nim.c -o c_code/4_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@senvvars.nim.c -o c_code/4_1/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@scmdline.nim.c -o c_code/4_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sos.nim.c -o c_code/4_1/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sparseopt.nim.c -o c_code/4_1/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@shashes.nim.c -o c_code/4_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sstrtabs.nim.c -o c_code/4_1/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@stables.nim.c -o c_code/4_1/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sstrformat.nim.c -o c_code/4_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sterminal.nim.c -o c_code/4_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpathutils.nim.c -o c_code/4_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mropes.nim.c -o c_code/4_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlineinfos.nim.c -o c_code/4_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplatform.nim.c -o c_code/4_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprefixmatches.nim.c -o c_code/4_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimpaths.nim.c -o c_code/4_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/4_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptions.nim.c -o c_code/4_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmsgs.nim.c -o c_code/4_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcondsyms.nim.c -o c_code/4_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mwordrecg.nim.c -o c_code/4_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@midents.nim.c -o c_code/4_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mint128.nim.c -o c_code/4_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mast.nim.c -o c_code/4_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mllstream.nim.c -o c_code/4_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimlexbase.nim.c -o c_code/4_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrenderer.nim.c -o c_code/4_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulepaths.nim.c -o c_code/4_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sstreams.nim.c -o c_code/4_1/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/4_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sosproc.nim.c -o c_code/4_1/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@slexbase.nim.c -o c_code/4_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sparsejson.nim.c -o c_code/4_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sjson.nim.c -o c_code/4_1/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/4_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mextccomp.nim.c -o c_code/4_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimblecmd.nim.c -o c_code/4_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcommands.nim.c -o c_code/4_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparser.nim.c -o c_code/4_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilters.nim.c -o c_code/4_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilter_tmpl.nim.c -o c_code/4_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msyntaxes.nim.c -o c_code/4_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrodutils.nim.c -o c_code/4_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/4_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastyaml.nim.c -o c_code/4_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastalgo.nim.c -o c_code/4_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtrees.nim.c -o c_code/4_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mbtrees.nim.c -o c_code/4_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpackages.nim.c -o c_code/4_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msuggestsymdb.nim.c -o c_code/4_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@srodfiles.nim.c -o c_code/4_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sbitabs.nim.c -o c_code/4_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@siclineinfos.nim.c -o c_code/4_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@spacked_ast.nim.c -o c_code/4_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sic.nim.c -o c_code/4_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulegraphs.nim.c -o c_code/4_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmagicsys.nim.c -o c_code/4_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastmsgs.nim.c -o c_code/4_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypes.nim.c -o c_code/4_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimsets.nim.c -o c_code/4_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mndi.nim.c -o c_code/4_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgendata.nim.c -o c_code/4_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmangleutils.nim.c -o c_code/4_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mccgutils.nim.c -o c_code/4_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtreetab.nim.c -o c_code/4_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mguards.nim.c -o c_code/4_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemfold.nim.c -o c_code/4_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdef.nim.c -o c_code/4_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemdata.nim.c -o c_code/4_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypeallowed.nim.c -o c_code/4_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@misolation_check.nim.c -o c_code/4_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvarpartitions.nim.c -o c_code/4_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnilcheck.nim.c -o c_code/4_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@merrorhandling.nim.c -o c_code/4_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliasanalysis.nim.c -o c_code/4_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemstrictfuncs.nim.c -o c_code/4_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/4_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/4_1/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlookups.nim.c -o c_code/4_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlinter.nim.c -o c_code/4_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemtypinst.nim.c -o c_code/4_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparampatterns.nim.c -o c_code/4_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlowerings.nim.c -o c_code/4_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mconcepts.nim.c -o c_code/4_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpragmas.nim.c -o c_code/4_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpushpoppragmas.nim.c -o c_code/4_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msighashes.nim.c -o c_code/4_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mliftdestructors.nim.c -o c_code/4_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msempass2.nim.c -o c_code/4_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgmeth.nim.c -o c_code/4_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliases.nim.c -o c_code/4_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mliftlocals.nim.c -o c_code/4_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlambdalifting.nim.c -o c_code/4_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mclosureiters.nim.c -o c_code/4_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtransf.nim.c -o c_code/4_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptimizer.nim.c -o c_code/4_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdfa.nim.c -o c_code/4_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@minjectdestructors.nim.c -o c_code/4_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mexpanddefaults.nim.c -o c_code/4_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelineutils.nim.c -o c_code/4_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mspawn.nim.c -o c_code/4_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemparallel.nim.c -o c_code/4_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sdynlib.nim.c -o c_code/4_1/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodules.nim.c -o c_code/4_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemmacrosanity.nim.c -o c_code/4_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmgen.nim.c -o c_code/4_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdeps.nim.c -o c_code/4_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mgorgeimpl.nim.c -o c_code/4_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmacrocacheimpl.nim.c -o c_code/4_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmprofiler.nim.c -o c_code/4_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mevaltempl.nim.c -o c_code/4_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmconv.nim.c -o c_code/4_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmmarshal.nim.c -o c_code/4_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvm.nim.c -o c_code/4_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mimporter.nim.c -o c_code/4_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprocfind.nim.c -o c_code/4_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpatterns.nim.c -o c_code/4_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpluginsupport.nim.c -o c_code/4_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@slocals.nim.c -o c_code/4_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sitersgen.nim.c -o c_code/4_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sactive.nim.c -o c_code/4_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@menumtostr.nim.c -o c_code/4_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvtables.nim.c -o c_code/4_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msem.nim.c -o c_code/4_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mreorder.nim.c -o c_code/4_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdepends.nim.c -o c_code/4_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msourcemap.nim.c -o c_code/4_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mjsgen.nim.c -o c_code/4_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/4_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypesrenderer.nim.c -o c_code/4_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrenderverbatim.nim.c -o c_code/4_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sxmltree.nim.c -o c_code/4_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@suri.nim.c -o c_code/4_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdocgen.nim.c -o c_code/4_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdocgen2.nim.c -o c_code/4_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sreplayer.nim.c -o c_code/4_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelines.nim.c -o c_code/4_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mscriptconfig.nim.c -o c_code/4_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimconf.nim.c -o c_code/4_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sdce.nim.c -o c_code/4_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@scbackend.nim.c -o c_code/4_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sintegrity.nim.c -o c_code/4_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@snavigator.nim.c -o c_code/4_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmain.nim.c -o c_code/4_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcmdlinehelper.nim.c -o c_code/4_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sbrowsers.nim.c -o c_code/4_1/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnim.nim.c -o c_code/4_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_1/@m..@slib@ssystem@sexceptions.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/4_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/4_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/4_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/4_1/@m..@slib@ssystem.nim.o \
c_code/4_1/@m..@slib@spure@sparseutils.nim.o \
c_code/4_1/@m..@slib@spure@smath.nim.o \
c_code/4_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/4_1/@m..@slib@spure@sunicode.nim.o \
c_code/4_1/@m..@slib@spure@sstrutils.nim.o \
c_code/4_1/@m..@slib@spure@spathnorm.nim.o \
c_code/4_1/@m..@slib@sstd@soserrors.nim.o \
c_code/4_1/@m..@slib@sstd@ssyncio.nim.o \
c_code/4_1/@m..@slib@sposix@sposix.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/4_1/@m..@slib@spure@stimes.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/4_1/@m..@slib@sstd@senvvars.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/4_1/@m..@slib@sstd@scmdline.nim.o \
c_code/4_1/@m..@slib@spure@sos.nim.o \
c_code/4_1/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/4_1/@m..@slib@spure@shashes.nim.o \
c_code/4_1/@m..@slib@spure@sstrtabs.nim.o \
c_code/4_1/@m..@slib@spure@scollections@stables.nim.o \
c_code/4_1/@m..@slib@spure@sstrformat.nim.o \
c_code/4_1/@m..@slib@spure@sterminal.nim.o \
c_code/4_1/@mpathutils.nim.o \
c_code/4_1/@mropes.nim.o \
c_code/4_1/@mlineinfos.nim.o \
c_code/4_1/@mplatform.nim.o \
c_code/4_1/@mprefixmatches.nim.o \
c_code/4_1/@mnimpaths.nim.o \
c_code/4_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/4_1/@moptions.nim.o \
c_code/4_1/@mmsgs.nim.o \
c_code/4_1/@mcondsyms.nim.o \
c_code/4_1/@mwordrecg.nim.o \
c_code/4_1/@midents.nim.o \
c_code/4_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/4_1/@mast.nim.o \
c_code/4_1/@mllstream.nim.o \
c_code/4_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/4_1/@mrenderer.nim.o \
c_code/4_1/@mmodulepaths.nim.o \
c_code/4_1/@m..@slib@spure@sstreams.nim.o \
c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/4_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/4_1/@m..@slib@spure@sosproc.nim.o \
c_code/4_1/@m..@slib@spure@slexbase.nim.o \
c_code/4_1/@m..@slib@spure@sparsejson.nim.o \
c_code/4_1/@m..@slib@spure@sjson.nim.o \
c_code/4_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_1/@mextccomp.nim.o \
c_code/4_1/@mnimblecmd.nim.o \
c_code/4_1/@mcommands.nim.o \
c_code/4_1/@mparser.nim.o \
c_code/4_1/@mfilters.nim.o \
c_code/4_1/@mfilter_tmpl.nim.o \
c_code/4_1/@msyntaxes.nim.o \
c_code/4_1/@mrodutils.nim.o \
c_code/4_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/4_1/@mastyaml.nim.o \
c_code/4_1/@mastalgo.nim.o \
c_code/4_1/@mtrees.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_1/@mbtrees.nim.o \
c_code/4_1/@mpackages.nim.o \
c_code/4_1/@msuggestsymdb.nim.o \
c_code/4_1/@mic@srodfiles.nim.o \
c_code/4_1/@mic@sbitabs.nim.o \
c_code/4_1/@mic@siclineinfos.nim.o \
c_code/4_1/@mic@spacked_ast.nim.o \
c_code/4_1/@mic@sic.nim.o \
c_code/4_1/@mmodulegraphs.nim.o \
c_code/4_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/4_1/@mastmsgs.nim.o \
c_code/4_1/@mtypes.nim.o \
c_code/4_1/@mnimsets.nim.o \
c_code/4_1/@mndi.nim.o \
c_code/4_1/@mcgendata.nim.o \
c_code/4_1/@mmangleutils.nim.o \
c_code/4_1/@mccgutils.nim.o \
c_code/4_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/4_1/@mguards.nim.o \
c_code/4_1/@msemfold.nim.o \
c_code/4_1/@mvmdef.nim.o \
c_code/4_1/@msemdata.nim.o \
c_code/4_1/@mtypeallowed.nim.o \
c_code/4_1/@misolation_check.nim.o \
c_code/4_1/@mvarpartitions.nim.o \
c_code/4_1/@mnilcheck.nim.o \
c_code/4_1/@merrorhandling.nim.o \
c_code/4_1/@maliasanalysis.nim.o \
c_code/4_1/@msemstrictfuncs.nim.o \
c_code/4_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/4_1/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/4_1/@mlookups.nim.o \
c_code/4_1/@mlinter.nim.o \
c_code/4_1/@msemtypinst.nim.o \
c_code/4_1/@mparampatterns.nim.o \
c_code/4_1/@mlowerings.nim.o \
c_code/4_1/@mconcepts.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/4_1/@mpragmas.nim.o \
c_code/4_1/@mpushpoppragmas.nim.o \
c_code/4_1/@msighashes.nim.o \
c_code/4_1/@mliftdestructors.nim.o \
c_code/4_1/@msempass2.nim.o \
c_code/4_1/@mcgmeth.nim.o \
c_code/4_1/@maliases.nim.o \
c_code/4_1/@mliftlocals.nim.o \
c_code/4_1/@mlambdalifting.nim.o \
c_code/4_1/@mclosureiters.nim.o \
c_code/4_1/@mtransf.nim.o \
c_code/4_1/@moptimizer.nim.o \
c_code/4_1/@mdfa.nim.o \
c_code/4_1/@minjectdestructors.nim.o \
c_code/4_1/@mexpanddefaults.nim.o \
c_code/4_1/@mpipelineutils.nim.o \
c_code/4_1/@mspawn.nim.o \
c_code/4_1/@msemparallel.nim.o \
c_code/4_1/@m..@slib@spure@sdynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/4_1/@mmodules.nim.o \
c_code/4_1/@msemmacrosanity.nim.o \
c_code/4_1/@mvmgen.nim.o \
c_code/4_1/@mvmdeps.nim.o \
c_code/4_1/@mgorgeimpl.nim.o \
c_code/4_1/@mmacrocacheimpl.nim.o \
c_code/4_1/@mvmprofiler.nim.o \
c_code/4_1/@mevaltempl.nim.o \
c_code/4_1/@mvmconv.nim.o \
c_code/4_1/@mvmmarshal.nim.o \
c_code/4_1/@mvm.nim.o \
c_code/4_1/@mimporter.nim.o \
c_code/4_1/@mprocfind.nim.o \
c_code/4_1/@mpatterns.nim.o \
c_code/4_1/@mpluginsupport.nim.o \
c_code/4_1/@mplugins@slocals.nim.o \
c_code/4_1/@mplugins@sitersgen.nim.o \
c_code/4_1/@mplugins@sactive.nim.o \
c_code/4_1/@menumtostr.nim.o \
c_code/4_1/@mvtables.nim.o \
c_code/4_1/@msem.nim.o \
c_code/4_1/@mreorder.nim.o \
c_code/4_1/@mdepends.nim.o \
c_code/4_1/@msourcemap.nim.o \
c_code/4_1/@mjsgen.nim.o \
c_code/4_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/4_1/@mtypesrenderer.nim.o \
c_code/4_1/@mrenderverbatim.nim.o \
c_code/4_1/@m..@slib@spure@sxmltree.nim.o \
c_code/4_1/@m..@slib@spure@suri.nim.o \
c_code/4_1/@mdocgen.nim.o \
c_code/4_1/@mdocgen2.nim.o \
c_code/4_1/@mic@sreplayer.nim.o \
c_code/4_1/@mpipelines.nim.o \
c_code/4_1/@mscriptconfig.nim.o \
c_code/4_1/@mnimconf.nim.o \
c_code/4_1/@mic@sdce.nim.o \
c_code/4_1/@mic@scbackend.nim.o \
c_code/4_1/@mic@sintegrity.nim.o \
c_code/4_1/@mic@snavigator.nim.o \
c_code/4_1/@mmain.nim.o \
c_code/4_1/@mcmdlinehelper.nim.o \
c_code/4_1/@m..@slib@spure@sbrowsers.nim.o \
c_code/4_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@ssystem@sexceptions.nim.c -o c_code/4_2/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sassertions.nim.c -o c_code/4_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/4_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/4_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@ssystem.nim.c -o c_code/4_2/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sparseutils.nim.c -o c_code/4_2/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@smath.nim.c -o c_code/4_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@salgorithm.nim.c -o c_code/4_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sunicode.nim.c -o c_code/4_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sstrutils.nim.c -o c_code/4_2/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@spathnorm.nim.c -o c_code/4_2/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@soserrors.nim.c -o c_code/4_2/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@ssyncio.nim.c -o c_code/4_2/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sposix@sposix.nim.c -o c_code/4_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@stimes.nim.c -o c_code/4_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@senvvars.nim.c -o c_code/4_2/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@scmdline.nim.c -o c_code/4_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sos.nim.c -o c_code/4_2/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sparseopt.nim.c -o c_code/4_2/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@shashes.nim.c -o c_code/4_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sstrtabs.nim.c -o c_code/4_2/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/4_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sstrformat.nim.c -o c_code/4_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sterminal.nim.c -o c_code/4_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpathutils.nim.c -o c_code/4_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mropes.nim.c -o c_code/4_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlineinfos.nim.c -o c_code/4_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplatform.nim.c -o c_code/4_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprefixmatches.nim.c -o c_code/4_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimpaths.nim.c -o c_code/4_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/4_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptions.nim.c -o c_code/4_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmsgs.nim.c -o c_code/4_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcondsyms.nim.c -o c_code/4_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mwordrecg.nim.c -o c_code/4_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@midents.nim.c -o c_code/4_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mint128.nim.c -o c_code/4_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mast.nim.c -o c_code/4_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mllstream.nim.c -o c_code/4_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimlexbase.nim.c -o c_code/4_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderer.nim.c -o c_code/4_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulepaths.nim.c -o c_code/4_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sstreams.nim.c -o c_code/4_2/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@smonotimes.nim.c -o c_code/4_2/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sosproc.nim.c -o c_code/4_2/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@slexbase.nim.c -o c_code/4_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sparsejson.nim.c -o c_code/4_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sjson.nim.c -o c_code/4_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/4_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mextccomp.nim.c -o c_code/4_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimblecmd.nim.c -o c_code/4_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcommands.nim.c -o c_code/4_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparser.nim.c -o c_code/4_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilters.nim.c -o c_code/4_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilter_tmpl.nim.c -o c_code/4_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msyntaxes.nim.c -o c_code/4_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrodutils.nim.c -o c_code/4_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/4_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastyaml.nim.c -o c_code/4_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastalgo.nim.c -o c_code/4_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtrees.nim.c -o c_code/4_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mbtrees.nim.c -o c_code/4_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpackages.nim.c -o c_code/4_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msuggestsymdb.nim.c -o c_code/4_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@srodfiles.nim.c -o c_code/4_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sbitabs.nim.c -o c_code/4_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@siclineinfos.nim.c -o c_code/4_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@spacked_ast.nim.c -o c_code/4_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sic.nim.c -o c_code/4_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulegraphs.nim.c -o c_code/4_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmagicsys.nim.c -o c_code/4_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastmsgs.nim.c -o c_code/4_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypes.nim.c -o c_code/4_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimsets.nim.c -o c_code/4_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mndi.nim.c -o c_code/4_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgendata.nim.c -o c_code/4_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmangleutils.nim.c -o c_code/4_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mccgutils.nim.c -o c_code/4_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtreetab.nim.c -o c_code/4_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mguards.nim.c -o c_code/4_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemfold.nim.c -o c_code/4_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdef.nim.c -o c_code/4_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemdata.nim.c -o c_code/4_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypeallowed.nim.c -o c_code/4_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@misolation_check.nim.c -o c_code/4_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvarpartitions.nim.c -o c_code/4_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnilcheck.nim.c -o c_code/4_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@merrorhandling.nim.c -o c_code/4_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliasanalysis.nim.c -o c_code/4_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemstrictfuncs.nim.c -o c_code/4_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/4_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlookups.nim.c -o c_code/4_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlinter.nim.c -o c_code/4_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemtypinst.nim.c -o c_code/4_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparampatterns.nim.c -o c_code/4_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlowerings.nim.c -o c_code/4_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mconcepts.nim.c -o c_code/4_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpragmas.nim.c -o c_code/4_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpushpoppragmas.nim.c -o c_code/4_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msighashes.nim.c -o c_code/4_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftdestructors.nim.c -o c_code/4_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msempass2.nim.c -o c_code/4_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgmeth.nim.c -o c_code/4_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliases.nim.c -o c_code/4_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftlocals.nim.c -o c_code/4_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlambdalifting.nim.c -o c_code/4_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mclosureiters.nim.c -o c_code/4_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtransf.nim.c -o c_code/4_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptimizer.nim.c -o c_code/4_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdfa.nim.c -o c_code/4_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@minjectdestructors.nim.c -o c_code/4_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mexpanddefaults.nim.c -o c_code/4_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelineutils.nim.c -o c_code/4_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mspawn.nim.c -o c_code/4_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemparallel.nim.c -o c_code/4_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sdynlib.nim.c -o c_code/4_2/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodules.nim.c -o c_code/4_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemmacrosanity.nim.c -o c_code/4_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmgen.nim.c -o c_code/4_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdeps.nim.c -o c_code/4_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mgorgeimpl.nim.c -o c_code/4_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmacrocacheimpl.nim.c -o c_code/4_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmprofiler.nim.c -o c_code/4_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mevaltempl.nim.c -o c_code/4_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmconv.nim.c -o c_code/4_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmmarshal.nim.c -o c_code/4_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvm.nim.c -o c_code/4_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mimporter.nim.c -o c_code/4_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprocfind.nim.c -o c_code/4_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpatterns.nim.c -o c_code/4_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpluginsupport.nim.c -o c_code/4_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@slocals.nim.c -o c_code/4_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sitersgen.nim.c -o c_code/4_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sactive.nim.c -o c_code/4_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@menumtostr.nim.c -o c_code/4_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvtables.nim.c -o c_code/4_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msem.nim.c -o c_code/4_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mreorder.nim.c -o c_code/4_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdepends.nim.c -o c_code/4_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msourcemap.nim.c -o c_code/4_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mjsgen.nim.c -o c_code/4_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/4_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypesrenderer.nim.c -o c_code/4_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderverbatim.nim.c -o c_code/4_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sxmltree.nim.c -o c_code/4_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@suri.nim.c -o c_code/4_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen.nim.c -o c_code/4_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen2.nim.c -o c_code/4_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sreplayer.nim.c -o c_code/4_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelines.nim.c -o c_code/4_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mscriptconfig.nim.c -o c_code/4_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimconf.nim.c -o c_code/4_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sdce.nim.c -o c_code/4_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@scbackend.nim.c -o c_code/4_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sintegrity.nim.c -o c_code/4_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@snavigator.nim.c -o c_code/4_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmain.nim.c -o c_code/4_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcmdlinehelper.nim.c -o c_code/4_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/4_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnim.nim.c -o c_code/4_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_2/@m..@slib@ssystem@sexceptions.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/4_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/4_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/4_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/4_2/@m..@slib@ssystem.nim.o \
c_code/4_2/@m..@slib@spure@sparseutils.nim.o \
c_code/4_2/@m..@slib@spure@smath.nim.o \
c_code/4_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/4_2/@m..@slib@spure@sunicode.nim.o \
c_code/4_2/@m..@slib@spure@sstrutils.nim.o \
c_code/4_2/@m..@slib@spure@spathnorm.nim.o \
c_code/4_2/@m..@slib@sstd@soserrors.nim.o \
c_code/4_2/@m..@slib@sstd@ssyncio.nim.o \
c_code/4_2/@m..@slib@sposix@sposix.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/4_2/@m..@slib@spure@stimes.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/4_2/@m..@slib@sstd@senvvars.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/4_2/@m..@slib@sstd@scmdline.nim.o \
c_code/4_2/@m..@slib@spure@sos.nim.o \
c_code/4_2/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/4_2/@m..@slib@spure@shashes.nim.o \
c_code/4_2/@m..@slib@spure@sstrtabs.nim.o \
c_code/4_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/4_2/@m..@slib@spure@sstrformat.nim.o \
c_code/4_2/@m..@slib@spure@sterminal.nim.o \
c_code/4_2/@mpathutils.nim.o \
c_code/4_2/@mropes.nim.o \
c_code/4_2/@mlineinfos.nim.o \
c_code/4_2/@mplatform.nim.o \
c_code/4_2/@mprefixmatches.nim.o \
c_code/4_2/@mnimpaths.nim.o \
c_code/4_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/4_2/@moptions.nim.o \
c_code/4_2/@mmsgs.nim.o \
c_code/4_2/@mcondsyms.nim.o \
c_code/4_2/@mwordrecg.nim.o \
c_code/4_2/@midents.nim.o \
c_code/4_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/4_2/@mast.nim.o \
c_code/4_2/@mllstream.nim.o \
c_code/4_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/4_2/@mrenderer.nim.o \
c_code/4_2/@mmodulepaths.nim.o \
c_code/4_2/@m..@slib@spure@sstreams.nim.o \
c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/4_2/@m..@slib@sstd@smonotimes.nim.o \
c_code/4_2/@m..@slib@spure@sosproc.nim.o \
c_code/4_2/@m..@slib@spure@slexbase.nim.o \
c_code/4_2/@m..@slib@spure@sparsejson.nim.o \
c_code/4_2/@m..@slib@spure@sjson.nim.o \
c_code/4_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_2/@mextccomp.nim.o \
c_code/4_2/@mnimblecmd.nim.o \
c_code/4_2/@mcommands.nim.o \
c_code/4_2/@mparser.nim.o \
c_code/4_2/@mfilters.nim.o \
c_code/4_2/@mfilter_tmpl.nim.o \
c_code/4_2/@msyntaxes.nim.o \
c_code/4_2/@mrodutils.nim.o \
c_code/4_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/4_2/@mastyaml.nim.o \
c_code/4_2/@mastalgo.nim.o \
c_code/4_2/@mtrees.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_2/@mbtrees.nim.o \
c_code/4_2/@mpackages.nim.o \
c_code/4_2/@msuggestsymdb.nim.o \
c_code/4_2/@mic@srodfiles.nim.o \
c_code/4_2/@mic@sbitabs.nim.o \
c_code/4_2/@mic@siclineinfos.nim.o \
c_code/4_2/@mic@spacked_ast.nim.o \
c_code/4_2/@mic@sic.nim.o \
c_code/4_2/@mmodulegraphs.nim.o \
c_code/4_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/4_2/@mastmsgs.nim.o \
c_code/4_2/@mtypes.nim.o \
c_code/4_2/@mnimsets.nim.o \
c_code/4_2/@mndi.nim.o \
c_code/4_2/@mcgendata.nim.o \
c_code/4_2/@mmangleutils.nim.o \
c_code/4_2/@mccgutils.nim.o \
c_code/4_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/4_2/@mguards.nim.o \
c_code/4_2/@msemfold.nim.o \
c_code/4_2/@mvmdef.nim.o \
c_code/4_2/@msemdata.nim.o \
c_code/4_2/@mtypeallowed.nim.o \
c_code/4_2/@misolation_check.nim.o \
c_code/4_2/@mvarpartitions.nim.o \
c_code/4_2/@mnilcheck.nim.o \
c_code/4_2/@merrorhandling.nim.o \
c_code/4_2/@maliasanalysis.nim.o \
c_code/4_2/@msemstrictfuncs.nim.o \
c_code/4_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/4_2/@mlookups.nim.o \
c_code/4_2/@mlinter.nim.o \
c_code/4_2/@msemtypinst.nim.o \
c_code/4_2/@mparampatterns.nim.o \
c_code/4_2/@mlowerings.nim.o \
c_code/4_2/@mconcepts.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/4_2/@mpragmas.nim.o \
c_code/4_2/@mpushpoppragmas.nim.o \
c_code/4_2/@msighashes.nim.o \
c_code/4_2/@mliftdestructors.nim.o \
c_code/4_2/@msempass2.nim.o \
c_code/4_2/@mcgmeth.nim.o \
c_code/4_2/@maliases.nim.o \
c_code/4_2/@mliftlocals.nim.o \
c_code/4_2/@mlambdalifting.nim.o \
c_code/4_2/@mclosureiters.nim.o \
c_code/4_2/@mtransf.nim.o \
c_code/4_2/@moptimizer.nim.o \
c_code/4_2/@mdfa.nim.o \
c_code/4_2/@minjectdestructors.nim.o \
c_code/4_2/@mexpanddefaults.nim.o \
c_code/4_2/@mpipelineutils.nim.o \
c_code/4_2/@mspawn.nim.o \
c_code/4_2/@msemparallel.nim.o \
c_code/4_2/@m..@slib@spure@sdynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/4_2/@mmodules.nim.o \
c_code/4_2/@msemmacrosanity.nim.o \
c_code/4_2/@mvmgen.nim.o \
c_code/4_2/@mvmdeps.nim.o \
c_code/4_2/@mgorgeimpl.nim.o \
c_code/4_2/@mmacrocacheimpl.nim.o \
c_code/4_2/@mvmprofiler.nim.o \
c_code/4_2/@mevaltempl.nim.o \
c_code/4_2/@mvmconv.nim.o \
c_code/4_2/@mvmmarshal.nim.o \
c_code/4_2/@mvm.nim.o \
c_code/4_2/@mimporter.nim.o \
c_code/4_2/@mprocfind.nim.o \
c_code/4_2/@mpatterns.nim.o \
c_code/4_2/@mpluginsupport.nim.o \
c_code/4_2/@mplugins@slocals.nim.o \
c_code/4_2/@mplugins@sitersgen.nim.o \
c_code/4_2/@mplugins@sactive.nim.o \
c_code/4_2/@menumtostr.nim.o \
c_code/4_2/@mvtables.nim.o \
c_code/4_2/@msem.nim.o \
c_code/4_2/@mreorder.nim.o \
c_code/4_2/@mdepends.nim.o \
c_code/4_2/@msourcemap.nim.o \
c_code/4_2/@mjsgen.nim.o \
c_code/4_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/4_2/@mtypesrenderer.nim.o \
c_code/4_2/@mrenderverbatim.nim.o \
c_code/4_2/@m..@slib@spure@sxmltree.nim.o \
c_code/4_2/@m..@slib@spure@suri.nim.o \
c_code/4_2/@mdocgen.nim.o \
c_code/4_2/@mdocgen2.nim.o \
c_code/4_2/@mic@sreplayer.nim.o \
c_code/4_2/@mpipelines.nim.o \
c_code/4_2/@mscriptconfig.nim.o \
c_code/4_2/@mnimconf.nim.o \
c_code/4_2/@mic@sdce.nim.o \
c_code/4_2/@mic@scbackend.nim.o \
c_code/4_2/@mic@sintegrity.nim.o \
c_code/4_2/@mic@snavigator.nim.o \
c_code/4_2/@mmain.nim.o \
c_code/4_2/@mcmdlinehelper.nim.o \
c_code/4_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/4_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@ssystem@sexceptions.nim.c -o c_code/4_8/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sassertions.nim.c -o c_code/4_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/4_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/4_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@ssystem.nim.c -o c_code/4_8/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sparseutils.nim.c -o c_code/4_8/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@smath.nim.c -o c_code/4_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@salgorithm.nim.c -o c_code/4_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sunicode.nim.c -o c_code/4_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sstrutils.nim.c -o c_code/4_8/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@spathnorm.nim.c -o c_code/4_8/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@sstd@soserrors.nim.c -o c_code/4_8/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@sstd@ssyncio.nim.c -o c_code/4_8/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sposix@sposix.nim.c -o c_code/4_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/4_8/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@stimes.nim.c -o c_code/4_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/4_8/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@sstd@senvvars.nim.c -o c_code/4_8/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@scmdline.nim.c -o c_code/4_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sos.nim.c -o c_code/4_8/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sparseopt.nim.c -o c_code/4_8/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@shashes.nim.c -o c_code/4_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sstrtabs.nim.c -o c_code/4_8/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@scollections@stables.nim.c -o c_code/4_8/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sstrformat.nim.c -o c_code/4_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sterminal.nim.c -o c_code/4_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpathutils.nim.c -o c_code/4_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mropes.nim.c -o c_code/4_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlineinfos.nim.c -o c_code/4_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mplatform.nim.c -o c_code/4_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprefixmatches.nim.c -o c_code/4_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimpaths.nim.c -o c_code/4_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/4_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@moptions.nim.c -o c_code/4_8/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmsgs.nim.c -o c_code/4_8/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcondsyms.nim.c -o c_code/4_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mwordrecg.nim.c -o c_code/4_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@midents.nim.c -o c_code/4_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mint128.nim.c -o c_code/4_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mast.nim.c -o c_code/4_8/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mllstream.nim.c -o c_code/4_8/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimlexbase.nim.c -o c_code/4_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlexer.nim.c -o c_code/4_8/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mrenderer.nim.c -o c_code/4_8/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulepaths.nim.c -o c_code/4_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sstreams.nim.c -o c_code/4_8/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@smonotimes.nim.c -o c_code/4_1/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sosproc.nim.c -o c_code/4_8/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@slexbase.nim.c -o c_code/4_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sparsejson.nim.c -o c_code/4_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sjson.nim.c -o c_code/4_8/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/4_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mextccomp.nim.c -o c_code/4_8/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnimblecmd.nim.c -o c_code/4_8/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcommands.nim.c -o c_code/4_8/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mparser.nim.c -o c_code/4_8/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilters.nim.c -o c_code/4_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mfilter_tmpl.nim.c -o c_code/4_8/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msyntaxes.nim.c -o c_code/4_8/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrodutils.nim.c -o c_code/4_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/4_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastyaml.nim.c -o c_code/4_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mastalgo.nim.c -o c_code/4_8/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtrees.nim.c -o c_code/4_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mbtrees.nim.c -o c_code/4_8/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpackages.nim.c -o c_code/4_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msuggestsymdb.nim.c -o c_code/4_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@srodfiles.nim.c -o c_code/4_8/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sbitabs.nim.c -o c_code/4_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@siclineinfos.nim.c -o c_code/4_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@spacked_ast.nim.c -o c_code/4_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sic.nim.c -o c_code/4_8/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulegraphs.nim.c -o c_code/4_8/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmagicsys.nim.c -o c_code/4_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastmsgs.nim.c -o c_code/4_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypes.nim.c -o c_code/4_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimsets.nim.c -o c_code/4_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mndi.nim.c -o c_code/4_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcgendata.nim.c -o c_code/4_8/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmangleutils.nim.c -o c_code/4_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mccgutils.nim.c -o c_code/4_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtreetab.nim.c -o c_code/4_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mguards.nim.c -o c_code/4_8/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemfold.nim.c -o c_code/4_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvmdef.nim.c -o c_code/4_8/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemdata.nim.c -o c_code/4_8/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypeallowed.nim.c -o c_code/4_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@misolation_check.nim.c -o c_code/4_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvarpartitions.nim.c -o c_code/4_8/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnilcheck.nim.c -o c_code/4_8/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@merrorhandling.nim.c -o c_code/4_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliasanalysis.nim.c -o c_code/4_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemstrictfuncs.nim.c -o c_code/4_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/4_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/4_8/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlookups.nim.c -o c_code/4_8/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlinter.nim.c -o c_code/4_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemtypinst.nim.c -o c_code/4_8/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparampatterns.nim.c -o c_code/4_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlowerings.nim.c -o c_code/4_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mconcepts.nim.c -o c_code/4_8/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msigmatch.nim.c -o c_code/4_8/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mpragmas.nim.c -o c_code/4_8/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpushpoppragmas.nim.c -o c_code/4_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msighashes.nim.c -o c_code/4_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mliftdestructors.nim.c -o c_code/4_8/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msempass2.nim.c -o c_code/4_8/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgmeth.nim.c -o c_code/4_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliases.nim.c -o c_code/4_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mliftlocals.nim.c -o c_code/4_8/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlambdalifting.nim.c -o c_code/4_8/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mclosureiters.nim.c -o c_code/4_8/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtransf.nim.c -o c_code/4_8/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@moptimizer.nim.c -o c_code/4_8/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdfa.nim.c -o c_code/4_8/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@minjectdestructors.nim.c -o c_code/4_8/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mexpanddefaults.nim.c -o c_code/4_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelineutils.nim.c -o c_code/4_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mspawn.nim.c -o c_code/4_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemparallel.nim.c -o c_code/4_8/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sdynlib.nim.c -o c_code/4_8/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcgen.nim.c -o c_code/4_8/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodules.nim.c -o c_code/4_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemmacrosanity.nim.c -o c_code/4_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvmgen.nim.c -o c_code/4_8/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdeps.nim.c -o c_code/4_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mgorgeimpl.nim.c -o c_code/4_8/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmacrocacheimpl.nim.c -o c_code/4_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmprofiler.nim.c -o c_code/4_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mevaltempl.nim.c -o c_code/4_8/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmconv.nim.c -o c_code/4_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmmarshal.nim.c -o c_code/4_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvm.nim.c -o c_code/4_8/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mimporter.nim.c -o c_code/4_8/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mprocfind.nim.c -o c_code/4_8/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mpatterns.nim.c -o c_code/4_8/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpluginsupport.nim.c -o c_code/4_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@slocals.nim.c -o c_code/4_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sitersgen.nim.c -o c_code/4_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sactive.nim.c -o c_code/4_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@menumtostr.nim.c -o c_code/4_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvtables.nim.c -o c_code/4_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msem.nim.c -o c_code/4_8/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mreorder.nim.c -o c_code/4_8/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdepends.nim.c -o c_code/4_8/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msourcemap.nim.c -o c_code/4_8/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mjsgen.nim.c -o c_code/4_8/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/4_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/4_8/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/4_8/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypesrenderer.nim.c -o c_code/4_8/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mrenderverbatim.nim.c -o c_code/4_8/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@sxmltree.nim.c -o c_code/4_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@slib@spure@suri.nim.c -o c_code/4_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen.nim.c -o c_code/4_8/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sreplayer.nim.c -o c_code/4_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelines.nim.c -o c_code/4_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mscriptconfig.nim.c -o c_code/4_8/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnimconf.nim.c -o c_code/4_8/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sdce.nim.c -o c_code/4_8/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@scbackend.nim.c -o c_code/4_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sintegrity.nim.c -o c_code/4_8/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@snavigator.nim.c -o c_code/4_8/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmain.nim.c -o c_code/4_8/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcmdlinehelper.nim.c -o c_code/4_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@slib@spure@sbrowsers.nim.c -o c_code/4_8/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnim.nim.c -o c_code/4_8/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_8/@m..@slib@ssystem@sexceptions.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/4_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/4_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/4_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/4_8/@m..@slib@ssystem.nim.o \
c_code/4_8/@m..@slib@spure@sparseutils.nim.o \
c_code/4_1/@m..@slib@spure@smath.nim.o \
c_code/4_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/4_1/@m..@slib@spure@sunicode.nim.o \
c_code/4_8/@m..@slib@spure@sstrutils.nim.o \
c_code/4_8/@m..@slib@spure@spathnorm.nim.o \
c_code/4_8/@m..@slib@sstd@soserrors.nim.o \
c_code/4_8/@m..@slib@sstd@ssyncio.nim.o \
c_code/4_1/@m..@slib@sposix@sposix.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/4_8/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/4_1/@m..@slib@spure@stimes.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/4_8/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/4_8/@m..@slib@sstd@senvvars.nim.o \
c_code/4_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/4_1/@m..@slib@sstd@scmdline.nim.o \
c_code/4_8/@m..@slib@spure@sos.nim.o \
c_code/4_8/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/4_1/@m..@slib@spure@shashes.nim.o \
c_code/4_8/@m..@slib@spure@sstrtabs.nim.o \
c_code/4_8/@m..@slib@spure@scollections@stables.nim.o \
c_code/4_1/@m..@slib@spure@sstrformat.nim.o \
c_code/4_1/@m..@slib@spure@sterminal.nim.o \
c_code/4_1/@mpathutils.nim.o \
c_code/4_1/@mropes.nim.o \
c_code/4_1/@mlineinfos.nim.o \
c_code/4_8/@mplatform.nim.o \
c_code/4_1/@mprefixmatches.nim.o \
c_code/4_1/@mnimpaths.nim.o \
c_code/4_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/4_8/@moptions.nim.o \
c_code/4_8/@mmsgs.nim.o \
c_code/4_1/@mcondsyms.nim.o \
c_code/4_1/@mwordrecg.nim.o \
c_code/4_1/@midents.nim.o \
c_code/4_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/4_8/@mast.nim.o \
c_code/4_8/@mllstream.nim.o \
c_code/4_1/@mnimlexbase.nim.o \
c_code/4_8/@mlexer.nim.o \
c_code/4_8/@mrenderer.nim.o \
c_code/4_1/@mmodulepaths.nim.o \
c_code/4_8/@m..@slib@spure@sstreams.nim.o \
c_code/4_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/4_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/4_1/@m..@slib@sstd@smonotimes.nim.o \
c_code/4_8/@m..@slib@spure@sosproc.nim.o \
c_code/4_1/@m..@slib@spure@slexbase.nim.o \
c_code/4_1/@m..@slib@spure@sparsejson.nim.o \
c_code/4_8/@m..@slib@spure@sjson.nim.o \
c_code/4_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_8/@mextccomp.nim.o \
c_code/4_8/@mnimblecmd.nim.o \
c_code/4_8/@mcommands.nim.o \
c_code/4_8/@mparser.nim.o \
c_code/4_1/@mfilters.nim.o \
c_code/4_8/@mfilter_tmpl.nim.o \
c_code/4_8/@msyntaxes.nim.o \
c_code/4_1/@mrodutils.nim.o \
c_code/4_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/4_1/@mastyaml.nim.o \
c_code/4_8/@mastalgo.nim.o \
c_code/4_1/@mtrees.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_8/@mbtrees.nim.o \
c_code/4_1/@mpackages.nim.o \
c_code/4_1/@msuggestsymdb.nim.o \
c_code/4_8/@mic@srodfiles.nim.o \
c_code/4_1/@mic@sbitabs.nim.o \
c_code/4_1/@mic@siclineinfos.nim.o \
c_code/4_1/@mic@spacked_ast.nim.o \
c_code/4_8/@mic@sic.nim.o \
c_code/4_8/@mmodulegraphs.nim.o \
c_code/4_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/4_1/@mastmsgs.nim.o \
c_code/4_1/@mtypes.nim.o \
c_code/4_1/@mnimsets.nim.o \
c_code/4_1/@mndi.nim.o \
c_code/4_8/@mcgendata.nim.o \
c_code/4_1/@mmangleutils.nim.o \
c_code/4_1/@mccgutils.nim.o \
c_code/4_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/4_8/@mguards.nim.o \
c_code/4_1/@msemfold.nim.o \
c_code/4_8/@mvmdef.nim.o \
c_code/4_8/@msemdata.nim.o \
c_code/4_1/@mtypeallowed.nim.o \
c_code/4_1/@misolation_check.nim.o \
c_code/4_8/@mvarpartitions.nim.o \
c_code/4_8/@mnilcheck.nim.o \
c_code/4_1/@merrorhandling.nim.o \
c_code/4_1/@maliasanalysis.nim.o \
c_code/4_1/@msemstrictfuncs.nim.o \
c_code/4_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/4_8/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/4_8/@mlookups.nim.o \
c_code/4_1/@mlinter.nim.o \
c_code/4_8/@msemtypinst.nim.o \
c_code/4_1/@mparampatterns.nim.o \
c_code/4_1/@mlowerings.nim.o \
c_code/4_8/@mconcepts.nim.o \
c_code/4_8/@msigmatch.nim.o \
c_code/4_8/@mpragmas.nim.o \
c_code/4_1/@mpushpoppragmas.nim.o \
c_code/4_1/@msighashes.nim.o \
c_code/4_8/@mliftdestructors.nim.o \
c_code/4_8/@msempass2.nim.o \
c_code/4_1/@mcgmeth.nim.o \
c_code/4_1/@maliases.nim.o \
c_code/4_8/@mliftlocals.nim.o \
c_code/4_8/@mlambdalifting.nim.o \
c_code/4_8/@mclosureiters.nim.o \
c_code/4_8/@mtransf.nim.o \
c_code/4_8/@moptimizer.nim.o \
c_code/4_8/@mdfa.nim.o \
c_code/4_8/@minjectdestructors.nim.o \
c_code/4_1/@mexpanddefaults.nim.o \
c_code/4_1/@mpipelineutils.nim.o \
c_code/4_1/@mspawn.nim.o \
c_code/4_8/@msemparallel.nim.o \
c_code/4_8/@m..@slib@spure@sdynlib.nim.o \
c_code/4_8/@mcgen.nim.o \
c_code/4_1/@mmodules.nim.o \
c_code/4_1/@msemmacrosanity.nim.o \
c_code/4_8/@mvmgen.nim.o \
c_code/4_1/@mvmdeps.nim.o \
c_code/4_8/@mgorgeimpl.nim.o \
c_code/4_1/@mmacrocacheimpl.nim.o \
c_code/4_1/@mvmprofiler.nim.o \
c_code/4_8/@mevaltempl.nim.o \
c_code/4_1/@mvmconv.nim.o \
c_code/4_1/@mvmmarshal.nim.o \
c_code/4_8/@mvm.nim.o \
c_code/4_8/@mimporter.nim.o \
c_code/4_8/@mprocfind.nim.o \
c_code/4_8/@mpatterns.nim.o \
c_code/4_1/@mpluginsupport.nim.o \
c_code/4_1/@mplugins@slocals.nim.o \
c_code/4_1/@mplugins@sitersgen.nim.o \
c_code/4_1/@mplugins@sactive.nim.o \
c_code/4_1/@menumtostr.nim.o \
c_code/4_1/@mvtables.nim.o \
c_code/4_8/@msem.nim.o \
c_code/4_8/@mreorder.nim.o \
c_code/4_8/@mdepends.nim.o \
c_code/4_8/@msourcemap.nim.o \
c_code/4_8/@mjsgen.nim.o \
c_code/4_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/4_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/4_8/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/4_8/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/4_8/@mtypesrenderer.nim.o \
c_code/4_8/@mrenderverbatim.nim.o \
c_code/4_1/@m..@slib@spure@sxmltree.nim.o \
c_code/4_1/@m..@slib@spure@suri.nim.o \
c_code/4_8/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/4_1/@mic@sreplayer.nim.o \
c_code/4_1/@mpipelines.nim.o \
c_code/4_8/@mscriptconfig.nim.o \
c_code/4_8/@mnimconf.nim.o \
c_code/4_8/@mic@sdce.nim.o \
c_code/4_1/@mic@scbackend.nim.o \
c_code/4_8/@mic@sintegrity.nim.o \
c_code/4_8/@mic@snavigator.nim.o \
c_code/4_8/@mmain.nim.o \
c_code/4_1/@mcmdlinehelper.nim.o \
c_code/4_8/@m..@slib@spure@sbrowsers.nim.o \
c_code/4_8/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@ssystem@sexceptions.nim.c -o c_code/4_9/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sassertions.nim.c -o c_code/4_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/4_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/4_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@ssystem.nim.c -o c_code/4_9/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sparseutils.nim.c -o c_code/4_9/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@smath.nim.c -o c_code/4_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@salgorithm.nim.c -o c_code/4_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sunicode.nim.c -o c_code/4_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sstrutils.nim.c -o c_code/4_9/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@spathnorm.nim.c -o c_code/4_9/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@sstd@soserrors.nim.c -o c_code/4_9/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@sstd@ssyncio.nim.c -o c_code/4_9/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sposix@sposix.nim.c -o c_code/4_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/4_9/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@stimes.nim.c -o c_code/4_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/4_9/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@sstd@senvvars.nim.c -o c_code/4_9/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@scmdline.nim.c -o c_code/4_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sos.nim.c -o c_code/4_9/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sparseopt.nim.c -o c_code/4_9/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@shashes.nim.c -o c_code/4_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sstrtabs.nim.c -o c_code/4_9/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/4_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sstrformat.nim.c -o c_code/4_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sterminal.nim.c -o c_code/4_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpathutils.nim.c -o c_code/4_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mropes.nim.c -o c_code/4_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlineinfos.nim.c -o c_code/4_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mplatform.nim.c -o c_code/4_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprefixmatches.nim.c -o c_code/4_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimpaths.nim.c -o c_code/4_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/4_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@moptions.nim.c -o c_code/4_9/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmsgs.nim.c -o c_code/4_9/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcondsyms.nim.c -o c_code/4_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mwordrecg.nim.c -o c_code/4_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@midents.nim.c -o c_code/4_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mint128.nim.c -o c_code/4_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mast.nim.c -o c_code/4_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mllstream.nim.c -o c_code/4_9/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimlexbase.nim.c -o c_code/4_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mrenderer.nim.c -o c_code/4_9/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulepaths.nim.c -o c_code/4_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sstreams.nim.c -o c_code/4_9/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@smonotimes.nim.c -o c_code/4_2/@m..@slib@sstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sosproc.nim.c -o c_code/4_9/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@slexbase.nim.c -o c_code/4_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sparsejson.nim.c -o c_code/4_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sjson.nim.c -o c_code/4_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/4_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mextccomp.nim.c -o c_code/4_9/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnimblecmd.nim.c -o c_code/4_9/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcommands.nim.c -o c_code/4_9/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mparser.nim.c -o c_code/4_9/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilters.nim.c -o c_code/4_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mfilter_tmpl.nim.c -o c_code/4_9/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msyntaxes.nim.c -o c_code/4_9/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrodutils.nim.c -o c_code/4_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/4_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastyaml.nim.c -o c_code/4_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastalgo.nim.c -o c_code/4_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtrees.nim.c -o c_code/4_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mbtrees.nim.c -o c_code/4_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpackages.nim.c -o c_code/4_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msuggestsymdb.nim.c -o c_code/4_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mic@srodfiles.nim.c -o c_code/4_9/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sbitabs.nim.c -o c_code/4_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@siclineinfos.nim.c -o c_code/4_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@spacked_ast.nim.c -o c_code/4_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mic@sic.nim.c -o c_code/4_9/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulegraphs.nim.c -o c_code/4_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmagicsys.nim.c -o c_code/4_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastmsgs.nim.c -o c_code/4_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypes.nim.c -o c_code/4_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimsets.nim.c -o c_code/4_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mndi.nim.c -o c_code/4_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgendata.nim.c -o c_code/4_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmangleutils.nim.c -o c_code/4_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mccgutils.nim.c -o c_code/4_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtreetab.nim.c -o c_code/4_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mguards.nim.c -o c_code/4_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemfold.nim.c -o c_code/4_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdef.nim.c -o c_code/4_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemdata.nim.c -o c_code/4_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypeallowed.nim.c -o c_code/4_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@misolation_check.nim.c -o c_code/4_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvarpartitions.nim.c -o c_code/4_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnilcheck.nim.c -o c_code/4_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@merrorhandling.nim.c -o c_code/4_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliasanalysis.nim.c -o c_code/4_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemstrictfuncs.nim.c -o c_code/4_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/4_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlookups.nim.c -o c_code/4_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlinter.nim.c -o c_code/4_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemtypinst.nim.c -o c_code/4_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparampatterns.nim.c -o c_code/4_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlowerings.nim.c -o c_code/4_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mconcepts.nim.c -o c_code/4_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mpragmas.nim.c -o c_code/4_9/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpushpoppragmas.nim.c -o c_code/4_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msighashes.nim.c -o c_code/4_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftdestructors.nim.c -o c_code/4_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msempass2.nim.c -o c_code/4_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgmeth.nim.c -o c_code/4_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliases.nim.c -o c_code/4_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftlocals.nim.c -o c_code/4_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlambdalifting.nim.c -o c_code/4_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mclosureiters.nim.c -o c_code/4_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtransf.nim.c -o c_code/4_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptimizer.nim.c -o c_code/4_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdfa.nim.c -o c_code/4_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@minjectdestructors.nim.c -o c_code/4_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mexpanddefaults.nim.c -o c_code/4_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelineutils.nim.c -o c_code/4_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mspawn.nim.c -o c_code/4_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemparallel.nim.c -o c_code/4_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sdynlib.nim.c -o c_code/4_9/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcgen.nim.c -o c_code/4_9/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodules.nim.c -o c_code/4_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemmacrosanity.nim.c -o c_code/4_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmgen.nim.c -o c_code/4_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdeps.nim.c -o c_code/4_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mgorgeimpl.nim.c -o c_code/4_9/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmacrocacheimpl.nim.c -o c_code/4_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmprofiler.nim.c -o c_code/4_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mevaltempl.nim.c -o c_code/4_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmconv.nim.c -o c_code/4_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmmarshal.nim.c -o c_code/4_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mvm.nim.c -o c_code/4_9/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mimporter.nim.c -o c_code/4_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprocfind.nim.c -o c_code/4_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpatterns.nim.c -o c_code/4_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpluginsupport.nim.c -o c_code/4_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@slocals.nim.c -o c_code/4_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sitersgen.nim.c -o c_code/4_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sactive.nim.c -o c_code/4_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@menumtostr.nim.c -o c_code/4_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvtables.nim.c -o c_code/4_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msem.nim.c -o c_code/4_9/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mreorder.nim.c -o c_code/4_9/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mdepends.nim.c -o c_code/4_9/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msourcemap.nim.c -o c_code/4_9/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mjsgen.nim.c -o c_code/4_9/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/4_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/4_9/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/4_9/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mtypesrenderer.nim.c -o c_code/4_9/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderverbatim.nim.c -o c_code/4_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@sxmltree.nim.c -o c_code/4_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@slib@spure@suri.nim.c -o c_code/4_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mdocgen.nim.c -o c_code/4_9/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen2.nim.c -o c_code/4_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sreplayer.nim.c -o c_code/4_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelines.nim.c -o c_code/4_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mscriptconfig.nim.c -o c_code/4_9/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnimconf.nim.c -o c_code/4_9/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sdce.nim.c -o c_code/4_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@scbackend.nim.c -o c_code/4_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sintegrity.nim.c -o c_code/4_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@snavigator.nim.c -o c_code/4_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmain.nim.c -o c_code/4_9/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcmdlinehelper.nim.c -o c_code/4_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@slib@spure@sbrowsers.nim.c -o c_code/4_9/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnim.nim.c -o c_code/4_9/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_9/@m..@slib@ssystem@sexceptions.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/4_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/4_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/4_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/4_9/@m..@slib@ssystem.nim.o \
c_code/4_9/@m..@slib@spure@sparseutils.nim.o \
c_code/4_2/@m..@slib@spure@smath.nim.o \
c_code/4_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/4_2/@m..@slib@spure@sunicode.nim.o \
c_code/4_9/@m..@slib@spure@sstrutils.nim.o \
c_code/4_9/@m..@slib@spure@spathnorm.nim.o \
c_code/4_9/@m..@slib@sstd@soserrors.nim.o \
c_code/4_9/@m..@slib@sstd@ssyncio.nim.o \
c_code/4_2/@m..@slib@sposix@sposix.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/4_9/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/4_2/@m..@slib@spure@stimes.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/4_9/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/4_9/@m..@slib@sstd@senvvars.nim.o \
c_code/4_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/4_2/@m..@slib@sstd@scmdline.nim.o \
c_code/4_9/@m..@slib@spure@sos.nim.o \
c_code/4_9/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/4_2/@m..@slib@spure@shashes.nim.o \
c_code/4_9/@m..@slib@spure@sstrtabs.nim.o \
c_code/4_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/4_2/@m..@slib@spure@sstrformat.nim.o \
c_code/4_2/@m..@slib@spure@sterminal.nim.o \
c_code/4_2/@mpathutils.nim.o \
c_code/4_2/@mropes.nim.o \
c_code/4_2/@mlineinfos.nim.o \
c_code/4_9/@mplatform.nim.o \
c_code/4_2/@mprefixmatches.nim.o \
c_code/4_2/@mnimpaths.nim.o \
c_code/4_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/4_9/@moptions.nim.o \
c_code/4_9/@mmsgs.nim.o \
c_code/4_2/@mcondsyms.nim.o \
c_code/4_2/@mwordrecg.nim.o \
c_code/4_2/@midents.nim.o \
c_code/4_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/4_2/@mast.nim.o \
c_code/4_9/@mllstream.nim.o \
c_code/4_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/4_9/@mrenderer.nim.o \
c_code/4_2/@mmodulepaths.nim.o \
c_code/4_9/@m..@slib@spure@sstreams.nim.o \
c_code/4_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/4_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/4_2/@m..@slib@sstd@smonotimes.nim.o \
c_code/4_9/@m..@slib@spure@sosproc.nim.o \
c_code/4_2/@m..@slib@spure@slexbase.nim.o \
c_code/4_2/@m..@slib@spure@sparsejson.nim.o \
c_code/4_2/@m..@slib@spure@sjson.nim.o \
c_code/4_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_9/@mextccomp.nim.o \
c_code/4_9/@mnimblecmd.nim.o \
c_code/4_9/@mcommands.nim.o \
c_code/4_9/@mparser.nim.o \
c_code/4_2/@mfilters.nim.o \
c_code/4_9/@mfilter_tmpl.nim.o \
c_code/4_9/@msyntaxes.nim.o \
c_code/4_2/@mrodutils.nim.o \
c_code/4_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/4_2/@mastyaml.nim.o \
c_code/4_2/@mastalgo.nim.o \
c_code/4_2/@mtrees.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_2/@mbtrees.nim.o \
c_code/4_2/@mpackages.nim.o \
c_code/4_2/@msuggestsymdb.nim.o \
c_code/4_9/@mic@srodfiles.nim.o \
c_code/4_2/@mic@sbitabs.nim.o \
c_code/4_2/@mic@siclineinfos.nim.o \
c_code/4_2/@mic@spacked_ast.nim.o \
c_code/4_9/@mic@sic.nim.o \
c_code/4_2/@mmodulegraphs.nim.o \
c_code/4_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/4_2/@mastmsgs.nim.o \
c_code/4_2/@mtypes.nim.o \
c_code/4_2/@mnimsets.nim.o \
c_code/4_2/@mndi.nim.o \
c_code/4_2/@mcgendata.nim.o \
c_code/4_2/@mmangleutils.nim.o \
c_code/4_2/@mccgutils.nim.o \
c_code/4_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/4_2/@mguards.nim.o \
c_code/4_2/@msemfold.nim.o \
c_code/4_2/@mvmdef.nim.o \
c_code/4_2/@msemdata.nim.o \
c_code/4_2/@mtypeallowed.nim.o \
c_code/4_2/@misolation_check.nim.o \
c_code/4_2/@mvarpartitions.nim.o \
c_code/4_2/@mnilcheck.nim.o \
c_code/4_2/@merrorhandling.nim.o \
c_code/4_2/@maliasanalysis.nim.o \
c_code/4_2/@msemstrictfuncs.nim.o \
c_code/4_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/4_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/4_2/@mlookups.nim.o \
c_code/4_2/@mlinter.nim.o \
c_code/4_2/@msemtypinst.nim.o \
c_code/4_2/@mparampatterns.nim.o \
c_code/4_2/@mlowerings.nim.o \
c_code/4_2/@mconcepts.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/4_9/@mpragmas.nim.o \
c_code/4_2/@mpushpoppragmas.nim.o \
c_code/4_2/@msighashes.nim.o \
c_code/4_2/@mliftdestructors.nim.o \
c_code/4_2/@msempass2.nim.o \
c_code/4_2/@mcgmeth.nim.o \
c_code/4_2/@maliases.nim.o \
c_code/4_2/@mliftlocals.nim.o \
c_code/4_2/@mlambdalifting.nim.o \
c_code/4_2/@mclosureiters.nim.o \
c_code/4_2/@mtransf.nim.o \
c_code/4_2/@moptimizer.nim.o \
c_code/4_2/@mdfa.nim.o \
c_code/4_2/@minjectdestructors.nim.o \
c_code/4_2/@mexpanddefaults.nim.o \
c_code/4_2/@mpipelineutils.nim.o \
c_code/4_2/@mspawn.nim.o \
c_code/4_2/@msemparallel.nim.o \
c_code/4_9/@m..@slib@spure@sdynlib.nim.o \
c_code/4_9/@mcgen.nim.o \
c_code/4_2/@mmodules.nim.o \
c_code/4_2/@msemmacrosanity.nim.o \
c_code/4_2/@mvmgen.nim.o \
c_code/4_2/@mvmdeps.nim.o \
c_code/4_9/@mgorgeimpl.nim.o \
c_code/4_2/@mmacrocacheimpl.nim.o \
c_code/4_2/@mvmprofiler.nim.o \
c_code/4_2/@mevaltempl.nim.o \
c_code/4_2/@mvmconv.nim.o \
c_code/4_2/@mvmmarshal.nim.o \
c_code/4_9/@mvm.nim.o \
c_code/4_2/@mimporter.nim.o \
c_code/4_2/@mprocfind.nim.o \
c_code/4_2/@mpatterns.nim.o \
c_code/4_2/@mpluginsupport.nim.o \
c_code/4_2/@mplugins@slocals.nim.o \
c_code/4_2/@mplugins@sitersgen.nim.o \
c_code/4_2/@mplugins@sactive.nim.o \
c_code/4_2/@menumtostr.nim.o \
c_code/4_2/@mvtables.nim.o \
c_code/4_9/@msem.nim.o \
c_code/4_9/@mreorder.nim.o \
c_code/4_9/@mdepends.nim.o \
c_code/4_9/@msourcemap.nim.o \
c_code/4_9/@mjsgen.nim.o \
c_code/4_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/4_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/4_9/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/4_9/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/4_9/@mtypesrenderer.nim.o \
c_code/4_2/@mrenderverbatim.nim.o \
c_code/4_2/@m..@slib@spure@sxmltree.nim.o \
c_code/4_2/@m..@slib@spure@suri.nim.o \
c_code/4_9/@mdocgen.nim.o \
c_code/4_2/@mdocgen2.nim.o \
c_code/4_2/@mic@sreplayer.nim.o \
c_code/4_2/@mpipelines.nim.o \
c_code/4_9/@mscriptconfig.nim.o \
c_code/4_9/@mnimconf.nim.o \
c_code/4_2/@mic@sdce.nim.o \
c_code/4_2/@mic@scbackend.nim.o \
c_code/4_2/@mic@sintegrity.nim.o \
c_code/4_2/@mic@snavigator.nim.o \
c_code/4_9/@mmain.nim.o \
c_code/4_2/@mcmdlinehelper.nim.o \
c_code/4_9/@m..@slib@spure@sbrowsers.nim.o \
c_code/4_9/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
freebsd)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_1/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sassertions.nim.c -o c_code/5_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@ssystem.nim.c -o c_code/5_1/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sparseutils.nim.c -o c_code/5_1/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@smath.nim.c -o c_code/5_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@salgorithm.nim.c -o c_code/5_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sunicode.nim.c -o c_code/5_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstrutils.nim.c -o c_code/5_1/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@spathnorm.nim.c -o c_code/5_1/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@soserrors.nim.c -o c_code/5_1/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_1/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sposix@sposix.nim.c -o c_code/3_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@stimes.nim.c -o c_code/5_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@senvvars.nim.c -o c_code/5_1/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@scmdline.nim.c -o c_code/5_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sos.nim.c -o c_code/5_1/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sparseopt.nim.c -o c_code/5_1/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@shashes.nim.c -o c_code/5_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_1/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_1/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstrformat.nim.c -o c_code/5_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sterminal.nim.c -o c_code/5_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplatform.nim.c -o c_code/5_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@moptions.nim.c -o c_code/5_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmsgs.nim.c -o c_code/5_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mast.nim.c -o c_code/5_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mllstream.nim.c -o c_code/5_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlexer.nim.c -o c_code/5_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrenderer.nim.c -o c_code/5_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstreams.nim.c -o c_code/5_1/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sosproc.nim.c -o c_code/5_1/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@slexbase.nim.c -o c_code/5_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sparsejson.nim.c -o c_code/5_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sjson.nim.c -o c_code/5_1/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mextccomp.nim.c -o c_code/5_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimblecmd.nim.c -o c_code/5_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparser.nim.c -o c_code/5_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilter_tmpl.nim.c -o c_code/5_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msyntaxes.nim.c -o c_code/5_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastalgo.nim.c -o c_code/5_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mbtrees.nim.c -o c_code/5_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@srodfiles.nim.c -o c_code/5_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sic.nim.c -o c_code/5_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulegraphs.nim.c -o c_code/5_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mndi.nim.c -o c_code/5_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgendata.nim.c -o c_code/5_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mguards.nim.c -o c_code/5_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemfold.nim.c -o c_code/5_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdef.nim.c -o c_code/5_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemdata.nim.c -o c_code/5_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypeallowed.nim.c -o c_code/5_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@misolation_check.nim.c -o c_code/5_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvarpartitions.nim.c -o c_code/5_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnilcheck.nim.c -o c_code/5_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@merrorhandling.nim.c -o c_code/5_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliasanalysis.nim.c -o c_code/5_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemstrictfuncs.nim.c -o c_code/5_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_1/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlookups.nim.c -o c_code/5_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlinter.nim.c -o c_code/5_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemtypinst.nim.c -o c_code/5_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparampatterns.nim.c -o c_code/5_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlowerings.nim.c -o c_code/5_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mconcepts.nim.c -o c_code/5_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msigmatch.nim.c -o c_code/5_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpragmas.nim.c -o c_code/5_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpushpoppragmas.nim.c -o c_code/5_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msighashes.nim.c -o c_code/5_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mliftdestructors.nim.c -o c_code/5_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msempass2.nim.c -o c_code/5_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgmeth.nim.c -o c_code/5_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliases.nim.c -o c_code/5_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mliftlocals.nim.c -o c_code/5_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlambdalifting.nim.c -o c_code/5_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mclosureiters.nim.c -o c_code/5_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtransf.nim.c -o c_code/5_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@moptimizer.nim.c -o c_code/5_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdfa.nim.c -o c_code/5_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@minjectdestructors.nim.c -o c_code/5_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mexpanddefaults.nim.c -o c_code/5_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelineutils.nim.c -o c_code/5_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mspawn.nim.c -o c_code/5_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemparallel.nim.c -o c_code/5_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sdynlib.nim.c -o c_code/5_1/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgen.nim.c -o c_code/5_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodules.nim.c -o c_code/5_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemmacrosanity.nim.c -o c_code/5_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmgen.nim.c -o c_code/5_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmacrocacheimpl.nim.c -o c_code/5_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmprofiler.nim.c -o c_code/5_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mevaltempl.nim.c -o c_code/5_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmconv.nim.c -o c_code/5_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmmarshal.nim.c -o c_code/5_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvm.nim.c -o c_code/5_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mimporter.nim.c -o c_code/5_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprocfind.nim.c -o c_code/5_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpatterns.nim.c -o c_code/5_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpluginsupport.nim.c -o c_code/5_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@slocals.nim.c -o c_code/5_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sitersgen.nim.c -o c_code/5_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sactive.nim.c -o c_code/5_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@menumtostr.nim.c -o c_code/5_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvtables.nim.c -o c_code/5_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mreorder.nim.c -o c_code/5_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdepends.nim.c -o c_code/5_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msourcemap.nim.c -o c_code/5_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mjsgen.nim.c -o c_code/5_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypesrenderer.nim.c -o c_code/5_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrenderverbatim.nim.c -o c_code/5_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sxmltree.nim.c -o c_code/5_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@suri.nim.c -o c_code/5_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen.nim.c -o c_code/5_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen2.nim.c -o c_code/5_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sreplayer.nim.c -o c_code/5_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelines.nim.c -o c_code/5_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mscriptconfig.nim.c -o c_code/5_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimconf.nim.c -o c_code/5_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sdce.nim.c -o c_code/5_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@scbackend.nim.c -o c_code/5_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sintegrity.nim.c -o c_code/5_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@snavigator.nim.c -o c_code/5_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmain.nim.c -o c_code/5_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcmdlinehelper.nim.c -o c_code/5_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_1/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnim.nim.c -o c_code/5_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_1/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/5_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_1/@m..@slib@ssystem.nim.o \
c_code/5_1/@m..@slib@spure@sparseutils.nim.o \
c_code/5_1/@m..@slib@spure@smath.nim.o \
c_code/5_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/5_1/@m..@slib@spure@sunicode.nim.o \
c_code/5_1/@m..@slib@spure@sstrutils.nim.o \
c_code/5_1/@m..@slib@spure@spathnorm.nim.o \
c_code/5_1/@m..@slib@sstd@soserrors.nim.o \
c_code/5_1/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_1/@m..@slib@sposix@sposix.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_1/@m..@slib@spure@stimes.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_1/@m..@slib@sstd@senvvars.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_1/@m..@slib@sstd@scmdline.nim.o \
c_code/5_1/@m..@slib@spure@sos.nim.o \
c_code/5_1/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_1/@m..@slib@spure@shashes.nim.o \
c_code/5_1/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_1/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_1/@m..@slib@spure@sstrformat.nim.o \
c_code/5_1/@m..@slib@spure@sterminal.nim.o \
c_code/5_1/@mpathutils.nim.o \
c_code/5_1/@mropes.nim.o \
c_code/5_1/@mlineinfos.nim.o \
c_code/5_1/@mplatform.nim.o \
c_code/5_1/@mprefixmatches.nim.o \
c_code/5_1/@mnimpaths.nim.o \
c_code/5_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_1/@moptions.nim.o \
c_code/5_1/@mmsgs.nim.o \
c_code/5_1/@mcondsyms.nim.o \
c_code/5_1/@mwordrecg.nim.o \
c_code/5_1/@midents.nim.o \
c_code/5_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/5_1/@mast.nim.o \
c_code/5_1/@mllstream.nim.o \
c_code/5_1/@mnimlexbase.nim.o \
c_code/5_1/@mlexer.nim.o \
c_code/5_1/@mrenderer.nim.o \
c_code/5_1/@mmodulepaths.nim.o \
c_code/5_1/@m..@slib@spure@sstreams.nim.o \
c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_1/@m..@slib@spure@sosproc.nim.o \
c_code/5_1/@m..@slib@spure@slexbase.nim.o \
c_code/5_1/@m..@slib@spure@sparsejson.nim.o \
c_code/5_1/@m..@slib@spure@sjson.nim.o \
c_code/5_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_1/@mextccomp.nim.o \
c_code/5_1/@mnimblecmd.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/5_1/@mparser.nim.o \
c_code/5_1/@mfilters.nim.o \
c_code/5_1/@mfilter_tmpl.nim.o \
c_code/5_1/@msyntaxes.nim.o \
c_code/5_1/@mrodutils.nim.o \
c_code/5_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_1/@mastyaml.nim.o \
c_code/5_1/@mastalgo.nim.o \
c_code/5_1/@mtrees.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_1/@mbtrees.nim.o \
c_code/5_1/@mpackages.nim.o \
c_code/5_1/@msuggestsymdb.nim.o \
c_code/5_1/@mic@srodfiles.nim.o \
c_code/5_1/@mic@sbitabs.nim.o \
c_code/5_1/@mic@siclineinfos.nim.o \
c_code/5_1/@mic@spacked_ast.nim.o \
c_code/5_1/@mic@sic.nim.o \
c_code/5_1/@mmodulegraphs.nim.o \
c_code/5_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/5_1/@mastmsgs.nim.o \
c_code/5_1/@mtypes.nim.o \
c_code/5_1/@mnimsets.nim.o \
c_code/5_1/@mndi.nim.o \
c_code/5_1/@mcgendata.nim.o \
c_code/5_1/@mmangleutils.nim.o \
c_code/5_1/@mccgutils.nim.o \
c_code/5_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/5_1/@mguards.nim.o \
c_code/5_1/@msemfold.nim.o \
c_code/5_1/@mvmdef.nim.o \
c_code/5_1/@msemdata.nim.o \
c_code/5_1/@mtypeallowed.nim.o \
c_code/5_1/@misolation_check.nim.o \
c_code/5_1/@mvarpartitions.nim.o \
c_code/5_1/@mnilcheck.nim.o \
c_code/5_1/@merrorhandling.nim.o \
c_code/5_1/@maliasanalysis.nim.o \
c_code/5_1/@msemstrictfuncs.nim.o \
c_code/5_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_1/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_1/@mlookups.nim.o \
c_code/5_1/@mlinter.nim.o \
c_code/5_1/@msemtypinst.nim.o \
c_code/5_1/@mparampatterns.nim.o \
c_code/5_1/@mlowerings.nim.o \
c_code/5_1/@mconcepts.nim.o \
c_code/5_1/@msigmatch.nim.o \
c_code/5_1/@mpragmas.nim.o \
c_code/5_1/@mpushpoppragmas.nim.o \
c_code/5_1/@msighashes.nim.o \
c_code/5_1/@mliftdestructors.nim.o \
c_code/5_1/@msempass2.nim.o \
c_code/5_1/@mcgmeth.nim.o \
c_code/5_1/@maliases.nim.o \
c_code/5_1/@mliftlocals.nim.o \
c_code/5_1/@mlambdalifting.nim.o \
c_code/5_1/@mclosureiters.nim.o \
c_code/5_1/@mtransf.nim.o \
c_code/5_1/@moptimizer.nim.o \
c_code/5_1/@mdfa.nim.o \
c_code/5_1/@minjectdestructors.nim.o \
c_code/5_1/@mexpanddefaults.nim.o \
c_code/5_1/@mpipelineutils.nim.o \
c_code/5_1/@mspawn.nim.o \
c_code/5_1/@msemparallel.nim.o \
c_code/5_1/@m..@slib@spure@sdynlib.nim.o \
c_code/5_1/@mcgen.nim.o \
c_code/5_1/@mmodules.nim.o \
c_code/5_1/@msemmacrosanity.nim.o \
c_code/5_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/5_1/@mmacrocacheimpl.nim.o \
c_code/5_1/@mvmprofiler.nim.o \
c_code/5_1/@mevaltempl.nim.o \
c_code/5_1/@mvmconv.nim.o \
c_code/5_1/@mvmmarshal.nim.o \
c_code/5_1/@mvm.nim.o \
c_code/5_1/@mimporter.nim.o \
c_code/5_1/@mprocfind.nim.o \
c_code/5_1/@mpatterns.nim.o \
c_code/5_1/@mpluginsupport.nim.o \
c_code/5_1/@mplugins@slocals.nim.o \
c_code/5_1/@mplugins@sitersgen.nim.o \
c_code/5_1/@mplugins@sactive.nim.o \
c_code/5_1/@menumtostr.nim.o \
c_code/5_1/@mvtables.nim.o \
c_code/5_1/@msem.nim.o \
c_code/5_1/@mreorder.nim.o \
c_code/5_1/@mdepends.nim.o \
c_code/5_1/@msourcemap.nim.o \
c_code/5_1/@mjsgen.nim.o \
c_code/5_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_1/@mtypesrenderer.nim.o \
c_code/5_1/@mrenderverbatim.nim.o \
c_code/5_1/@m..@slib@spure@sxmltree.nim.o \
c_code/5_1/@m..@slib@spure@suri.nim.o \
c_code/5_1/@mdocgen.nim.o \
c_code/5_1/@mdocgen2.nim.o \
c_code/5_1/@mic@sreplayer.nim.o \
c_code/5_1/@mpipelines.nim.o \
c_code/5_1/@mscriptconfig.nim.o \
c_code/5_1/@mnimconf.nim.o \
c_code/5_1/@mic@sdce.nim.o \
c_code/5_1/@mic@scbackend.nim.o \
c_code/5_1/@mic@sintegrity.nim.o \
c_code/5_1/@mic@snavigator.nim.o \
c_code/5_1/@mmain.nim.o \
c_code/5_1/@mcmdlinehelper.nim.o \
c_code/5_1/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_2/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sassertions.nim.c -o c_code/5_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@ssystem.nim.c -o c_code/5_2/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sparseutils.nim.c -o c_code/5_2/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@smath.nim.c -o c_code/5_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@salgorithm.nim.c -o c_code/5_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sunicode.nim.c -o c_code/5_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstrutils.nim.c -o c_code/5_2/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@spathnorm.nim.c -o c_code/5_2/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@soserrors.nim.c -o c_code/5_2/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_2/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sposix@sposix.nim.c -o c_code/5_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@stimes.nim.c -o c_code/5_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@senvvars.nim.c -o c_code/5_2/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@scmdline.nim.c -o c_code/5_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sos.nim.c -o c_code/5_2/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sparseopt.nim.c -o c_code/5_2/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@shashes.nim.c -o c_code/5_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_2/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_2/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstrformat.nim.c -o c_code/5_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sterminal.nim.c -o c_code/5_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplatform.nim.c -o c_code/5_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptions.nim.c -o c_code/5_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmsgs.nim.c -o c_code/5_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mllstream.nim.c -o c_code/5_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlexer.nim.c -o c_code/5_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstreams.nim.c -o c_code/5_2/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sosproc.nim.c -o c_code/5_2/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@slexbase.nim.c -o c_code/5_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sparsejson.nim.c -o c_code/5_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sjson.nim.c -o c_code/5_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mextccomp.nim.c -o c_code/5_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimblecmd.nim.c -o c_code/5_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparser.nim.c -o c_code/5_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilter_tmpl.nim.c -o c_code/5_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@srodfiles.nim.c -o c_code/5_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mndi.nim.c -o c_code/5_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdef.nim.c -o c_code/5_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemdata.nim.c -o c_code/5_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msigmatch.nim.c -o c_code/5_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpragmas.nim.c -o c_code/5_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@minjectdestructors.nim.c -o c_code/5_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sdynlib.nim.c -o c_code/5_2/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgen.nim.c -o c_code/5_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mgorgeimpl.nim.c -o c_code/5_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvm.nim.c -o c_code/5_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msem.nim.c -o c_code/5_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mreorder.nim.c -o c_code/5_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdepends.nim.c -o c_code/5_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msourcemap.nim.c -o c_code/5_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mjsgen.nim.c -o c_code/5_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypesrenderer.nim.c -o c_code/5_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sxmltree.nim.c -o c_code/5_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@suri.nim.c -o c_code/5_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen.nim.c -o c_code/5_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mscriptconfig.nim.c -o c_code/5_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimconf.nim.c -o c_code/5_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmain.nim.c -o c_code/5_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_2/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnim.nim.c -o c_code/5_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_2/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/5_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_2/@m..@slib@ssystem.nim.o \
c_code/5_2/@m..@slib@spure@sparseutils.nim.o \
c_code/5_2/@m..@slib@spure@smath.nim.o \
c_code/5_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/5_2/@m..@slib@spure@sunicode.nim.o \
c_code/5_2/@m..@slib@spure@sstrutils.nim.o \
c_code/5_2/@m..@slib@spure@spathnorm.nim.o \
c_code/5_2/@m..@slib@sstd@soserrors.nim.o \
c_code/5_2/@m..@slib@sstd@ssyncio.nim.o \
c_code/5_2/@m..@slib@sposix@sposix.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@m..@slib@spure@stimes.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_2/@m..@slib@sstd@senvvars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@m..@slib@sstd@scmdline.nim.o \
c_code/5_2/@m..@slib@spure@sos.nim.o \
c_code/5_2/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_2/@m..@slib@spure@shashes.nim.o \
c_code/5_2/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_2/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_2/@m..@slib@spure@sstrformat.nim.o \
c_code/5_2/@m..@slib@spure@sterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_2/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_2/@moptions.nim.o \
c_code/5_2/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_2/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_2/@mlexer.nim.o \
c_code/5_2/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_2/@m..@slib@spure@sstreams.nim.o \
c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_2/@m..@slib@spure@sosproc.nim.o \
c_code/5_2/@m..@slib@spure@slexbase.nim.o \
c_code/5_2/@m..@slib@spure@sparsejson.nim.o \
c_code/5_2/@m..@slib@spure@sjson.nim.o \
c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_2/@mextccomp.nim.o \
c_code/5_2/@mnimblecmd.nim.o \
c_code/5_2/@mcommands.nim.o \
c_code/5_2/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_2/@mfilter_tmpl.nim.o \
c_code/5_2/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_2/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_2/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mndi.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_2/@mvmdef.nim.o \
c_code/5_2/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_2/@msigmatch.nim.o \
c_code/5_2/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_2/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_2/@m..@slib@spure@sdynlib.nim.o \
c_code/5_2/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_2/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_2/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_2/@msem.nim.o \
c_code/5_2/@mreorder.nim.o \
c_code/5_2/@mdepends.nim.o \
c_code/5_2/@msourcemap.nim.o \
c_code/5_2/@mjsgen.nim.o \
c_code/5_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_2/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@m..@slib@spure@sxmltree.nim.o \
c_code/5_2/@m..@slib@spure@suri.nim.o \
c_code/5_2/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_2/@mscriptconfig.nim.o \
c_code/5_2/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_2/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_2/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_6/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sassertions.nim.c -o c_code/5_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@ssystem.nim.c -o c_code/5_6/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sparseutils.nim.c -o c_code/5_6/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@smath.nim.c -o c_code/5_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@salgorithm.nim.c -o c_code/5_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sunicode.nim.c -o c_code/5_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstrutils.nim.c -o c_code/5_6/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@spathnorm.nim.c -o c_code/5_6/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@soserrors.nim.c -o c_code/5_6/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_6/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sposix@sposix.nim.c -o c_code/5_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@stimes.nim.c -o c_code/5_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@senvvars.nim.c -o c_code/5_6/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@scmdline.nim.c -o c_code/5_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sos.nim.c -o c_code/5_6/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sparseopt.nim.c -o c_code/5_6/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@shashes.nim.c -o c_code/5_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_6/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_6/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstrformat.nim.c -o c_code/5_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sterminal.nim.c -o c_code/5_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mplatform.nim.c -o c_code/5_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstreams.nim.c -o c_code/5_6/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sosproc.nim.c -o c_code/5_6/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@slexbase.nim.c -o c_code/5_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sparsejson.nim.c -o c_code/5_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sjson.nim.c -o c_code/5_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@srodfiles.nim.c -o c_code/5_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mndi.nim.c -o c_code/5_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sdynlib.nim.c -o c_code/5_6/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sxmltree.nim.c -o c_code/5_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@suri.nim.c -o c_code/5_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_6/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/5_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_6/@m..@slib@ssystem.nim.o \
c_code/5_6/@m..@slib@spure@sparseutils.nim.o \
c_code/5_2/@m..@slib@spure@smath.nim.o \
c_code/5_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/5_2/@m..@slib@spure@sunicode.nim.o \
c_code/5_6/@m..@slib@spure@sstrutils.nim.o \
c_code/5_6/@m..@slib@spure@spathnorm.nim.o \
c_code/5_6/@m..@slib@sstd@soserrors.nim.o \
c_code/5_6/@m..@slib@sstd@ssyncio.nim.o \
c_code/5_2/@m..@slib@sposix@sposix.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@m..@slib@spure@stimes.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_6/@m..@slib@sstd@senvvars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@m..@slib@sstd@scmdline.nim.o \
c_code/5_6/@m..@slib@spure@sos.nim.o \
c_code/5_6/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_2/@m..@slib@spure@shashes.nim.o \
c_code/5_6/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_6/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_2/@m..@slib@spure@sstrformat.nim.o \
c_code/5_2/@m..@slib@spure@sterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_6/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@m..@slib@spure@sstreams.nim.o \
c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_6/@m..@slib@spure@sosproc.nim.o \
c_code/5_2/@m..@slib@spure@slexbase.nim.o \
c_code/5_2/@m..@slib@spure@sparsejson.nim.o \
c_code/5_2/@m..@slib@spure@sjson.nim.o \
c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_6/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mndi.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@m..@slib@spure@sdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@m..@slib@spure@sxmltree.nim.o \
c_code/5_2/@m..@slib@spure@suri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/5_6/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_6/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_6/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_7/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sassertions.nim.c -o c_code/5_7/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@ssystem@siterators.nim.c -o c_code/2_7/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_7/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_7/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@ssystem.nim.c -o c_code/5_7/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sparseutils.nim.c -o c_code/5_7/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@smath.nim.c -o c_code/5_7/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@salgorithm.nim.c -o c_code/5_7/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@senumutils.nim.c -o c_code/2_7/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sunicode.nim.c -o c_code/5_7/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sstrutils.nim.c -o c_code/5_7/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@spathnorm.nim.c -o c_code/5_7/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@soserrors.nim.c -o c_code/5_7/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_7/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sposix@sposix.nim.c -o c_code/5_7/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@stimes.nim.c -o c_code/5_7/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@senvvars.nim.c -o c_code/5_7/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_7/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@scmdline.nim.c -o c_code/5_7/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sos.nim.c -o c_code/5_7/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sparseopt.nim.c -o c_code/5_7/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@shashes.nim.c -o c_code/5_7/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_7/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_7/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sstrformat.nim.c -o c_code/5_7/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sterminal.nim.c -o c_code/5_7/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpathutils.nim.c -o c_code/5_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mropes.nim.c -o c_code/5_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlineinfos.nim.c -o c_code/5_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplatform.nim.c -o c_code/5_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mprefixmatches.nim.c -o c_code/5_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimpaths.nim.c -o c_code/5_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_7/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@moptions.nim.c -o c_code/5_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmsgs.nim.c -o c_code/5_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcondsyms.nim.c -o c_code/5_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mwordrecg.nim.c -o c_code/5_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@midents.nim.c -o c_code/5_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mint128.nim.c -o c_code/5_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnodekinds.nim.c -o c_code/2_7/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mast.nim.c -o c_code/5_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mllstream.nim.c -o c_code/5_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimlexbase.nim.c -o c_code/5_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlexer.nim.c -o c_code/5_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrenderer.nim.c -o c_code/5_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulepaths.nim.c -o c_code/5_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sstreams.nim.c -o c_code/5_7/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_7/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sosproc.nim.c -o c_code/5_7/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@slexbase.nim.c -o c_code/5_7/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sparsejson.nim.c -o c_code/5_7/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sjson.nim.c -o c_code/5_7/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_7/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mextccomp.nim.c -o c_code/5_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimblecmd.nim.c -o c_code/5_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcommands.nim.c -o c_code/5_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mparser.nim.c -o c_code/5_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mfilters.nim.c -o c_code/5_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mfilter_tmpl.nim.c -o c_code/5_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msyntaxes.nim.c -o c_code/5_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrodutils.nim.c -o c_code/5_7/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_7/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastyaml.nim.c -o c_code/5_7/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastalgo.nim.c -o c_code/5_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtrees.nim.c -o c_code/5_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mbtrees.nim.c -o c_code/5_7/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpackages.nim.c -o c_code/5_7/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msuggestsymdb.nim.c -o c_code/5_7/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@srodfiles.nim.c -o c_code/5_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sbitabs.nim.c -o c_code/5_7/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@siclineinfos.nim.c -o c_code/5_7/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@spacked_ast.nim.c -o c_code/5_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sic.nim.c -o c_code/5_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulegraphs.nim.c -o c_code/5_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmagicsys.nim.c -o c_code/5_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastmsgs.nim.c -o c_code/5_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypes.nim.c -o c_code/5_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimsets.nim.c -o c_code/5_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mndi.nim.c -o c_code/5_7/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgendata.nim.c -o c_code/5_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmangleutils.nim.c -o c_code/5_7/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mccgutils.nim.c -o c_code/5_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtreetab.nim.c -o c_code/5_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msaturate.nim.c -o c_code/5_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mguards.nim.c -o c_code/5_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemfold.nim.c -o c_code/5_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdef.nim.c -o c_code/5_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemdata.nim.c -o c_code/5_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypeallowed.nim.c -o c_code/5_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@misolation_check.nim.c -o c_code/5_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvarpartitions.nim.c -o c_code/5_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnilcheck.nim.c -o c_code/5_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@merrorhandling.nim.c -o c_code/5_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@maliasanalysis.nim.c -o c_code/5_7/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemstrictfuncs.nim.c -o c_code/5_7/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_7/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_7/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlookups.nim.c -o c_code/5_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlinter.nim.c -o c_code/5_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemtypinst.nim.c -o c_code/5_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mparampatterns.nim.c -o c_code/5_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlowerings.nim.c -o c_code/5_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mconcepts.nim.c -o c_code/5_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msigmatch.nim.c -o c_code/5_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpragmas.nim.c -o c_code/5_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpushpoppragmas.nim.c -o c_code/5_7/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msighashes.nim.c -o c_code/5_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mliftdestructors.nim.c -o c_code/5_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msempass2.nim.c -o c_code/5_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgmeth.nim.c -o c_code/5_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@maliases.nim.c -o c_code/5_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mliftlocals.nim.c -o c_code/5_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlambdalifting.nim.c -o c_code/5_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mclosureiters.nim.c -o c_code/5_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtransf.nim.c -o c_code/5_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@moptimizer.nim.c -o c_code/5_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdfa.nim.c -o c_code/5_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@minjectdestructors.nim.c -o c_code/5_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mexpanddefaults.nim.c -o c_code/5_7/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpipelineutils.nim.c -o c_code/5_7/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mspawn.nim.c -o c_code/5_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemparallel.nim.c -o c_code/5_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sdynlib.nim.c -o c_code/5_7/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgen.nim.c -o c_code/5_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodules.nim.c -o c_code/5_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemmacrosanity.nim.c -o c_code/5_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmgen.nim.c -o c_code/5_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdeps.nim.c -o c_code/5_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mgorgeimpl.nim.c -o c_code/5_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmacrocacheimpl.nim.c -o c_code/5_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmprofiler.nim.c -o c_code/5_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mevaltempl.nim.c -o c_code/5_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmconv.nim.c -o c_code/5_7/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmmarshal.nim.c -o c_code/5_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvm.nim.c -o c_code/5_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mimporter.nim.c -o c_code/5_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mprocfind.nim.c -o c_code/5_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpatterns.nim.c -o c_code/5_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpluginsupport.nim.c -o c_code/5_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@slocals.nim.c -o c_code/5_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@sitersgen.nim.c -o c_code/5_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@sactive.nim.c -o c_code/5_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@menumtostr.nim.c -o c_code/5_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvtables.nim.c -o c_code/5_7/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msem.nim.c -o c_code/5_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mreorder.nim.c -o c_code/5_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdepends.nim.c -o c_code/5_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msourcemap.nim.c -o c_code/5_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mjsgen.nim.c -o c_code/5_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_7/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_7/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypesrenderer.nim.c -o c_code/5_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrenderverbatim.nim.c -o c_code/5_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sxmltree.nim.c -o c_code/5_7/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@suri.nim.c -o c_code/5_7/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen.nim.c -o c_code/5_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen2.nim.c -o c_code/5_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sreplayer.nim.c -o c_code/5_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpipelines.nim.c -o c_code/5_7/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mscriptconfig.nim.c -o c_code/5_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimconf.nim.c -o c_code/5_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sdce.nim.c -o c_code/5_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@scbackend.nim.c -o c_code/5_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sintegrity.nim.c -o c_code/5_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@snavigator.nim.c -o c_code/5_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmain.nim.c -o c_code/5_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcmdlinehelper.nim.c -o c_code/5_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_7/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnim.nim.c -o c_code/5_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_7/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_7/@m..@slib@sstd@sassertions.nim.o \
c_code/2_7/@m..@slib@ssystem@siterators.nim.o \
c_code/5_7/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_7/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_7/@m..@slib@ssystem.nim.o \
c_code/5_7/@m..@slib@spure@sparseutils.nim.o \
c_code/5_7/@m..@slib@spure@smath.nim.o \
c_code/5_7/@m..@slib@spure@salgorithm.nim.o \
c_code/2_7/@m..@slib@sstd@senumutils.nim.o \
c_code/5_7/@m..@slib@spure@sunicode.nim.o \
c_code/5_7/@m..@slib@spure@sstrutils.nim.o \
c_code/5_7/@m..@slib@spure@spathnorm.nim.o \
c_code/5_7/@m..@slib@sstd@soserrors.nim.o \
c_code/5_7/@m..@slib@sstd@ssyncio.nim.o \
c_code/5_7/@m..@slib@sposix@sposix.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_7/@m..@slib@spure@stimes.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_7/@m..@slib@sstd@senvvars.nim.o \
c_code/5_7/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_7/@m..@slib@sstd@scmdline.nim.o \
c_code/5_7/@m..@slib@spure@sos.nim.o \
c_code/5_7/@m..@slib@spure@sparseopt.nim.o \
c_code/2_7/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_7/@m..@slib@spure@shashes.nim.o \
c_code/5_7/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_7/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_7/@m..@slib@spure@sstrformat.nim.o \
c_code/5_7/@m..@slib@spure@sterminal.nim.o \
c_code/5_7/@mpathutils.nim.o \
c_code/5_7/@mropes.nim.o \
c_code/5_7/@mlineinfos.nim.o \
c_code/5_7/@mplatform.nim.o \
c_code/5_7/@mprefixmatches.nim.o \
c_code/5_7/@mnimpaths.nim.o \
c_code/5_7/@m..@slib@spure@scollections@ssets.nim.o \
c_code/2_7/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_7/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_7/@moptions.nim.o \
c_code/5_7/@mmsgs.nim.o \
c_code/5_7/@mcondsyms.nim.o \
c_code/5_7/@mwordrecg.nim.o \
c_code/5_7/@midents.nim.o \
c_code/5_7/@mint128.nim.o \
c_code/2_7/@mnodekinds.nim.o \
c_code/5_7/@mast.nim.o \
c_code/5_7/@mllstream.nim.o \
c_code/5_7/@mnimlexbase.nim.o \
c_code/5_7/@mlexer.nim.o \
c_code/5_7/@mrenderer.nim.o \
c_code/5_7/@mmodulepaths.nim.o \
c_code/5_7/@m..@slib@spure@sstreams.nim.o \
c_code/5_7/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_7/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_7/@m..@slib@spure@sosproc.nim.o \
c_code/5_7/@m..@slib@spure@slexbase.nim.o \
c_code/5_7/@m..@slib@spure@sparsejson.nim.o \
c_code/5_7/@m..@slib@spure@sjson.nim.o \
c_code/5_7/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_7/@mextccomp.nim.o \
c_code/5_7/@mnimblecmd.nim.o \
c_code/5_7/@mcommands.nim.o \
c_code/5_7/@mparser.nim.o \
c_code/5_7/@mfilters.nim.o \
c_code/5_7/@mfilter_tmpl.nim.o \
c_code/5_7/@msyntaxes.nim.o \
c_code/5_7/@mrodutils.nim.o \
c_code/5_7/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_7/@mastyaml.nim.o \
c_code/5_7/@mastalgo.nim.o \
c_code/5_7/@mtrees.nim.o \
c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_7/@mbtrees.nim.o \
c_code/5_7/@mpackages.nim.o \
c_code/5_7/@msuggestsymdb.nim.o \
c_code/5_7/@mic@srodfiles.nim.o \
c_code/5_7/@mic@sbitabs.nim.o \
c_code/5_7/@mic@siclineinfos.nim.o \
c_code/5_7/@mic@spacked_ast.nim.o \
c_code/5_7/@mic@sic.nim.o \
c_code/5_7/@mmodulegraphs.nim.o \
c_code/5_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/5_7/@mastmsgs.nim.o \
c_code/5_7/@mtypes.nim.o \
c_code/5_7/@mnimsets.nim.o \
c_code/5_7/@mndi.nim.o \
c_code/5_7/@mcgendata.nim.o \
c_code/5_7/@mmangleutils.nim.o \
c_code/5_7/@mccgutils.nim.o \
c_code/5_7/@mtreetab.nim.o \
c_code/5_7/@msaturate.nim.o \
c_code/5_7/@mguards.nim.o \
c_code/5_7/@msemfold.nim.o \
c_code/5_7/@mvmdef.nim.o \
c_code/5_7/@msemdata.nim.o \
c_code/5_7/@mtypeallowed.nim.o \
c_code/5_7/@misolation_check.nim.o \
c_code/5_7/@mvarpartitions.nim.o \
c_code/5_7/@mnilcheck.nim.o \
c_code/5_7/@merrorhandling.nim.o \
c_code/5_7/@maliasanalysis.nim.o \
c_code/5_7/@msemstrictfuncs.nim.o \
c_code/5_7/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_7/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_7/@mlookups.nim.o \
c_code/5_7/@mlinter.nim.o \
c_code/5_7/@msemtypinst.nim.o \
c_code/5_7/@mparampatterns.nim.o \
c_code/5_7/@mlowerings.nim.o \
c_code/5_7/@mconcepts.nim.o \
c_code/5_7/@msigmatch.nim.o \
c_code/5_7/@mpragmas.nim.o \
c_code/5_7/@mpushpoppragmas.nim.o \
c_code/5_7/@msighashes.nim.o \
c_code/5_7/@mliftdestructors.nim.o \
c_code/5_7/@msempass2.nim.o \
c_code/5_7/@mcgmeth.nim.o \
c_code/5_7/@maliases.nim.o \
c_code/5_7/@mliftlocals.nim.o \
c_code/5_7/@mlambdalifting.nim.o \
c_code/5_7/@mclosureiters.nim.o \
c_code/5_7/@mtransf.nim.o \
c_code/5_7/@moptimizer.nim.o \
c_code/5_7/@mdfa.nim.o \
c_code/5_7/@minjectdestructors.nim.o \
c_code/5_7/@mexpanddefaults.nim.o \
c_code/5_7/@mpipelineutils.nim.o \
c_code/5_7/@mspawn.nim.o \
c_code/5_7/@msemparallel.nim.o \
c_code/5_7/@m..@slib@spure@sdynlib.nim.o \
c_code/5_7/@mcgen.nim.o \
c_code/5_7/@mmodules.nim.o \
c_code/5_7/@msemmacrosanity.nim.o \
c_code/5_7/@mvmgen.nim.o \
c_code/5_7/@mvmdeps.nim.o \
c_code/5_7/@mgorgeimpl.nim.o \
c_code/5_7/@mmacrocacheimpl.nim.o \
c_code/5_7/@mvmprofiler.nim.o \
c_code/5_7/@mevaltempl.nim.o \
c_code/5_7/@mvmconv.nim.o \
c_code/5_7/@mvmmarshal.nim.o \
c_code/5_7/@mvm.nim.o \
c_code/5_7/@mimporter.nim.o \
c_code/5_7/@mprocfind.nim.o \
c_code/5_7/@mpatterns.nim.o \
c_code/5_7/@mpluginsupport.nim.o \
c_code/5_7/@mplugins@slocals.nim.o \
c_code/5_7/@mplugins@sitersgen.nim.o \
c_code/5_7/@mplugins@sactive.nim.o \
c_code/5_7/@menumtostr.nim.o \
c_code/5_7/@mvtables.nim.o \
c_code/5_7/@msem.nim.o \
c_code/5_7/@mreorder.nim.o \
c_code/5_7/@mdepends.nim.o \
c_code/5_7/@msourcemap.nim.o \
c_code/5_7/@mjsgen.nim.o \
c_code/5_7/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_7/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_7/@mtypesrenderer.nim.o \
c_code/5_7/@mrenderverbatim.nim.o \
c_code/5_7/@m..@slib@spure@sxmltree.nim.o \
c_code/5_7/@m..@slib@spure@suri.nim.o \
c_code/5_7/@mdocgen.nim.o \
c_code/5_7/@mdocgen2.nim.o \
c_code/5_7/@mic@sreplayer.nim.o \
c_code/5_7/@mpipelines.nim.o \
c_code/5_7/@mscriptconfig.nim.o \
c_code/5_7/@mnimconf.nim.o \
c_code/5_7/@mic@sdce.nim.o \
c_code/5_7/@mic@scbackend.nim.o \
c_code/5_7/@mic@sintegrity.nim.o \
c_code/5_7/@mic@snavigator.nim.o \
c_code/5_7/@mmain.nim.o \
c_code/5_7/@mcmdlinehelper.nim.o \
c_code/5_7/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_6/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sassertions.nim.c -o c_code/5_2/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@ssystem@siterators.nim.c -o c_code/1_2/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_2/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@ssystem.nim.c -o c_code/5_6/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sparseutils.nim.c -o c_code/5_6/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@smath.nim.c -o c_code/5_2/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@salgorithm.nim.c -o c_code/5_2/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@senumutils.nim.c -o c_code/1_2/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sunicode.nim.c -o c_code/5_2/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstrutils.nim.c -o c_code/5_6/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@spathnorm.nim.c -o c_code/5_6/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@soserrors.nim.c -o c_code/5_6/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_6/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sposix@sposix.nim.c -o c_code/5_2/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@stimes.nim.c -o c_code/5_2/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@sstd@senvvars.nim.c -o c_code/5_6/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@scmdline.nim.c -o c_code/5_2/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sos.nim.c -o c_code/5_6/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sparseopt.nim.c -o c_code/5_6/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@shashes.nim.c -o c_code/5_2/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_6/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_6/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sstrformat.nim.c -o c_code/5_2/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sterminal.nim.c -o c_code/5_2/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mplatform.nim.c -o c_code/5_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sstreams.nim.c -o c_code/5_6/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sosproc.nim.c -o c_code/5_6/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@slexbase.nim.c -o c_code/5_2/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sparsejson.nim.c -o c_code/5_2/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sjson.nim.c -o c_code/5_2/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_2/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@srodfiles.nim.c -o c_code/5_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mndi.nim.c -o c_code/5_2/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_2/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sdynlib.nim.c -o c_code/5_6/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_2/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@sxmltree.nim.c -o c_code/5_2/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@slib@spure@suri.nim.c -o c_code/5_2/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_6/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@m..@slib@sstd@sassertions.nim.o \
c_code/1_2/@m..@slib@ssystem@siterators.nim.o \
c_code/5_2/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_2/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_6/@m..@slib@ssystem.nim.o \
c_code/5_6/@m..@slib@spure@sparseutils.nim.o \
c_code/5_2/@m..@slib@spure@smath.nim.o \
c_code/5_2/@m..@slib@spure@salgorithm.nim.o \
c_code/1_2/@m..@slib@sstd@senumutils.nim.o \
c_code/5_2/@m..@slib@spure@sunicode.nim.o \
c_code/5_6/@m..@slib@spure@sstrutils.nim.o \
c_code/5_6/@m..@slib@spure@spathnorm.nim.o \
c_code/5_6/@m..@slib@sstd@soserrors.nim.o \
c_code/5_6/@m..@slib@sstd@ssyncio.nim.o \
c_code/5_2/@m..@slib@sposix@sposix.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_6/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@m..@slib@spure@stimes.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_6/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_6/@m..@slib@sstd@senvvars.nim.o \
c_code/5_2/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@m..@slib@sstd@scmdline.nim.o \
c_code/5_6/@m..@slib@spure@sos.nim.o \
c_code/5_6/@m..@slib@spure@sparseopt.nim.o \
c_code/1_2/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_2/@m..@slib@spure@shashes.nim.o \
c_code/5_6/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_6/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_2/@m..@slib@spure@sstrformat.nim.o \
c_code/5_2/@m..@slib@spure@sterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_9/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_2/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_2/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@m..@slib@spure@sstreams.nim.o \
c_code/5_2/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_6/@m..@slib@spure@sosproc.nim.o \
c_code/5_2/@m..@slib@spure@slexbase.nim.o \
c_code/5_2/@m..@slib@spure@sparsejson.nim.o \
c_code/5_2/@m..@slib@spure@sjson.nim.o \
c_code/5_2/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_6/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mndi.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_2/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@m..@slib@spure@sdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_2/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_6/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_6/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@m..@slib@spure@sxmltree.nim.o \
c_code/5_2/@m..@slib@spure@suri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/5_6/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_6/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_6/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_11/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sassertions.nim.c -o c_code/5_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@ssystem.nim.c -o c_code/5_11/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sparseutils.nim.c -o c_code/5_11/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@smath.nim.c -o c_code/5_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@salgorithm.nim.c -o c_code/5_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sunicode.nim.c -o c_code/5_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstrutils.nim.c -o c_code/5_11/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@spathnorm.nim.c -o c_code/5_11/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@soserrors.nim.c -o c_code/5_11/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_11/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sposix@sposix.nim.c -o c_code/3_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_11/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@stimes.nim.c -o c_code/5_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_11/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@senvvars.nim.c -o c_code/5_11/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@scmdline.nim.c -o c_code/5_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sos.nim.c -o c_code/5_11/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sparseopt.nim.c -o c_code/5_11/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@shashes.nim.c -o c_code/5_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_11/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_11/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstrformat.nim.c -o c_code/5_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sterminal.nim.c -o c_code/5_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mplatform.nim.c -o c_code/5_11/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptions.nim.c -o c_code/5_11/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmsgs.nim.c -o c_code/5_11/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mast.nim.c -o c_code/5_11/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mllstream.nim.c -o c_code/5_11/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlexer.nim.c -o c_code/5_11/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mrenderer.nim.c -o c_code/5_11/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstreams.nim.c -o c_code/5_11/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sosproc.nim.c -o c_code/5_11/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@slexbase.nim.c -o c_code/5_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sparsejson.nim.c -o c_code/5_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sjson.nim.c -o c_code/5_11/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_11/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mextccomp.nim.c -o c_code/5_11/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimblecmd.nim.c -o c_code/5_11/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcommands.nim.c -o c_code/5_11/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mparser.nim.c -o c_code/5_11/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mfilter_tmpl.nim.c -o c_code/5_11/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msyntaxes.nim.c -o c_code/5_11/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mastalgo.nim.c -o c_code/5_11/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mbtrees.nim.c -o c_code/5_11/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@srodfiles.nim.c -o c_code/5_11/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@sic.nim.c -o c_code/5_11/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmodulegraphs.nim.c -o c_code/5_11/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mndi.nim.c -o c_code/5_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgendata.nim.c -o c_code/5_11/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mguards.nim.c -o c_code/5_11/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemfold.nim.c -o c_code/5_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvmdef.nim.c -o c_code/5_11/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msemdata.nim.c -o c_code/5_11/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypeallowed.nim.c -o c_code/5_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@misolation_check.nim.c -o c_code/5_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvarpartitions.nim.c -o c_code/5_11/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnilcheck.nim.c -o c_code/5_11/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@merrorhandling.nim.c -o c_code/5_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliasanalysis.nim.c -o c_code/5_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemstrictfuncs.nim.c -o c_code/5_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@seditdistance.nim.c -o c_code/5_1/@m..@slib@sstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@scollections@sheapqueue.nim.c -o c_code/5_11/@m..@slib@spure@scollections@sheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlookups.nim.c -o c_code/5_11/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlinter.nim.c -o c_code/5_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msemtypinst.nim.c -o c_code/5_11/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparampatterns.nim.c -o c_code/5_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlowerings.nim.c -o c_code/5_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mconcepts.nim.c -o c_code/5_11/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msigmatch.nim.c -o c_code/5_11/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mpragmas.nim.c -o c_code/5_11/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpushpoppragmas.nim.c -o c_code/5_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msighashes.nim.c -o c_code/5_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mliftdestructors.nim.c -o c_code/5_11/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msempass2.nim.c -o c_code/5_11/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgmeth.nim.c -o c_code/5_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliases.nim.c -o c_code/5_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mliftlocals.nim.c -o c_code/5_11/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlambdalifting.nim.c -o c_code/5_11/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mclosureiters.nim.c -o c_code/5_11/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mtransf.nim.c -o c_code/5_11/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptimizer.nim.c -o c_code/5_11/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdfa.nim.c -o c_code/5_11/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@minjectdestructors.nim.c -o c_code/5_11/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mexpanddefaults.nim.c -o c_code/5_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelineutils.nim.c -o c_code/5_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mspawn.nim.c -o c_code/5_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msemparallel.nim.c -o c_code/5_11/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sdynlib.nim.c -o c_code/5_11/@m..@slib@spure@sdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgen.nim.c -o c_code/5_11/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodules.nim.c -o c_code/5_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemmacrosanity.nim.c -o c_code/5_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvmgen.nim.c -o c_code/5_11/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mgorgeimpl.nim.c -o c_code/5_11/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmacrocacheimpl.nim.c -o c_code/5_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmprofiler.nim.c -o c_code/5_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mevaltempl.nim.c -o c_code/5_11/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmconv.nim.c -o c_code/5_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmmarshal.nim.c -o c_code/5_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mvm.nim.c -o c_code/5_11/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mimporter.nim.c -o c_code/5_11/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mprocfind.nim.c -o c_code/5_11/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mpatterns.nim.c -o c_code/5_11/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpluginsupport.nim.c -o c_code/5_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@slocals.nim.c -o c_code/5_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sitersgen.nim.c -o c_code/5_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sactive.nim.c -o c_code/5_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@menumtostr.nim.c -o c_code/5_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvtables.nim.c -o c_code/5_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msem.nim.c -o c_code/5_11/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mreorder.nim.c -o c_code/5_11/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdepends.nim.c -o c_code/5_11/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msourcemap.nim.c -o c_code/5_11/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mjsgen.nim.c -o c_code/5_11/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@slists.nim.c -o c_code/5_1/@m..@slib@spure@scollections@slists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.c -o c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spackages@sdocutils@srst.nim.c -o c_code/5_11/@m..@slib@spackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spackages@sdocutils@srstgen.nim.c -o c_code/5_11/@m..@slib@spackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mtypesrenderer.nim.c -o c_code/5_11/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mrenderverbatim.nim.c -o c_code/5_11/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sxmltree.nim.c -o c_code/5_1/@m..@slib@spure@sxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@suri.nim.c -o c_code/5_1/@m..@slib@spure@suri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdocgen.nim.c -o c_code/5_11/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mdocgen2.nim.c -o c_code/5_11/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sreplayer.nim.c -o c_code/5_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelines.nim.c -o c_code/5_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mscriptconfig.nim.c -o c_code/5_11/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimconf.nim.c -o c_code/5_11/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@sdce.nim.c -o c_code/5_11/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@scbackend.nim.c -o c_code/5_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@sintegrity.nim.c -o c_code/5_11/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@snavigator.nim.c -o c_code/5_11/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmain.nim.c -o c_code/5_11/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcmdlinehelper.nim.c -o c_code/5_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sbrowsers.nim.c -o c_code/5_11/@m..@slib@spure@sbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnim.nim.c -o c_code/5_11/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_11/@m..@slib@ssystem@sexceptions.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o \
c_code/5_1/@m..@slib@sstd@sassertions.nim.o \
c_code/1_1/@m..@slib@ssystem@siterators.nim.o \
c_code/5_1/@m..@slib@ssystem@sdollars.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.o \
c_code/5_1/@m..@slib@sstd@sformatfloat.nim.o \
c_code/5_11/@m..@slib@ssystem.nim.o \
c_code/5_11/@m..@slib@spure@sparseutils.nim.o \
c_code/5_1/@m..@slib@spure@smath.nim.o \
c_code/5_1/@m..@slib@spure@salgorithm.nim.o \
c_code/1_1/@m..@slib@sstd@senumutils.nim.o \
c_code/5_1/@m..@slib@spure@sunicode.nim.o \
c_code/5_11/@m..@slib@spure@sstrutils.nim.o \
c_code/5_11/@m..@slib@spure@spathnorm.nim.o \
c_code/5_11/@m..@slib@sstd@soserrors.nim.o \
c_code/5_11/@m..@slib@sstd@ssyncio.nim.o \
c_code/3_1/@m..@slib@sposix@sposix.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.o \
c_code/5_11/@m..@slib@sstd@sprivate@sospaths2.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o \
c_code/5_1/@m..@slib@spure@stimes.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.o \
c_code/5_11/@m..@slib@sstd@sprivate@sosdirs.nim.o \
c_code/5_11/@m..@slib@sstd@senvvars.nim.o \
c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o \
c_code/5_1/@m..@slib@sstd@scmdline.nim.o \
c_code/5_11/@m..@slib@spure@sos.nim.o \
c_code/5_11/@m..@slib@spure@sparseopt.nim.o \
c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o \
c_code/5_1/@m..@slib@spure@shashes.nim.o \
c_code/5_11/@m..@slib@spure@sstrtabs.nim.o \
c_code/5_11/@m..@slib@spure@scollections@stables.nim.o \
c_code/5_1/@m..@slib@spure@sstrformat.nim.o \
c_code/5_1/@m..@slib@spure@sterminal.nim.o \
c_code/5_1/@mpathutils.nim.o \
c_code/5_1/@mropes.nim.o \
c_code/5_1/@mlineinfos.nim.o \
c_code/5_11/@mplatform.nim.o \
c_code/5_1/@mprefixmatches.nim.o \
c_code/5_1/@mnimpaths.nim.o \
c_code/5_1/@m..@slib@spure@scollections@ssets.nim.o \
c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o \
c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o \
c_code/5_11/@moptions.nim.o \
c_code/5_11/@mmsgs.nim.o \
c_code/5_1/@mcondsyms.nim.o \
c_code/5_1/@mwordrecg.nim.o \
c_code/5_1/@midents.nim.o \
c_code/5_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/5_11/@mast.nim.o \
c_code/5_11/@mllstream.nim.o \
c_code/5_1/@mnimlexbase.nim.o \
c_code/5_11/@mlexer.nim.o \
c_code/5_11/@mrenderer.nim.o \
c_code/5_1/@mmodulepaths.nim.o \
c_code/5_11/@m..@slib@spure@sstreams.nim.o \
c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o \
c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.o \
c_code/5_11/@m..@slib@spure@sosproc.nim.o \
c_code/5_1/@m..@slib@spure@slexbase.nim.o \
c_code/5_1/@m..@slib@spure@sparsejson.nim.o \
c_code/5_11/@m..@slib@spure@sjson.nim.o \
c_code/5_1/@m..@slib@sstd@sjsonutils.nim.o \
c_code/5_11/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_11/@mextccomp.nim.o \
c_code/5_11/@mnimblecmd.nim.o \
c_code/5_11/@mcommands.nim.o \
c_code/5_11/@mparser.nim.o \
c_code/5_1/@mfilters.nim.o \
c_code/5_11/@mfilter_tmpl.nim.o \
c_code/5_11/@msyntaxes.nim.o \
c_code/5_1/@mrodutils.nim.o \
c_code/5_1/@m..@slib@sstd@spackedsets.nim.o \
c_code/5_1/@mastyaml.nim.o \
c_code/5_11/@mastalgo.nim.o \
c_code/5_1/@mtrees.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_11/@mbtrees.nim.o \
c_code/5_1/@mpackages.nim.o \
c_code/5_1/@msuggestsymdb.nim.o \
c_code/5_11/@mic@srodfiles.nim.o \
c_code/5_1/@mic@sbitabs.nim.o \
c_code/5_1/@mic@siclineinfos.nim.o \
c_code/5_1/@mic@spacked_ast.nim.o \
c_code/5_11/@mic@sic.nim.o \
c_code/5_11/@mmodulegraphs.nim.o \
c_code/5_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/5_1/@mastmsgs.nim.o \
c_code/5_1/@mtypes.nim.o \
c_code/5_1/@mnimsets.nim.o \
c_code/5_1/@mndi.nim.o \
c_code/5_11/@mcgendata.nim.o \
c_code/5_1/@mmangleutils.nim.o \
c_code/5_1/@mccgutils.nim.o \
c_code/5_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/5_11/@mguards.nim.o \
c_code/5_1/@msemfold.nim.o \
c_code/5_11/@mvmdef.nim.o \
c_code/5_11/@msemdata.nim.o \
c_code/5_1/@mtypeallowed.nim.o \
c_code/5_1/@misolation_check.nim.o \
c_code/5_11/@mvarpartitions.nim.o \
c_code/5_11/@mnilcheck.nim.o \
c_code/5_1/@merrorhandling.nim.o \
c_code/5_1/@maliasanalysis.nim.o \
c_code/5_1/@msemstrictfuncs.nim.o \
c_code/5_1/@m..@slib@sstd@seditdistance.nim.o \
c_code/5_11/@m..@slib@spure@scollections@sheapqueue.nim.o \
c_code/5_11/@mlookups.nim.o \
c_code/5_1/@mlinter.nim.o \
c_code/5_11/@msemtypinst.nim.o \
c_code/5_1/@mparampatterns.nim.o \
c_code/5_1/@mlowerings.nim.o \
c_code/5_11/@mconcepts.nim.o \
c_code/5_11/@msigmatch.nim.o \
c_code/5_11/@mpragmas.nim.o \
c_code/5_1/@mpushpoppragmas.nim.o \
c_code/5_1/@msighashes.nim.o \
c_code/5_11/@mliftdestructors.nim.o \
c_code/5_11/@msempass2.nim.o \
c_code/5_1/@mcgmeth.nim.o \
c_code/5_1/@maliases.nim.o \
c_code/5_11/@mliftlocals.nim.o \
c_code/5_11/@mlambdalifting.nim.o \
c_code/5_11/@mclosureiters.nim.o \
c_code/5_11/@mtransf.nim.o \
c_code/5_11/@moptimizer.nim.o \
c_code/5_11/@mdfa.nim.o \
c_code/5_11/@minjectdestructors.nim.o \
c_code/5_1/@mexpanddefaults.nim.o \
c_code/5_1/@mpipelineutils.nim.o \
c_code/5_1/@mspawn.nim.o \
c_code/5_11/@msemparallel.nim.o \
c_code/5_11/@m..@slib@spure@sdynlib.nim.o \
c_code/5_11/@mcgen.nim.o \
c_code/5_1/@mmodules.nim.o \
c_code/5_1/@msemmacrosanity.nim.o \
c_code/5_11/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/5_11/@mgorgeimpl.nim.o \
c_code/5_1/@mmacrocacheimpl.nim.o \
c_code/5_1/@mvmprofiler.nim.o \
c_code/5_11/@mevaltempl.nim.o \
c_code/5_1/@mvmconv.nim.o \
c_code/5_1/@mvmmarshal.nim.o \
c_code/5_11/@mvm.nim.o \
c_code/5_11/@mimporter.nim.o \
c_code/5_11/@mprocfind.nim.o \
c_code/5_11/@mpatterns.nim.o \
c_code/5_1/@mpluginsupport.nim.o \
c_code/5_1/@mplugins@slocals.nim.o \
c_code/5_1/@mplugins@sitersgen.nim.o \
c_code/5_1/@mplugins@sactive.nim.o \
c_code/5_1/@menumtostr.nim.o \
c_code/5_1/@mvtables.nim.o \
c_code/5_11/@msem.nim.o \
c_code/5_11/@mreorder.nim.o \
c_code/5_11/@mdepends.nim.o \
c_code/5_11/@msourcemap.nim.o \
c_code/5_11/@mjsgen.nim.o \
c_code/5_1/@m..@slib@spure@scollections@slists.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srstast.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@sdochelpers.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@srstidx.nim.o \
c_code/5_1/@m..@slib@spackages@sdocutils@shighlite.nim.o \
c_code/5_11/@m..@slib@spackages@sdocutils@srst.nim.o \
c_code/5_11/@m..@slib@spackages@sdocutils@srstgen.nim.o \
c_code/5_11/@mtypesrenderer.nim.o \
c_code/5_11/@mrenderverbatim.nim.o \
c_code/5_1/@m..@slib@spure@sxmltree.nim.o \
c_code/5_1/@m..@slib@spure@suri.nim.o \
c_code/5_11/@mdocgen.nim.o \
c_code/5_11/@mdocgen2.nim.o \
c_code/5_1/@mic@sreplayer.nim.o \
c_code/5_1/@mpipelines.nim.o \
c_code/5_11/@mscriptconfig.nim.o \
c_code/5_11/@mnimconf.nim.o \
c_code/5_11/@mic@sdce.nim.o \
c_code/5_1/@mic@scbackend.nim.o \
c_code/5_11/@mic@sintegrity.nim.o \
c_code/5_11/@mic@snavigator.nim.o \
c_code/5_11/@mmain.nim.o \
c_code/5_1/@mcmdlinehelper.nim.o \
c_code/5_11/@m..@slib@spure@sbrowsers.nim.o \
c_code/5_11/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@ssystem@sexceptions.nim.c -o c_code/5_11/@m..@slib@ssystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sassertions.nim.c -o c_code/5_1/@m..@slib@sstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@ssystem@siterators.nim.c -o c_code/1_1/@m..@slib@ssystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@ssystem@sdollars.nim.c -o c_code/5_1/@m..@slib@ssystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sformatfloat.nim.c -o c_code/5_1/@m..@slib@sstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@ssystem.nim.c -o c_code/5_11/@m..@slib@ssystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sparseutils.nim.c -o c_code/5_11/@m..@slib@spure@sparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@smath.nim.c -o c_code/5_1/@m..@slib@spure@smath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@salgorithm.nim.c -o c_code/5_1/@m..@slib@spure@salgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@senumutils.nim.c -o c_code/1_1/@m..@slib@sstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sunicode.nim.c -o c_code/5_1/@m..@slib@spure@sunicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstrutils.nim.c -o c_code/5_11/@m..@slib@spure@sstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@spathnorm.nim.c -o c_code/5_11/@m..@slib@spure@spathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@soserrors.nim.c -o c_code/5_11/@m..@slib@sstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@ssyncio.nim.c -o c_code/5_11/@m..@slib@sstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@slib@sposix@sposix.nim.c -o c_code/3_1/@m..@slib@sposix@sposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@sprivate@sospaths2.nim.c -o c_code/5_11/@m..@slib@sstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@stimes.nim.c -o c_code/5_1/@m..@slib@spure@stimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@sprivate@sosdirs.nim.c -o c_code/5_11/@m..@slib@sstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@sstd@senvvars.nim.c -o c_code/5_11/@m..@slib@sstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@m..@slib@sstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@scmdline.nim.c -o c_code/5_1/@m..@slib@sstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sos.nim.c -o c_code/5_11/@m..@slib@spure@sos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sparseopt.nim.c -o c_code/5_11/@m..@slib@spure@sparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.c -o c_code/1_1/@m..@slib@spure@scollections@ssequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@shashes.nim.c -o c_code/5_1/@m..@slib@spure@shashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstrtabs.nim.c -o c_code/5_11/@m..@slib@spure@sstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@scollections@stables.nim.c -o c_code/5_11/@m..@slib@spure@scollections@stables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sstrformat.nim.c -o c_code/5_1/@m..@slib@spure@sstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sterminal.nim.c -o c_code/5_1/@m..@slib@spure@sterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mplatform.nim.c -o c_code/5_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@ssets.nim.c -o c_code/5_1/@m..@slib@spure@scollections@ssets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.c -o c_code/1_1/@m..@slib@sstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.c -o c_code/2_1/@m..@slib@sstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@moptions.nim.c -o c_code/5_11/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmsgs.nim.c -o c_code/5_11/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mast.nim.c -o c_code/5_11/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mllstream.nim.c -o c_code/5_11/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mlexer.nim.c -o c_code/5_11/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mrenderer.nim.c -o c_code/5_11/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sstreams.nim.c -o c_code/5_11/@m..@slib@spure@sstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.c -o c_code/5_1/@m..@slib@spure@sconcurrency@scpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.c -o c_code/5_1/@m..@slib@spure@scollections@sdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sosproc.nim.c -o c_code/5_11/@m..@slib@spure@sosproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@slexbase.nim.c -o c_code/5_1/@m..@slib@spure@slexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@spure@sparsejson.nim.c -o c_code/5_1/@m..@slib@spure@sparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@m..@slib@spure@sjson.nim.c -o c_code/5_11/@m..@slib@spure@sjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@sjsonutils.nim.c -o c_code/5_1/@m..@slib@sstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mextccomp.nim.c -o c_code/5_11/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mnimblecmd.nim.c -o c_code/5_11/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcommands.nim.c -o c_code/5_11/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mparser.nim.c -o c_code/5_11/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mfilter_tmpl.nim.c -o c_code/5_11/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@msyntaxes.nim.c -o c_code/5_11/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@slib@sstd@spackedsets.nim.c -o c_code/5_1/@m..@slib@sstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mastalgo.nim.c -o c_code/5_11/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mbtrees.nim.c -o c_code/5_11/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@srodfiles.nim.c -o c_code/5_12/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mic@sic.nim.c -o c_code/5_11/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mmodulegraphs.nim.c -o c_code/5_11/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mndi.nim.c -o c_code/5_1/@mndi.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_11/@mcgendata.nim.c -o c_code/5_11/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $C