/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.errorbars;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.errorbars.ErrorBarPixel;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AErrorBarPolicyConfigurable
implements IErrorBarPolicy<AErrorBarPolicyConfigurable>,
PropertyChangeListener {
    private final Set<IErrorBarPainter> m_errorBarPainters = new LinkedHashSet<IErrorBarPainter>();
    private boolean m_isEnded = false;
    protected ITracePoint2D m_lastPoint;
    protected int m_lastX;
    protected int m_lastY;
    protected PropertyChangeSupport m_propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private final ErrorBarPixel m_reusedErrorBarPixel = new ErrorBarPixel(null);
    private boolean m_showNegativeXErrors;
    private boolean m_showNegativeYErrors;
    private boolean m_showPositiveXErrors;
    private boolean m_showPositiveYErrors;
    private ITrace2D m_trace;

    @Override
    public void addErrorBarPainter(IErrorBarPainter painter) {
        this.m_errorBarPainters.add(painter);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", null, painter);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
    }

    @Override
    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public final void calculateErrorBar(int xPixel, int yPixel, ErrorBarPixel errorBar, ITracePoint2D original) {
        errorBar.clear();
        if (this.m_showNegativeXErrors) {
            errorBar.setNegativeXErrorPixel(this.internalGetNegativeXError(xPixel, yPixel, original));
        }
        if (this.m_showNegativeYErrors) {
            errorBar.setNegativeYErrorPixel(this.internalGetNegativeYError(xPixel, yPixel, original));
        }
        if (this.m_showPositiveXErrors) {
            errorBar.setPositiveXErrorPixel(this.internalGetPositiveXError(xPixel, yPixel, original));
        }
        if (this.m_showPositiveYErrors) {
            errorBar.setPositiveYErrorPixel(this.internalGetPositiveYError(xPixel, yPixel, original));
        }
    }

    @Override
    public int compareTo(AErrorBarPolicyConfigurable o) {
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public void discontinue(Graphics g2d) {
        this.endPaintIteration(g2d);
        this.startPaintIteration(g2d);
    }

    @Override
    public void endPaintIteration(Graphics g2d) {
        if (g2d != null) {
            this.calculateErrorBar(this.getPreviousX(), this.getPreviousY(), this.m_reusedErrorBarPixel, this.getPreviousTracePoint());
            for (IErrorBarPainter painter : this.m_errorBarPainters) {
                painter.paintErrorBar(this.getPreviousX(), this.getPreviousY(), this.getPreviousTracePoint(), g2d, this.m_reusedErrorBarPixel);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AErrorBarPolicyConfigurable other = (AErrorBarPolicyConfigurable)obj;
        if (this.m_errorBarPainters == null ? other.m_errorBarPainters != null : !((Object)this.m_errorBarPainters).equals(other.m_errorBarPainters)) {
            return false;
        }
        if (this.m_isEnded != other.m_isEnded) {
            return false;
        }
        if (this.m_lastPoint == null ? other.m_lastPoint != null : !this.m_lastPoint.equals(other.m_lastPoint)) {
            return false;
        }
        if (this.m_lastX != other.m_lastX) {
            return false;
        }
        if (this.m_lastY != other.m_lastY) {
            return false;
        }
        if (this.m_showNegativeXErrors != other.m_showNegativeXErrors) {
            return false;
        }
        if (this.m_showNegativeYErrors != other.m_showNegativeYErrors) {
            return false;
        }
        if (this.m_showPositiveXErrors != other.m_showPositiveXErrors) {
            return false;
        }
        return this.m_showPositiveYErrors == other.m_showPositiveYErrors;
    }

    protected final void firePropertyChange(String property, Object oldvalue, Object newvalue) {
        this.m_propertyChangeSupport.firePropertyChange(property, oldvalue, newvalue);
    }

    @Override
    public JComponent getCustomConfigurator() {
        return null;
    }

    @Override
    public Set<IErrorBarPainter> getErrorBarPainters() {
        return this.m_errorBarPainters;
    }

    private ITracePoint2D getPreviousTracePoint() {
        ITracePoint2D result = this.m_lastPoint;
        return result;
    }

    private int getPreviousX() {
        int result = this.m_lastX;
        if (this.m_isEnded) {
            this.m_lastX = Integer.MIN_VALUE;
            if (this.m_lastY == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    private int getPreviousY() {
        int result = this.m_lastY;
        if (this.m_isEnded) {
            this.m_lastY = Integer.MIN_VALUE;
            if (this.m_lastX == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    protected final ITrace2D getTrace() {
        return this.m_trace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_errorBarPainters == null ? 0 : ((Object)this.m_errorBarPainters).hashCode());
        result = 31 * result + (this.m_isEnded ? 1231 : 1237);
        result = 31 * result + (this.m_lastPoint == null ? 0 : this.m_lastPoint.hashCode());
        result = 31 * result + this.m_lastX;
        result = 31 * result + this.m_lastY;
        result = 31 * result + (this.m_showNegativeXErrors ? 1231 : 1237);
        result = 31 * result + (this.m_showNegativeYErrors ? 1231 : 1237);
        result = 31 * result + (this.m_showPositiveXErrors ? 1231 : 1237);
        result = 31 * result + (this.m_showPositiveYErrors ? 1231 : 1237);
        return result;
    }

    protected abstract int internalGetNegativeXError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetNegativeYError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetPositiveXError(int var1, int var2, ITracePoint2D var3);

    protected abstract int internalGetPositiveYError(int var1, int var2, ITracePoint2D var3);

    @Override
    public final boolean isShowNegativeXErrors() {
        return this.m_showNegativeXErrors;
    }

    @Override
    public final boolean isShowNegativeYErrors() {
        return this.m_showNegativeYErrors;
    }

    @Override
    public final boolean isShowPositiveXErrors() {
        return this.m_showPositiveXErrors;
    }

    @Override
    public final boolean isShowPositiveYErrors() {
        return this.m_showPositiveYErrors;
    }

    @Override
    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        this.calculateErrorBar(nextX, nextY, this.m_reusedErrorBarPixel, original);
        for (IErrorBarPainter painter : this.m_errorBarPainters) {
            painter.paintErrorBar(nextX, nextY, original, g, this.m_reusedErrorBarPixel);
        }
        this.m_lastX = nextX;
        this.m_lastY = nextY;
        this.m_lastPoint = original;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public boolean removeErrorBarPainter(IErrorBarPainter painter) {
        boolean result = this.m_errorBarPainters.remove(painter);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        painter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        if (result) {
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", painter, null);
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
        return result;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    @Override
    public void setErrorBarPainter(IErrorBarPainter painter) {
        Iterator<IErrorBarPainter> it = this.m_errorBarPainters.iterator();
        while (it.hasNext()) {
            IErrorBarPainter removePainter = it.next();
            it.remove();
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
            removePainter.removePropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", removePainter, null);
        }
        this.m_errorBarPainters.add(painter);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_CONNECTION_COLOR", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_ENDPOINT_COLOR", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT", this);
        painter.addPropertyChangeListener("IErrorBarPainter.PROPERTY_STARTPOINT_COLOR", this);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_ERRORBARPAINTER", null, painter);
        this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
    }

    @Override
    public final void setShowNegativeXErrors(boolean showNegativeXErrors) {
        boolean change = this.m_showNegativeXErrors ^ showNegativeXErrors;
        if (change) {
            this.m_showNegativeXErrors = showNegativeXErrors;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowNegativeYErrors(boolean showNegativeYErrors) {
        boolean change = this.m_showNegativeYErrors ^ showNegativeYErrors;
        if (change) {
            this.m_showNegativeYErrors = showNegativeYErrors;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowPositiveXErrors(boolean showPositiveXErrors) {
        boolean change = this.m_showPositiveXErrors ^ showPositiveXErrors;
        if (change) {
            this.m_showPositiveXErrors = showPositiveXErrors;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public final void setShowPositiveYErrors(boolean showPositiveYErrors) {
        boolean change = this.m_showPositiveYErrors ^ showPositiveYErrors;
        if (change) {
            this.m_showPositiveYErrors = showPositiveYErrors;
            this.firePropertyChange("IErrorBarPolicy.PROPERTY_CONFIGURATION", null, null);
        }
    }

    @Override
    public void setTrace(ITrace2D trace) {
        this.m_trace = trace;
        this.m_reusedErrorBarPixel.setTrace(trace);
    }

    @Override
    public void startPaintIteration(Graphics g2d) {
    }
}

