// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
//
// Copyright (C) 2023 - Dassault Systemes - Bruno JOFRET
//
// This file is released under the 3-clause BSD license. See COPYING-BSD.

function demo_interactive_colormaps()
    colormapList = ["autumn", "bone", "cool", "copper", "gray", "hot", "hsv", ...
    "jet", "ocean", "parula", "pink", "rainbow", "spring", "summer", "white", "winter", ...
    "blues", "greens", "greys", "oranges", "purples", "reds", ...
    "BuGn", "BuPu", "GnBu", "OrRd", "PuBu", "PuBuGn", "PuRd", "RdPu", "YlGn", "YlGnBu", "YlOrBr", "YlOrRd", ...
    "BrBG", "PiYG", "PRGn", "PuOr", "RdBu", "RdGy", "RdYlBu", "RdYlGn", "spectral", "coolwarm"];

    f = figure( ...
        "default_axes", "on", ...
        "layout", "border", ...
        "visible", "off", ...
        "background", -2, ...
        "figure_name", _("Interactive colormaps"), ...
        "tag", "colormapDemoFigure");
        
     plot_frame = uicontrol(f, ...
        "style", "frame", ...
        "layout", "border", ...
        "constraints", createConstraints("border", "center"));

    newaxes(plot_frame);
    plot3d();

    control_frame =  uicontrol(f, ...
        "style", "frame", ...
        "layout", "border", ...
        "constraints", createConstraints("border", "left", [150, 0]));
        
    ddown_colormap = uicontrol(control_frame, ...
        "style", "listbox", ...
        "string", colormapList, ...
        "value", find(colormapList == "jet"), ...
        "tag", "colormapDemoChooser", ...
        "callback", "updateDemoColormap");

    f.visible = "on";
endfunction

function updateDemoColormap()
    f = findobj("tag", "colormapDemoFigure");
    ddown = findobj("tag", "colormapDemoChooser");
    f.color_map = colormap(ddown.string(ddown.value));
endfunction


demo_interactive_colormaps();
clear demo_interactive_colormaps;
