---
name: 🧠 Rsyslog Core AI Feedback
about: Report bugs, share experiences, or suggest improvements for AI features built directly into rsyslog.
title: "[Core AI]: "
labels: ['ai-core', 'bug', 'enhancement', 'feedback', 'needs-triage']
assignees: ''
---

**📣 Important Note:**

This form is for feedback on **AI functionality built into rsyslog itself** — such as automated classification, anonymization, tagging, or other AI-based logic inside the core engine.

> If your feedback is about the **external rsyslog Assistant AI** at [rsyslog.ai](https://rsyslog.ai), please use the separate "🤖 Rsyslog Assistant Feedback" form.

Your insights help us improve and shape these experimental features.

---

### 📝 Type of Feedback:
(Mark all that apply by placing an `x` in the appropriate boxes.)

- [ ] **Bug Report:** An AI feature causes errors, misbehavior, or incorrect output.
- [ ] **Performance Issue:** Excessive CPU, memory use, or delays caused by an AI feature.
- [ ] **Positive Experience:** The feature worked well or exceeded expectations.
- [ ] **Suggestion / Enhancement:** You have an idea for improvement or a new AI-based capability.
- [ ] **General Feedback:** Other comments, observations, or conceptual thoughts.

---

### 🔍 Which AI Feature / Component?
(Which part of rsyslog is involved? E.g. “log anonymization”, “drain clustering”, “aiTag”, etc. Be as specific as possible.)

```
# e.g., mmaitag, mmabstract, drain3 integration
```

---

### 💬 Scenario or Sample Input:
(What kind of log data was rsyslog processing? What conditions triggered the issue or feedback? Include relevant, sanitized config snippets or input data.)

```text
<Insert relevant input or configuration here>
```

---

### 🤖 Actual Behavior:
(What did rsyslog do that was incorrect, unexpected, or surprising? For positive experiences, describe what went well.)

```text
<Describe what you observed>
```

---

### 🎯 Expected Behavior / Desired Outcome:
(What did you expect to happen instead? What would be a better outcome?)

```text
<Describe the correct or improved behavior>
```

---

### 💡 Suggested Improvement:
(If you have ideas for improving the feature or behavior, please share them here. Even partial thoughts are helpful.)

```text
<Optional suggestions>
```

---

### 💻 Environment:
(Please provide context to help us reproduce or understand the scenario.)

* **Rsyslog Version:** `<!-- e.g. 8.2506.0 -->`
* **Platform & Distro:** `<!-- e.g. Ubuntu 24.04, CentOS 7, etc. -->`
* **Deployment Method:** `<!-- apt, yum, Docker, from source, etc. -->`

---

### ➕ Additional Context:
(Include any other relevant notes, links, screenshots, logs, or experiments. Everything helps.)

```text
<Optional>
```

---

**Thanks for helping shape the future of AI in rsyslog!** 🧠🚀

