// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetClusterParams creates a new GetClusterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetClusterParams() *GetClusterParams {
	return &GetClusterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetClusterParamsWithTimeout creates a new GetClusterParams object
// with the ability to set a timeout on a request.
func NewGetClusterParamsWithTimeout(timeout time.Duration) *GetClusterParams {
	return &GetClusterParams{
		timeout: timeout,
	}
}

// NewGetClusterParamsWithContext creates a new GetClusterParams object
// with the ability to set a context for a request.
func NewGetClusterParamsWithContext(ctx context.Context) *GetClusterParams {
	return &GetClusterParams{
		Context: ctx,
	}
}

// NewGetClusterParamsWithHTTPClient creates a new GetClusterParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetClusterParamsWithHTTPClient(client *http.Client) *GetClusterParams {
	return &GetClusterParams{
		HTTPClient: client,
	}
}

/*
GetClusterParams contains all the parameters to send to the API endpoint

	for the get cluster operation.

	Typically these are written to a http.Request.
*/
type GetClusterParams struct {

	/* ID.

	   id is the user settable GNM cluster name
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterParams) WithDefaults() *GetClusterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetClusterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get cluster params
func (o *GetClusterParams) WithTimeout(timeout time.Duration) *GetClusterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get cluster params
func (o *GetClusterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get cluster params
func (o *GetClusterParams) WithContext(ctx context.Context) *GetClusterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get cluster params
func (o *GetClusterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get cluster params
func (o *GetClusterParams) WithHTTPClient(client *http.Client) *GetClusterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get cluster params
func (o *GetClusterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get cluster params
func (o *GetClusterParams) WithID(id string) *GetClusterParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get cluster params
func (o *GetClusterParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get cluster params
func (o *GetClusterParams) WithLocationOrganizationID(locationOrganizationID string) *GetClusterParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get cluster params
func (o *GetClusterParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get cluster params
func (o *GetClusterParams) WithLocationProjectID(locationProjectID string) *GetClusterParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get cluster params
func (o *GetClusterParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get cluster params
func (o *GetClusterParams) WithLocationRegionProvider(locationRegionProvider *string) *GetClusterParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get cluster params
func (o *GetClusterParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get cluster params
func (o *GetClusterParams) WithLocationRegionRegion(locationRegionRegion *string) *GetClusterParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get cluster params
func (o *GetClusterParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetClusterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
