--DOC_GEN_IMAGE --DOC_HIDE_START
local parent = ...
local wibox  = require("wibox")

-- luacheck: push no max string line length

local image_path1 = [[
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="48" height="48" viewBox="0 0 12.7 12.7">
   <defs>
      <linearGradient id="a">
         <stop style="stop-color:#ff2121;stop-opacity:1" offset="0" />
         <stop style="stop-color:#2c21ff;stop-opacity:1" offset="1" />
      </linearGradient>
      <linearGradient xlink:href="#a" id="b" x1="37.798" y1="89.869" x2="148.167" y2="200.238" gradientUnits="userSpaceOnUse" gradientTransform="translate(31.412 180.42) scale(.11008)" />
      <linearGradient xlink:href="#a" id="c" gradientUnits="userSpaceOnUse" gradientTransform="translate(31.412 180.42) scale(.11008)" x1="148.167" y1="200.238" x2="37.798" y2="89.869" />
   </defs>
   <g transform="translate(-35.298 -190.038)">
      <rect style="fill:url(#b);stroke-width:.55040765;stroke-miterlimit:4;;" width="12.15" height="12.15" x="35.573" y="190.313" rx="2.371" ry="2.371" />
      <path style="color:#000;dominant-baseline:auto;baseline-shift:baseline;white-space:normal;shape-padding:0;clip-rule:nonzero;display:inline;overflow:visible;visibility:visible;isolation:auto;mix-blend-mode:normal;color-interpolation:sRGB;color-interpolation-filters:linearRGB;solid-color:#000;solid-vector-effect:none;fill:url(#c);fill-fill-rule:nonzero;stroke:none;stroke-width:.55040765;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dashoffset:0;stroke-color-rendering:auto;image-rendering:auto;shape-rendering:auto;enable-background:accumulate" d="M37.943 190.037a2.647 2.647 0 0 0-2.646 2.647v7.408a2.647 2.647 0 0 0 2.646 2.646h7.409a2.647 2.647 0 0 0 2.646-2.646v-7.408a2.647 2.647 0 0 0-2.646-2.647zm0 .55h7.409c1.165 0 2.095.931 2.095 2.097v7.408c0 1.165-.93 2.095-2.095 2.095h-7.409a2.085 2.085 0 0 1-2.095-2.095v-7.408c0-1.166.93-2.096 2.095-2.096z" />
   </g>
</svg>
]]

local image_path2 = [[
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="90" height="90" viewBox="0 0 23.812 23.813">
   <defs>
      <linearGradient id="a">
         <stop style="stop-color:#2c21ff;stop-opacity:1" offset="0" />
         <stop style="stop-color:#4cc155;stop-opacity:1" offset="1" />
      </linearGradient>
      <linearGradient xlink:href="#a" id="b" x1="19.837" y1="28.684" x2="21.503" y2="30.629" gradientUnits="userSpaceOnUse" gradientTransform="matrix(3.00654 0 0 3.01583 -33.75 -72.882)" />
   </defs>
   <g transform="translate(-16.82 -12.342)">
      <ellipse style="fill:#ff7f2a;stroke-width:4.39130402;stroke-miterlimit:4;" cx="20.797" cy="16.332" rx="3.977" ry="3.99" />
      <ellipse cy="16.332" cx="28.681" style="fill:url(#b);stroke-width:4.39130402;stroke-miterlimit:4;" rx="3.977" ry="3.99" />
      <ellipse style="fill:#f0c;stroke-width:4.39130402;stroke-miterlimit:4;" cx="36.655" cy="16.332" rx="3.977" ry="3.99" />
      <ellipse cy="24.29" cx="20.797" style="fill:#6f0;stroke-width:4.39130402;stroke-miterlimit:4;" rx="3.977" ry="3.99" />
      <ellipse style="fill:#cf0;stroke-width:4.39130402;stroke-miterlimit:4;" cx="28.681" cy="24.29" rx="3.977" ry="3.99" />
      <ellipse cy="24.29" cx="36.655" style="fill:#0ff;stroke-width:4.39130402;stroke-miterlimit:4;" rx="3.977" ry="3.99" />
      <ellipse style="fill:#f0f;stroke-width:4.39130402;stroke-miterlimit:4;" cx="20.797" cy="32.165" rx="3.977" ry="3.99" />
      <ellipse cy="32.165" cx="28.681" style="fill:#c8ab37;stroke-width:4.39130402;stroke-miterlimit:4;" rx="3.977" ry="3.99" />
      <ellipse style="fill:#ff2a2a;stroke-width:4.39130402;stroke-miterlimit:4;" cx="36.655" cy="32.165" rx="3.977" ry="3.99" />
   </g>
</svg>
]]

local image_path3 = [[
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" width="67.006" height="65.26">
   <defs>
      <filter height="1.408" y="-.204" width="1.408" x="-.204" id="a" style="color-interpolation-filters:sRGB">
         <feGaussianBlur stdDeviation="2.079" />
      </filter>
      <filter height="1.158" y="-.079" width="1.158" x="-.079" id="b" style="color-interpolation-filters:sRGB">
         <feGaussianBlur stdDeviation=".919" />
      </filter>
      <clipPath id="c" clipPathUnits="userSpaceOnUse">
         <rect style="opacity:1;fill:#4cc155;fill-opacity:1;" width="12.7" height="12.7" x="56.318" y="122.526" rx="2.266" ry="2.266" />
      </clipPath>
   </defs>
   <g transform="matrix(3.77953 0 0 3.77953 -205.339 -465.345)">
      <path style="opacity:1;fill:#000;fill-opacity:1;filter:url(#a)" d="M341.607 504.254v40.498H326.25v-.09h-28.72a8.542 8.542 0 0 0 8.154 5.942h30.873a8.545 8.545 0 0 0 8.562-8.565v-30.873a8.527 8.527 0 0 0-3.512-6.912z" transform="matrix(.26458 0 0 .26458 -21.823 -7.793)" />
      <rect ry="2.266" rx="2.266" y="122.526" x="56.318" height="12.7" width="12.7" style="opacity:1;fill:none;fill-opacity:1;filter:url(#b)" clip-path="url(#c)" transform="translate(-.267 1.837)" />
      <path style="color:#000;dominant-baseline:auto;baseline-shift:baseline;white-space:normal;shape-padding:0;clip-rule:nonzero;display:inline;overflow:visible;visibility:visible;opacity:1;isolation:auto;mix-blend-mode:normal;color-interpolation:sRGB;color-interpolation-filters:linearRGB;solid-color:#000;solid-opacity:1;vector-effect:none;fill:#ef00d9;fill-opacity:1;fill-rule:nonzero;color-rendering:auto;image-rendering:auto;shape-rendering:auto;enable-background:accumulate" d="M58.384 123.88a2.617 2.617 0 0 0-2.616 2.615v8.17a2.617 2.617 0 0 0 2.616 2.615h8.168a2.619 2.619 0 0 0 2.617-2.615v-8.17a2.619 2.619 0 0 0-2.617-2.615zm0 .7h8.168c1.067 0 1.916.847 1.916 1.915v8.17a1.904 1.904 0 0 1-1.917 1.916h-8.167a1.904 1.904 0 0 1-1.916-1.916v-8.17c0-1.068.848-1.914 1.916-1.914z" />
      <path style="color:#000;dominant-baseline:auto;baseline-shift:baseline;white-space:normal;shape-padding:0;clip-rule:nonzero;display:inline;overflow:visible;visibility:visible;opacity:1;isolation:auto;mix-blend-mode:normal;color-interpolation:sRGB;color-interpolation-filters:linearRGB;solid-color:#000;solid-opacity:1;vector-effect:none;fill:#0c00ef;fill-opacity:1;fill-rule:nonzero;color-rendering:auto;image-rendering:auto;shape-rendering:auto;enable-background:accumulate" d="M58.383 123.73a2.766 2.766 0 0 0-2.764 2.764v8.17a2.768 2.768 0 0 0 2.764 2.766h8.168a2.771 2.771 0 0 0 2.767-2.766v-8.17a2.77 2.77 0 0 0-2.767-2.764zm0 .3h8.168a2.468 2.468 0 0 1 2.469 2.464v8.17a2.47 2.47 0 0 1-2.47 2.467h-8.167a2.466 2.466 0 0 1-2.465-2.467v-8.17a2.464 2.464 0 0 1 2.465-2.465zm0 .402a2.054 2.054 0 0 0-2.065 2.062v8.17c0 1.147.918 2.066 2.065 2.066h8.168a2.06 2.06 0 0 0 2.066-2.066v-8.17c0-1.147-.92-2.062-2.066-2.062zm0 .298h8.168a1.75 1.75 0 0 1 1.767 1.764v8.17c0 .988-.78 1.768-1.767 1.768h-8.168c-.988 0-1.766-.78-1.766-1.768v-8.17c0-.988.778-1.764 1.766-1.764z" />
   </g>
</svg>
]]

--luacheck: pop

local l = wibox.layout {
    forced_width    = 640,
    spacing         = 5,
    forced_num_cols = 2,
    homogeneous     = false,
    expand          = false,
    layout          = wibox.layout.grid.vertical
}

l:add(wibox.widget {
    markup = "<b>Original image:</b>",
    widget = wibox.widget.textbox,
})

for idx, original in ipairs {image_path1, image_path2, image_path3 } do
    l:add_widget_at(wibox.widget {
        image         = original,
        forced_height = 64,
        forced_width  = 200,
        halign        = "center",
        widget        = wibox.widget.imagebox,
    }, 2, idx, 1, 1)
end

--DOC_HIDE_END

local images = {
    {
        path     = image_path1,
        borders = 10,
    },
    {
        path    = image_path2,
        borders = 30,
    },
    {
        path    = image_path3,
        borders = {
            top    = 20,
            left   = 20,
            bottom = 20,
            right  = 20,
        },
    },
}

--DOC_NEWLINE

for k, mode in ipairs {"fit", "repeat", "reflect", "pad"} do
    --DOC_HIDE_START
    local r = 1 + k*2

    l:add_widget_at(wibox.widget {
        markup = "<b>sides_fit_policy = \"".. mode .."\"</b>",
        widget = wibox.widget.textbox,
    }, r, 1, 1, 2)
    --DOC_HIDE_END


    for idx, image in ipairs(images) do
        local w = wibox.widget {
            {
                text          = "Central widget",
                valign        = "center",
                align         = "center",
                widget        = wibox.widget.textbox
            },
            fill               = false,
            borders            = image.borders,
            border_image       = image.path,
            sides_fit_policy   = mode,
            forced_width       = 200, --DOC_HIDE
            widget             = wibox.container.border
        }

        l:add_widget_at(w, r+1, idx, 1, 1) --DOC_HIDE
    end
    --DOC_HIDE_END
end
--DOC_HIDE_START

parent:add(l)

-- vim: filetype=lua:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:textwidth=80
