% This LilyPond file was generated by Rosegarden 25.06
\include "nederlands.ly"
\version "2.18.0"
\header {
    composer = "W. A. Mozart"
    copyright = "2003"
    title = "Quartet"
    tagline = "Created using Rosegarden 25.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*126 
}
globalTempo = {
    \override Score.MetronomeMark.transparent = ##t
    \tempo 4 = 220  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn.force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering.staff-padding = #'()
        \context StaffGroup = "1" <<
            \context GrandStaff = "1" <<

                \context Staff = "track 1, Violin I" << 
                    \set Staff.instrumentName = \markup { \center-column { "Violin I " } }
                    \set Staff.midiInstrument = "String Ensemble 1"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 0.0" {
                        % Segment: 
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 4/4
                        
                        \clef "treble"
                        \key c \major
                        c' 4. -\tenuto d' 8 -\tenuto e' 4 -\tenuto e' -\tenuto  |
                        e' 8 -\tenuto [ d' -\tenuto f' -\tenuto e' -\tenuto ] d' 4 -\tenuto r  |
                        d' 4. -\tenuto e' 8 -\tenuto f' 4 -\tenuto f' -\tenuto  |
                        f' 8 -\tenuto [ e' -\tenuto g' -\tenuto f' -\tenuto ] e' 4 -\tenuto r  |
%% 5
                        a' 4. -\tenuto b' 8 -\tenuto c'' 4 -\tenuto c'' -\tenuto  |
                        c'' 4 -\tenuto b' -\tenuto a' -\tenuto g' -\tenuto  |
                        g' 4 -\tenuto f' -\tenuto e' -\tenuto d' -\tenuto  |
                        c' 4 -\tenuto r r2  |
                        c'' 4. -\tenuto d'' 8 -\tenuto e'' 4 -\tenuto e'' -\tenuto  |
%% 10
                        e'' 8 -\tenuto [ d'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 4 -\tenuto r  |
                        d'' 4. -\tenuto e'' 8 -\tenuto f'' 4 -\tenuto f'' -\tenuto  |
                        f'' 8 -\tenuto [ e'' -\tenuto g'' -\tenuto f'' -\tenuto ] e'' 4 -\tenuto r  |
                        g'' 4. -\tenuto e'' 16 -\tenuto [ f'' -\tenuto ] g'' 8 -\tenuto [ a'' 16 -\tenuto b'' -\tenuto ] d''' -\tenuto [ c''' -\tenuto b'' -\tenuto a'' -\tenuto ]  |
                        g'' 4. -\tenuto e'' 16 -\tenuto [ f'' -\tenuto ] g'' 8 -\tenuto [ a'' 16 -\tenuto b'' -\tenuto ] d''' -\tenuto [ c''' -\tenuto b'' -\tenuto a'' -\tenuto ]  |
%% 15
                        a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 8 -\tenuto [ e'' -\tenuto ] a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 8 -\tenuto [ e'' -\tenuto ]  |
                        e'' 8. -\tenuto [ c'' 16 -\tenuto ] a' 8. -\tenuto [ d'' 16 -\tenuto ] c'' 4 -\tenuto b' -\tenuto  |
                        a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' -\tenuto [ e'' -\tenuto d'' -\tenuto e'' -\tenuto ] g'' -\tenuto [ f'' -\tenuto e'' -\tenuto d'' -\tenuto ] c'' -\tenuto [ d'' -\tenuto c'' -\tenuto d'' -\tenuto ]  |
                        e'' 16 -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ] a' -\tenuto [ b' -\tenuto c'' -\tenuto d'' -\tenuto ] c'' 4 -\tenuto b' -\tenuto  |
                        c'' 4. -\tenuto d'' 16 -\tenuto [ e'' -\tenuto ] f'' 8 -\tenuto [ g'' -\tenuto a'' -\tenuto f'' -\tenuto ]  |
%% 20
                        e'' 2 -\tenuto d'' 4 -\tenuto r  |
                        b'' 2 -\tenuto a'' 16 -\tenuto g'' 8. -\tenuto f'' 16 -\tenuto e'' 8. -\tenuto  |
                        d'' 8 -\tenuto [ c'' -\tenuto b' -\tenuto c'' -\tenuto ] a 4 -\tenuto r  |
                        a'' 2 -\tenuto g'' 16 -\tenuto fis'' 8. -\tenuto e'' 16 -\tenuto d'' 8. -\tenuto  |
                        c'' 8 -\tenuto [ b' -\tenuto a' -\tenuto b' -\tenuto ] g 4 -\tenuto r  |
%% 25
                        e'' 8. -\tenuto [ g'' 16 -\tenuto a'' 32 -\tenuto g'' -\tenuto a'' -\tenuto g'' -\tenuto a'' -\tenuto g'' -\tenuto fis'' -\tenuto g'' -\tenuto ] d'' 4. -\tenuto b' 8 -\tenuto  |
                        c'' 16 -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ] c'' -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ] b' 2 -\tenuto  |
                        e'' 8. -\tenuto [ g'' 16 -\tenuto a'' 32 -\tenuto g'' -\tenuto a'' -\tenuto g'' -\tenuto a'' -\tenuto g'' -\tenuto fis'' -\tenuto g'' -\tenuto ] d'' 4. -\tenuto b' 8 -\tenuto  |
                        c'' 16 -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ] c'' -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ] b' 2 -\tenuto  |
                        a' 4 -\tenuto a'' 2 -\tenuto g'' 4 -\tenuto  |
%% 30
                        g'' 16 -\tenuto [ fis'' -\tenuto e'' -\tenuto d'' -\tenuto ] d'' 8 -\tenuto [ d'' -\tenuto ] d'' 4 -\tenuto r  |
                        g'' 8 -\tenuto [ g'' -\tenuto ] r a'' 16 -\tenuto [ fis'' -\tenuto ] g'' 8 -\tenuto [ d'' -\tenuto g'' -\tenuto b'' -\tenuto ]  |
                        g'' 8 -\tenuto [ g'' -\tenuto ] r a'' 16 -\tenuto [ fis'' -\tenuto ] g'' 8 -\tenuto [ d'' -\tenuto g'' -\tenuto b'' -\tenuto ]  |
                        d''' 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 1  |
%% 35
                        r2 c''' -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 b'' 2 -\tenuto  |
                        a'' 4. -\tenuto c''' 16 -\tenuto [ a'' -\tenuto ] g'' 4 -\tenuto fis'' -\tenuto  |
                        g'' 8 -\tenuto [ d'' -\tenuto d'' -\tenuto d'' -\tenuto ] d'' -\tenuto [ d'' -\tenuto d'' -\tenuto d'' -\tenuto ]  |
                        d'' 2 -\tenuto c'' -\tenuto 
                        % warning: overlong bar truncated here |
%% 40
                        \skip 2 b' 2 -\tenuto  |
                        a' 4. -\tenuto c'' 16 -\tenuto [ e'' -\tenuto ] g' 4 -\tenuto fis' -\tenuto  |
                        g' 8 -\tenuto [ b' -\tenuto d' -\tenuto d' -\tenuto ] a' -\tenuto [ c'' -\tenuto d' -\tenuto d' -\tenuto ]  |
                        b' 8 -\tenuto [ d'' -\tenuto d' -\tenuto d' -\tenuto ] d'' 16 -\tenuto [ c'' -\tenuto b' -\tenuto a' -\tenuto ] b' -\tenuto [ a' -\tenuto g' -\tenuto fis' -\tenuto ]  |
                        g' 8 -\tenuto [ b' -\tenuto d' -\tenuto d' -\tenuto ] a' -\tenuto [ c'' -\tenuto d' -\tenuto d' -\tenuto ]  |
%% 45
                        b' 8 -\tenuto [ d'' -\tenuto d' -\tenuto d' -\tenuto ] d'' 16 -\tenuto [ c'' -\tenuto b' -\tenuto a' -\tenuto ] b' -\tenuto [ a' -\tenuto g' -\tenuto fis' -\tenuto ]  |
                        g' 4 -\tenuto g'' -\tenuto a'' -\tenuto b'' -\tenuto  |
                        c''' 4 -\tenuto b'' -\tenuto a'' 8 -\tenuto [ g'' -\tenuto a'' -\tenuto b'' -\tenuto ]  |
                        g'' 4 -\tenuto g' -\tenuto a' -\tenuto b' -\tenuto  |
                        c'' 4 -\tenuto b' -\tenuto a' 8 -\tenuto [ g' -\tenuto a' -\tenuto b' -\tenuto ]  |
%% 50
                        g' 2 -\tenuto a' 8 -\tenuto [ g' -\tenuto a' -\tenuto b' -\tenuto ]  |
                        g' 2 -\tenuto a' 8 -\tenuto [ g' -\tenuto a' -\tenuto b' -\tenuto ]  |
                        g' 4 -\tenuto g'' -\tenuto g'' -\tenuto r  |
                        g' 8 -\tenuto [ b' -\tenuto d' -\tenuto d' -\tenuto ] b' -\tenuto [ d'' -\tenuto f' -\tenuto f' -\tenuto ]  |
                        d'' 8 -\tenuto [ g'' -\tenuto b' -\tenuto b' -\tenuto ] a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] e'' -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ]  |
%% 55
                        c'' 8 -\tenuto [ e'' -\tenuto g' -\tenuto g' -\tenuto ] e'' -\tenuto [ g'' -\tenuto c'' -\tenuto c'' -\tenuto ]  |
                        g'' 8 -\tenuto [ c''' -\tenuto e'' -\tenuto e'' -\tenuto ] a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] f'' -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ]  |
                        b' 8 -\tenuto [ d'' -\tenuto g' -\tenuto g' -\tenuto ] d'' -\tenuto [ f'' -\tenuto b' -\tenuto b' -\tenuto ]  |
                        f'' 8 -\tenuto [ b'' -\tenuto b' -\tenuto b' -\tenuto ] g'' 16 -\tenuto [ f'' -\tenuto e'' -\tenuto d'' -\tenuto ] e'' -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ]  |
                        e'' 8 -\tenuto [ a'' -\tenuto c'' -\tenuto c'' -\tenuto ] f'' 16 -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ] d'' -\tenuto [ c'' -\tenuto b' -\tenuto a' -\tenuto ]  |
%% 60
                        aes' 4 -\tenuto e'' -\tenuto e'' -\tenuto r  |
                        a' 8 -\tenuto [ a' -\tenuto ] r b' 16 -\tenuto [ aes' -\tenuto ] a' 8 -\tenuto [ e' -\tenuto a' -\tenuto c'' -\tenuto ]  |
                        a' 8 -\tenuto [ a' -\tenuto ] r b' 16 -\tenuto [ aes' -\tenuto ] a' 8 -\tenuto [ a' -\tenuto c'' -\tenuto e'' -\tenuto ]  |
                        a'' 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 1  |
%% 65
                        g'' 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 1  |
                        r2 f'' -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 e'' 2 -\tenuto  |
                        ees'' 2 -\tenuto d'' 4 -\tenuto c'' -\tenuto  |
%% 70
                        b' 16 -\tenuto [ g'' -\tenuto g'' -\tenuto g'' -\tenuto ] g'' -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ] d'' -\tenuto [ g'' -\tenuto g'' -\tenuto g'' -\tenuto ] g'' -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ]  |
                        b' 8 -\tenuto [ d'' -\tenuto g'' -\tenuto b'' -\tenuto ] r c''' -\tenuto [ a'' -\tenuto f'' -\tenuto ]  |
                        r8 e'' -\tenuto [ g'' -\tenuto b'' -\tenuto ] r a'' -\tenuto [ f'' -\tenuto d'' -\tenuto ]  |
                        r8 c'' -\tenuto [ e'' -\tenuto g'' -\tenuto ] f'' 16 -\tenuto [ g'' -\tenuto e'' -\tenuto g'' -\tenuto ] f'' -\tenuto [ g'' -\tenuto e'' -\tenuto g'' -\tenuto ]  |
                        f'' 8 -\tenuto [ d'' -\tenuto b' -\tenuto g' -\tenuto ] fis' -\tenuto [ f' -\tenuto d' -\tenuto b -\tenuto ]  |
%% 75
                        c' 4. -\tenuto d' 8 -\tenuto e' 4 -\tenuto e' -\tenuto  |
                        e' 8 -\tenuto [ d' -\tenuto f' -\tenuto e' -\tenuto ] d' 4 -\tenuto r  |
                        d' 4. -\tenuto e' 8 -\tenuto f' 4 -\tenuto f' -\tenuto  |
                        f' 8 -\tenuto [ e' -\tenuto g' -\tenuto f' -\tenuto ] e' 4 -\tenuto r  |
                        a' 4. -\tenuto b' 8 -\tenuto c'' 4 -\tenuto c'' -\tenuto  |
%% 80
                        c'' 4 -\tenuto b' -\tenuto a' -\tenuto g' -\tenuto  |
                        g' 4 -\tenuto f' -\tenuto e' -\tenuto d' -\tenuto  |
                        c' 4 -\tenuto r r2  |
                        c'' 4. -\tenuto d'' 8 -\tenuto e'' 4 -\tenuto e'' -\tenuto  |
                        e'' 8 -\tenuto [ d'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 4 -\tenuto r  |
%% 85
                        d'' 4. -\tenuto e'' 8 -\tenuto f'' 4 -\tenuto f'' -\tenuto  |
                        f'' 8 -\tenuto [ e'' -\tenuto g'' -\tenuto f'' -\tenuto ] e'' 4 -\tenuto r  |
                        g'' 4. -\tenuto e'' 16 -\tenuto [ f'' -\tenuto ] g'' 8 -\tenuto [ a'' 16 -\tenuto b'' -\tenuto ] d''' -\tenuto [ c''' -\tenuto b'' -\tenuto a'' -\tenuto ]  |
                        g'' 4. -\tenuto e'' 16 -\tenuto [ f'' -\tenuto ] g'' 8 -\tenuto [ a'' 16 -\tenuto b'' -\tenuto ] d''' -\tenuto [ c''' -\tenuto b'' -\tenuto a'' -\tenuto ]  |
                        a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 8 -\tenuto [ e'' -\tenuto ] a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' 8 -\tenuto [ e'' -\tenuto ]  |
%% 90
                        e'' 8. -\tenuto [ c'' 16 -\tenuto ] a' 8. -\tenuto [ d'' 16 -\tenuto ] c'' 4 -\tenuto b' -\tenuto  |
                        a'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] d'' -\tenuto [ e'' -\tenuto d'' -\tenuto e'' -\tenuto ] g'' -\tenuto [ f'' -\tenuto e'' -\tenuto d'' -\tenuto ] c'' -\tenuto [ d'' -\tenuto c'' -\tenuto d'' -\tenuto ]  |
                        e'' 16 -\tenuto [ d'' -\tenuto e'' -\tenuto c'' -\tenuto ] a' -\tenuto [ b' -\tenuto c'' -\tenuto d'' -\tenuto ] c'' 4 -\tenuto b' -\tenuto  |
                        c'' 4. -\tenuto d'' 16 -\tenuto [ e'' -\tenuto ] f'' 8 -\tenuto [ g'' -\tenuto a'' -\tenuto f'' -\tenuto ]  |
                        e'' 2 -\tenuto d'' 4 -\tenuto r  |
%% 95
                        bes'' 2 -\tenuto a'' 16 -\tenuto g'' 8. -\tenuto f'' 16 -\tenuto e'' 8. -\tenuto  |
                        e'' 8 -\tenuto [ f'' -\tenuto cis'' -\tenuto d'' -\tenuto ] d' 4 -\tenuto r  |
                        a'' 2 -\tenuto g'' 16 -\tenuto f'' 8. -\tenuto e'' 16 -\tenuto d'' 8. -\tenuto  |
                        d'' 8 -\tenuto [ e'' -\tenuto b' -\tenuto c'' -\tenuto ] c' 4 -\tenuto r  |
                        a'' 8. -\tenuto [ c''' 16 -\tenuto d''' 32 -\tenuto c''' -\tenuto d''' -\tenuto c''' -\tenuto d''' -\tenuto c''' -\tenuto b'' -\tenuto c''' -\tenuto ] g'' 4. -\tenuto e'' 8 -\tenuto  |
%% 100
                        f'' 16 -\tenuto [ g'' -\tenuto f'' -\tenuto e'' -\tenuto ] f'' -\tenuto [ g'' -\tenuto a'' -\tenuto f'' -\tenuto ] e'' 2 -\tenuto  |
                        a' 8. -\tenuto [ c'' 16 -\tenuto d'' 32 -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto b' -\tenuto c'' -\tenuto ] g' 4. -\tenuto e' 8 -\tenuto  |
                        f' 16 -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ] f' -\tenuto [ g' -\tenuto a' -\tenuto f' -\tenuto ] e' 2 -\tenuto  |
                        d' 4 -\tenuto d'' 2 -\tenuto c'' 4 -\tenuto  |
                        c'' 16 -\tenuto [ b' -\tenuto a' -\tenuto g' -\tenuto ] g' 8 -\tenuto [ g' -\tenuto ] g' 4 -\tenuto r  |
%% 105
                        c'' 8 -\tenuto [ c'' -\tenuto ] r d'' 16 -\tenuto [ b' -\tenuto ] c'' 8 -\tenuto [ g' -\tenuto c'' -\tenuto e'' -\tenuto ]  |
                        c'' 8 -\tenuto [ c'' -\tenuto ] r d'' 16 -\tenuto [ b' -\tenuto ] c'' 8 -\tenuto [ g' -\tenuto c'' -\tenuto e'' -\tenuto ]  |
                        g'' 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 1  |
                        r2 f'' -\tenuto 
                        % warning: overlong bar truncated here |
%% 110
                        \skip 2 e'' 2 -\tenuto  |
                        d'' 4. -\tenuto f'' 16 -\tenuto [ a'' -\tenuto ] c'' 4 -\tenuto b' -\tenuto  |
                        c'' 8 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g' -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ]  |
                        g' 2 -\tenuto f' -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 e' 2 -\tenuto  |
%% 115
                        d' 4. -\tenuto f' 16 -\tenuto [ a' -\tenuto ] c' 4 -\tenuto b -\tenuto  |
                        c' 8 -\tenuto [ e' -\tenuto g -\tenuto g -\tenuto ] d' -\tenuto [ f' -\tenuto g -\tenuto g -\tenuto ]  |
                        e' 8 -\tenuto [ g' -\tenuto c'' -\tenuto c'' -\tenuto ] g'' 16 -\tenuto [ f'' -\tenuto e'' -\tenuto d'' -\tenuto ] e'' -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ]  |
                        c'' 8 -\tenuto [ e'' -\tenuto g' -\tenuto g' -\tenuto ] d'' -\tenuto [ f'' -\tenuto g' -\tenuto g' -\tenuto ]  |
                        e'' 8 -\tenuto [ g'' -\tenuto g' -\tenuto g' -\tenuto ] g'' 16 -\tenuto [ f'' -\tenuto e'' -\tenuto d'' -\tenuto ] e'' -\tenuto [ d'' -\tenuto c'' -\tenuto b' -\tenuto ]  |
%% 120
                        c'' 4 -\tenuto c'' -\tenuto d'' -\tenuto e'' -\tenuto  |
                        f'' 4 -\tenuto e'' -\tenuto d'' 8 -\tenuto [ c'' -\tenuto d'' -\tenuto e'' -\tenuto ]  |
                        c'' 4 -\tenuto c' -\tenuto d' -\tenuto e' -\tenuto  |
                        f' 4 -\tenuto e' -\tenuto d' 8 -\tenuto [ c' -\tenuto d' -\tenuto e' -\tenuto ]  |
                        c' 2 -\tenuto d' 8 -\tenuto [ c' -\tenuto d' -\tenuto e' -\tenuto ]  |
%% 125
                        c' 2 -\tenuto d' 8 -\tenuto [ c' -\tenuto d' -\tenuto e' -\tenuto ]  |
                        c' 4 -\tenuto c''' -\tenuto c''' 2 -\tenuto 
                        \bar "|."
                    } % Voice

                    % End of segment 

                    % End voice 0
                >> % Staff ends

                \context Staff = "track 2, Violin II" << 
                    \set Staff.instrumentName = \markup { \center-column { "Violin II " } }
                    \set Staff.midiInstrument = "String Ensemble 1"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 1.0" {
                        % Segment: 
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 4/4
                        
                        \clef "treble"
                        \key c \major
                        r4 r8 b -\tenuto c' 4 -\tenuto c' -\tenuto  |
                        c' 8 -\tenuto [ b -\tenuto d' -\tenuto c' -\tenuto ] b 4 -\tenuto r  |
                        b 4. -\tenuto c' 8 -\tenuto d' 4 -\tenuto d' -\tenuto  |
                        d' 8 -\tenuto [ c' -\tenuto e' -\tenuto d' -\tenuto ] c' 4 -\tenuto r  |
%% 5
                        d' 2. -\tenuto a' 4 -\tenuto  |
                        a' 4 -\tenuto g' -\tenuto f' -\tenuto e' -\tenuto  |
                        e' 4 -\tenuto d' -\tenuto c' -\tenuto b -\tenuto  |
                        c' 4 -\tenuto r r2  |
                        c'' 4. -\tenuto b' 8 -\tenuto c'' 4 -\tenuto c'' -\tenuto  |
%% 10
                        c'' 8 -\tenuto [ b' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 4 -\tenuto r  |
                        b' 4. -\tenuto c'' 8 -\tenuto d'' 4 -\tenuto d'' -\tenuto  |
                        d'' 8 -\tenuto [ c'' -\tenuto e'' -\tenuto d'' -\tenuto ] c'' 4 -\tenuto r  |
                        e'' 4. -\tenuto c'' 16 -\tenuto [ d'' -\tenuto ] e'' 8 -\tenuto [ f'' 16 -\tenuto g'' -\tenuto ] b'' -\tenuto [ a'' -\tenuto g'' -\tenuto f'' -\tenuto ]  |
                        e'' 4. -\tenuto c'' 16 -\tenuto [ d'' -\tenuto ] e'' 8 -\tenuto [ f'' 16 -\tenuto g'' -\tenuto ] b'' -\tenuto [ a'' -\tenuto g'' -\tenuto f'' -\tenuto ]  |
%% 15
                        f'' 16 -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 8 -\tenuto [ c'' -\tenuto ] f'' 16 -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 8 -\tenuto [ c'' -\tenuto ]  |
                        c'' 8. -\tenuto [ e' 16 -\tenuto ] c' 8. -\tenuto [ f' 16 -\tenuto ] e' 4 -\tenuto d' -\tenuto  |
                        f' 16 -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ] b -\tenuto [ c' -\tenuto b -\tenuto c' -\tenuto ] e' -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ] a -\tenuto [ b -\tenuto a -\tenuto b -\tenuto ]  |
                        c' 4 -\tenuto c' 16 -\tenuto [ d' -\tenuto e' -\tenuto f' -\tenuto ] e' 4 -\tenuto d' -\tenuto  |
                        c' 4. -\tenuto d' 16 -\tenuto [ e' -\tenuto ] f' 8 -\tenuto [ g' -\tenuto a' -\tenuto d'' -\tenuto ]  |
%% 20
                        c'' 2 -\tenuto b' 4 -\tenuto r  |
                        R1  |
                        e'' 2 -\tenuto d'' 16 -\tenuto c'' 8. -\tenuto b' 16 -\tenuto a' 8. -\tenuto  |
                        g' 8 -\tenuto [ fis' -\tenuto e' -\tenuto fis' -\tenuto ] a 4 -\tenuto r  |
                        d'' 2 -\tenuto c'' 16 -\tenuto b' 8. -\tenuto a' 16 -\tenuto g' 8. -\tenuto  |
%% 25
                        g' 4 -\tenuto r g 8. -\tenuto [ g' 16 -\tenuto a' 32 -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto fis' -\tenuto g' -\tenuto ]  |
                        g 2 -\tenuto r16 g' -\tenuto [ fis' -\tenuto g' -\tenuto ] a' -\tenuto [ g' -\tenuto fis' -\tenuto g' -\tenuto ]  |
                        g' 4 -\tenuto r g 8. -\tenuto [ g' 16 -\tenuto a' 32 -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto fis' -\tenuto g' -\tenuto ]  |
                        g 2 -\tenuto r16 g' -\tenuto [ fis' -\tenuto g' -\tenuto ] a' -\tenuto [ g' -\tenuto fis' -\tenuto g' -\tenuto ]  |
                        g' 8 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g' -\tenuto [ g' -\tenuto e'' -\tenuto e'' -\tenuto ]  |
%% 30
                        d'' 4 -\tenuto a' -\tenuto fis' -\tenuto r  |
                        r4 c'' -\tenuto b' -\tenuto r  |
                        r4 c'' -\tenuto b' -\tenuto r  |
                        g' 8 -\tenuto [ g' -\tenuto ] r a' 16 -\tenuto [ fis' -\tenuto ] g' 8 -\tenuto [ d' -\tenuto g' -\tenuto a' -\tenuto ]  |
                        b' 8 -\tenuto [ b' -\tenuto ] r c'' 16 -\tenuto [ a' -\tenuto ] b' 8 -\tenuto [ g' -\tenuto d'' -\tenuto c'' -\tenuto ]  |
%% 35
                        b' 4 -\tenuto e'' 2 -\tenuto a' 4 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 4 d'' 2 -\tenuto g' 4 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 4 r8 e'' 16 -\tenuto [ c'' -\tenuto ] b' 4 -\tenuto a' -\tenuto  |
                        g' 4 -\tenuto r r2  |
                        aes' 4 -\tenuto b' -\tenuto c'' 8 -\tenuto [ b' -\tenuto a' -\tenuto g' -\tenuto ]  |
%% 40
                        fis' 4 -\tenuto a' -\tenuto b' 8 -\tenuto [ a' -\tenuto g' -\tenuto fis' -\tenuto ]  |
                        e' 4. -\tenuto c' 8 -\tenuto b 4 -\tenuto a -\tenuto  |
                        b 4 -\tenuto r c' -\tenuto r  |
                        b 4 -\tenuto r e' -\tenuto c' -\tenuto  |
                        b 4 -\tenuto r d' -\tenuto r  |
%% 45
                        d' 4 -\tenuto r e' -\tenuto c' -\tenuto  |
                        b 4 -\tenuto g' -\tenuto a' -\tenuto b' -\tenuto  |
                        c'' 4 -\tenuto b' -\tenuto a' 8 -\tenuto [ g' -\tenuto a' -\tenuto b' -\tenuto ]  |
                        g' 4 -\tenuto d' -\tenuto fis' -\tenuto g' -\tenuto  |
                        a' 4 -\tenuto g' -\tenuto c' 8 -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
%% 50
                        b 2 -\tenuto c' 8 -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
                        b 2 -\tenuto c' 8 -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
                        b 4 -\tenuto b' -\tenuto b' -\tenuto r  |
                        d' 4 -\tenuto r g' -\tenuto r  |
                        b' 4 -\tenuto r r2  |
%% 55
                        e' 4 -\tenuto r g' -\tenuto r  |
                        c'' 4 -\tenuto r r2  |
                        f' 4 -\tenuto r d' -\tenuto r  |
                        d'' 4 -\tenuto r r2  |
                        c'' 4 -\tenuto r a' -\tenuto e' -\tenuto  |
%% 60
                        e' 4 -\tenuto aes' -\tenuto aes' -\tenuto r  |
                        r4 d' -\tenuto c' -\tenuto r  |
                        r4 d' -\tenuto c' -\tenuto r  |
                        e' 8 -\tenuto [ e' -\tenuto ] r g' 16 -\tenuto [ e' -\tenuto ] f' 8 -\tenuto [ f' -\tenuto ] r f'' 16 -\tenuto [ d'' -\tenuto ]  |
                        cis'' 8 -\tenuto [ e'' -\tenuto e' -\tenuto g' -\tenuto ] f' -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ]  |
%% 65
                        d' 8 -\tenuto [ d' -\tenuto ] r f' 16 -\tenuto [ d' -\tenuto ] e' 8 -\tenuto [ e' -\tenuto ] r e'' 16 -\tenuto [ c'' -\tenuto ]  |
                        b' 8 -\tenuto [ d'' -\tenuto d' -\tenuto f' -\tenuto ] e' -\tenuto [ g' -\tenuto c'' -\tenuto g' -\tenuto ]  |
                        e' 4 -\tenuto a' 2 -\tenuto d' 4 -\tenuto  |
                        d' 4 -\tenuto g' 2 -\tenuto c' 4 -\tenuto  |
                        c' 2 -\tenuto d' 4 -\tenuto ees' -\tenuto  |
%% 70
                        d' 4 -\tenuto b' 8 -\tenuto [ c'' -\tenuto ] b' 4 -\tenuto b 8 -\tenuto [ c' -\tenuto ]  |
                        b 16 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g' -\tenuto [ b' -\tenuto b' -\tenuto g' -\tenuto ] g' -\tenuto [ f' -\tenuto f' -\tenuto f' -\tenuto ] f' -\tenuto [ a' -\tenuto a' -\tenuto c'' -\tenuto ]  |
                        c'' 16 -\tenuto [ b' -\tenuto b' -\tenuto b' -\tenuto ] b' -\tenuto [ g' -\tenuto g' -\tenuto e' -\tenuto ] e' -\tenuto [ d' -\tenuto d' -\tenuto d' -\tenuto ] d' -\tenuto [ f' -\tenuto f' -\tenuto a' -\tenuto ]  |
                        a' 16 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g' -\tenuto [ e' -\tenuto e' -\tenuto c' -\tenuto ] b 8 -\tenuto [ c' -\tenuto b -\tenuto c' -\tenuto ]  |
                        b 4 -\tenuto r r2  |
%% 75
                        c' 4. -\tenuto b 8 -\tenuto c' 4 -\tenuto c' -\tenuto  |
                        c' 8 -\tenuto [ b -\tenuto d' -\tenuto c' -\tenuto ] b 4 -\tenuto r  |
                        b 4. -\tenuto c' 8 -\tenuto d' 4 -\tenuto d' -\tenuto  |
                        d' 8 -\tenuto [ c' -\tenuto e' -\tenuto d' -\tenuto ] c' 4 -\tenuto r  |
                        d' 2. -\tenuto a' 4 -\tenuto  |
%% 80
                        a' 4 -\tenuto g' -\tenuto f' -\tenuto e' -\tenuto  |
                        e' 4 -\tenuto d' -\tenuto c' -\tenuto b -\tenuto  |
                        c' 4 -\tenuto r r2  |
                        c'' 4. -\tenuto b' 8 -\tenuto c'' 4 -\tenuto c'' -\tenuto  |
                        c'' 8 -\tenuto [ b' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 4 -\tenuto r  |
%% 85
                        b' 4. -\tenuto c'' 8 -\tenuto d'' 4 -\tenuto d'' -\tenuto  |
                        d'' 8 -\tenuto [ c'' -\tenuto e'' -\tenuto d'' -\tenuto ] c'' 4 -\tenuto r  |
                        e'' 4. -\tenuto c'' 16 -\tenuto [ d'' -\tenuto ] e'' 8 -\tenuto [ f'' 16 -\tenuto g'' -\tenuto ] b'' -\tenuto [ a'' -\tenuto g'' -\tenuto f'' -\tenuto ]  |
                        e'' 4. -\tenuto c'' 16 -\tenuto [ d'' -\tenuto ] e'' 8 -\tenuto [ f'' 16 -\tenuto g'' -\tenuto ] b'' -\tenuto [ a'' -\tenuto g'' -\tenuto f'' -\tenuto ]  |
                        f'' 16 -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 8 -\tenuto [ c'' -\tenuto ] f'' 16 -\tenuto [ e'' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 8 -\tenuto [ c'' -\tenuto ]  |
%% 90
                        c'' 8. -\tenuto [ e' 16 -\tenuto ] c' 8. -\tenuto [ f' 16 -\tenuto ] e' 4 -\tenuto d' -\tenuto  |
                        f' 16 -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ] b -\tenuto [ c' -\tenuto b -\tenuto c' -\tenuto ] e' -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ] a -\tenuto [ b -\tenuto a -\tenuto b -\tenuto ]  |
                        c' 4 -\tenuto c' 16 -\tenuto [ d' -\tenuto e' -\tenuto f' -\tenuto ] e' 4 -\tenuto d' -\tenuto  |
                        c' 4. -\tenuto d' 16 -\tenuto [ e' -\tenuto ] f' 8 -\tenuto [ g' -\tenuto a' -\tenuto d'' -\tenuto ]  |
                        c'' 2 -\tenuto b' 4 -\tenuto r  |
%% 95
                        R1  |
                        a'' 2 -\tenuto g'' 16 -\tenuto f'' 8. -\tenuto e'' 16 -\tenuto d'' 8. -\tenuto  |
                        c'' 8 -\tenuto [ b' -\tenuto d'' -\tenuto c'' -\tenuto ] b' 4 -\tenuto r  |
                        g'' 2 -\tenuto f'' 16 -\tenuto e'' 8. -\tenuto d'' 16 -\tenuto c'' 8. -\tenuto  |
                        c'' 4 -\tenuto r c' 8. -\tenuto [ c'' 16 -\tenuto d'' 32 -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto b' -\tenuto c'' -\tenuto ]  |
%% 100
                        c' 2 -\tenuto r16 c'' -\tenuto [ b' -\tenuto c'' -\tenuto ] d'' -\tenuto [ c'' -\tenuto b' -\tenuto c'' -\tenuto ]  |
                        c' 4 -\tenuto r c' 8. -\tenuto [ c'' 16 -\tenuto d'' 32 -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto b' -\tenuto c'' -\tenuto ]  |
                        c' 2 -\tenuto c' 16 -\tenuto [ c'' -\tenuto b' -\tenuto c'' -\tenuto ] d'' -\tenuto [ c'' -\tenuto b' -\tenuto c'' -\tenuto ]  |
                        c' 8 -\tenuto [ c' -\tenuto c' -\tenuto c' -\tenuto ] c' -\tenuto [ c' -\tenuto a' -\tenuto a' -\tenuto ]  |
                        e' 16 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ] b 8 -\tenuto [ b -\tenuto ] b 4 -\tenuto r  |
%% 105
                        r4 f' -\tenuto e' -\tenuto r  |
                        r4 f' -\tenuto e' -\tenuto r  |
                        c' 8 -\tenuto [ c' -\tenuto ] r d' 16 -\tenuto [ b -\tenuto ] c' 8 -\tenuto [ g -\tenuto c' -\tenuto d' -\tenuto ]  |
                        e' 8 -\tenuto [ e' -\tenuto ] r f' 16 -\tenuto [ d' -\tenuto ] e' 8 -\tenuto [ c' -\tenuto g' -\tenuto f' -\tenuto ]  |
                        e' 4 -\tenuto a' 2 -\tenuto d' 4 -\tenuto 
                        % warning: overlong bar truncated here |
%% 110
                        \skip 4 g' 2 -\tenuto c' 4 -\tenuto  |
                        a' 4. -\tenuto f' 8 -\tenuto [ e' -\tenuto g' -\tenuto f' -\tenuto ] d' -\tenuto  |
                        c' 4 -\tenuto r r2  |
                        cis' 4 -\tenuto e' -\tenuto f' 8 -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ]  |
                        b 4 -\tenuto d' -\tenuto e' 8 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ]  |
%% 115
                        a 4 -\tenuto f' -\tenuto e' -\tenuto d' -\tenuto  |
                        c' 4 -\tenuto r g -\tenuto r  |
                        g 4 -\tenuto r d' -\tenuto f' -\tenuto  |
                        e' 4 -\tenuto r g' -\tenuto r  |
                        g' 4 -\tenuto r a' -\tenuto f' -\tenuto  |
%% 120
                        e' 4 -\tenuto g' -\tenuto b' -\tenuto c'' -\tenuto  |
                        d'' 4 -\tenuto c'' -\tenuto b' 8 -\tenuto [ a' -\tenuto b' -\tenuto c'' -\tenuto ]  |
                        e' 4 -\tenuto g -\tenuto b -\tenuto c' -\tenuto  |
                        d' 4 -\tenuto c' -\tenuto b 2 -\tenuto  |
                        c' 2 -\tenuto b -\tenuto  |
%% 125
                        c' 2 -\tenuto b -\tenuto  |
                        c' 4 -\tenuto e'' -\tenuto e'' 2 -\tenuto 
                        \bar "|."
                    } % Voice

                    % End of segment 

                    % End voice 0
                >> % Staff ends
            >> % GrandStaff (final) 1
            \context GrandStaff = "2" <<

                \context Staff = "track 3, Viola" << 
                    \set Staff.instrumentName = \markup { \center-column { "Viola " } }
                    \set Staff.midiInstrument = "String Ensemble 1"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 2.0" {
                        % Segment: 
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 4/4
                        
                        \clef "alto"
                        \key c \major
                        g 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 r8 b -\tenuto [ d' -\tenuto b -\tenuto ]  |
                        g 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 r8 e' -\tenuto [ g' -\tenuto e' -\tenuto ]  |
%% 5
                        c' 2 -\tenuto a 4 -\tenuto d' -\tenuto  |
                        g 2 -\tenuto r  |
                        g 2 -\tenuto r  |
                        r8 e -\tenuto [ f -\tenuto g -\tenuto ] a -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
                        e' 8 -\tenuto g' 4 -\tenuto g' -\tenuto g' -\tenuto g' 8 -\tenuto 
                        % warning: overlong bar truncated here |
%% 10
                        \skip 8 g' 4 -\tenuto g' -\tenuto g' 8 -\tenuto [ fis' -\tenuto ] g' -\tenuto  |
                        g 8 -\tenuto g' 4 -\tenuto g' -\tenuto g' -\tenuto g' 8 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 8 g' 4 -\tenuto g' -\tenuto c'' 8 -\tenuto [ b' -\tenuto ] c'' -\tenuto  |
                        c' 4 -\tenuto r r8 c' -\tenuto [ b -\tenuto c' -\tenuto ]  |
                        c 4 -\tenuto r r8 c'' -\tenuto [ b' -\tenuto c'' -\tenuto ]  |
%% 15
                        c' 8 -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ] r f' -\tenuto [ e' -\tenuto d' -\tenuto ]  |
                        c' 4 -\tenuto r8 a -\tenuto g 2 -\tenuto  |
                        r8 g -\tenuto [ f -\tenuto e -\tenuto ] r f -\tenuto [ e -\tenuto d -\tenuto ]  |
                        c 4 -\tenuto r8 a -\tenuto g 2 -\tenuto  |
                        g 8 -\tenuto [ g -\tenuto e -\tenuto e -\tenuto ] c' -\tenuto [ e' -\tenuto f' -\tenuto a' -\tenuto ]  |
%% 20
                        g' 8 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g -\tenuto [ g' -\tenuto d' -\tenuto b -\tenuto ]  |
                        g 4 -\tenuto r r2  |
                        r4 a -\tenuto e' -\tenuto c' -\tenuto  |
                        d' 4 -\tenuto r r2  |
                        r4 g -\tenuto d' -\tenuto b -\tenuto  |
%% 25
                        c' 16 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ] c' -\tenuto [ d' -\tenuto e' -\tenuto c' -\tenuto ] b 2 -\tenuto  |
                        e' 8. -\tenuto [ g' 16 -\tenuto a' 32 -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto fis' -\tenuto g' -\tenuto ] d' 4. -\tenuto b 8 -\tenuto  |
                        c' 16 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ] c' -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ] b 2 -\tenuto  |
                        e' 8. -\tenuto [ g' 16 -\tenuto a' 32 -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto a' -\tenuto g' -\tenuto fis' -\tenuto g' -\tenuto ] d' 4. -\tenuto b 8 -\tenuto  |
                        e' 8 -\tenuto [ e' -\tenuto e' -\tenuto e' -\tenuto ] e' -\tenuto [ e' -\tenuto a' -\tenuto a' -\tenuto ]  |
%% 30
                        a' 4 -\tenuto fis' -\tenuto a -\tenuto r  |
                        r4 a' -\tenuto g' -\tenuto r  |
                        r4 a' -\tenuto g' -\tenuto r  |
                        b 8 -\tenuto [ b -\tenuto ] r c' 16 -\tenuto [ a -\tenuto ] b 8 -\tenuto [ b -\tenuto d' -\tenuto fis' -\tenuto ]  |
                        g' 8 -\tenuto [ g' -\tenuto ] r a' 16 -\tenuto [ fis' -\tenuto ] g' 8 -\tenuto [ e' -\tenuto b' -\tenuto a' -\tenuto ]  |
%% 35
                        aes' 4 -\tenuto b' -\tenuto c'' 8 -\tenuto [ b' -\tenuto a' -\tenuto g' -\tenuto ]  |
                        fis' 4 -\tenuto a' -\tenuto b' 8 -\tenuto [ a' -\tenuto g' -\tenuto fis' -\tenuto ]  |
                        e' 8 -\tenuto [ e' -\tenuto e' -\tenuto e' -\tenuto ] d' -\tenuto [ d' -\tenuto c' -\tenuto c' -\tenuto ]  |
                        b 4 -\tenuto r r2  |
                        b 4 -\tenuto e' 2 -\tenuto a 4 -\tenuto 
                        % warning: overlong bar truncated here |
%% 40
                        \skip 4 d' 2 -\tenuto g 4 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 4 r8 e -\tenuto d 2 -\tenuto  |
                        d 4 -\tenuto r d' -\tenuto r  |
                        d' 4 -\tenuto r a 2 -\tenuto  |
                        g 4 -\tenuto r c' -\tenuto r  |
%% 45
                        b 4 -\tenuto r a 2 -\tenuto  |
                        g 4 -\tenuto d' -\tenuto fis' -\tenuto g' -\tenuto  |
                        e' 4 -\tenuto d' -\tenuto c' 8 -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
                        b 4 -\tenuto b -\tenuto c' -\tenuto d' -\tenuto  |
                        d' 2 -\tenuto fis -\tenuto  |
%% 50
                        g 2 -\tenuto fis' -\tenuto  |
                        g' 2 -\tenuto fis -\tenuto  |
                        g 4 -\tenuto d' -\tenuto d' -\tenuto r  |
                        b 4 -\tenuto r d' -\tenuto r  |
                        g' 4 -\tenuto r r2  |
%% 55
                        c' 4 -\tenuto r e' -\tenuto r  |
                        e' 4 -\tenuto r r2  |
                        d' 4 -\tenuto r b -\tenuto r  |
                        b 4 -\tenuto r r2  |
                        a' 4 -\tenuto r c' -\tenuto c' -\tenuto  |
%% 60
                        b 4 -\tenuto e -\tenuto e -\tenuto r  |
                        r4 b -\tenuto a -\tenuto r  |
                        r4 b -\tenuto a -\tenuto r  |
                        cis' 8 -\tenuto [ cis' -\tenuto ] r e' 16 -\tenuto [ cis' -\tenuto ] d' 8 -\tenuto [ d' -\tenuto ] r a' 16 -\tenuto [ f' -\tenuto ]  |
                        e' 8 -\tenuto [ g' -\tenuto cis' -\tenuto e' -\tenuto ] d' -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ]  |
%% 65
                        b 8 -\tenuto [ b -\tenuto ] r d' 16 -\tenuto [ b -\tenuto ] c' 8 -\tenuto [ c' -\tenuto ] r g' 16 -\tenuto [ e' -\tenuto ]  |
                        d' 8 -\tenuto [ f' -\tenuto b -\tenuto d' -\tenuto ] c' -\tenuto [ e' -\tenuto g' -\tenuto e' -\tenuto ]  |
                        cis' 8 -\tenuto [ cis' -\tenuto ] r e' 16 -\tenuto [ cis' -\tenuto ] f' 8 -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ]  |
                        b 8 -\tenuto [ b -\tenuto ] r d' 16 -\tenuto [ b -\tenuto ] e' 8 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ]  |
                        a 8 -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ] a -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ]  |
%% 70
                        b 4 -\tenuto r8 g' -\tenuto [ g' -\tenuto g -\tenuto ] r g -\tenuto  |
                        g 4 -\tenuto r8 d' -\tenuto c' 4 -\tenuto r8 a' -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 4 r8 b -\tenuto a 4 -\tenuto r8 b -\tenuto  |
                        c' 4 -\tenuto r g -\tenuto g -\tenuto  |
                        g 4 -\tenuto r r2  |
%% 75
                        g 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 r8 b -\tenuto [ d' -\tenuto b -\tenuto ]  |
                        g 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 2 r8 e' -\tenuto [ g' -\tenuto e' -\tenuto ]  |
                        c' 2 -\tenuto a 4 -\tenuto d' -\tenuto  |
%% 80
                        g 2 -\tenuto r  |
                        g 2 -\tenuto r  |
                        r8 e -\tenuto [ f -\tenuto g -\tenuto ] a -\tenuto [ b -\tenuto c' -\tenuto d' -\tenuto ]  |
                        e' 8 -\tenuto g' 4 -\tenuto g' -\tenuto g' -\tenuto g' 8 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 8 g' 4 -\tenuto g' -\tenuto g' 8 -\tenuto [ fis' -\tenuto ] g' -\tenuto  |
%% 85
                        g 8 -\tenuto g' 4 -\tenuto g' -\tenuto g' -\tenuto g' 8 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 8 g' 4 -\tenuto g' -\tenuto c'' 8 -\tenuto [ b' -\tenuto ] c'' -\tenuto  |
                        c' 4 -\tenuto r r8 c' -\tenuto [ b -\tenuto c' -\tenuto ]  |
                        c 4 -\tenuto r r8 c'' -\tenuto [ b' -\tenuto c'' -\tenuto ]  |
                        c' 8 -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ] r f' -\tenuto [ e' -\tenuto d' -\tenuto ]  |
%% 90
                        c' 4 -\tenuto r8 a -\tenuto g 2 -\tenuto  |
                        r8 g -\tenuto [ f -\tenuto e -\tenuto ] r f -\tenuto [ e -\tenuto d -\tenuto ]  |
                        c 4 -\tenuto r8 a -\tenuto g 2 -\tenuto  |
                        g 8 -\tenuto [ g -\tenuto e -\tenuto e -\tenuto ] c' -\tenuto [ e' -\tenuto f' -\tenuto a' -\tenuto ]  |
                        g' 8 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g -\tenuto [ f' -\tenuto e' -\tenuto d' -\tenuto ]  |
%% 95
                        cis' 8 -\tenuto [ cis' -\tenuto cis' -\tenuto cis' -\tenuto ] bes' -\tenuto [ bes' -\tenuto bes' -\tenuto bes' -\tenuto ]  |
                        a' 8 -\tenuto [ a' -\tenuto a' -\tenuto a' -\tenuto ] a -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ]  |
                        d' 8 -\tenuto [ d' -\tenuto d' -\tenuto d' -\tenuto ] b' -\tenuto [ b' -\tenuto b' -\tenuto b' -\tenuto ]  |
                        g' 8 -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ] g' -\tenuto [ g' -\tenuto g' -\tenuto g' -\tenuto ]  |
                        f' 16 -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ] f' -\tenuto [ g' -\tenuto a' -\tenuto f' -\tenuto ] e' 2 -\tenuto  |
%% 100
                        a' 8. -\tenuto [ c'' 16 -\tenuto d'' 32 -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto d'' -\tenuto c'' -\tenuto b' -\tenuto c'' -\tenuto ] g' 4. -\tenuto e' 8 -\tenuto  |
                        f' 16 -\tenuto [ g' -\tenuto f' -\tenuto e' -\tenuto ] f' -\tenuto [ a' -\tenuto g' -\tenuto f' -\tenuto ] e' 4 -\tenuto g -\tenuto  |
                        a 8. -\tenuto [ c' 16 -\tenuto d' 32 -\tenuto c' -\tenuto d' -\tenuto c' -\tenuto d' -\tenuto c' -\tenuto b -\tenuto c' -\tenuto ] g 4. -\tenuto e' 8 -\tenuto  |
                        a 8 -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ] a -\tenuto [ a -\tenuto d' -\tenuto d' -\tenuto ]  |
                        d' 4 -\tenuto d' -\tenuto d' -\tenuto r  |
%% 105
                        r4 d' -\tenuto c' -\tenuto r  |
                        r4 d' -\tenuto c' -\tenuto r  |
                        e 8 -\tenuto [ e -\tenuto ] r f 16 -\tenuto [ d -\tenuto ] e 4 -\tenuto g 8 -\tenuto [ b -\tenuto ]  |
                        c' 8 -\tenuto [ c' -\tenuto ] r d' 16 -\tenuto [ b -\tenuto ] c' 8 -\tenuto [ g -\tenuto e' -\tenuto d' -\tenuto ]  |
                        cis' 4 -\tenuto e' -\tenuto f' 8 -\tenuto [ e' -\tenuto d' -\tenuto c' -\tenuto ]  |
%% 110
                        b 4 -\tenuto d' -\tenuto e' 8 -\tenuto [ d' -\tenuto c' -\tenuto b -\tenuto ]  |
                        c' 4. -\tenuto a 8 -\tenuto [ g -\tenuto e' -\tenuto d' -\tenuto ] f' -\tenuto  |
                        e' 4 -\tenuto r r2  |
                        e 4 -\tenuto a 2 -\tenuto d 4 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 4 g 2 -\tenuto c 4 -\tenuto 
                        % warning: overlong bar truncated here |
%% 115
                        \skip 4 a 4 -\tenuto g -\tenuto f -\tenuto  |
                        e 4 -\tenuto r f -\tenuto r  |
                        e 4 -\tenuto r a -\tenuto d' -\tenuto  |
                        c' 4 -\tenuto r f' -\tenuto r  |
                        e' 4 -\tenuto r d' 2 -\tenuto  |
%% 120
                        c' 4 -\tenuto e' -\tenuto f' -\tenuto g' -\tenuto  |
                        g' 2 -\tenuto b -\tenuto  |
                        c' 4 -\tenuto e -\tenuto f -\tenuto g -\tenuto  |
                        a 4 -\tenuto g -\tenuto f 8 -\tenuto [ e -\tenuto f -\tenuto g -\tenuto ]  |
                        e 2 -\tenuto f 8 -\tenuto [ e -\tenuto f -\tenuto g -\tenuto ]  |
%% 125
                        e 2 -\tenuto f 8 -\tenuto [ e -\tenuto f -\tenuto g -\tenuto ]  |
                        e 4 -\tenuto g -\tenuto c' 2 -\tenuto 
                        \bar "|."
                    } % Voice

                    % End of segment 

                    % End voice 0
                >> % Staff ends

                \context Staff = "track 4, Cello" << 
                    \set Staff.instrumentName = \markup { \center-column { "Cello " } }
                    \set Staff.midiInstrument = "String Ensemble 1"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 3.0" {
                        % Segment: 
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 4/4
                        
                        \clef "bass"
                        \key c \major
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] c -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ]  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, 4 -\tenuto r  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] c 4 -\tenuto r  |
%% 5
                        fis 8 -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ] fis -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto d -\tenuto e -\tenuto ] f -\tenuto [ g -\tenuto a -\tenuto b -\tenuto ]  |
                        c' 4 -\tenuto g -\tenuto e -\tenuto c -\tenuto  |
%% 10
                        g 4 -\tenuto g, -\tenuto r2  |
                        g 4 -\tenuto d -\tenuto b, -\tenuto g, -\tenuto  |
                        c 4 -\tenuto c' -\tenuto r2  |
                        r8 c' -\tenuto [ b -\tenuto c' -\tenuto ] c 4 -\tenuto r  |
                        r8 c -\tenuto [ b, -\tenuto c -\tenuto ] c, 4 -\tenuto r  |
%% 15
                        c 4 -\tenuto r g -\tenuto r  |
                        c' 4 -\tenuto f -\tenuto g -\tenuto g, -\tenuto  |
                        c 4 -\tenuto r g, -\tenuto r  |
                        c 4 -\tenuto f, -\tenuto g, -\tenuto f -\tenuto  |
                        e 8 -\tenuto [ e -\tenuto c -\tenuto c -\tenuto ] a -\tenuto [ g -\tenuto f -\tenuto d -\tenuto ]  |
%% 20
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g, 4 -\tenuto r  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        a 8 -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ] a -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ]  |
                        d 8 -\tenuto [ d -\tenuto d -\tenuto d -\tenuto ] d -\tenuto [ d -\tenuto d -\tenuto d -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
%% 25
                        c 4 -\tenuto r b, -\tenuto r  |
                        e 4 -\tenuto r d -\tenuto r  |
                        c 4 -\tenuto r b, -\tenuto r  |
                        e 4 -\tenuto r d -\tenuto r  |
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] c -\tenuto [ c -\tenuto cis -\tenuto cis -\tenuto ]  |
%% 30
                        d 4 -\tenuto d -\tenuto d -\tenuto r  |
                        r4 d -\tenuto g, -\tenuto r  |
                        r4 d -\tenuto g, -\tenuto r  |
                        g 4 -\tenuto d -\tenuto g, -\tenuto r  |
                        g 4 -\tenuto d -\tenuto g, -\tenuto r  |
%% 35
                        e 8 -\tenuto [ e -\tenuto ] r aes 16 -\tenuto [ e -\tenuto ] a 8 -\tenuto [ g -\tenuto fis -\tenuto e -\tenuto ]  |
                        d 8 -\tenuto [ d -\tenuto ] r fis 16 -\tenuto [ d -\tenuto ] g 8 -\tenuto [ fis -\tenuto e -\tenuto d -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] d -\tenuto [ d -\tenuto d -\tenuto d -\tenuto ]  |
                        g 4 -\tenuto r r2  |
                        e 8 -\tenuto [ e -\tenuto ] r aes 16 -\tenuto [ e -\tenuto ] a 8 -\tenuto [ g -\tenuto fis -\tenuto e -\tenuto ]  |
%% 40
                        d 8 -\tenuto [ d -\tenuto ] r fis 16 -\tenuto [ d -\tenuto ] g 8 -\tenuto [ fis -\tenuto e -\tenuto d -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] d -\tenuto [ d -\tenuto d -\tenuto d -\tenuto ]  |
                        g, 4 -\tenuto r fis, -\tenuto r  |
                        g, 4 -\tenuto r c -\tenuto d -\tenuto  |
                        g, 4 -\tenuto r fis, -\tenuto r  |
%% 45
                        g, 4 -\tenuto r c -\tenuto d -\tenuto  |
                        g, 4 -\tenuto b -\tenuto a -\tenuto g -\tenuto  |
                        fis 4 -\tenuto g -\tenuto d -\tenuto d -\tenuto  |
                        g, 4 -\tenuto b -\tenuto a -\tenuto g -\tenuto  |
                        fis 4 -\tenuto g -\tenuto d -\tenuto d -\tenuto  |
%% 50
                        g, 1 -\tenuto 
                        % warning: overlong bar truncated here |
                        \skip 1  |
                        r4 g -\tenuto g, -\tenuto r  |
                        g 4 -\tenuto r g -\tenuto r  |
                        g 4 -\tenuto r r2  |
%% 55
                        g 4 -\tenuto r g -\tenuto r  |
                        g 4 -\tenuto r r2  |
                        g 4 -\tenuto r g -\tenuto r  |
                        aes 4 -\tenuto r r2  |
                        a 4 -\tenuto r a, -\tenuto a, -\tenuto  |
%% 60
                        e 4 -\tenuto e, -\tenuto e, -\tenuto r  |
                        r4 e -\tenuto a, -\tenuto r  |
                        r4 e -\tenuto a, -\tenuto r  |
                        r4 a -\tenuto f -\tenuto d -\tenuto  |
                        a, 4 -\tenuto a -\tenuto d -\tenuto f -\tenuto  |
%% 65
                        g, 4 -\tenuto g -\tenuto e -\tenuto c -\tenuto  |
                        g, 4 -\tenuto g -\tenuto c -\tenuto e -\tenuto  |
                        a 8 -\tenuto [ a -\tenuto ] r cis' 16 -\tenuto [ a -\tenuto ] d' 8 -\tenuto [ c' -\tenuto b -\tenuto a -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto ] r b 16 -\tenuto [ g -\tenuto ] c' 8 -\tenuto [ b -\tenuto a -\tenuto g -\tenuto ]  |
                        fis 8 -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ] fis -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ]  |
%% 70
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] a -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] f -\tenuto [ f -\tenuto f -\tenuto f -\tenuto ]  |
                        e 8 -\tenuto [ e -\tenuto e -\tenuto e -\tenuto ] d -\tenuto [ c -\tenuto d -\tenuto c -\tenuto ]  |
                        d 4 -\tenuto r r2  |
%% 75
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] c -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ]  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, 4 -\tenuto r  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto c -\tenuto c -\tenuto ] c 4 -\tenuto r  |
                        fis 8 -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ] fis -\tenuto [ fis -\tenuto fis -\tenuto fis -\tenuto ]  |
%% 80
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        g, 8 -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ] g, -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ]  |
                        c 8 -\tenuto [ c -\tenuto d -\tenuto e -\tenuto ] f -\tenuto [ g -\tenuto a -\tenuto b -\tenuto ]  |
                        c' 4 -\tenuto g -\tenuto e -\tenuto c -\tenuto  |
                        g 4 -\tenuto g, -\tenuto r2  |
%% 85
                        g 4 -\tenuto d -\tenuto b, -\tenuto g, -\tenuto  |
                        c 4 -\tenuto c' -\tenuto r2  |
                        r8 c' -\tenuto [ b -\tenuto c' -\tenuto ] c 4 -\tenuto r  |
                        r8 c -\tenuto [ b, -\tenuto c -\tenuto ] c, 4 -\tenuto r  |
                        c 4 -\tenuto r g -\tenuto r  |
%% 90
                        c' 4 -\tenuto f -\tenuto g -\tenuto g, -\tenuto  |
                        c 4 -\tenuto r g, -\tenuto r  |
                        c 4 -\tenuto f, -\tenuto g, -\tenuto f -\tenuto  |
                        e 8 -\tenuto [ e -\tenuto c -\tenuto c -\tenuto ] a -\tenuto [ g -\tenuto f -\tenuto d -\tenuto ]  |
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g, 4 -\tenuto r  |
%% 95
                        g 8 -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        a 8 -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ] a -\tenuto [ a -\tenuto a -\tenuto a -\tenuto ]  |
                        f 8 -\tenuto [ f -\tenuto f -\tenuto f -\tenuto ] f -\tenuto [ f -\tenuto f -\tenuto f -\tenuto ]  |
                        e 8 -\tenuto [ e -\tenuto e -\tenuto e -\tenuto ] e -\tenuto [ e -\tenuto e -\tenuto e -\tenuto ]  |
                        f 4 -\tenuto r e -\tenuto r  |
%% 100
                        a 4 -\tenuto r g -\tenuto r  |
                        f 4 -\tenuto r e -\tenuto r  |
                        a 4 -\tenuto r g -\tenuto r  |
                        f 8 -\tenuto [ f -\tenuto f -\tenuto f -\tenuto ] f -\tenuto [ f -\tenuto fis -\tenuto fis -\tenuto ]  |
                        g 4 -\tenuto g, -\tenuto g, -\tenuto r  |
%% 105
                        r4 g -\tenuto c -\tenuto r  |
                        r4 g -\tenuto c -\tenuto r  |
                        c 4 -\tenuto g, -\tenuto c, -\tenuto r  |
                        c, 4 -\tenuto g, -\tenuto c -\tenuto r  |
                        a 8 -\tenuto [ a -\tenuto ] r cis' 16 -\tenuto r < a d' > -\tenuto c' 8 -\tenuto b -\tenuto a -\tenuto 
                        % warning: bar too short, padding with rests
                        % 414720 + 3600 < 418560  &&  15/16 < 4/4
                        r16  |
%% 110
                        g 8 -\tenuto [ g -\tenuto ] r b 16 -\tenuto r < g c' > -\tenuto b 8 -\tenuto a -\tenuto g -\tenuto 
                        % warning: bar too short, padding with rests
                        % 418560 + 3600 < 422400  &&  15/16 < 4/4
                        r16  |
                        f 8 -\tenuto [ f -\tenuto f -\tenuto f -\tenuto ] g -\tenuto [ g -\tenuto g -\tenuto g -\tenuto ]  |
                        c 4 -\tenuto r r2  |
                        a, 8 -\tenuto [ a, -\tenuto ] r cis 16 -\tenuto r < a, d > -\tenuto c 8 -\tenuto b, -\tenuto a, -\tenuto 
                        % warning: bar too short, padding with rests
                        % 430080 + 3600 < 433920  &&  15/16 < 4/4
                        r16  |
                        g, 8 -\tenuto [ g, -\tenuto ] r b, 16 -\tenuto r < g, c > -\tenuto b, 8 -\tenuto a, -\tenuto g, -\tenuto 
                        % warning: bar too short, padding with rests
                        % 433920 + 3600 < 437760  &&  15/16 < 4/4
                        r16  |
%% 115
                        f, 8 -\tenuto [ f, -\tenuto f, -\tenuto f, -\tenuto ] g, -\tenuto [ g, -\tenuto g, -\tenuto g, -\tenuto ]  |
                        c 4 -\tenuto r b, -\tenuto r  |
                        c 4 -\tenuto r f -\tenuto g -\tenuto  |
                        c 4 -\tenuto r b, -\tenuto r  |
                        c 4 -\tenuto r f -\tenuto g -\tenuto  |
%% 120
                        c 4 -\tenuto e' -\tenuto d' -\tenuto c' -\tenuto  |
                        b 4 -\tenuto c' -\tenuto g -\tenuto g, -\tenuto  |
                        c 4 -\tenuto e -\tenuto d -\tenuto c -\tenuto  |
                        b, 4 -\tenuto c -\tenuto g, -\tenuto g, -\tenuto  |
                        c, 1 -\tenuto 
                        % warning: overlong bar truncated here |
%% 125
                        \skip 1  |
                        r4 c -\tenuto c, 2 -\tenuto 
                        \bar "|."
                    } % Voice

                    % End of segment 

                    % End voice 0
                >> % Staff ends
            >> % GrandStaff (final) 2
        >> % StaffGroup (final) 1

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
