<details><summary>Combinatoric example</summary>

```no_run
use bpaf::*;

#[derive(Debug, Clone)]
pub struct Options {
    message: String,
}

pub fn options() -> OptionParser<Options> {
    let message = positional("MESSAGE").help("Message to print in a big friendly letters");
    construct!(Options { message }).to_options()
}

fn main() {
    println!("{:?}", options().run())
}
```

</details>
<details><summary>Derive example</summary>

```no_run
use bpaf::*;

#[derive(Debug, Clone, Bpaf)]
#[bpaf(options)]
pub struct Options {
    /// Message to print in a big friendly letters
    #[bpaf(positional("MESSAGE"))]
    message: String,
}

fn main() {
    println!("{:?}", options().run())
}
```

</details>
<details><summary>Output</summary>

With everything in place users should be able to pass their arguments


<div class='bpaf-doc'>
$ app "Hello world"<br>
Options { message: "Hello world" }
</div>


As well as read the help message generated by the library


<div class='bpaf-doc'>
$ app --help<br>
<p><b>Usage</b>: <tt><b>app</b></tt> <tt><i>MESSAGE</i></tt></p><p><div>
<b>Available positional items:</b></div><dl><dt><tt><i>MESSAGE</i></tt></dt>
<dd>Message to print in a big friendly letters</dd>
</dl>
</p><p><div>
<b>Available options:</b></div><dl><dt><tt><b>-h</b></tt>, <tt><b>--help</b></tt></dt>
<dd>Prints help information</dd>
</dl>
</p>
<style>
div.bpaf-doc {
    padding: 14px;
    background-color:var(--code-block-background-color);
    font-family: "Source Code Pro", monospace;
    margin-bottom: 0.75em;
}
div.bpaf-doc dt { margin-left: 1em; }
div.bpaf-doc dd { margin-left: 3em; }
div.bpaf-doc dl { margin-top: 0; padding-left: 1em; }
div.bpaf-doc  { padding-left: 1em; }
</style>
</div>

</details>