/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String string2) {
        return IPAddress.isValidIPv4(string2) || IPAddress.isValidIPv6(string2);
    }

    public static boolean isValidWithNetMask(String string2) {
        return IPAddress.isValidIPv4WithNetmask(string2) || IPAddress.isValidIPv6WithNetmask(string2);
    }

    public static boolean isValidIPv4(String string2) {
        int n = string2.length();
        if (n < 7 || n > 15) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            int n3 = string2.indexOf(46, n2);
            if (!IPAddress.isParseableIPv4Octet(string2, n2, n3)) {
                return false;
            }
            n2 = n3 + 1;
        }
        return IPAddress.isParseableIPv4Octet(string2, n2, n);
    }

    public static boolean isValidIPv4WithNetmask(String string2) {
        int n = string2.indexOf("/");
        if (n < 1) {
            return false;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        return IPAddress.isValidIPv4(string3) && (IPAddress.isValidIPv4(string4) || IPAddress.isParseableIPv4Mask(string4));
    }

    public static boolean isValidIPv6(String string2) {
        int n;
        if (string2.length() == 0) {
            return false;
        }
        char c = string2.charAt(0);
        if (c != ':' && Character.digit(c, 16) < 0) {
            return false;
        }
        int n2 = 0;
        String string3 = string2 + ":";
        boolean bl = false;
        int n3 = 0;
        while (n3 < string3.length() && (n = string3.indexOf(58, n3)) >= n3) {
            if (n2 == 8) {
                return false;
            }
            if (n3 != n) {
                String string4 = string3.substring(n3, n);
                if (n == string3.length() - 1 && string4.indexOf(46) > 0) {
                    if (++n2 == 8) {
                        return false;
                    }
                    if (!IPAddress.isValidIPv4(string4)) {
                        return false;
                    }
                } else if (!IPAddress.isParseableIPv6Segment(string3, n3, n)) {
                    return false;
                }
            } else {
                if (n != 1 && n != string3.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n3 = n + 1;
            ++n2;
        }
        return n2 == 8 || bl;
    }

    public static boolean isValidIPv6WithNetmask(String string2) {
        int n = string2.indexOf("/");
        if (n < 1) {
            return false;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        return IPAddress.isValidIPv6(string3) && (IPAddress.isValidIPv6(string4) || IPAddress.isParseableIPv6Mask(string4));
    }

    private static boolean isParseableIPv4Mask(String string2) {
        return IPAddress.isParseable(string2, 0, string2.length(), 10, 2, false, 0, 32);
    }

    private static boolean isParseableIPv4Octet(String string2, int n, int n2) {
        return IPAddress.isParseable(string2, n, n2, 10, 3, true, 0, 255);
    }

    private static boolean isParseableIPv6Mask(String string2) {
        return IPAddress.isParseable(string2, 0, string2.length(), 10, 3, false, 1, 128);
    }

    private static boolean isParseableIPv6Segment(String string2, int n, int n2) {
        return IPAddress.isParseable(string2, n, n2, 16, 4, true, 0, 65535);
    }

    private static boolean isParseable(String string2, int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        int n7 = n2 - n;
        if (n7 < 1 | n7 > n4) {
            return false;
        }
        boolean bl2 = n7 > 1 & !bl;
        if (bl2 && Character.digit(string2.charAt(n), n3) <= 0) {
            return false;
        }
        int n8 = 0;
        while (n < n2) {
            char c;
            int n9;
            if ((n9 = Character.digit(c = string2.charAt(n++), n3)) < 0) {
                return false;
            }
            n8 *= n3;
            n8 += n9;
        }
        return n8 >= n5 & n8 <= n6;
    }
}

