/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.AttrMaxPause;
import org.igniterealtime.jbosh.AttrPause;
import org.igniterealtime.jbosh.AttrPolling;
import org.igniterealtime.jbosh.AttrRequests;
import org.igniterealtime.jbosh.AttrVersion;
import org.igniterealtime.jbosh.Attributes;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.BOSHClientConnEvent;
import org.igniterealtime.jbosh.BOSHClientConnListener;
import org.igniterealtime.jbosh.BOSHClientRequestListener;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.CMSessionParams;
import org.igniterealtime.jbosh.ComposableBody;
import org.igniterealtime.jbosh.HTTPExchange;
import org.igniterealtime.jbosh.HTTPResponse;
import org.igniterealtime.jbosh.HTTPSender;
import org.igniterealtime.jbosh.RequestIDSequence;
import org.igniterealtime.jbosh.ServiceLib;
import org.igniterealtime.jbosh.TerminalBindingCondition;

public final class BOSHClient {
    private static final Logger LOG = Logger.getLogger(BOSHClient.class.getName());
    private static final String TERMINATE = "terminate";
    private static final String ERROR = "error";
    private static final String INTERRUPTED = "Interrupted";
    private static final String UNHANDLED = "Unhandled Exception";
    private static final String NULL_LISTENER = "Listener may not be null";
    private static final int DEFAULT_EMPTY_REQUEST_DELAY = 100;
    private static final int EMPTY_REQUEST_DELAY = Integer.getInteger(BOSHClient.class.getName() + ".emptyRequestDelay", 100);
    private static final int DEFAULT_PAUSE_MARGIN = 500;
    private static final int PAUSE_MARGIN = Integer.getInteger(BOSHClient.class.getName() + ".pauseMargin", 500);
    private static final int DEFAULT_REQ_PROC_COUNT = 1;
    private static final boolean ASSERTIONS;
    private final Set<BOSHClientConnListener> connListeners = new CopyOnWriteArraySet<BOSHClientConnListener>();
    private final Set<BOSHClientRequestListener> requestListeners = new CopyOnWriteArraySet<BOSHClientRequestListener>();
    private final Set<BOSHClientResponseListener> responseListeners = new CopyOnWriteArraySet<BOSHClientResponseListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private final Condition drained = this.lock.newCondition();
    private final BOSHClientConfig cfg;
    private final Runnable emptyRequestRunnable = new Runnable(){

        @Override
        public void run() {
            BOSHClient.this.sendEmptyRequest();
        }
    };
    private final HTTPSender httpSender = ServiceLib.loadService(HTTPSender.class);
    private final AtomicReference<ExchangeInterceptor> exchInterceptor = new AtomicReference();
    private final RequestIDSequence requestIDSeq = new RequestIDSequence();
    private final ScheduledExecutorService schedExec = Executors.newSingleThreadScheduledExecutor();
    private RequestProcessor[] procThreads;
    private ScheduledFuture<?> emptyRequestFuture;
    private CMSessionParams cmParams;
    private LinkedList<HTTPExchange> exchanges = new LinkedList();
    private SortedSet<Long> pendingResponseAcks = new TreeSet<Long>();
    private Long responseAck = -1L;
    private List<ComposableBody> pendingRequestAcks = new ArrayList<ComposableBody>();

    private BOSHClient(BOSHClientConfig sessCfg) {
        this.cfg = sessCfg;
        this.init();
    }

    public static BOSHClient create(BOSHClientConfig clientCfg) {
        if (clientCfg == null) {
            throw new IllegalArgumentException("Client configuration may not be null");
        }
        return new BOSHClient(clientCfg);
    }

    public BOSHClientConfig getBOSHClientConfig() {
        return this.cfg;
    }

    public void addBOSHClientConnListener(BOSHClientConnListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.connListeners.add(listener);
    }

    public void removeBOSHClientConnListener(BOSHClientConnListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.connListeners.remove(listener);
    }

    public void addBOSHClientRequestListener(BOSHClientRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.requestListeners.add(listener);
    }

    public void removeBOSHClientRequestListener(BOSHClientRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.requestListeners.remove(listener);
    }

    public void addBOSHClientResponseListener(BOSHClientResponseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.responseListeners.add(listener);
    }

    public void removeBOSHClientResponseListener(BOSHClientResponseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(NULL_LISTENER);
        }
        this.responseListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ComposableBody body) throws BOSHException {
        HTTPExchange exch;
        CMSessionParams params;
        this.assertUnlocked();
        if (body == null) {
            throw new IllegalArgumentException("Message body may not be null");
        }
        this.lock.lock();
        try {
            this.blockUntilSendable(body);
            if (!this.isWorking() && !BOSHClient.isTermination(body)) {
                throw new BOSHException("Cannot send message when session is closed");
            }
            long rid = this.requestIDSeq.getNextRID();
            ComposableBody request = body;
            params = this.cmParams;
            if (params == null && this.exchanges.isEmpty()) {
                request = this.applySessionCreationRequest(rid, body);
            } else {
                request = this.applySessionData(rid, body);
                if (this.cmParams.isAckingRequests()) {
                    this.pendingRequestAcks.add(request);
                }
            }
            exch = new HTTPExchange(request);
            this.exchanges.add(exch);
            this.notEmpty.signal();
            this.clearEmptyRequest();
        }
        finally {
            this.lock.unlock();
        }
        AbstractBody finalReq = exch.getRequest();
        HTTPResponse resp = this.httpSender.send(params, finalReq);
        exch.setHTTPResponse(resp);
        this.fireRequestSent(finalReq);
    }

    public boolean pause() {
        this.assertUnlocked();
        this.lock.lock();
        AttrMaxPause maxPause = null;
        try {
            if (this.cmParams == null) {
                boolean bl = false;
                return bl;
            }
            maxPause = this.cmParams.getMaxPause();
            if (maxPause == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.send(ComposableBody.builder().setAttribute(Attributes.PAUSE, maxPause.toString()).build());
        }
        catch (BOSHException boshx) {
            LOG.log(Level.FINEST, "Could not send pause", boshx);
        }
        return true;
    }

    public void disconnect() throws BOSHException {
        this.disconnect(ComposableBody.builder().build());
    }

    public void disconnect(ComposableBody msg) throws BOSHException {
        if (msg == null) {
            throw new IllegalArgumentException("Message body may not be null");
        }
        ComposableBody.Builder builder = msg.rebuild();
        builder.setAttribute(Attributes.TYPE, TERMINATE);
        this.send(builder.build());
    }

    public void close() {
        this.dispose(new BOSHException("Session explicitly closed by caller"));
    }

    CMSessionParams getCMSessionParams() {
        this.lock.lock();
        try {
            CMSessionParams cMSessionParams = this.cmParams;
            return cMSessionParams;
        }
        finally {
            this.lock.unlock();
        }
    }

    void drain() {
        this.lock.lock();
        try {
            LOG.finest("Waiting while draining...");
            while (this.isWorking() && (this.emptyRequestFuture == null || this.emptyRequestFuture.isDone())) {
                try {
                    this.drained.await();
                }
                catch (InterruptedException intx) {
                    LOG.log(Level.FINEST, INTERRUPTED, intx);
                }
            }
            LOG.finest("Drained");
        }
        finally {
            this.lock.unlock();
        }
    }

    void setExchangeInterceptor(ExchangeInterceptor interceptor) {
        this.exchInterceptor.set(interceptor);
    }

    private void init() {
        this.assertUnlocked();
        this.lock.lock();
        try {
            this.httpSender.init(this.cfg);
            LOG.info("Starting with 1 request processors");
            this.procThreads = new RequestProcessor[1];
            for (int i = 0; i < this.procThreads.length; ++i) {
                this.procThreads[i] = new RequestProcessor(i);
                this.procThreads[i].start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(Throwable cause) {
        this.assertUnlocked();
        this.lock.lock();
        try {
            if (this.procThreads == null) {
                return;
            }
            for (RequestProcessor processor : this.procThreads) {
                processor.dispose();
            }
            this.procThreads = null;
            this.clearEmptyRequest();
            this.exchanges = null;
            this.cmParams = null;
            this.pendingResponseAcks = null;
            this.pendingRequestAcks = null;
            this.notEmpty.signalAll();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (cause == null) {
            this.fireConnectionClosed();
        } else {
            this.fireConnectionClosedOnError(cause);
        }
        this.lock.lock();
        try {
            this.drained.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.httpSender.destroy();
        this.schedExec.shutdownNow();
    }

    private static boolean isPause(AbstractBody msg) {
        return msg.getAttribute(Attributes.PAUSE) != null;
    }

    private static boolean isTermination(AbstractBody msg) {
        return TERMINATE.equals(msg.getAttribute(Attributes.TYPE));
    }

    private TerminalBindingCondition getTerminalBindingCondition(int respCode, AbstractBody respBody) {
        this.assertLocked();
        if (BOSHClient.isTermination(respBody)) {
            String str = respBody.getAttribute(Attributes.CONDITION);
            return TerminalBindingCondition.forString(str);
        }
        if (this.cmParams != null && this.cmParams.getVersion() == null) {
            return TerminalBindingCondition.forHTTPResponseCode(respCode);
        }
        return null;
    }

    private boolean isImmediatelySendable(AbstractBody msg) {
        this.assertLocked();
        if (this.cmParams == null) {
            return this.exchanges.isEmpty();
        }
        AttrRequests requests = this.cmParams.getRequests();
        if (requests == null) {
            return true;
        }
        int maxRequests = requests.intValue();
        if (this.exchanges.size() < maxRequests) {
            return true;
        }
        return this.exchanges.size() == maxRequests && (BOSHClient.isTermination(msg) || BOSHClient.isPause(msg));
    }

    private boolean isWorking() {
        this.assertLocked();
        return this.procThreads != null;
    }

    private void blockUntilSendable(AbstractBody msg) {
        this.assertLocked();
        while (this.isWorking() && !this.isImmediatelySendable(msg)) {
            try {
                this.notFull.await();
            }
            catch (InterruptedException intx) {
                LOG.log(Level.FINEST, INTERRUPTED, intx);
            }
        }
    }

    private ComposableBody applySessionCreationRequest(long rid, ComposableBody orig) throws BOSHException {
        this.assertLocked();
        ComposableBody.Builder builder = orig.rebuild();
        builder.setAttribute(Attributes.TO, this.cfg.getTo());
        builder.setAttribute(Attributes.XML_LANG, this.cfg.getLang());
        builder.setAttribute(Attributes.VER, AttrVersion.getSupportedVersion().toString());
        builder.setAttribute(Attributes.WAIT, "60");
        builder.setAttribute(Attributes.HOLD, "1");
        builder.setAttribute(Attributes.RID, Long.toString(rid));
        this.applyRoute(builder);
        this.applyFrom(builder);
        if (this.cfg.isAckEnabled()) {
            builder.setAttribute(Attributes.ACK, "1");
        }
        builder.setAttribute(Attributes.SID, null);
        return builder.build();
    }

    private void applyRoute(ComposableBody.Builder builder) {
        this.assertLocked();
        String route = this.cfg.getRoute();
        if (route != null) {
            builder.setAttribute(Attributes.ROUTE, route);
        }
    }

    private void applyFrom(ComposableBody.Builder builder) {
        this.assertLocked();
        String from = this.cfg.getFrom();
        if (from != null) {
            builder.setAttribute(Attributes.FROM, from);
        }
    }

    private ComposableBody applySessionData(long rid, ComposableBody orig) throws BOSHException {
        this.assertLocked();
        ComposableBody.Builder builder = orig.rebuild();
        builder.setAttribute(Attributes.SID, this.cmParams.getSessionID().toString());
        builder.setAttribute(Attributes.RID, Long.toString(rid));
        if (this.cfg.isAckEnabled()) {
            this.applyResponseAcknowledgement(builder, rid);
        }
        return builder.build();
    }

    private void applyResponseAcknowledgement(ComposableBody.Builder builder, long rid) {
        this.assertLocked();
        if (this.responseAck.equals(-1L)) {
            return;
        }
        Long prevRID = rid - 1L;
        if (this.responseAck.equals(prevRID)) {
            return;
        }
        builder.setAttribute(Attributes.ACK, this.responseAck.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessages(int idx) {
        LOG.finest("Processing thread " + idx + " starting...");
        try {
            HTTPExchange exch;
            while ((exch = this.nextExchange(idx)) != null) {
                ExchangeInterceptor interceptor = this.exchInterceptor.get();
                if (interceptor != null) {
                    HTTPExchange newExch = interceptor.interceptExchange(exch);
                    if (newExch == null) {
                        LOG.log(Level.FINE, "Discarding exchange on request of test hook: RID=" + exch.getRequest().getAttribute(Attributes.RID));
                        this.lock.lock();
                        try {
                            this.exchanges.remove(exch);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        continue;
                    }
                    exch = newExch;
                }
                this.processExchange(idx, exch);
            }
        }
        finally {
            LOG.log(Level.FINEST, "Processing thread exiting: " + idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPExchange nextExchange(int idx) {
        this.assertUnlocked();
        Thread thread = Thread.currentThread();
        HTTPExchange exch = null;
        this.lock.lock();
        try {
            while (this.procThreads != null) {
                if (!thread.equals(this.procThreads[idx].procThread)) {
                    break;
                }
                exch = this.claimExchange(idx);
                if (exch == null) {
                    try {
                        this.notEmpty.await();
                    }
                    catch (InterruptedException intx) {
                        LOG.log(Level.FINEST, INTERRUPTED, intx);
                    }
                }
                if (exch == null) continue;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return exch;
    }

    private HTTPExchange claimExchange(int idx) {
        this.assertLocked();
        HTTPExchange exch = null;
        for (HTTPExchange toClaim : this.exchanges) {
            if (this.findProcessorForExchange(toClaim) != null) continue;
            exch = toClaim;
            break;
        }
        if (exch != null) {
            this.procThreads[idx].procExchange = exch;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Thread " + idx + " claimed: " + exch.getRequest().getAttribute(Attributes.RID));
            }
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Thread " + idx + " will wait for new request...");
        }
        return exch;
    }

    private RequestProcessor findProcessorForExchange(HTTPExchange exch) {
        this.assertLocked();
        for (RequestProcessor reqProc : this.procThreads) {
            if (exch != reqProc.procExchange) continue;
            return reqProc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExchange(int idx, HTTPExchange exch) {
        CMSessionParams params;
        int respCode;
        AbstractBody body;
        this.assertUnlocked();
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Thread " + idx + " is sending " + exch.getRequest().getAttribute(Attributes.RID));
            }
            HTTPResponse resp = exch.getHTTPResponse();
            body = resp.getBody();
            respCode = resp.getHTTPStatus();
            if (LOG.isLoggable(Level.FINEST)) {
                String respRid = body.getAttribute(Attributes.RID);
                if (respRid == null) {
                    respRid = exch.getRequest().getAttribute(Attributes.RID);
                }
                LOG.finest("Thread " + idx + " received response for RID: " + respRid + " code: " + respCode + " ACK: " + body.getAttribute(Attributes.ACK));
            }
        }
        catch (BOSHException boshx) {
            LOG.log(Level.FINEST, "Could not obtain response", boshx);
            this.dispose(boshx);
            return;
        }
        catch (InterruptedException intx) {
            LOG.log(Level.FINEST, INTERRUPTED, intx);
            this.dispose(intx);
            return;
        }
        this.fireResponseReceived(body);
        AbstractBody req = exch.getRequest();
        ArrayList<HTTPExchange> toResend = null;
        this.lock.lock();
        try {
            if (!this.isWorking()) {
                this.lock.unlock();
                return;
            }
            if (this.cmParams == null) {
                this.cmParams = CMSessionParams.fromSessionInit(req, body);
                this.adjustRequestProcessorsPool();
                this.fireConnectionEstablished();
            }
            params = this.cmParams;
            this.checkForTerminalBindingConditions(body, respCode);
            if (BOSHClient.isTermination(body)) {
                this.lock.unlock();
                this.dispose(null);
                return;
            }
            if (BOSHClient.isRecoverableBindingCondition(body)) {
                if (toResend == null) {
                    toResend = new ArrayList<HTTPExchange>(this.exchanges.size());
                }
                for (HTTPExchange exchange : this.exchanges) {
                    HTTPExchange resendExch = new HTTPExchange(exchange.getRequest());
                    toResend.add(resendExch);
                }
                for (HTTPExchange exchange : toResend) {
                    this.exchanges.add(exchange);
                }
            } else {
                this.processRequestAcknowledgements(req, body);
                this.processResponseAcknowledgementData(req);
                HTTPExchange resendExch = this.processResponseAcknowledgementReport(body);
                if (resendExch != null && toResend == null) {
                    toResend = new ArrayList(1);
                    toResend.add(resendExch);
                    this.exchanges.add(resendExch);
                }
            }
        }
        catch (BOSHException boshx) {
            LOG.log(Level.FINEST, "Could not process response", boshx);
            this.lock.unlock();
            this.dispose(boshx);
            return;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                try {
                    this.exchanges.remove(exch);
                    if (this.exchanges.isEmpty()) {
                        this.scheduleEmptyRequest(this.processPauseRequest(req));
                    }
                    this.notFull.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (toResend != null) {
            for (HTTPExchange resend : toResend) {
                HTTPResponse response = this.httpSender.send(params, resend.getRequest());
                resend.setHTTPResponse(response);
                this.fireRequestSent(resend.getRequest());
            }
        }
    }

    private void adjustRequestProcessorsPool() {
        int requests;
        this.assertLocked();
        AttrRequests attrRequests = this.cmParams.getRequests();
        int n = requests = attrRequests != null ? attrRequests.intValue() : 2;
        if (requests <= 1 && "1".equals(String.valueOf(this.cmParams.getHold()))) {
            LOG.warning("CM supports only 1 requests at a time and there is a risk of connection being stuck up to " + this.cmParams.getWait() + "seconds");
        }
        if (requests > this.procThreads.length) {
            RequestProcessor[] oldProcessors = this.procThreads;
            this.procThreads = new RequestProcessor[requests];
            System.arraycopy(oldProcessors, 0, this.procThreads, 0, oldProcessors.length);
            for (int i = oldProcessors.length; i < requests; ++i) {
                this.procThreads[i] = new RequestProcessor(i);
                this.procThreads[i].start();
            }
        }
    }

    private void clearEmptyRequest() {
        this.assertLocked();
        if (this.emptyRequestFuture != null) {
            this.emptyRequestFuture.cancel(false);
            this.emptyRequestFuture = null;
        }
    }

    private long getDefaultEmptyRequestDelay() {
        AttrPolling polling;
        this.assertLocked();
        AttrRequests requests = this.cmParams.getRequests();
        long delay = EMPTY_REQUEST_DELAY;
        if ((requests == null || requests.intValue() <= 1) && (polling = this.cmParams.getPollingInterval()) != null) {
            delay = polling.getInMilliseconds();
        }
        return delay;
    }

    private void scheduleEmptyRequest(long delay) {
        this.assertLocked();
        if (delay < 0L) {
            throw new IllegalArgumentException("Empty request delay must be >= 0 (was: " + delay + ")");
        }
        this.clearEmptyRequest();
        if (!this.isWorking()) {
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Scheduling empty request in " + delay + "ms");
        }
        try {
            this.emptyRequestFuture = this.schedExec.schedule(this.emptyRequestRunnable, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rex) {
            LOG.log(Level.FINEST, "Could not schedule empty request", rex);
        }
        this.drained.signalAll();
    }

    private void sendEmptyRequest() {
        this.assertUnlocked();
        LOG.finest("Sending empty request");
        try {
            this.send(ComposableBody.builder().build());
        }
        catch (BOSHException boshx) {
            this.dispose(boshx);
        }
    }

    private void assertLocked() {
        if (ASSERTIONS) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new AssertionError((Object)"Lock is not held by current thread");
            }
            return;
        }
    }

    private void assertUnlocked() {
        if (ASSERTIONS) {
            if (this.lock.isHeldByCurrentThread()) {
                throw new AssertionError((Object)"Lock is held by current thread");
            }
            return;
        }
    }

    private void checkForTerminalBindingConditions(AbstractBody body, int code) throws BOSHException {
        TerminalBindingCondition cond = this.getTerminalBindingCondition(code, body);
        if (cond != null) {
            throw new BOSHException("Terminal binding condition encountered: " + cond.getCondition() + "  (" + cond.getMessage() + ")");
        }
    }

    private static boolean isRecoverableBindingCondition(AbstractBody resp) {
        return ERROR.equals(resp.getAttribute(Attributes.TYPE));
    }

    private long processPauseRequest(AbstractBody req) {
        this.assertLocked();
        if (this.cmParams != null && this.cmParams.getMaxPause() != null) {
            try {
                AttrPause pause = AttrPause.createFromString(req.getAttribute(Attributes.PAUSE));
                if (pause != null) {
                    long delay = pause.getInMilliseconds() - PAUSE_MARGIN;
                    if (delay < 0L) {
                        delay = EMPTY_REQUEST_DELAY;
                    }
                    return delay;
                }
            }
            catch (BOSHException boshx) {
                LOG.log(Level.FINEST, "Could not extract", boshx);
            }
        }
        return this.getDefaultEmptyRequestDelay();
    }

    private void processRequestAcknowledgements(AbstractBody req, AbstractBody resp) {
        this.assertLocked();
        if (!this.cmParams.isAckingRequests()) {
            return;
        }
        if (resp.getAttribute(Attributes.REPORT) != null) {
            return;
        }
        String acked = resp.getAttribute(Attributes.ACK);
        Long ackUpTo = acked == null ? Long.valueOf(Long.parseLong(req.getAttribute(Attributes.RID))) : Long.valueOf(Long.parseLong(acked));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Removing pending acks up to: " + ackUpTo);
        }
        Iterator<ComposableBody> iter = this.pendingRequestAcks.iterator();
        while (iter.hasNext()) {
            AbstractBody pending = iter.next();
            Long pendingRID = Long.parseLong(pending.getAttribute(Attributes.RID));
            if (pendingRID.compareTo(ackUpTo) > 0) continue;
            iter.remove();
        }
    }

    private void processResponseAcknowledgementData(AbstractBody req) {
        this.assertLocked();
        Long rid = Long.parseLong(req.getAttribute(Attributes.RID));
        if (this.responseAck.equals(-1L)) {
            this.responseAck = rid;
        } else {
            this.pendingResponseAcks.add(rid);
            Long whileVal = this.responseAck + 1L;
            while (!this.pendingResponseAcks.isEmpty() && whileVal.equals(this.pendingResponseAcks.first())) {
                this.responseAck = whileVal;
                this.pendingResponseAcks.remove(whileVal);
                whileVal = whileVal + 1L;
            }
        }
    }

    private HTTPExchange processResponseAcknowledgementReport(AbstractBody resp) throws BOSHException {
        this.assertLocked();
        String reportStr = resp.getAttribute(Attributes.REPORT);
        if (reportStr == null) {
            return null;
        }
        Long report = Long.parseLong(reportStr);
        Long time = Long.parseLong(resp.getAttribute(Attributes.TIME));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received report of missing request (RID=" + report + ", time=" + time + "ms)");
        }
        Iterator<ComposableBody> iter = this.pendingRequestAcks.iterator();
        AbstractBody req = null;
        while (iter.hasNext() && req == null) {
            AbstractBody pending = iter.next();
            Long pendingRID = Long.parseLong(pending.getAttribute(Attributes.RID));
            if (!report.equals(pendingRID)) continue;
            req = pending;
        }
        if (req == null) {
            throw new BOSHException("Report of missing message with RID '" + reportStr + "' but local copy of that request was not found");
        }
        HTTPExchange exch = new HTTPExchange(req);
        this.exchanges.add(exch);
        this.notEmpty.signal();
        return exch;
    }

    private void fireRequestSent(AbstractBody request) {
        this.assertUnlocked();
        BOSHMessageEvent event = null;
        for (BOSHClientRequestListener listener : this.requestListeners) {
            if (event == null) {
                event = BOSHMessageEvent.createRequestSentEvent(this, request);
            }
            try {
                listener.requestSent(event);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, UNHANDLED, ex);
            }
        }
    }

    private void fireResponseReceived(AbstractBody response) {
        this.assertUnlocked();
        BOSHMessageEvent event = null;
        for (BOSHClientResponseListener listener : this.responseListeners) {
            if (event == null) {
                event = BOSHMessageEvent.createResponseReceivedEvent(this, response);
            }
            try {
                listener.responseReceived(event);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, UNHANDLED, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEstablished() {
        boolean hadLock = this.lock.isHeldByCurrentThread();
        if (hadLock) {
            this.lock.unlock();
        }
        try {
            BOSHClientConnEvent event = null;
            for (BOSHClientConnListener listener : this.connListeners) {
                if (event == null) {
                    event = BOSHClientConnEvent.createConnectionEstablishedEvent(this);
                }
                try {
                    listener.connectionEvent(event);
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, UNHANDLED, ex);
                }
            }
        }
        finally {
            if (hadLock) {
                this.lock.lock();
            }
        }
    }

    private void fireConnectionClosed() {
        this.assertUnlocked();
        BOSHClientConnEvent event = null;
        for (BOSHClientConnListener listener : this.connListeners) {
            if (event == null) {
                event = BOSHClientConnEvent.createConnectionClosedEvent(this);
            }
            try {
                listener.connectionEvent(event);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, UNHANDLED, ex);
            }
        }
    }

    private void fireConnectionClosedOnError(Throwable cause) {
        this.assertUnlocked();
        BOSHClientConnEvent event = null;
        for (BOSHClientConnListener listener : this.connListeners) {
            if (event == null) {
                event = BOSHClientConnEvent.createConnectionClosedOnErrorEvent(this, this.pendingRequestAcks, cause);
            }
            try {
                listener.connectionEvent(event);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, UNHANDLED, ex);
            }
        }
    }

    static {
        String prop = BOSHClient.class.getSimpleName() + ".assertionsEnabled";
        boolean enabled = false;
        if (System.getProperty(prop) == null) {
            if (!$assertionsDisabled) {
                enabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
        } else {
            enabled = Boolean.getBoolean(prop);
        }
        ASSERTIONS = enabled;
    }

    private class RequestProcessor
    implements Runnable {
        private final int idx;
        private Thread procThread;
        private HTTPExchange procExchange;

        RequestProcessor(int idx) {
            this.idx = idx;
        }

        @Override
        public void run() {
            BOSHClient.this.processMessages(this.idx);
        }

        void start() {
            this.procThread = new Thread(this);
            this.procThread.setDaemon(true);
            this.procThread.setName(RequestProcessor.class.getSimpleName() + "[" + System.identityHashCode(this) + "]: Receive thread " + this.idx);
            this.procThread.start();
        }

        void dispose() {
            this.procThread = null;
        }
    }

    static abstract class ExchangeInterceptor {
        ExchangeInterceptor() {
        }

        abstract HTTPExchange interceptExchange(HTTPExchange var1);
    }
}

