/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.proxy.ProxySocketConnection;
import org.jivesoftware.smack.util.OutputStreamUtil;

public class Socks5ProxySocketConnection
implements ProxySocketConnection {
    private final ProxyInfo proxy;

    Socks5ProxySocketConnection(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public void connect(Socket socket, String host, int port, int timeout) throws IOException {
        int addressBytes;
        String proxy_host = this.proxy.getProxyAddress();
        int proxy_port = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        String passwd = this.proxy.getProxyPassword();
        socket.connect(new InetSocketAddress(proxy_host, proxy_port), timeout);
        InputStream in = socket.getInputStream();
        DataInputStream dis = new DataInputStream(in);
        OutputStream out = socket.getOutputStream();
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        outBuf.write(5);
        outBuf.write(2);
        outBuf.write(0);
        outBuf.write(2);
        OutputStreamUtil.writeResetAndFlush(outBuf, out);
        byte[] inBuf = new byte[2];
        dis.readFully(inBuf);
        boolean check = false;
        switch (inBuf[1] & 0xFF) {
            case 0: {
                check = true;
                break;
            }
            case 2: {
                if (user == null || passwd == null) break;
                outBuf.write(1);
                byte[] userBytes = user.getBytes(StandardCharsets.UTF_8);
                OutputStreamUtil.writeByteSafe(outBuf, userBytes.length, "Username to long");
                outBuf.write(userBytes);
                byte[] passwordBytes = passwd.getBytes(StandardCharsets.UTF_8);
                OutputStreamUtil.writeByteSafe(outBuf, passwordBytes.length, "Password to long");
                outBuf.write(passwordBytes);
                OutputStreamUtil.writeResetAndFlush(outBuf, out);
                inBuf = new byte[2];
                dis.readFully(inBuf);
                if (inBuf[1] != 0) break;
                check = true;
                break;
            }
        }
        if (!check) {
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS5, "fail in SOCKS5 proxy");
        }
        outBuf.write(5);
        outBuf.write(1);
        outBuf.write(0);
        byte[] hostb = host.getBytes(StandardCharsets.UTF_8);
        int len = hostb.length;
        outBuf.write(3);
        OutputStreamUtil.writeByteSafe(outBuf, len, "Hostname too long");
        outBuf.write(hostb);
        outBuf.write(port >>> 8);
        outBuf.write(port & 0xFF);
        OutputStreamUtil.writeResetAndFlush(outBuf, out);
        inBuf = new byte[4];
        dis.readFully(inBuf);
        if (inBuf[1] != 0) {
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS5, "server returns " + inBuf[1]);
        }
        int atyp = Byte.toUnsignedInt(inBuf[3]);
        switch (atyp) {
            case 1: {
                addressBytes = 4;
                break;
            }
            case 3: {
                byte domainnameLengthByte = dis.readByte();
                addressBytes = Byte.toUnsignedInt(domainnameLengthByte);
                break;
            }
            case 4: {
                addressBytes = 16;
                break;
            }
            default: {
                throw new IOException("Unknown ATYP value: " + atyp);
            }
        }
        inBuf = new byte[addressBytes + 2];
        dis.readFully(inBuf);
    }
}

