/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.EventManger;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public abstract class StreamNegotiator
extends Manager {
    protected static final EventManger<String, IQ, SmackException.NotConnectedException> initationSetEvents = new EventManger();

    protected StreamNegotiator(XMPPConnection connection) {
        super(connection);
    }

    protected static StreamInitiation createInitiationAccept(StreamInitiation streamInitiationOffer, String namespace) {
        StreamInitiation response = new StreamInitiation();
        response.setTo(streamInitiationOffer.getFrom());
        response.setFrom(streamInitiationOffer.getTo());
        response.setType(IQ.Type.result);
        response.setStanzaId(streamInitiationOffer.getStanzaId());
        DataForm.Builder form = DataForm.builder();
        ListSingleFormField.Builder field2 = FormField.listSingleBuilder("stream-method");
        field2.setValue(namespace);
        form.addField(field2.build());
        response.setFeatureNegotiationForm(form.build());
        return response;
    }

    protected final IQ initiateIncomingStream(final XMPPConnection connection, StreamInitiation initiation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ streamMethodInitiation;
        final StreamInitiation response = StreamNegotiator.createInitiationAccept(initiation, this.getNamespace());
        this.newStreamInitiation(initiation.getFrom(), initiation.getSessionID());
        String eventKey = initiation.getFrom().toString() + "\t" + initiation.getSessionID();
        try {
            streamMethodInitiation = initationSetEvents.performActionAndWaitForEvent(eventKey, connection.getReplyTimeout(), new EventManger.Callback<SmackException.NotConnectedException>(){

                @Override
                public void action() throws SmackException.NotConnectedException {
                    try {
                        connection.sendStanza(response);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (streamMethodInitiation == null) {
            throw SmackException.NoResponseException.newWith(connection, "stream initiation");
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(streamMethodInitiation);
        return streamMethodInitiation;
    }

    protected abstract void newStreamInitiation(Jid var1, String var2);

    abstract InputStream negotiateIncomingStream(Stanza var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException;

    public abstract InputStream createIncomingStream(StreamInitiation var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException;

    public abstract OutputStream createOutgoingStream(String var1, Jid var2, Jid var3) throws SmackException, XMPPException, InterruptedException;

    public abstract String getNamespace();

    public static void signal(String eventKey, IQ eventValue) {
        initationSetEvents.signalEvent(eventKey, eventValue);
    }
}

