/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.abstr;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpMetadataStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public abstract class AbstractOpenPgpMetadataStore
implements OpenPgpMetadataStore {
    private final Map<BareJid, Map<OpenPgpV4Fingerprint, Date>> announcedFingerprints = new HashMap<BareJid, Map<OpenPgpV4Fingerprint, Date>>();

    @Override
    public Map<OpenPgpV4Fingerprint, Date> getAnnouncedFingerprintsOf(BareJid contact) throws IOException {
        Map<OpenPgpV4Fingerprint, Date> fingerprints = this.announcedFingerprints.get(contact);
        if (fingerprints == null) {
            fingerprints = this.readAnnouncedFingerprintsOf(contact);
            this.announcedFingerprints.put(contact, fingerprints);
        }
        return fingerprints;
    }

    @Override
    public void setAnnouncedFingerprintsOf(BareJid contact, Map<OpenPgpV4Fingerprint, Date> data) throws IOException {
        this.announcedFingerprints.put(contact, data);
        this.writeAnnouncedFingerprintsOf(contact, data);
    }

    protected abstract Map<OpenPgpV4Fingerprint, Date> readAnnouncedFingerprintsOf(BareJid var1) throws IOException;

    protected abstract void writeAnnouncedFingerprintsOf(BareJid var1, Map<OpenPgpV4Fingerprint, Date> var2) throws IOException;
}

