/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.provider;

import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.jxmpp.JxmppContext;

public class DataValidationProvider
extends FormFieldChildElementProvider<ValidateElement> {
    private static final Logger LOGGER = Logger.getLogger(DataValidationProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ValidateElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String dataType = parser.getAttributeValue("", "datatype");
        ValidateElement dataValidation = null;
        ValidateElement.ListRange listRange = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "open": {
                            dataValidation = new ValidateElement.OpenValidateElement(dataType);
                            break block0;
                        }
                        case "basic": {
                            dataValidation = new ValidateElement.BasicValidateElement(dataType);
                            break block0;
                        }
                        case "range": {
                            dataValidation = new ValidateElement.RangeValidateElement(dataType, parser.getAttributeValue("", "min"), parser.getAttributeValue("", "max"));
                            break block0;
                        }
                        case "regex": {
                            dataValidation = new ValidateElement.RegexValidateElement(dataType, parser.nextText());
                            break block0;
                        }
                        case "list-range": {
                            UInt32 min = ParserUtils.getUInt32Attribute(parser, "min");
                            UInt32 max = ParserUtils.getUInt32Attribute(parser, "max");
                            if (min != null || max != null) {
                                listRange = new ValidateElement.ListRange(min, max);
                                break block0;
                            }
                            LOGGER.fine("Ignoring list-range element without min or max attribute");
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    if (dataValidation == null) {
                        dataValidation = new ValidateElement.BasicValidateElement(dataType);
                    }
                    dataValidation.setListRange(listRange);
                    return dataValidation;
                }
            }
        }
    }

    @Override
    public QName getQName() {
        return ValidateElement.QNAME;
    }
}

