/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.algorithms.JavaSecSignatureVerifier;
import org.minidns.record.DNSKEY;
import org.minidns.record.RRSIG;

class DsaSignatureVerifier
extends JavaSecSignatureVerifier {
    private static final int LENGTH = 20;

    DsaSignatureVerifier(String algorithm) throws NoSuchAlgorithmException {
        super("DSA", algorithm);
    }

    @Override
    protected byte[] getSignature(RRSIG rrsig) throws DnssecValidationFailedException.DataMalformedException {
        ByteArrayOutputStream bos;
        DataInputStream dis = rrsig.getSignatureAsDataInputStream();
        try {
            int slen;
            int soff;
            int rlen;
            int roff;
            byte t = dis.readByte();
            byte[] r = new byte[20];
            dis.readFully(r);
            if (r[0] == 0) {
                for (roff = 0; roff < 20 && r[roff] == 0; ++roff) {
                }
                rlen = r.length - roff;
            } else {
                rlen = r[0] < 0 ? r.length + 1 : r.length;
            }
            byte[] s = new byte[20];
            dis.readFully(s);
            if (s[0] == 0) {
                for (soff = 0; soff < 20 && s[soff] == 0; ++soff) {
                }
                slen = s.length - soff;
            } else {
                slen = s[0] < 0 ? s.length + 1 : s.length;
            }
            bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(48);
            dos.writeByte(rlen + slen + 4);
            dos.writeByte(2);
            dos.writeByte(rlen);
            if (rlen > 20) {
                dos.writeByte(0);
            }
            dos.write(r, roff, 20 - roff);
            dos.writeByte(2);
            dos.writeByte(slen);
            if (slen > 20) {
                dos.writeByte(0);
            }
            dos.write(s, soff, 20 - soff);
        }
        catch (IOException e) {
            throw new DnssecValidationFailedException.DataMalformedException(e, rrsig.getSignature());
        }
        return bos.toByteArray();
    }

    @Override
    protected PublicKey getPublicKey(DNSKEY key) throws DnssecValidationFailedException.DataMalformedException, DnssecValidationFailedException.DnssecInvalidKeySpecException {
        BigInteger pubKey;
        BigInteger base;
        BigInteger prime;
        BigInteger subPrime;
        DataInputStream dis = key.getKeyAsDataInputStream();
        try {
            int t = dis.readUnsignedByte();
            byte[] subPrimeBytes = new byte[20];
            dis.readFully(subPrimeBytes);
            subPrime = new BigInteger(1, subPrimeBytes);
            byte[] primeBytes = new byte[64 + t * 8];
            dis.readFully(primeBytes);
            prime = new BigInteger(1, primeBytes);
            byte[] baseBytes = new byte[64 + t * 8];
            dis.readFully(baseBytes);
            base = new BigInteger(1, baseBytes);
            byte[] pubKeyBytes = new byte[64 + t * 8];
            dis.readFully(pubKeyBytes);
            pubKey = new BigInteger(1, pubKeyBytes);
        }
        catch (IOException e) {
            throw new DnssecValidationFailedException.DataMalformedException(e, key.getKey());
        }
        try {
            return this.getKeyFactory().generatePublic(new DSAPublicKeySpec(pubKey, prime, subPrime, base));
        }
        catch (InvalidKeySpecException e) {
            throw new DnssecValidationFailedException.DnssecInvalidKeySpecException(e);
        }
    }
}

