/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.security.MessageDigest;
import javax.annotation.Nonnull;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;

abstract class PGPHashContextContentSignerBuilder
implements PGPContentSignerBuilder {
    PGPHashContextContentSignerBuilder() {
    }

    static class ExistingMessageDigest
    implements Digest {
        private final MessageDigest digest;

        ExistingMessageDigest(MessageDigest messageDigest) {
            this.digest = messageDigest;
        }

        @Override
        public void update(byte in) {
            this.digest.update(in);
        }

        @Override
        public void update(byte[] in, int inOff, int len) {
            this.digest.update(in, inOff, len);
        }

        @Override
        public int doFinal(byte[] out, int outOff) {
            byte[] hash = this.digest.digest();
            System.arraycopy(hash, 0, out, outOff, hash.length);
            return this.getDigestSize();
        }

        @Override
        public void reset() {
        }

        @Override
        public String getAlgorithmName() {
            return this.digest.getAlgorithm();
        }

        @Override
        public int getDigestSize() {
            return this.digest.getDigestLength();
        }
    }

    static class SignerOutputStream
    extends OutputStream {
        private Signer sig;

        SignerOutputStream(Signer sig) {
            this.sig = sig;
        }

        @Override
        public void write(@Nonnull byte[] bytes, int off, int len) {
            this.sig.update(bytes, off, len);
        }

        @Override
        public void write(@Nonnull byte[] bytes) {
            this.sig.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(int b) {
            this.sig.update((byte)b);
        }
    }
}

