/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.SubkeyIdentifier;

class SignatureGenerationStream
extends OutputStream {
    private final OutputStream wrapped;
    private final SigningOptions options;

    SignatureGenerationStream(@Nonnull OutputStream wrapped, @Nullable SigningOptions signingOptions) {
        this.wrapped = wrapped;
        this.options = signingOptions;
    }

    @Override
    public void write(int b) throws IOException {
        this.wrapped.write(b);
        if (this.options == null || this.options.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : this.options.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = this.options.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            byte asByte = (byte)(b & 0xFF);
            signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(@Nonnull byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
        this.wrapped.write(buffer, 0, len);
        if (this.options == null || this.options.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : this.options.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = this.options.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
    }
}

