/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.WeakHashSet;

@JRubyClass(name={"ThreadGroup"})
public class RubyThreadGroup
extends RubyObject {
    private final Set<RubyThread> rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(Ruby runtime2) {
        RubyClass threadGroupClass = runtime2.defineClass("ThreadGroup", runtime2.getObject(), RubyThreadGroup::new);
        threadGroupClass.setClassIndex(ClassIndex.THREADGROUP);
        threadGroupClass.defineAnnotatedMethods(RubyThreadGroup.class);
        RubyThreadGroup defaultThreadGroup = new RubyThreadGroup(runtime2, threadGroupClass);
        runtime2.setDefaultThreadGroup(defaultThreadGroup);
        threadGroupClass.defineConstant("Default", defaultThreadGroup);
        return threadGroupClass;
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add(ThreadContext context, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(rubyThread, this.getRuntime().getThread());
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to the frozen thread group");
        }
        if (this.enclosed) {
            throw this.getRuntime().newTypeError("can't move to the enclosed thread group");
        }
        RubyThread thread2 = (RubyThread)rubyThread;
        RubyThreadGroup threadGroup = thread2.getThreadGroup();
        if (threadGroup != null) {
            if (threadGroup.isFrozen()) {
                throw this.getRuntime().newTypeError("can't move from the frozen thread group");
            }
            if (threadGroup.enclosed_p(block).isTrue()) {
                throw this.getRuntime().newTypeError("can't move from the enclosed thread group");
            }
        }
        if (thread2.alive_p(context).isTrue()) {
            this.addDirectly(thread2);
        } else {
            thread2.setThreadGroup(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectly(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            IRubyObject oldGroup = rubyThread.group();
            if (!oldGroup.isNil()) {
                RubyThreadGroup threadGroup = (RubyThreadGroup)oldGroup;
                threadGroup.rubyThreadList.remove(rubyThread);
            }
            rubyThread.setThreadGroup(this);
            this.rubyThreadList.add(rubyThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            this.rubyThreadList.remove(rubyThread);
        }
    }

    @JRubyMethod
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"})
    public IRubyObject enclosed_p(Block block) {
        return this.getRuntime().newBoolean(this.enclosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject list(Block block) {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        Set<RubyThread> set2 = this.rubyThreadList;
        synchronized (set2) {
            for (RubyThread thread2 : this.rubyThreadList) {
                if (thread2 == null) continue;
                ary.append(thread2);
            }
        }
        return ary;
    }

    public int size() {
        return this.rubyThreadList.size();
    }

    private RubyThreadGroup(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Deprecated
    public IRubyObject add(IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(rubyThread, this.getRuntime().getThread());
        }
        return this.add(((RubyThread)rubyThread).getContext(), rubyThread, block);
    }
}

