/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class KernelJavaAddons {
    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject) {
        Ruby runtime2 = context.runtime;
        if (fromObject instanceof RubyArray) {
            return KernelJavaAddons.toJavaArray(runtime2, Object.class, (RubyArray)fromObject);
        }
        return Java.getInstance(runtime2, fromObject.toJava(Object.class));
    }

    @JRubyMethod
    public static IRubyObject to_java(ThreadContext context, IRubyObject fromObject, IRubyObject type2) {
        if (type2.isNil()) {
            return KernelJavaAddons.to_java(context, fromObject);
        }
        Class<?> targetType = Java.resolveClassType(context, type2);
        if (fromObject instanceof RubyArray) {
            return KernelJavaAddons.toJavaArray(context.runtime, targetType, (RubyArray)fromObject);
        }
        return Java.getInstance(context.runtime, fromObject.toJava(targetType));
    }

    static ArrayJavaProxy toJavaArray(Ruby runtime2, Class<?> type2, RubyArray fromArray) {
        Object newArray = KernelJavaAddons.toJavaArrayInternal(runtime2, type2, fromArray);
        return new ArrayJavaProxy(runtime2, Java.getProxyClassForObject(runtime2, newArray), newArray, JavaUtil.getJavaConverter(type2));
    }

    private static Object toJavaArrayInternal(Ruby runtime2, Class<?> type2, RubyArray fromArray) {
        Object newArray = Array.newInstance(type2, fromArray.size());
        if (type2.isArray()) {
            for (int i2 = 0; i2 < fromArray.size(); ++i2) {
                Class<?> nestedType = type2.getComponentType();
                Object element = fromArray.eltInternal(i2);
                Object nestedArray = element instanceof RubyArray ? KernelJavaAddons.toJavaArrayInternal(runtime2, nestedType, (RubyArray)element) : (type2.isInstance(element) ? element : element.toJava(type2));
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, newArray, i2, nestedArray);
            }
        } else {
            ArrayUtils.copyDataToJavaArrayDirect(fromArray, newArray);
        }
        return newArray;
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_signature(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_name(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_implements(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_annotation(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_require(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_package(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject java_field(IRubyObject recv2, IRubyObject[] args2) {
        return recv2.getRuntime().getNil();
    }
}

