%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM1": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2": ["0xFDFDFDFEFDFDFDFE", "0xFCFCFCFDFCFCFCFD", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x0202020202020202", "0x0303030303030303", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0xFDFDFDFE00000000", "0x03030303FCFCFCFD", "0x0000000000000000", "0x0000000000000000"],
    "XMM5": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6": ["0xFDFDFDFEFDFDFDFE", "0xFCFCFCFDFCFCFCFD", "0xFDFDFDFEFDFDFDFE", "0xFCFCFCFDFCFCFCFD"],
    "XMM7": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM8": ["0xFDFDFDFE00000000", "0x03030303FCFCFCFD", "0xFDFDFDFE00000000", "0x03030303FCFCFCFD"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx + 32 * 4]

; Test with full zero
vpsignd xmm1, xmm0, [rdx + 32 * 0]
vpsignd ymm5, ymm0, [rdx + 32 * 0]

; Test with full negative
vpsignd xmm2, xmm0, [rdx + 32 * 1]
vpsignd ymm6, ymm0, [rdx + 32 * 1]

; Test with full positive
vpsignd xmm3, xmm0, [rdx + 32 * 2]
vpsignd ymm7, ymm0, [rdx + 32 * 2]

; Test a mix
vpsignd xmm4, xmm0, [rdx + 32 * 3]
vpsignd ymm8, ymm0, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000

dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

dq 0x0000000100000001
dq 0x0000000100000001
dq 0x0000000100000001
dq 0x0000000100000001

dq 0xFFFFFFFF00000000
dq 0x00000001FFFFFFFF
dq 0xFFFFFFFF00000000
dq 0x00000001FFFFFFFF

dq 0x0202020202020202
dq 0x0303030303030303
dq 0x0202020202020202
dq 0x0303030303030303
