//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-symbols")]
use objc2_symbols::*;

use crate::*;

/// Completion handler for adding and removing symbol effects/content transitions.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisymboleffectcompletion?language=objc)
#[cfg(feature = "block2")]
pub type UISymbolEffectCompletion =
    *mut block2::DynBlock<dyn Fn(NonNull<UISymbolEffectCompletionContext>)>;

extern_class!(
    /// Represents information about a symbol effect's completion.
    /// You don't create one of these. Instead, UIKit creates one and passes it into the completion handler
    /// of a symbol effect or symbol content transition.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uisymboleffectcompletioncontext?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UISymbolEffectCompletionContext;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UISymbolEffectCompletionContext {}
);

impl UISymbolEffectCompletionContext {
    extern_methods!(
        /// Whether or not the symbol effect was completely finished.
        /// This will be YES for effects that have successfully run to completion.
        #[unsafe(method(isFinished))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFinished(&self) -> bool;

        /// The object (such as an image view) that the symbol effect was added to.
        #[unsafe(method(sender))]
        #[unsafe(method_family = none)]
        pub unsafe fn sender(&self) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "objc2-symbols")]
        /// The symbol effect that has completed.
        /// There is no guarantee that this effect will be the same instance as the effect originally added.
        /// This will be `nil` if a symbol content transition was added instead.
        #[unsafe(method(effect))]
        #[unsafe(method_family = none)]
        pub unsafe fn effect(&self) -> Option<Retained<NSSymbolEffect>>;

        #[cfg(feature = "objc2-symbols")]
        /// The symbol content transition that has completed.
        /// There is no guarantee that this content transition will be the same instance as the content transition originally added.
        /// This will be `nil` if a symbol effect was added instead.
        #[unsafe(method(contentTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentTransition(&self) -> Option<Retained<NSSymbolContentTransition>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
