package org.mozilla.javascript;

/**
 * Super type for Javascript scripts and functions. The type variable is threaded through the whole
 * implementation of {@link JSScript}, {@link JSFunction}, {@link JSDescriptor}, etc. to avoid
 * explicit casting in both Java and generated bytecode.
 */
public interface ScriptOrFn<T extends ScriptOrFn<T>> {

    public default Scriptable getHomeObject() {
        return null;
    }

    public default JSDescriptor<T> getDescriptor() {
        return null;
    }

    public default Scriptable getDeclarationScope() {
        return null;
    }
}
