﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudfront/model/Tags.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace CloudFront {
namespace Model {

Tags::Tags(const XmlNode& xmlNode) { *this = xmlNode; }

Tags& Tags::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode itemsNode = resultNode.FirstChild("Items");
    if (!itemsNode.IsNull()) {
      XmlNode itemsMember = itemsNode.FirstChild("Tag");
      m_itemsHasBeenSet = !itemsMember.IsNull();
      while (!itemsMember.IsNull()) {
        m_items.push_back(itemsMember);
        itemsMember = itemsMember.NextNode("Tag");
      }

      m_itemsHasBeenSet = true;
    }
  }

  return *this;
}

void Tags::AddToNode(XmlNode& parentNode) const {
  Aws::StringStream ss;
  if (m_itemsHasBeenSet) {
    XmlNode itemsParentNode = parentNode.CreateChildElement("Items");
    for (const auto& item : m_items) {
      XmlNode itemsNode = itemsParentNode.CreateChildElement("Tag");
      item.AddToNode(itemsNode);
    }
  }
}

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
