﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cognito-idp/model/UpdateUserAttributesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CognitoIdentityProvider::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateUserAttributesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_userAttributesHasBeenSet) {
    Aws::Utils::Array<JsonValue> userAttributesJsonList(m_userAttributes.size());
    for (unsigned userAttributesIndex = 0; userAttributesIndex < userAttributesJsonList.GetLength(); ++userAttributesIndex) {
      userAttributesJsonList[userAttributesIndex].AsObject(m_userAttributes[userAttributesIndex].Jsonize());
    }
    payload.WithArray("UserAttributes", std::move(userAttributesJsonList));
  }

  if (m_accessTokenHasBeenSet) {
    payload.WithString("AccessToken", m_accessToken);
  }

  if (m_clientMetadataHasBeenSet) {
    JsonValue clientMetadataJsonMap;
    for (auto& clientMetadataItem : m_clientMetadata) {
      clientMetadataJsonMap.WithString(clientMetadataItem.first, clientMetadataItem.second);
    }
    payload.WithObject("ClientMetadata", std::move(clientMetadataJsonMap));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateUserAttributesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSCognitoIdentityProviderService.UpdateUserAttributes"));
  return headers;
}
