/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueColumnReferenceExpression
extends SQLQueryValueExpression {
    @Nullable
    private final SQLQuerySymbolEntry columnName;
    @Nullable
    private SQLQueryResultColumn column = null;

    public SQLQueryValueColumnReferenceExpression(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry columnName) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.columnName = columnName;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.columnName);
    }

    @Nullable
    public SQLQuerySymbolEntry getColumnName() {
        return this.columnName;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.columnName == null ? null : this.columnName.getSymbol();
    }

    @Override
    @Nullable
    public SQLQueryResultColumn getColumnIfTrivialExpression() {
        return this.column;
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
    }

    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryExprType type;
        SQLQueryResultColumn resultColumn;
        if (this.columnName != null) {
            SQLQuerySymbolOrigin.ColumnNameFromRowsData columnRefOrigin = new SQLQuerySymbolOrigin.ColumnNameFromRowsData(context);
            resultColumn = context.resolveColumn(statistics.getMonitor(), this.columnName.getName());
            if (resultColumn != null || !context.getRowsSources().hasUnresolvedSource()) {
                SQLQuerySemanticUtils.propagateColumnDefinition(this.columnName, resultColumn, statistics, columnRefOrigin);
            }
            SQLQueryExprType sQLQueryExprType = type = resultColumn != null ? resultColumn.type : SQLQueryExprType.UNKNOWN;
            if (this.columnName.getOrigin() == null) {
                this.columnName.setOrigin(columnRefOrigin);
            }
        } else {
            statistics.appendError(this.getSyntaxNode(), "Invalid column reference");
            resultColumn = null;
            type = this.type;
        }
        this.column = resultColumn;
        return type;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueColumnRefExpr(this, arg);
    }

    @NotNull
    public String toString() {
        String columnName = this.columnName == null ? "<NULL>" : this.columnName.getName();
        String type = this.type == null ? "<NULL>" : this.type.toString();
        return "ColumnReference[" + columnName + ":" + type + "]";
    }
}

