//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsinvalidarchiveoperationexception?language=objc)
    #[cfg(all(feature = "NSObjCRuntime", feature = "NSString"))]
    pub static NSInvalidArchiveOperationException: &'static NSExceptionName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsinvalidunarchiveoperationexception?language=objc)
    #[cfg(all(feature = "NSObjCRuntime", feature = "NSString"))]
    pub static NSInvalidUnarchiveOperationException: &'static NSExceptionName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nskeyedarchiverootobjectkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSKeyedArchiveRootObjectKey: &'static NSString;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nskeyedarchiver?language=objc)
    #[unsafe(super(NSCoder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSCoder")]
    pub struct NSKeyedArchiver;
);

#[cfg(feature = "NSCoder")]
unsafe impl NSObjectProtocol for NSKeyedArchiver {}

#[cfg(feature = "NSCoder")]
impl NSKeyedArchiver {
    extern_methods!(
        /// Initializes the receiver for encoding an archive, optionally disabling secure coding.
        ///
        /// If
        /// `NSSecureCoding`cannot be used,
        /// `requiresSecureCoding`may be turned off here; for improved security, however,
        /// `requiresSecureCoding`should be left enabled whenever possible.
        /// `requiresSecureCoding`ensures that all encoded objects conform to
        /// `NSSecureCoding,`preventing the possibility of encoding objects which cannot be decoded later.
        ///
        /// To produce archives whose structure matches those previously encoded using
        /// `+archivedDataWithRootObject,`encode the top-level object in your archive for the
        /// `NSKeyedArchiveRootObjectKey.`
        #[unsafe(method(initRequiringSecureCoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initRequiringSecureCoding(
            this: Allocated<Self>,
            requires_secure_coding: bool,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        /// Returns an
        /// `NSData`object containing the encoded form of the object graph whose root object is given, optionally disabling secure coding.
        ///
        /// If
        /// `NSSecureCoding`cannot be used,
        /// `requiresSecureCoding`may be turned off here; for improved security, however,
        /// `requiresSecureCoding`should be left enabled whenever possible.
        /// `requiresSecureCoding`ensures that all encoded objects conform to
        /// `NSSecureCoding,`preventing the possibility of encoding objects which cannot be decoded later.
        ///
        /// If the object graph cannot be encoded, returns
        /// `nil`and sets the
        /// `error`out parameter.
        #[unsafe(method(archivedDataWithRootObject:requiringSecureCoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn archivedDataWithRootObject_requiringSecureCoding_error(
            object: &AnyObject,
            requires_secure_coding: bool,
        ) -> Result<Retained<NSData>, Retained<NSError>>;

        /// Initialize the archiver with empty data, ready for writing.
        #[deprecated = "Use -initRequiringSecureCoding: instead"]
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[deprecated = "Use -initRequiringSecureCoding: instead"]
        #[unsafe(method(initForWritingWithMutableData:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initForWritingWithMutableData(
            this: Allocated<Self>,
            data: &NSMutableData,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[deprecated = "Use +archivedDataWithRootObject:requiringSecureCoding:error: instead"]
        #[unsafe(method(archivedDataWithRootObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn archivedDataWithRootObject(root_object: &AnyObject) -> Retained<NSData>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use +archivedDataWithRootObject:requiringSecureCoding:error: and -writeToURL:options:error: instead"]
        #[unsafe(method(archiveRootObject:toFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn archiveRootObject_toFile(root_object: &AnyObject, path: &NSString) -> bool;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSKeyedArchiverDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSKeyedArchiverDelegate>>,
        );

        #[cfg(feature = "NSPropertyList")]
        #[unsafe(method(outputFormat))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputFormat(&self) -> NSPropertyListFormat;

        #[cfg(feature = "NSPropertyList")]
        /// Setter for [`outputFormat`][Self::outputFormat].
        #[unsafe(method(setOutputFormat:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOutputFormat(&self, output_format: NSPropertyListFormat);

        #[cfg(feature = "NSData")]
        /// If encoding has not yet finished, then invoking this property will call finishEncoding and return the data. If you initialized the keyed archiver with a specific mutable data instance, then it will be returned from this property after finishEncoding is called.
        #[unsafe(method(encodedData))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodedData(&self) -> Retained<NSData>;

        #[unsafe(method(finishEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn finishEncoding(&self);

        #[cfg(feature = "NSString")]
        #[unsafe(method(setClassName:forClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClassName_forClass_class(coded_name: Option<&NSString>, cls: &AnyClass);

        #[cfg(feature = "NSString")]
        #[unsafe(method(setClassName:forClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClassName_forClass(&self, coded_name: Option<&NSString>, cls: &AnyClass);

        #[cfg(feature = "NSString")]
        #[unsafe(method(classNameForClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn classNameForClass_class(cls: &AnyClass) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(classNameForClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn classNameForClass(&self, cls: &AnyClass) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeObject:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeObject_forKey(&self, object: Option<&AnyObject>, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeConditionalObject:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeConditionalObject_forKey(
            &self,
            object: Option<&AnyObject>,
            key: &NSString,
        );

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeBool:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeBool_forKey(&self, value: bool, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeInt:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeInt_forKey(&self, value: c_int, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeInt32:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeInt32_forKey(&self, value: i32, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeInt64:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeInt64_forKey(&self, value: i64, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeFloat:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeFloat_forKey(&self, value: c_float, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeDouble:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeDouble_forKey(&self, value: c_double, key: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(encodeBytes:length:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeBytes_length_forKey(
            &self,
            bytes: *const u8,
            length: NSUInteger,
            key: &NSString,
        );

        #[unsafe(method(requiresSecureCoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn requiresSecureCoding(&self) -> bool;

        /// Setter for [`requiresSecureCoding`][Self::requiresSecureCoding].
        #[unsafe(method(setRequiresSecureCoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRequiresSecureCoding(&self, requires_secure_coding: bool);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSCoder")]
impl NSKeyedArchiver {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nskeyedunarchiver?language=objc)
    #[unsafe(super(NSCoder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSCoder")]
    pub struct NSKeyedUnarchiver;
);

#[cfg(feature = "NSCoder")]
unsafe impl NSObjectProtocol for NSKeyedUnarchiver {}

#[cfg(feature = "NSCoder")]
impl NSKeyedUnarchiver {
    extern_methods!(
        #[cfg(all(feature = "NSData", feature = "NSError"))]
        /// Initializes the receiver for decoding an archive previously encoded by
        /// `NSKeyedUnarchiver.`
        /// Enables
        /// `requiresSecureCoding`by default. If
        /// `NSSecureCoding`cannot be used,
        /// `requiresSecureCoding`may be turned off manually; for improved security,
        /// `requiresSecureCoding`should be left enabled whenever possible.
        ///
        /// Sets the unarchiver's
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid, and sets the
        /// `error`out parameter.
        #[unsafe(method(initForReadingFromData:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initForReadingFromData_error(
            this: Allocated<Self>,
            data: &NSData,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        /// Decodes the root object of the given class from the given archive, previously encoded by
        /// `NSKeyedArchiver.`
        /// Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedObjectOfClass:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedObjectOfClass_fromData_error(
            cls: &AnyClass,
            data: &NSData,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(all(feature = "NSArray", feature = "NSData", feature = "NSError"))]
        /// Decodes the
        /// `NSArray`root object from
        /// `data`which should be an
        /// `NSArray<cls>`containing the given non-collection class (no nested arrays or arrays of dictionaries, etc) from the given archive, previously encoded by
        /// `NSKeyedArchiver.`Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedArrayOfObjectsOfClass:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedArrayOfObjectsOfClass_fromData_error(
            cls: &AnyClass,
            data: &NSData,
        ) -> Result<Retained<NSArray>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSDictionary", feature = "NSError"))]
        /// Decodes the
        /// `NSDictionary`root object from
        /// `data`which should be an
        /// `NSDictionary<keyCls,objectCls>`with keys of type given in
        /// `keyCls`and objects of the given non-collection class
        /// `objectCls`(no nested dictionaries or other dictionaries contained in the dictionary, etc) from the given archive, previously encoded by
        /// `NSKeyedArchiver.`
        /// Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedDictionaryWithKeysOfClass:objectsOfClass:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedDictionaryWithKeysOfClass_objectsOfClass_fromData_error(
            key_cls: &AnyClass,
            value_cls: &AnyClass,
            data: &NSData,
        ) -> Result<Retained<NSDictionary>, Retained<NSError>>;

        #[cfg(all(feature = "NSData", feature = "NSError", feature = "NSSet"))]
        /// Decodes the root object of one of the given classes from the given archive, previously encoded by
        /// `NSKeyedArchiver.`
        /// Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedObjectOfClasses:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedObjectOfClasses_fromData_error(
            classes: &NSSet<AnyClass>,
            data: &NSData,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSData",
            feature = "NSError",
            feature = "NSSet"
        ))]
        /// Decodes the
        /// `NSArray`root object from
        /// `data`which should be an
        /// `NSArray,`containing the given non-collection classes in
        /// `classes`(no nested arrays or arrays of dictionaries, etc) from the given archive, previously encoded by
        /// `NSKeyedArchiver.`
        /// Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedArrayOfObjectsOfClasses:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedArrayOfObjectsOfClasses_fromData_error(
            classes: &NSSet<AnyClass>,
            data: &NSData,
        ) -> Result<Retained<NSArray>, Retained<NSError>>;

        #[cfg(all(
            feature = "NSData",
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSSet"
        ))]
        /// Decodes the
        /// `NSDictionary`root object from
        /// `data`which should be an
        /// `NSDictionary,`with keys of the types given in
        /// `keyClasses`and objects of the given non-collection classes in
        /// `objectClasses`(no nested dictionaries or other dictionaries contained in the dictionary, etc) from the given archive, previously encoded by
        /// `NSKeyedArchiver.`
        /// Enables
        /// `requiresSecureCoding`and sets the
        /// `decodingFailurePolicy`to
        /// `NSDecodingFailurePolicySetErrorAndReturn.`
        /// Returns
        /// `nil`if the given data is not valid or cannot be decoded, and sets the
        /// `error`out parameter.
        #[unsafe(method(unarchivedDictionaryWithKeysOfClasses:objectsOfClasses:fromData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchivedDictionaryWithKeysOfClasses_objectsOfClasses_fromData_error(
            key_classes: &NSSet<AnyClass>,
            value_classes: &NSSet<AnyClass>,
            data: &NSData,
        ) -> Result<Retained<NSDictionary>, Retained<NSError>>;

        #[deprecated = "Use -initForReadingFromData:error: instead"]
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[deprecated = "Use -initForReadingFromData:error: instead"]
        #[unsafe(method(initForReadingWithData:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initForReadingWithData(
            this: Allocated<Self>,
            data: &NSData,
        ) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[deprecated = "Use +unarchivedObjectOfClass:fromData:error: instead"]
        #[unsafe(method(unarchiveObjectWithData:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchiveObjectWithData(data: &NSData) -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSData", feature = "NSError"))]
        #[deprecated = "Use +unarchivedObjectOfClass:fromData:error: instead"]
        #[unsafe(method(unarchiveTopLevelObjectWithData:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchiveTopLevelObjectWithData_error(
            data: &NSData,
        ) -> Result<Retained<AnyObject>, Retained<NSError>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use +unarchivedObjectOfClass:fromData:error: instead"]
        #[unsafe(method(unarchiveObjectWithFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unarchiveObjectWithFile(path: &NSString) -> Option<Retained<AnyObject>>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSKeyedUnarchiverDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSKeyedUnarchiverDelegate>>,
        );

        #[unsafe(method(finishDecoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn finishDecoding(&self);

        #[cfg(feature = "NSString")]
        #[unsafe(method(setClass:forClassName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClass_forClassName_class(cls: Option<&AnyClass>, coded_name: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(setClass:forClassName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClass_forClassName(&self, cls: Option<&AnyClass>, coded_name: &NSString);

        #[cfg(feature = "NSString")]
        #[unsafe(method(classForClassName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn classForClassName_class(coded_name: &NSString) -> Option<&'static AnyClass>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(classForClassName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn classForClassName(&self, coded_name: &NSString) -> Option<&'static AnyClass>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(containsValueForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn containsValueForKey(&self, key: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeObjectForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeObjectForKey(&self, key: &NSString) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeBoolForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeBoolForKey(&self, key: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeIntForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeIntForKey(&self, key: &NSString) -> c_int;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeInt32ForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeInt32ForKey(&self, key: &NSString) -> i32;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeInt64ForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeInt64ForKey(&self, key: &NSString) -> i64;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeFloatForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeFloatForKey(&self, key: &NSString) -> c_float;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeDoubleForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeDoubleForKey(&self, key: &NSString) -> c_double;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decodeBytesForKey:returnedLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeBytesForKey_returnedLength(
            &self,
            key: &NSString,
            lengthp: *mut NSUInteger,
        ) -> *const u8;

        #[unsafe(method(requiresSecureCoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn requiresSecureCoding(&self) -> bool;

        /// Setter for [`requiresSecureCoding`][Self::requiresSecureCoding].
        #[unsafe(method(setRequiresSecureCoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRequiresSecureCoding(&self, requires_secure_coding: bool);

        #[unsafe(method(decodingFailurePolicy))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodingFailurePolicy(&self) -> NSDecodingFailurePolicy;

        /// Setter for [`decodingFailurePolicy`][Self::decodingFailurePolicy].
        #[unsafe(method(setDecodingFailurePolicy:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDecodingFailurePolicy(
            &self,
            decoding_failure_policy: NSDecodingFailurePolicy,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSCoder")]
impl NSKeyedUnarchiver {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nskeyedarchiverdelegate?language=objc)
    pub unsafe trait NSKeyedArchiverDelegate: NSObjectProtocol {
        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(archiver:willEncodeObject:))]
        #[unsafe(method_family = none)]
        unsafe fn archiver_willEncodeObject(
            &self,
            archiver: &NSKeyedArchiver,
            object: &AnyObject,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(archiver:didEncodeObject:))]
        #[unsafe(method_family = none)]
        unsafe fn archiver_didEncodeObject(
            &self,
            archiver: &NSKeyedArchiver,
            object: Option<&AnyObject>,
        );

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(archiver:willReplaceObject:withObject:))]
        #[unsafe(method_family = none)]
        unsafe fn archiver_willReplaceObject_withObject(
            &self,
            archiver: &NSKeyedArchiver,
            object: Option<&AnyObject>,
            new_object: Option<&AnyObject>,
        );

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(archiverWillFinish:))]
        #[unsafe(method_family = none)]
        unsafe fn archiverWillFinish(&self, archiver: &NSKeyedArchiver);

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(archiverDidFinish:))]
        #[unsafe(method_family = none)]
        unsafe fn archiverDidFinish(&self, archiver: &NSKeyedArchiver);
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nskeyedunarchiverdelegate?language=objc)
    pub unsafe trait NSKeyedUnarchiverDelegate: NSObjectProtocol {
        #[cfg(all(feature = "NSArray", feature = "NSCoder", feature = "NSString"))]
        #[optional]
        #[unsafe(method(unarchiver:cannotDecodeObjectOfClassName:originalClasses:))]
        #[unsafe(method_family = none)]
        unsafe fn unarchiver_cannotDecodeObjectOfClassName_originalClasses(
            &self,
            unarchiver: &NSKeyedUnarchiver,
            name: &NSString,
            class_names: &NSArray<NSString>,
        ) -> Option<&'static AnyClass>;

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(unarchiver:willReplaceObject:withObject:))]
        #[unsafe(method_family = none)]
        unsafe fn unarchiver_willReplaceObject_withObject(
            &self,
            unarchiver: &NSKeyedUnarchiver,
            object: &AnyObject,
            new_object: &AnyObject,
        );

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(unarchiverWillFinish:))]
        #[unsafe(method_family = none)]
        unsafe fn unarchiverWillFinish(&self, unarchiver: &NSKeyedUnarchiver);

        #[cfg(feature = "NSCoder")]
        #[optional]
        #[unsafe(method(unarchiverDidFinish:))]
        #[unsafe(method_family = none)]
        unsafe fn unarchiverDidFinish(&self, unarchiver: &NSKeyedUnarchiver);
    }
);

mod private_NSObjectNSKeyedArchiverObjectSubstitution {
    pub trait Sealed {}
}

/// Category "NSKeyedArchiverObjectSubstitution" on [`NSObject`].
#[doc(alias = "NSKeyedArchiverObjectSubstitution")]
pub unsafe trait NSObjectNSKeyedArchiverObjectSubstitution:
    ClassType + Sized + private_NSObjectNSKeyedArchiverObjectSubstitution::Sealed
{
    extern_methods!(
        #[unsafe(method(classForKeyedArchiver))]
        #[unsafe(method_family = none)]
        unsafe fn classForKeyedArchiver(&self) -> Option<&'static AnyClass>;

        #[cfg(feature = "NSCoder")]
        #[unsafe(method(replacementObjectForKeyedArchiver:))]
        #[unsafe(method_family = none)]
        unsafe fn replacementObjectForKeyedArchiver(
            &self,
            archiver: &NSKeyedArchiver,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(classFallbacksForKeyedArchiver))]
        #[unsafe(method_family = none)]
        unsafe fn classFallbacksForKeyedArchiver() -> Retained<NSArray<NSString>>;
    );
}

impl private_NSObjectNSKeyedArchiverObjectSubstitution::Sealed for NSObject {}
unsafe impl NSObjectNSKeyedArchiverObjectSubstitution for NSObject {}

mod private_NSObjectNSKeyedUnarchiverObjectSubstitution {
    pub trait Sealed {}
}

/// Category "NSKeyedUnarchiverObjectSubstitution" on [`NSObject`].
#[doc(alias = "NSKeyedUnarchiverObjectSubstitution")]
pub unsafe trait NSObjectNSKeyedUnarchiverObjectSubstitution:
    ClassType + Sized + private_NSObjectNSKeyedUnarchiverObjectSubstitution::Sealed
{
    extern_methods!(
        #[unsafe(method(classForKeyedUnarchiver))]
        #[unsafe(method_family = none)]
        unsafe fn classForKeyedUnarchiver() -> &'static AnyClass;
    );
}

impl private_NSObjectNSKeyedUnarchiverObjectSubstitution::Sealed for NSObject {}
unsafe impl NSObjectNSKeyedUnarchiverObjectSubstitution for NSObject {}
