/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-Studio-CLA-applies
 *
 * MuseScore Studio
 * Music Composition & Notation
 *
 * Copyright (C) 2025 MuseScore Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include "testing/environment.h"

#include "draw/drawmodule.h"
#include "engraving/engravingmodule.h"
#include "engraving/tests/utils/scorerw.h"

#include "importexport/tabledit/tableditmodule.h"

#include "engraving/dom/instrtemplate.h"

#include "log.h"

using namespace mu::iex::tabledit;

static muse::testing::SuiteEnvironment importexport_se(
{
    new muse::draw::DrawModule(),         // needs for engraving
    new mu::engraving::EngravingModule(),
    new mu::iex::tabledit::TablEditModule()
},
    nullptr,
    []() {
    LOGI() << "tabledit tests suite post init";

    mu::engraving::ScoreRW::setRootPath(muse::String::fromUtf8(iex_tabledit_tests_DATA_ROOT));

    mu::engraving::MScore::testMode = true;
    mu::engraving::MScore::noGui = true;

    mu::engraving::loadInstrumentTemplates(":/engraving/instruments/instruments.xml");
}
    );
