/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern pattern, Locator locator) {
        super(false, 3, ListPattern.combineHashCode(37, pattern.hashCode()));
        this.p = pattern;
        this.locator = locator;
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeList(pattern, this.locator);
        }
        return this;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    @Override
    boolean samePattern(Pattern pattern) {
        return pattern instanceof ListPattern && this.p == ((ListPattern)pattern).p;
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseList(this);
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, duplicateAttributeDetector, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.locator);
            throw restrictionViolationException;
        }
    }

    Pattern getOperand() {
        return this.p;
    }
}

